package software.amazon.awscdk.services.kinesisfirehose;

/**
 * (experimental) Properties for a new delivery stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * // Provide a Lambda function that will transform records before delivery, with custom
 * // buffering and retry configuration
 * Function lambdaFunction = Function.Builder.create(this, "Processor")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "process-records")))
 *         .build();
 * LambdaFunctionProcessor lambdaProcessor = LambdaFunctionProcessor.Builder.create(lambdaFunction)
 *         .bufferInterval(Duration.minutes(5))
 *         .bufferSize(Size.mebibytes(5))
 *         .retries(5)
 *         .build();
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .processor(lambdaProcessor)
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destinations(List.of(s3Destination))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:42.298Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisfirehose.$Module.class, fqn = "@aws-cdk/aws-kinesisfirehose.DeliveryStreamProps")
@software.amazon.jsii.Jsii.Proxy(DeliveryStreamProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DeliveryStreamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The destinations that this delivery stream will deliver data to.
     * <p>
     * Only a singleton array is supported at this time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.kinesisfirehose.IDestination> getDestinations();

    /**
     * (experimental) A name for the delivery stream.
     * <p>
     * Default: - a name is generated by CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamName() {
        return null;
    }

    /**
     * (experimental) Indicates the type of customer master key (CMK) to use for server-side encryption, if any.
     * <p>
     * Default: StreamEncryption.UNENCRYPTED - unless `encryptionKey` is provided, in which case this will be implicitly set to `StreamEncryption.CUSTOMER_MANAGED`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.StreamEncryption getEncryption() {
        return null;
    }

    /**
     * (experimental) Customer managed key to server-side encrypt data in the stream.
     * <p>
     * Default: - no KMS key will be used; if `encryption` is set to `CUSTOMER_MANAGED`, a KMS key will be created for you
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * (experimental) The IAM role associated with this delivery stream.
     * <p>
     * Assumed by Kinesis Data Firehose to read from sources and encrypt data server-side.
     * <p>
     * Default: - a role will be created with default permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * (experimental) The Kinesis data stream to use as a source for this delivery stream.
     * <p>
     * Default: - data must be written to the delivery stream via a direct put.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.IStream getSourceStream() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DeliveryStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeliveryStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DeliveryStreamProps> {
        java.util.List<software.amazon.awscdk.services.kinesisfirehose.IDestination> destinations;
        java.lang.String deliveryStreamName;
        software.amazon.awscdk.services.kinesisfirehose.StreamEncryption encryption;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.kinesis.IStream sourceStream;

        /**
         * Sets the value of {@link DeliveryStreamProps#getDestinations}
         * @param destinations The destinations that this delivery stream will deliver data to. This parameter is required.
         *                     Only a singleton array is supported at this time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder destinations(java.util.List<? extends software.amazon.awscdk.services.kinesisfirehose.IDestination> destinations) {
            this.destinations = (java.util.List<software.amazon.awscdk.services.kinesisfirehose.IDestination>)destinations;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryStreamProps#getDeliveryStreamName}
         * @param deliveryStreamName A name for the delivery stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deliveryStreamName(java.lang.String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryStreamProps#getEncryption}
         * @param encryption Indicates the type of customer master key (CMK) to use for server-side encryption, if any.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryption(software.amazon.awscdk.services.kinesisfirehose.StreamEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryStreamProps#getEncryptionKey}
         * @param encryptionKey Customer managed key to server-side encrypt data in the stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryStreamProps#getRole}
         * @param role The IAM role associated with this delivery stream.
         *             Assumed by Kinesis Data Firehose to read from sources and encrypt data server-side.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryStreamProps#getSourceStream}
         * @param sourceStream The Kinesis data stream to use as a source for this delivery stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceStream(software.amazon.awscdk.services.kinesis.IStream sourceStream) {
            this.sourceStream = sourceStream;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeliveryStreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DeliveryStreamProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeliveryStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryStreamProps {
        private final java.util.List<software.amazon.awscdk.services.kinesisfirehose.IDestination> destinations;
        private final java.lang.String deliveryStreamName;
        private final software.amazon.awscdk.services.kinesisfirehose.StreamEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.kinesis.IStream sourceStream;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.IDestination.class)));
            this.deliveryStreamName = software.amazon.jsii.Kernel.get(this, "deliveryStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.StreamEncryption.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.sourceStream = software.amazon.jsii.Kernel.get(this, "sourceStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.IStream.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinations = (java.util.List<software.amazon.awscdk.services.kinesisfirehose.IDestination>)java.util.Objects.requireNonNull(builder.destinations, "destinations is required");
            this.deliveryStreamName = builder.deliveryStreamName;
            this.encryption = builder.encryption;
            this.encryptionKey = builder.encryptionKey;
            this.role = builder.role;
            this.sourceStream = builder.sourceStream;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.kinesisfirehose.IDestination> getDestinations() {
            return this.destinations;
        }

        @Override
        public final java.lang.String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.StreamEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.IStream getSourceStream() {
            return this.sourceStream;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinations", om.valueToTree(this.getDestinations()));
            if (this.getDeliveryStreamName() != null) {
                data.set("deliveryStreamName", om.valueToTree(this.getDeliveryStreamName()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSourceStream() != null) {
                data.set("sourceStream", om.valueToTree(this.getSourceStream()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesisfirehose.DeliveryStreamProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeliveryStreamProps.Jsii$Proxy that = (DeliveryStreamProps.Jsii$Proxy) o;

            if (!destinations.equals(that.destinations)) return false;
            if (this.deliveryStreamName != null ? !this.deliveryStreamName.equals(that.deliveryStreamName) : that.deliveryStreamName != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.sourceStream != null ? this.sourceStream.equals(that.sourceStream) : that.sourceStream == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinations.hashCode();
            result = 31 * result + (this.deliveryStreamName != null ? this.deliveryStreamName.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.sourceStream != null ? this.sourceStream.hashCode() : 0);
            return result;
        }
    }
}
