package software.amazon.awscdk.services.kinesisfirehose;

/**
 * (experimental) Configure the data processor.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import path.*;
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.lambda.nodejs.*;
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.kinesisfirehose.destinations.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-cdk-firehose-delivery-stream-s3-all-properties");
 * Bucket bucket = Bucket.Builder.create(stack, "Bucket")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .autoDeleteObjects(true)
 *         .build();
 * Bucket backupBucket = Bucket.Builder.create(stack, "BackupBucket")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .autoDeleteObjects(true)
 *         .build();
 * LogGroup logGroup = LogGroup.Builder.create(stack, "LogGroup")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * NodejsFunction dataProcessorFunction = NodejsFunction.Builder.create(stack, "DataProcessorFunction")
 *         .entry(join(__dirname, "lambda-data-processor.js"))
 *         .timeout(Duration.minutes(1))
 *         .build();
 * LambdaFunctionProcessor processor = LambdaFunctionProcessor.Builder.create(dataProcessorFunction)
 *         .bufferInterval(Duration.seconds(60))
 *         .bufferSize(Size.mebibytes(1))
 *         .retries(1)
 *         .build();
 * Key key = Key.Builder.create(stack, "Key")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * Key backupKey = Key.Builder.create(stack, "BackupKey")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * DeliveryStream.Builder.create(stack, "Delivery Stream")
 *         .destinations(List.of(S3Bucket.Builder.create(bucket)
 *                 .logging(true)
 *                 .logGroup(logGroup)
 *                 .processor(processor)
 *                 .compression(Compression.GZIP)
 *                 .dataOutputPrefix("regularPrefix")
 *                 .errorOutputPrefix("errorPrefix")
 *                 .bufferingInterval(Duration.seconds(60))
 *                 .bufferingSize(Size.mebibytes(1))
 *                 .encryptionKey(key)
 *                 .s3Backup(DestinationS3BackupProps.builder()
 *                         .mode(BackupMode.ALL)
 *                         .bucket(backupBucket)
 *                         .compression(Compression.ZIP)
 *                         .dataOutputPrefix("backupPrefix")
 *                         .errorOutputPrefix("backupErrorPrefix")
 *                         .bufferingInterval(Duration.seconds(60))
 *                         .bufferingSize(Size.mebibytes(1))
 *                         .encryptionKey(backupKey)
 *                         .build())
 *                 .build()))
 *         .build();
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:41.088Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisfirehose.$Module.class, fqn = "@aws-cdk/aws-kinesisfirehose.DataProcessorProps")
@software.amazon.jsii.Jsii.Proxy(DataProcessorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DataProcessorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The length of time Kinesis Data Firehose will buffer incoming data before calling the processor.
     * <p>
     * s
     * <p>
     * Default: Duration.minutes(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getBufferInterval() {
        return null;
    }

    /**
     * (experimental) The amount of incoming data Kinesis Data Firehose will buffer before calling the processor.
     * <p>
     * Default: Size.mebibytes(3)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Size getBufferSize() {
        return null;
    }

    /**
     * (experimental) The number of times Kinesis Data Firehose will retry the processor invocation after a failure due to network timeout or invocation limits.
     * <p>
     * Default: 3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetries() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DataProcessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataProcessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DataProcessorProps> {
        software.amazon.awscdk.core.Duration bufferInterval;
        software.amazon.awscdk.core.Size bufferSize;
        java.lang.Number retries;

        /**
         * Sets the value of {@link DataProcessorProps#getBufferInterval}
         * @param bufferInterval The length of time Kinesis Data Firehose will buffer incoming data before calling the processor.
         *                       s
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bufferInterval(software.amazon.awscdk.core.Duration bufferInterval) {
            this.bufferInterval = bufferInterval;
            return this;
        }

        /**
         * Sets the value of {@link DataProcessorProps#getBufferSize}
         * @param bufferSize The amount of incoming data Kinesis Data Firehose will buffer before calling the processor.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bufferSize(software.amazon.awscdk.core.Size bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        /**
         * Sets the value of {@link DataProcessorProps#getRetries}
         * @param retries The number of times Kinesis Data Firehose will retry the processor invocation after a failure due to network timeout or invocation limits.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retries(java.lang.Number retries) {
            this.retries = retries;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataProcessorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DataProcessorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataProcessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataProcessorProps {
        private final software.amazon.awscdk.core.Duration bufferInterval;
        private final software.amazon.awscdk.core.Size bufferSize;
        private final java.lang.Number retries;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bufferInterval = software.amazon.jsii.Kernel.get(this, "bufferInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.bufferSize = software.amazon.jsii.Kernel.get(this, "bufferSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class));
            this.retries = software.amazon.jsii.Kernel.get(this, "retries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bufferInterval = builder.bufferInterval;
            this.bufferSize = builder.bufferSize;
            this.retries = builder.retries;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getBufferInterval() {
            return this.bufferInterval;
        }

        @Override
        public final software.amazon.awscdk.core.Size getBufferSize() {
            return this.bufferSize;
        }

        @Override
        public final java.lang.Number getRetries() {
            return this.retries;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBufferInterval() != null) {
                data.set("bufferInterval", om.valueToTree(this.getBufferInterval()));
            }
            if (this.getBufferSize() != null) {
                data.set("bufferSize", om.valueToTree(this.getBufferSize()));
            }
            if (this.getRetries() != null) {
                data.set("retries", om.valueToTree(this.getRetries()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesisfirehose.DataProcessorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataProcessorProps.Jsii$Proxy that = (DataProcessorProps.Jsii$Proxy) o;

            if (this.bufferInterval != null ? !this.bufferInterval.equals(that.bufferInterval) : that.bufferInterval != null) return false;
            if (this.bufferSize != null ? !this.bufferSize.equals(that.bufferSize) : that.bufferSize != null) return false;
            return this.retries != null ? this.retries.equals(that.retries) : that.retries == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bufferInterval != null ? this.bufferInterval.hashCode() : 0;
            result = 31 * result + (this.bufferSize != null ? this.bufferSize.hashCode() : 0);
            result = 31 * result + (this.retries != null ? this.retries.hashCode() : 0);
            return result;
        }
    }
}
