package software.amazon.awscdk.services.kms;

/**
 * Properties for defining a <code>CfnKey</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kms.*;
 * Object keyPolicy;
 * CfnKeyProps cfnKeyProps = CfnKeyProps.builder()
 *         .keyPolicy(keyPolicy)
 *         // the properties below are optional
 *         .description("description")
 *         .enabled(false)
 *         .enableKeyRotation(false)
 *         .keySpec("keySpec")
 *         .keyUsage("keyUsage")
 *         .multiRegion(false)
 *         .pendingWindowInDays(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:37.277Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kms.$Module.class, fqn = "@aws-cdk/aws-kms.CfnKeyProps")
@software.amazon.jsii.Jsii.Proxy(CfnKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnKeyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The key policy that authorizes use of the KMS key. The key policy must conform to the following rules.
     * <p>
     * <ul>
     * <li>The key policy must allow the caller to make a subsequent <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_PutKeyPolicy.html">PutKeyPolicy</a> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default key policy</a> section of the <strong>AWS Key Management Service Developer Guide</strong> .</li>
     * <li>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to AWS KMS . When you create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to AWS KMS . For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <em>AWS Identity and Access Management User Guide</em> .</li>
     * </ul>
     * <p>
     * If you are unsure of which policy to use, consider the <em>default key policy</em> . This is the key policy that AWS KMS applies to KMS keys that are created by using the CreateKey API with no specified key policy. It gives the AWS account that owns the key permission to perform all operations on the key. It also allows you write IAM policies to authorize access to the key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key policy</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * A key policy document can include only the following characters:
     * <p>
     * <ul>
     * <li>Printable ASCII characters</li>
     * <li>Printable characters in the Basic Latin and Latin-1 Supplement character set</li>
     * <li>The tab ( <code>\ u0009</code> ), line feed ( <code>\ u000A</code> ), and carriage return ( <code>\ u000D</code> ) special characters</li>
     * </ul>
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>32768</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKeyPolicy();

    /**
     * A description of the KMS key.
     * <p>
     * Use a description that helps you to distinguish this KMS key from others in the account, such as its intended use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
     * <p>
     * When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
     * <p>
     * The actual key state of the KMS key might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations.
     * <p>
     * For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return null;
    }

    /**
     * Enables automatic rotation of the key material for the specified KMS key.
     * <p>
     * By default, automatic key rotation is not enabled.
     * <p>
     * AWS KMS supports automatic rotation only for symmetric encryption KMS keys ( <code>KeySpec</code> = <code>SYMMETRIC_DEFAULT</code> ). For asymmetric KMS keys and HMAC KMS keys, omit the <code>EnableKeyRotation</code> property or set it to <code>false</code> .
     * <p>
     * To enable automatic key rotation of the key material for a multi-Region KMS key, set <code>EnableKeyRotation</code> to <code>true</code> on the primary key (created by using <code>AWS::KMS::Key</code> ). AWS KMS copies the rotation status to all replica keys. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate">Rotating multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * When you enable automatic rotation, AWS KMS automatically creates new key material for the KMS key one year after the enable date and every year thereafter. AWS KMS retains all key material until you delete the KMS key. For detailed information about automatic key rotation, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">Rotating KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableKeyRotation() {
        return null;
    }

    /**
     * Specifies the type of KMS key to create.
     * <p>
     * The default value, <code>SYMMETRIC_DEFAULT</code> , creates a KMS key with a 256-bit symmetric key for encryption and decryption. In China Regions, <code>SYMMETRIC_DEFAULT</code> creates a 128-bit symmetric key that uses SM4 encryption. You can't change the <code>KeySpec</code> value after the KMS key is created. For help choosing a key spec for your KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html">Choosing a KMS key type</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * The <code>KeySpec</code> property determines the type of key material in the KMS key and the algorithms that the KMS key supports. To further restrict the algorithms that can be used with the KMS key, use a condition key in its key policy or IAM policy. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms">AWS KMS condition keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you change the value of the <code>KeySpec</code> property on an existing KMS key, the update request fails, regardless of the value of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"><code>UpdateReplacePolicy</code> attribute</a> . This prevents you from accidentally deleting a KMS key by changing an immutable property value. &gt; <a href="https://docs.aws.amazon.com/kms/features/#AWS_Service_Integration">AWS services that are integrated with AWS KMS</a> use symmetric encryption KMS keys to protect your data. These services do not support encryption with asymmetric KMS keys. For help determining whether a KMS key is asymmetric, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/find-symm-asymm.html">Identifying asymmetric KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * AWS KMS supports the following key specs for KMS keys:
     * <p>
     * <ul>
     * <li>Symmetric encryption key (default)</li>
     * <li><code>SYMMETRIC_DEFAULT</code> (AES-256-GCM)</li>
     * <li>HMAC keys (symmetric)</li>
     * <li><code>HMAC_224</code></li>
     * <li><code>HMAC_256</code></li>
     * <li><code>HMAC_384</code></li>
     * <li><code>HMAC_512</code></li>
     * <li>Asymmetric RSA key pairs</li>
     * <li><code>RSA_2048</code></li>
     * <li><code>RSA_3072</code></li>
     * <li><code>RSA_4096</code></li>
     * <li>Asymmetric NIST-recommended elliptic curve key pairs</li>
     * <li><code>ECC_NIST_P256</code> (secp256r1)</li>
     * <li><code>ECC_NIST_P384</code> (secp384r1)</li>
     * <li><code>ECC_NIST_P521</code> (secp521r1)</li>
     * <li>Other asymmetric elliptic curve key pairs</li>
     * <li><code>ECC_SECG_P256K1</code> (secp256k1), commonly used for cryptocurrencies.</li>
     * <li>SM2 key pairs (China Regions only)</li>
     * <li><code>SM2</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeySpec() {
        return null;
    }

    /**
     * Determines the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key. The default value is <code>ENCRYPT_DECRYPT</code> . This property is required for asymmetric KMS keys and HMAC KMS keys. You can't change the <code>KeyUsage</code> value after the KMS key is created.
     * <p>
     * <blockquote>
     * <p>
     * If you change the value of the <code>KeyUsage</code> property on an existing KMS key, the update request fails, regardless of the value of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"><code>UpdateReplacePolicy</code> attribute</a> . This prevents you from accidentally deleting a KMS key by changing an immutable property value.
     * <p>
     * </blockquote>
     * <p>
     * Select only one valid value.
     * <p>
     * <ul>
     * <li>For symmetric encryption KMS keys, omit the property or specify <code>ENCRYPT_DECRYPT</code> .</li>
     * <li>For asymmetric KMS keys with RSA key material, specify <code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code> .</li>
     * <li>For asymmetric KMS keys with ECC key material, specify <code>SIGN_VERIFY</code> .</li>
     * <li>For asymmetric KMS keys with SM2 (China Regions only) key material, specify <code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code> .</li>
     * <li>For HMAC KMS keys, specify <code>GENERATE_VERIFY_MAC</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyUsage() {
        return null;
    }

    /**
     * Creates a multi-Region primary key that you can replicate in other AWS Regions .
     * <p>
     * You can't change the <code>MultiRegion</code> value after the KMS key is created.
     * <p>
     * For a list of AWS Regions in which multi-Region keys are supported, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys in AWS KMS</a> in the ** .
     * <p>
     * <blockquote>
     * <p>
     * If you change the value of the <code>MultiRegion</code> property on an existing KMS key, the update request fails, regardless of the value of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"><code>UpdateReplacePolicy</code> attribute</a> . This prevents you from accidentally deleting a KMS key by changing an immutable property value.
     * <p>
     * </blockquote>
     * <p>
     * For a multi-Region key, set to this property to <code>true</code> . For a single-Region key, omit this property or set it to <code>false</code> . The default value is <code>false</code> .
     * <p>
     * <em>Multi-Region keys</em> are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * You can create a symmetric encryption, HMAC, or asymmetric multi-Region KMS key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.
     * <p>
     * To create a replica of this primary key in a different AWS Region , create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html">AWS::KMS::ReplicaKey</a> resource in a CloudFormation stack in the replica Region. Specify the key ARN of this primary key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMultiRegion() {
        return null;
    }

    /**
     * Specifies the number of days in the waiting period before AWS KMS deletes a KMS key that has been removed from a CloudFormation stack.
     * <p>
     * Enter a value between 7 and 30 days. The default value is 30 days.
     * <p>
     * When you remove a KMS key from a CloudFormation stack, AWS KMS schedules the KMS key for deletion and starts the mandatory waiting period. The <code>PendingWindowInDays</code> property determines the length of waiting period. During the waiting period, the key state of KMS key is <code>Pending Deletion</code> or <code>Pending Replica Deletion</code> , which prevents the KMS key from being used in cryptographic operations. When the waiting period expires, AWS KMS permanently deletes the KMS key.
     * <p>
     * AWS KMS will not delete a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">multi-Region primary key</a> that has replica keys. If you remove a multi-Region primary key from a CloudFormation stack, its key state changes to <code>PendingReplicaDeletion</code> so it cannot be replicated or used in cryptographic operations. This state can persist indefinitely. When the last of its replica keys is deleted, the key state of the primary key changes to <code>PendingDeletion</code> and the waiting period specified by <code>PendingWindowInDays</code> begins. When this waiting period expires, AWS KMS deletes the primary key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html">Deleting multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * You cannot use a CloudFormation template to cancel deletion of the KMS key after you remove it from the stack, regardless of the waiting period. If you specify a KMS key in your template, even one with the same name, CloudFormation creates a new KMS key. To cancel deletion of a KMS key, use the AWS KMS console or the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CancelKeyDeletion.html">CancelKeyDeletion</a> operation.
     * <p>
     * For information about the <code>Pending Deletion</code> and <code>Pending Replica Deletion</code> key states, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> . For more information about deleting KMS keys, see the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operation in the <em>AWS Key Management Service API Reference</em> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">Deleting KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * <em>Minimum</em> : 7
     * <p>
     * <em>Maximum</em> : 30
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPendingWindowInDays() {
        return null;
    }

    /**
     * Assigns one or more tags to the replica key.
     * <p>
     * <blockquote>
     * <p>
     * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC for AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * For information about tags in AWS KMS , see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging keys</a> in the <em>AWS Key Management Service Developer Guide</em> . For information about tags in CloudFormation, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnKeyProps> {
        java.lang.Object keyPolicy;
        java.lang.String description;
        java.lang.Object enabled;
        java.lang.Object enableKeyRotation;
        java.lang.String keySpec;
        java.lang.String keyUsage;
        java.lang.Object multiRegion;
        java.lang.Number pendingWindowInDays;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnKeyProps#getKeyPolicy}
         * @param keyPolicy The key policy that authorizes use of the KMS key. The key policy must conform to the following rules. This parameter is required.
         *                  <ul>
         *                  <li>The key policy must allow the caller to make a subsequent <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_PutKeyPolicy.html">PutKeyPolicy</a> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default key policy</a> section of the <strong>AWS Key Management Service Developer Guide</strong> .</li>
         *                  <li>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to AWS KMS . When you create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to AWS KMS . For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <em>AWS Identity and Access Management User Guide</em> .</li>
         *                  </ul>
         *                  <p>
         *                  If you are unsure of which policy to use, consider the <em>default key policy</em> . This is the key policy that AWS KMS applies to KMS keys that are created by using the CreateKey API with no specified key policy. It gives the AWS account that owns the key permission to perform all operations on the key. It also allows you write IAM policies to authorize access to the key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key policy</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                  <p>
         *                  A key policy document can include only the following characters:
         *                  <p>
         *                  <ul>
         *                  <li>Printable ASCII characters</li>
         *                  <li>Printable characters in the Basic Latin and Latin-1 Supplement character set</li>
         *                  <li>The tab ( <code>\ u0009</code> ), line feed ( <code>\ u000A</code> ), and carriage return ( <code>\ u000D</code> ) special characters</li>
         *                  </ul>
         *                  <p>
         *                  <em>Minimum</em> : <code>1</code>
         *                  <p>
         *                  <em>Maximum</em> : <code>32768</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPolicy(java.lang.Object keyPolicy) {
            this.keyPolicy = keyPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getDescription}
         * @param description A description of the KMS key.
         *                    Use a description that helps you to distinguish this KMS key from others in the account, such as its intended use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getEnabled}
         * @param enabled Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
         *                When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
         *                <p>
         *                The actual key state of the KMS key might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations.
         *                <p>
         *                For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getEnabled}
         * @param enabled Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
         *                When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
         *                <p>
         *                The actual key state of the KMS key might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations.
         *                <p>
         *                For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getEnableKeyRotation}
         * @param enableKeyRotation Enables automatic rotation of the key material for the specified KMS key.
         *                          By default, automatic key rotation is not enabled.
         *                          <p>
         *                          AWS KMS supports automatic rotation only for symmetric encryption KMS keys ( <code>KeySpec</code> = <code>SYMMETRIC_DEFAULT</code> ). For asymmetric KMS keys and HMAC KMS keys, omit the <code>EnableKeyRotation</code> property or set it to <code>false</code> .
         *                          <p>
         *                          To enable automatic key rotation of the key material for a multi-Region KMS key, set <code>EnableKeyRotation</code> to <code>true</code> on the primary key (created by using <code>AWS::KMS::Key</code> ). AWS KMS copies the rotation status to all replica keys. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate">Rotating multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                          <p>
         *                          When you enable automatic rotation, AWS KMS automatically creates new key material for the KMS key one year after the enable date and every year thereafter. AWS KMS retains all key material until you delete the KMS key. For detailed information about automatic key rotation, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">Rotating KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(java.lang.Boolean enableKeyRotation) {
            this.enableKeyRotation = enableKeyRotation;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getEnableKeyRotation}
         * @param enableKeyRotation Enables automatic rotation of the key material for the specified KMS key.
         *                          By default, automatic key rotation is not enabled.
         *                          <p>
         *                          AWS KMS supports automatic rotation only for symmetric encryption KMS keys ( <code>KeySpec</code> = <code>SYMMETRIC_DEFAULT</code> ). For asymmetric KMS keys and HMAC KMS keys, omit the <code>EnableKeyRotation</code> property or set it to <code>false</code> .
         *                          <p>
         *                          To enable automatic key rotation of the key material for a multi-Region KMS key, set <code>EnableKeyRotation</code> to <code>true</code> on the primary key (created by using <code>AWS::KMS::Key</code> ). AWS KMS copies the rotation status to all replica keys. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate">Rotating multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                          <p>
         *                          When you enable automatic rotation, AWS KMS automatically creates new key material for the KMS key one year after the enable date and every year thereafter. AWS KMS retains all key material until you delete the KMS key. For detailed information about automatic key rotation, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">Rotating KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(software.amazon.awscdk.core.IResolvable enableKeyRotation) {
            this.enableKeyRotation = enableKeyRotation;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getKeySpec}
         * @param keySpec Specifies the type of KMS key to create.
         *                The default value, <code>SYMMETRIC_DEFAULT</code> , creates a KMS key with a 256-bit symmetric key for encryption and decryption. In China Regions, <code>SYMMETRIC_DEFAULT</code> creates a 128-bit symmetric key that uses SM4 encryption. You can't change the <code>KeySpec</code> value after the KMS key is created. For help choosing a key spec for your KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html">Choosing a KMS key type</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                <p>
         *                The <code>KeySpec</code> property determines the type of key material in the KMS key and the algorithms that the KMS key supports. To further restrict the algorithms that can be used with the KMS key, use a condition key in its key policy or IAM policy. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms">AWS KMS condition keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                <p>
         *                <blockquote>
         *                <p>
         *                If you change the value of the <code>KeySpec</code> property on an existing KMS key, the update request fails, regardless of the value of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"><code>UpdateReplacePolicy</code> attribute</a> . This prevents you from accidentally deleting a KMS key by changing an immutable property value. &gt; <a href="https://docs.aws.amazon.com/kms/features/#AWS_Service_Integration">AWS services that are integrated with AWS KMS</a> use symmetric encryption KMS keys to protect your data. These services do not support encryption with asymmetric KMS keys. For help determining whether a KMS key is asymmetric, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/find-symm-asymm.html">Identifying asymmetric KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                <p>
         *                </blockquote>
         *                <p>
         *                AWS KMS supports the following key specs for KMS keys:
         *                <p>
         *                <ul>
         *                <li>Symmetric encryption key (default)</li>
         *                <li><code>SYMMETRIC_DEFAULT</code> (AES-256-GCM)</li>
         *                <li>HMAC keys (symmetric)</li>
         *                <li><code>HMAC_224</code></li>
         *                <li><code>HMAC_256</code></li>
         *                <li><code>HMAC_384</code></li>
         *                <li><code>HMAC_512</code></li>
         *                <li>Asymmetric RSA key pairs</li>
         *                <li><code>RSA_2048</code></li>
         *                <li><code>RSA_3072</code></li>
         *                <li><code>RSA_4096</code></li>
         *                <li>Asymmetric NIST-recommended elliptic curve key pairs</li>
         *                <li><code>ECC_NIST_P256</code> (secp256r1)</li>
         *                <li><code>ECC_NIST_P384</code> (secp384r1)</li>
         *                <li><code>ECC_NIST_P521</code> (secp521r1)</li>
         *                <li>Other asymmetric elliptic curve key pairs</li>
         *                <li><code>ECC_SECG_P256K1</code> (secp256k1), commonly used for cryptocurrencies.</li>
         *                <li>SM2 key pairs (China Regions only)</li>
         *                <li><code>SM2</code></li>
         *                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySpec(java.lang.String keySpec) {
            this.keySpec = keySpec;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getKeyUsage}
         * @param keyUsage Determines the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key. The default value is <code>ENCRYPT_DECRYPT</code> . This property is required for asymmetric KMS keys and HMAC KMS keys. You can't change the <code>KeyUsage</code> value after the KMS key is created.
         *                 <blockquote>
         *                 <p>
         *                 If you change the value of the <code>KeyUsage</code> property on an existing KMS key, the update request fails, regardless of the value of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"><code>UpdateReplacePolicy</code> attribute</a> . This prevents you from accidentally deleting a KMS key by changing an immutable property value.
         *                 <p>
         *                 </blockquote>
         *                 <p>
         *                 Select only one valid value.
         *                 <p>
         *                 <ul>
         *                 <li>For symmetric encryption KMS keys, omit the property or specify <code>ENCRYPT_DECRYPT</code> .</li>
         *                 <li>For asymmetric KMS keys with RSA key material, specify <code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code> .</li>
         *                 <li>For asymmetric KMS keys with ECC key material, specify <code>SIGN_VERIFY</code> .</li>
         *                 <li>For asymmetric KMS keys with SM2 (China Regions only) key material, specify <code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code> .</li>
         *                 <li>For HMAC KMS keys, specify <code>GENERATE_VERIFY_MAC</code> .</li>
         *                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyUsage(java.lang.String keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getMultiRegion}
         * @param multiRegion Creates a multi-Region primary key that you can replicate in other AWS Regions .
         *                    You can't change the <code>MultiRegion</code> value after the KMS key is created.
         *                    <p>
         *                    For a list of AWS Regions in which multi-Region keys are supported, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys in AWS KMS</a> in the ** .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    If you change the value of the <code>MultiRegion</code> property on an existing KMS key, the update request fails, regardless of the value of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"><code>UpdateReplacePolicy</code> attribute</a> . This prevents you from accidentally deleting a KMS key by changing an immutable property value.
         *                    <p>
         *                    </blockquote>
         *                    <p>
         *                    For a multi-Region key, set to this property to <code>true</code> . For a single-Region key, omit this property or set it to <code>false</code> . The default value is <code>false</code> .
         *                    <p>
         *                    <em>Multi-Region keys</em> are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                    <p>
         *                    You can create a symmetric encryption, HMAC, or asymmetric multi-Region KMS key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.
         *                    <p>
         *                    To create a replica of this primary key in a different AWS Region , create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html">AWS::KMS::ReplicaKey</a> resource in a CloudFormation stack in the replica Region. Specify the key ARN of this primary key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegion(java.lang.Boolean multiRegion) {
            this.multiRegion = multiRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getMultiRegion}
         * @param multiRegion Creates a multi-Region primary key that you can replicate in other AWS Regions .
         *                    You can't change the <code>MultiRegion</code> value after the KMS key is created.
         *                    <p>
         *                    For a list of AWS Regions in which multi-Region keys are supported, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys in AWS KMS</a> in the ** .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    If you change the value of the <code>MultiRegion</code> property on an existing KMS key, the update request fails, regardless of the value of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"><code>UpdateReplacePolicy</code> attribute</a> . This prevents you from accidentally deleting a KMS key by changing an immutable property value.
         *                    <p>
         *                    </blockquote>
         *                    <p>
         *                    For a multi-Region key, set to this property to <code>true</code> . For a single-Region key, omit this property or set it to <code>false</code> . The default value is <code>false</code> .
         *                    <p>
         *                    <em>Multi-Region keys</em> are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                    <p>
         *                    You can create a symmetric encryption, HMAC, or asymmetric multi-Region KMS key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.
         *                    <p>
         *                    To create a replica of this primary key in a different AWS Region , create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html">AWS::KMS::ReplicaKey</a> resource in a CloudFormation stack in the replica Region. Specify the key ARN of this primary key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegion(software.amazon.awscdk.core.IResolvable multiRegion) {
            this.multiRegion = multiRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getPendingWindowInDays}
         * @param pendingWindowInDays Specifies the number of days in the waiting period before AWS KMS deletes a KMS key that has been removed from a CloudFormation stack.
         *                            Enter a value between 7 and 30 days. The default value is 30 days.
         *                            <p>
         *                            When you remove a KMS key from a CloudFormation stack, AWS KMS schedules the KMS key for deletion and starts the mandatory waiting period. The <code>PendingWindowInDays</code> property determines the length of waiting period. During the waiting period, the key state of KMS key is <code>Pending Deletion</code> or <code>Pending Replica Deletion</code> , which prevents the KMS key from being used in cryptographic operations. When the waiting period expires, AWS KMS permanently deletes the KMS key.
         *                            <p>
         *                            AWS KMS will not delete a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">multi-Region primary key</a> that has replica keys. If you remove a multi-Region primary key from a CloudFormation stack, its key state changes to <code>PendingReplicaDeletion</code> so it cannot be replicated or used in cryptographic operations. This state can persist indefinitely. When the last of its replica keys is deleted, the key state of the primary key changes to <code>PendingDeletion</code> and the waiting period specified by <code>PendingWindowInDays</code> begins. When this waiting period expires, AWS KMS deletes the primary key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html">Deleting multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                            <p>
         *                            You cannot use a CloudFormation template to cancel deletion of the KMS key after you remove it from the stack, regardless of the waiting period. If you specify a KMS key in your template, even one with the same name, CloudFormation creates a new KMS key. To cancel deletion of a KMS key, use the AWS KMS console or the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CancelKeyDeletion.html">CancelKeyDeletion</a> operation.
         *                            <p>
         *                            For information about the <code>Pending Deletion</code> and <code>Pending Replica Deletion</code> key states, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> . For more information about deleting KMS keys, see the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operation in the <em>AWS Key Management Service API Reference</em> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">Deleting KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                            <p>
         *                            <em>Minimum</em> : 7
         *                            <p>
         *                            <em>Maximum</em> : 30
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pendingWindowInDays(java.lang.Number pendingWindowInDays) {
            this.pendingWindowInDays = pendingWindowInDays;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getTags}
         * @param tags Assigns one or more tags to the replica key.
         *             <blockquote>
         *             <p>
         *             Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC for AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *             <p>
         *             </blockquote>
         *             <p>
         *             For information about tags in AWS KMS , see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging keys</a> in the <em>AWS Key Management Service Developer Guide</em> . For information about tags in CloudFormation, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnKeyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnKeyProps {
        private final java.lang.Object keyPolicy;
        private final java.lang.String description;
        private final java.lang.Object enabled;
        private final java.lang.Object enableKeyRotation;
        private final java.lang.String keySpec;
        private final java.lang.String keyUsage;
        private final java.lang.Object multiRegion;
        private final java.lang.Number pendingWindowInDays;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.keyPolicy = software.amazon.jsii.Kernel.get(this, "keyPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableKeyRotation = software.amazon.jsii.Kernel.get(this, "enableKeyRotation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.keySpec = software.amazon.jsii.Kernel.get(this, "keySpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyUsage = software.amazon.jsii.Kernel.get(this, "keyUsage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiRegion = software.amazon.jsii.Kernel.get(this, "multiRegion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.pendingWindowInDays = software.amazon.jsii.Kernel.get(this, "pendingWindowInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keyPolicy = java.util.Objects.requireNonNull(builder.keyPolicy, "keyPolicy is required");
            this.description = builder.description;
            this.enabled = builder.enabled;
            this.enableKeyRotation = builder.enableKeyRotation;
            this.keySpec = builder.keySpec;
            this.keyUsage = builder.keyUsage;
            this.multiRegion = builder.multiRegion;
            this.pendingWindowInDays = builder.pendingWindowInDays;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getKeyPolicy() {
            return this.keyPolicy;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.Object getEnableKeyRotation() {
            return this.enableKeyRotation;
        }

        @Override
        public final java.lang.String getKeySpec() {
            return this.keySpec;
        }

        @Override
        public final java.lang.String getKeyUsage() {
            return this.keyUsage;
        }

        @Override
        public final java.lang.Object getMultiRegion() {
            return this.multiRegion;
        }

        @Override
        public final java.lang.Number getPendingWindowInDays() {
            return this.pendingWindowInDays;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("keyPolicy", om.valueToTree(this.getKeyPolicy()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEnableKeyRotation() != null) {
                data.set("enableKeyRotation", om.valueToTree(this.getEnableKeyRotation()));
            }
            if (this.getKeySpec() != null) {
                data.set("keySpec", om.valueToTree(this.getKeySpec()));
            }
            if (this.getKeyUsage() != null) {
                data.set("keyUsage", om.valueToTree(this.getKeyUsage()));
            }
            if (this.getMultiRegion() != null) {
                data.set("multiRegion", om.valueToTree(this.getMultiRegion()));
            }
            if (this.getPendingWindowInDays() != null) {
                data.set("pendingWindowInDays", om.valueToTree(this.getPendingWindowInDays()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-kms.CfnKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnKeyProps.Jsii$Proxy that = (CfnKeyProps.Jsii$Proxy) o;

            if (!keyPolicy.equals(that.keyPolicy)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.enableKeyRotation != null ? !this.enableKeyRotation.equals(that.enableKeyRotation) : that.enableKeyRotation != null) return false;
            if (this.keySpec != null ? !this.keySpec.equals(that.keySpec) : that.keySpec != null) return false;
            if (this.keyUsage != null ? !this.keyUsage.equals(that.keyUsage) : that.keyUsage != null) return false;
            if (this.multiRegion != null ? !this.multiRegion.equals(that.multiRegion) : that.multiRegion != null) return false;
            if (this.pendingWindowInDays != null ? !this.pendingWindowInDays.equals(that.pendingWindowInDays) : that.pendingWindowInDays != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.keyPolicy.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.enableKeyRotation != null ? this.enableKeyRotation.hashCode() : 0);
            result = 31 * result + (this.keySpec != null ? this.keySpec.hashCode() : 0);
            result = 31 * result + (this.keyUsage != null ? this.keyUsage.hashCode() : 0);
            result = 31 * result + (this.multiRegion != null ? this.multiRegion.hashCode() : 0);
            result = 31 * result + (this.pendingWindowInDays != null ? this.pendingWindowInDays.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
