/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kms;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.iam.AddToResourcePolicyResult;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.$Module;
import software.amazon.awscdk.services.kms.Alias;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.kms.KeyProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-kms.Key")
public class Key
extends Resource
implements IKey {
    protected Key(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Key(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Key(@NotNull Construct scope, @NotNull String id, @Nullable KeyProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Key(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IKey fromKeyArn(@NotNull Construct scope, @NotNull String id, @NotNull String keyArn) {
        return (IKey)JsiiObject.jsiiStaticCall(Key.class, (String)"fromKeyArn", IKey.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(keyArn, "keyArn is required")});
    }

    @Override
    @NotNull
    public Alias addAlias(@NotNull String aliasName) {
        return (Alias)this.jsiiCall("addAlias", Alias.class, new Object[]{Objects.requireNonNull(aliasName, "aliasName is required")});
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement, @Nullable Boolean allowNoOp) {
        return (AddToResourcePolicyResult)this.jsiiCall("addToResourcePolicy", AddToResourcePolicyResult.class, new Object[]{Objects.requireNonNull(statement, "statement is required"), allowNoOp});
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement) {
        return (AddToResourcePolicyResult)this.jsiiCall("addToResourcePolicy", AddToResourcePolicyResult.class, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)this.jsiiCall("grant", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Grant grantDecrypt(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantDecrypt", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantEncrypt(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantEncrypt", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantEncryptDecrypt(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantEncryptDecrypt", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)this.jsiiCall("validate", NativeType.listOf((NativeType)NativeType.forClass(String.class)), new Object[0]));
    }

    @Override
    @NotNull
    public String getKeyArn() {
        return (String)this.jsiiGet("keyArn", String.class);
    }

    @Override
    @NotNull
    public String getKeyId() {
        return (String)this.jsiiGet("keyId", String.class);
    }

    @NotNull
    protected Boolean getTrustAccountIdentities() {
        return (Boolean)this.jsiiGet("trustAccountIdentities", Boolean.class);
    }

    @Nullable
    protected PolicyDocument getPolicy() {
        return (PolicyDocument)this.jsiiGet("policy", PolicyDocument.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Key> {
        private final Construct scope;
        private final String id;
        private KeyProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder alias(String alias) {
            this.props().alias(alias);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        public Builder enableKeyRotation(Boolean enableKeyRotation) {
            this.props().enableKeyRotation(enableKeyRotation);
            return this;
        }

        public Builder policy(PolicyDocument policy) {
            this.props().policy(policy);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        public Builder trustAccountIdentities(Boolean trustAccountIdentities) {
            this.props().trustAccountIdentities(trustAccountIdentities);
            return this;
        }

        public Key build() {
            return new Key(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private KeyProps.Builder props() {
            if (this.props == null) {
                this.props = new KeyProps.Builder();
            }
            return this.props;
        }
    }
}

