package software.amazon.awscdk.services.lambda;

/**
 * Represents an ECR image that will be constructed from the specified asset and can be bound as Lambda code.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T15:56:23.577Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.AssetImageCode")
public class AssetImageCode extends software.amazon.awscdk.services.lambda.Code {

    protected AssetImageCode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetImageCode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param directory This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetImageCode(final @org.jetbrains.annotations.NotNull java.lang.String directory, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AssetImageCodeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(directory, "directory is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Determines whether this Code is inline code or not.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsInline() {
        return software.amazon.jsii.Kernel.get(this, "isInline", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.AssetImageCode}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.AssetImageCode> {
        /**
         * @return a new instance of {@link Builder}.
         * @param directory This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String directory) {
            return new Builder(directory);
        }

        private final java.lang.String directory;
        private final software.amazon.awscdk.services.lambda.AssetImageCodeProps.Builder props;

        private Builder(final java.lang.String directory) {
            this.directory = directory;
            this.props = new software.amazon.awscdk.services.lambda.AssetImageCodeProps.Builder();
        }

        /**
         * Glob patterns to exclude from the copy.
         * <p>
         * Default: - nothing is excluded
         * <p>
         * @return {@code this}
         * @param exclude Glob patterns to exclude from the copy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(final java.util.List<java.lang.String> exclude) {
            this.props.exclude(exclude);
            return this;
        }

        /**
         * (deprecated) A strategy for how to handle symlinks.
         * <p>
         * Default: Never
         * <p>
         * @return {@code this}
         * @deprecated use `followSymlinks` instead
         * @param follow A strategy for how to handle symlinks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder follow(final software.amazon.awscdk.assets.FollowMode follow) {
            this.props.follow(follow);
            return this;
        }

        /**
         * The ignore behavior to use for exclude patterns.
         * <p>
         * Default: IgnoreMode.GLOB
         * <p>
         * @return {@code this}
         * @param ignoreMode The ignore behavior to use for exclude patterns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(final software.amazon.awscdk.core.IgnoreMode ignoreMode) {
            this.props.ignoreMode(ignoreMode);
            return this;
        }

        /**
         * Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * <p>
         * Default: - hash is only based on source content
         * <p>
         * @return {@code this}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHash(final java.lang.String extraHash) {
            this.props.extraHash(extraHash);
            return this;
        }

        /**
         * A strategy for how to handle symlinks.
         * <p>
         * Default: SymlinkFollowMode.NEVER
         * <p>
         * @return {@code this}
         * @param followSymlinks A strategy for how to handle symlinks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(final software.amazon.awscdk.core.SymlinkFollowMode followSymlinks) {
            this.props.followSymlinks(followSymlinks);
            return this;
        }

        /**
         * Build args to pass to the `docker build` command.
         * <p>
         * Since Docker build arguments are resolved before deployment, keys and
         * values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
         * <code>queue.queueUrl</code>).
         * <p>
         * Default: - no build args are passed
         * <p>
         * @return {@code this}
         * @param buildArgs Build args to pass to the `docker build` command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildArgs(final java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.props.buildArgs(buildArgs);
            return this;
        }

        /**
         * Path to the Dockerfile (relative to the directory).
         * <p>
         * Default: 'Dockerfile'
         * <p>
         * @return {@code this}
         * @param file Path to the Dockerfile (relative to the directory). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder file(final java.lang.String file) {
            this.props.file(file);
            return this;
        }

        /**
         * (deprecated) ECR repository name.
         * <p>
         * Specify this property if you need to statically address the image, e.g.
         * from a Kubernetes Pod. Note, this is only the repository name, without the
         * registry and the tag parts.
         * <p>
         * Default: - the default ECR repository for CDK assets
         * <p>
         * @return {@code this}
         * @deprecated to control the location of docker image assets, please override
         * `Stack.addDockerImageAsset`. this feature will be removed in future
         * releases.
         * @param repositoryName ECR repository name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder repositoryName(final java.lang.String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        /**
         * Docker target to build to.
         * <p>
         * Default: - no target
         * <p>
         * @return {@code this}
         * @param target Docker target to build to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final java.lang.String target) {
            this.props.target(target);
            return this;
        }

        /**
         * Specify or override the CMD on the specified Docker image or Dockerfile.
         * <p>
         * This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
         * <p>
         * Default: - use the CMD specified in the docker image or Dockerfile.
         * <p>
         * @return {@code this}
         * @see https://docs.docker.com/engine/reference/builder/#cmd
         * @param cmd Specify or override the CMD on the specified Docker image or Dockerfile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmd(final java.util.List<java.lang.String> cmd) {
            this.props.cmd(cmd);
            return this;
        }

        /**
         * Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile.
         * <p>
         * An ENTRYPOINT allows you to configure a container that will run as an executable.
         * This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
         * <p>
         * Default: - use the ENTRYPOINT in the docker image or Dockerfile.
         * <p>
         * @return {@code this}
         * @see https://docs.docker.com/engine/reference/builder/#entrypoint
         * @param entrypoint Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entrypoint(final java.util.List<java.lang.String> entrypoint) {
            this.props.entrypoint(entrypoint);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.AssetImageCode}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.AssetImageCode build() {
            return new software.amazon.awscdk.services.lambda.AssetImageCode(
                this.directory,
                this.props.build()
            );
        }
    }
}
