/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.lambda.;
import software.amazon.awscdk.services.lambda.CfnEventSourceMapping;
import software.amazon.awscdk.services.lambda.CfnEventSourceMappingProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda.CfnEventSourceMapping")
public class CfnEventSourceMapping
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnEventSourceMapping.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnEventSourceMapping(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEventSourceMapping(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnEventSourceMapping(@NotNull Construct scope, @NotNull String id, @NotNull CfnEventSourceMappingProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getFunctionName() {
        return (String)Kernel.get((Object)((Object)this), (String)"functionName", (NativeType)NativeType.forClass(String.class));
    }

    public void setFunctionName(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"functionName", (Object)Objects.requireNonNull(value, "functionName is required"));
    }

    @Nullable
    public Number getBatchSize() {
        return (Number)Kernel.get((Object)((Object)this), (String)"batchSize", (NativeType)NativeType.forClass(Number.class));
    }

    public void setBatchSize(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"batchSize", (Object)value);
    }

    @Nullable
    public Object getBisectBatchOnFunctionError() {
        return Kernel.get((Object)((Object)this), (String)"bisectBatchOnFunctionError", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBisectBatchOnFunctionError(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"bisectBatchOnFunctionError", (Object)value);
    }

    public void setBisectBatchOnFunctionError(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"bisectBatchOnFunctionError", (Object)value);
    }

    @Nullable
    public Object getDestinationConfig() {
        return Kernel.get((Object)((Object)this), (String)"destinationConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDestinationConfig(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"destinationConfig", (Object)value);
    }

    public void setDestinationConfig(@Nullable DestinationConfigProperty value) {
        Kernel.set((Object)((Object)this), (String)"destinationConfig", (Object)value);
    }

    @Nullable
    public Object getEnabled() {
        return Kernel.get((Object)((Object)this), (String)"enabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnabled(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"enabled", (Object)value);
    }

    public void setEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"enabled", (Object)value);
    }

    @Nullable
    public String getEventSourceArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"eventSourceArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setEventSourceArn(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"eventSourceArn", (Object)value);
    }

    @Nullable
    public List<String> getFunctionResponseTypes() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"functionResponseTypes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setFunctionResponseTypes(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"functionResponseTypes", value);
    }

    @Nullable
    public Number getMaximumBatchingWindowInSeconds() {
        return (Number)Kernel.get((Object)((Object)this), (String)"maximumBatchingWindowInSeconds", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaximumBatchingWindowInSeconds(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"maximumBatchingWindowInSeconds", (Object)value);
    }

    @Nullable
    public Number getMaximumRecordAgeInSeconds() {
        return (Number)Kernel.get((Object)((Object)this), (String)"maximumRecordAgeInSeconds", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaximumRecordAgeInSeconds(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"maximumRecordAgeInSeconds", (Object)value);
    }

    @Nullable
    public Number getMaximumRetryAttempts() {
        return (Number)Kernel.get((Object)((Object)this), (String)"maximumRetryAttempts", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaximumRetryAttempts(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"maximumRetryAttempts", (Object)value);
    }

    @Nullable
    public Number getParallelizationFactor() {
        return (Number)Kernel.get((Object)((Object)this), (String)"parallelizationFactor", (NativeType)NativeType.forClass(Number.class));
    }

    public void setParallelizationFactor(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"parallelizationFactor", (Object)value);
    }

    @Nullable
    public List<String> getQueues() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"queues", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setQueues(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"queues", value);
    }

    @Nullable
    public Object getSelfManagedEventSource() {
        return Kernel.get((Object)((Object)this), (String)"selfManagedEventSource", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSelfManagedEventSource(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"selfManagedEventSource", (Object)value);
    }

    public void setSelfManagedEventSource(@Nullable SelfManagedEventSourceProperty value) {
        Kernel.set((Object)((Object)this), (String)"selfManagedEventSource", (Object)value);
    }

    @Nullable
    public Object getSourceAccessConfigurations() {
        return Kernel.get((Object)((Object)this), (String)"sourceAccessConfigurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSourceAccessConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"sourceAccessConfigurations", (Object)value);
    }

    public void setSourceAccessConfigurations(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"sourceAccessConfigurations", value);
    }

    @Nullable
    public String getStartingPosition() {
        return (String)Kernel.get((Object)((Object)this), (String)"startingPosition", (NativeType)NativeType.forClass(String.class));
    }

    public void setStartingPosition(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"startingPosition", (Object)value);
    }

    @Nullable
    public Number getStartingPositionTimestamp() {
        return (Number)Kernel.get((Object)((Object)this), (String)"startingPositionTimestamp", (NativeType)NativeType.forClass(Number.class));
    }

    public void setStartingPositionTimestamp(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"startingPositionTimestamp", (Object)value);
    }

    @Nullable
    public List<String> getTopics() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"topics", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTopics(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"topics", value);
    }

    @Nullable
    public Number getTumblingWindowInSeconds() {
        return (Number)Kernel.get((Object)((Object)this), (String)"tumblingWindowInSeconds", (NativeType)NativeType.forClass(Number.class));
    }

    public void setTumblingWindowInSeconds(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"tumblingWindowInSeconds", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnEventSourceMapping> {
        private final Construct scope;
        private final String id;
        private final CfnEventSourceMappingProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnEventSourceMappingProps.Builder();
        }

        public Builder functionName(String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        public Builder batchSize(Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        public Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.props.bisectBatchOnFunctionError(bisectBatchOnFunctionError);
            return this;
        }

        public Builder bisectBatchOnFunctionError(IResolvable bisectBatchOnFunctionError) {
            this.props.bisectBatchOnFunctionError(bisectBatchOnFunctionError);
            return this;
        }

        public Builder destinationConfig(IResolvable destinationConfig) {
            this.props.destinationConfig(destinationConfig);
            return this;
        }

        public Builder destinationConfig(DestinationConfigProperty destinationConfig) {
            this.props.destinationConfig(destinationConfig);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder enabled(IResolvable enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder eventSourceArn(String eventSourceArn) {
            this.props.eventSourceArn(eventSourceArn);
            return this;
        }

        public Builder functionResponseTypes(List<String> functionResponseTypes) {
            this.props.functionResponseTypes(functionResponseTypes);
            return this;
        }

        public Builder maximumBatchingWindowInSeconds(Number maximumBatchingWindowInSeconds) {
            this.props.maximumBatchingWindowInSeconds(maximumBatchingWindowInSeconds);
            return this;
        }

        public Builder maximumRecordAgeInSeconds(Number maximumRecordAgeInSeconds) {
            this.props.maximumRecordAgeInSeconds(maximumRecordAgeInSeconds);
            return this;
        }

        public Builder maximumRetryAttempts(Number maximumRetryAttempts) {
            this.props.maximumRetryAttempts(maximumRetryAttempts);
            return this;
        }

        public Builder parallelizationFactor(Number parallelizationFactor) {
            this.props.parallelizationFactor(parallelizationFactor);
            return this;
        }

        public Builder queues(List<String> queues) {
            this.props.queues(queues);
            return this;
        }

        public Builder selfManagedEventSource(IResolvable selfManagedEventSource) {
            this.props.selfManagedEventSource(selfManagedEventSource);
            return this;
        }

        public Builder selfManagedEventSource(SelfManagedEventSourceProperty selfManagedEventSource) {
            this.props.selfManagedEventSource(selfManagedEventSource);
            return this;
        }

        public Builder sourceAccessConfigurations(IResolvable sourceAccessConfigurations) {
            this.props.sourceAccessConfigurations(sourceAccessConfigurations);
            return this;
        }

        public Builder sourceAccessConfigurations(List<? extends Object> sourceAccessConfigurations) {
            this.props.sourceAccessConfigurations(sourceAccessConfigurations);
            return this;
        }

        public Builder startingPosition(String startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        public Builder startingPositionTimestamp(Number startingPositionTimestamp) {
            this.props.startingPositionTimestamp(startingPositionTimestamp);
            return this;
        }

        public Builder topics(List<String> topics) {
            this.props.topics(topics);
            return this;
        }

        public Builder tumblingWindowInSeconds(Number tumblingWindowInSeconds) {
            this.props.tumblingWindowInSeconds(tumblingWindowInSeconds);
            return this;
        }

        public CfnEventSourceMapping build() {
            return new CfnEventSourceMapping(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda.CfnEventSourceMapping.SourceAccessConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceAccessConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public String getUri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceAccessConfigurationProperty> {
            private String type;
            private String uri;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public SourceAccessConfigurationProperty build() {
                return new Jsii.Proxy(this.type, this.uri);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda.CfnEventSourceMapping.SelfManagedEventSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SelfManagedEventSourceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEndpoints() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SelfManagedEventSourceProperty> {
            private Object endpoints;

            public Builder endpoints(IResolvable endpoints) {
                this.endpoints = endpoints;
                return this;
            }

            public Builder endpoints(EndpointsProperty endpoints) {
                this.endpoints = endpoints;
                return this;
            }

            public SelfManagedEventSourceProperty build() {
                return new Jsii.Proxy(this.endpoints);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda.CfnEventSourceMapping.OnFailureProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnFailureProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDestination() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnFailureProperty> {
            private String destination;

            public Builder destination(String destination) {
                this.destination = destination;
                return this;
            }

            public OnFailureProperty build() {
                return new Jsii.Proxy(this.destination);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda.CfnEventSourceMapping.EndpointsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getKafkaBootstrapServers() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EndpointsProperty> {
            private List<String> kafkaBootstrapServers;

            public Builder kafkaBootstrapServers(List<String> kafkaBootstrapServers) {
                this.kafkaBootstrapServers = kafkaBootstrapServers;
                return this;
            }

            public EndpointsProperty build() {
                return new Jsii.Proxy(this.kafkaBootstrapServers);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda.CfnEventSourceMapping.DestinationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DestinationConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getOnFailure() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DestinationConfigProperty> {
            private Object onFailure;

            public Builder onFailure(IResolvable onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            public Builder onFailure(OnFailureProperty onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            public DestinationConfigProperty build() {
                return new Jsii.Proxy(this.onFailure);
            }
        }
    }
}

