package software.amazon.awscdk.services.lambda;

/**
 * Aspect for upgrading function versions when the feature flag provided feature flag present.
 * <p>
 * This can be necessary when the feature flag
 * changes the function hash, as such changes must be associated with a new
 * version. This aspect will change the function description in these cases,
 * which "validates" the new function hash.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Stack stack = new Stack();
 * Aspects.of(stack).add(new FunctionVersionUpgrade(LAMBDA_RECOGNIZE_VERSION_PROPS));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:40.763Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.FunctionVersionUpgrade")
public class FunctionVersionUpgrade extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IAspect {

    protected FunctionVersionUpgrade(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FunctionVersionUpgrade(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param featureFlag This parameter is required.
     * @param enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FunctionVersionUpgrade(final @org.jetbrains.annotations.NotNull java.lang.String featureFlag, final @org.jetbrains.annotations.Nullable java.lang.Boolean enabled) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(featureFlag, "featureFlag is required"), enabled });
    }

    /**
     * @param featureFlag This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FunctionVersionUpgrade(final @org.jetbrains.annotations.NotNull java.lang.String featureFlag) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(featureFlag, "featureFlag is required") });
    }

    /**
     * All aspects can visit an IConstruct.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void visit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IConstruct node) {
        software.amazon.jsii.Kernel.call(this, "visit", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }
}
