package software.amazon.awscdk.services.lambda;

/**
 * Version of CloudWatch Lambda Insights.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String layerArn = "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:14";
 * Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_16_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .insightsVersion(LambdaInsightsVersion.fromInsightVersionArn(layerArn))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:40.796Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.LambdaInsightsVersion")
public abstract class LambdaInsightsVersion extends software.amazon.jsii.JsiiObject {

    protected LambdaInsightsVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaInsightsVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VERSION_1_0_119_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class, "VERSION_1_0_119_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class));
        VERSION_1_0_135_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class, "VERSION_1_0_135_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class));
        VERSION_1_0_54_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class, "VERSION_1_0_54_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class));
        VERSION_1_0_86_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class, "VERSION_1_0_86_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class));
        VERSION_1_0_89_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class, "VERSION_1_0_89_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class));
        VERSION_1_0_98_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class, "VERSION_1_0_98_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected LambdaInsightsVersion() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Use the insights extension associated with the provided ARN.
     * <p>
     * Make sure the ARN is associated
     * with same region as your function
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-extension-versions.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-extension-versions.html</a>
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.LambdaInsightsVersion fromInsightVersionArn(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class, "fromInsightVersionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.LambdaInsightsVersion.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Version 1.0.119.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.LambdaInsightsVersion VERSION_1_0_119_0;

    /**
     * Version 1.0.135.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.LambdaInsightsVersion VERSION_1_0_135_0;

    /**
     * Version 1.0.54.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.LambdaInsightsVersion VERSION_1_0_54_0;

    /**
     * Version 1.0.86.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.LambdaInsightsVersion VERSION_1_0_86_0;

    /**
     * Version 1.0.89.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.LambdaInsightsVersion VERSION_1_0_89_0;

    /**
     * Version 1.0.98.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.LambdaInsightsVersion VERSION_1_0_98_0;

    /**
     * The arn of the Lambda Insights extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLayerVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "layerVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.lambda.LambdaInsightsVersion {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
