/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.lambda.$Module;
import software.amazon.awscdk.services.lambda.CfnFunction;
import software.amazon.awscdk.services.lambda.CfnFunctionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-lambda.CfnFunctionProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface CfnFunctionProps
extends JsiiSerializable {
    @NotNull
    public Object getCode();

    @NotNull
    public String getRole();

    @Nullable
    default public String getCodeSigningConfigArn() {
        return null;
    }

    @Nullable
    default public Object getDeadLetterConfig() {
        return null;
    }

    @Nullable
    default public String getDescription() {
        return null;
    }

    @Nullable
    default public Object getEnvironment() {
        return null;
    }

    @Nullable
    default public Object getFileSystemConfigs() {
        return null;
    }

    @Nullable
    default public String getFunctionName() {
        return null;
    }

    @Nullable
    default public String getHandler() {
        return null;
    }

    @Nullable
    default public Object getImageConfig() {
        return null;
    }

    @Nullable
    default public String getKmsKeyArn() {
        return null;
    }

    @Nullable
    default public List<String> getLayers() {
        return null;
    }

    @Nullable
    default public Number getMemorySize() {
        return null;
    }

    @Nullable
    default public String getPackageType() {
        return null;
    }

    @Nullable
    default public Number getReservedConcurrentExecutions() {
        return null;
    }

    @Nullable
    default public String getRuntime() {
        return null;
    }

    @Nullable
    default public List<CfnTag> getTags() {
        return null;
    }

    @Nullable
    default public Number getTimeout() {
        return null;
    }

    @Nullable
    default public Object getTracingConfig() {
        return null;
    }

    @Nullable
    default public Object getVpcConfig() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFunctionProps> {
        private Object code;
        private String role;
        private String codeSigningConfigArn;
        private Object deadLetterConfig;
        private String description;
        private Object environment;
        private Object fileSystemConfigs;
        private String functionName;
        private String handler;
        private Object imageConfig;
        private String kmsKeyArn;
        private List<String> layers;
        private Number memorySize;
        private String packageType;
        private Number reservedConcurrentExecutions;
        private String runtime;
        private List<CfnTag> tags;
        private Number timeout;
        private Object tracingConfig;
        private Object vpcConfig;

        public Builder code(IResolvable code) {
            this.code = code;
            return this;
        }

        public Builder code(CfnFunction.CodeProperty code) {
            this.code = code;
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public Builder codeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
            return this;
        }

        public Builder deadLetterConfig(IResolvable deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public Builder deadLetterConfig(CfnFunction.DeadLetterConfigProperty deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder environment(IResolvable environment) {
            this.environment = environment;
            return this;
        }

        public Builder environment(CfnFunction.EnvironmentProperty environment) {
            this.environment = environment;
            return this;
        }

        public Builder fileSystemConfigs(IResolvable fileSystemConfigs) {
            this.fileSystemConfigs = fileSystemConfigs;
            return this;
        }

        public Builder fileSystemConfigs(List<? extends Object> fileSystemConfigs) {
            this.fileSystemConfigs = fileSystemConfigs;
            return this;
        }

        public Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public Builder imageConfig(IResolvable imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        public Builder imageConfig(CfnFunction.ImageConfigProperty imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        public Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public Builder layers(List<String> layers) {
            this.layers = layers;
            return this;
        }

        public Builder memorySize(Number memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        public Builder reservedConcurrentExecutions(Number reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            return this;
        }

        public Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        public Builder timeout(Number timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder tracingConfig(IResolvable tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public Builder tracingConfig(CfnFunction.TracingConfigProperty tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public Builder vpcConfig(IResolvable vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public Builder vpcConfig(CfnFunction.VpcConfigProperty vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public CfnFunctionProps build() {
            return new Jsii.Proxy(this.code, this.role, this.codeSigningConfigArn, this.deadLetterConfig, this.description, this.environment, this.fileSystemConfigs, this.functionName, this.handler, this.imageConfig, this.kmsKeyArn, this.layers, this.memorySize, this.packageType, this.reservedConcurrentExecutions, this.runtime, this.tags, this.timeout, this.tracingConfig, this.vpcConfig);
        }
    }
}

