package software.amazon.awscdk.services.lambda;

/**
 * Lambda code defined using 2 CloudFormation parameters.
 * <p>
 * Useful when you don't have access to the code of your Lambda from your CDK code, so you can't use Assets,
 * and you want to deploy the Lambda in a CodePipeline, using CloudFormation Actions -
 * you can fill the parameters using the {&#64;link #assign} method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:46:44.550Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnParametersCode")
public class CfnParametersCode extends software.amazon.awscdk.services.lambda.Code {

    protected CfnParametersCode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnParametersCode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnParametersCode(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.CfnParametersCodeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnParametersCode() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Create a parameters map from this instance's CloudFormation parameters.
     * <p>
     * It returns a map with 2 keys that correspond to the names of the parameters defined in this Lambda code,
     * and as values it contains the appropriate expressions pointing at the provided S3 location
     * (most likely, obtained from a CodePipeline Artifact by calling the <code>artifact.s3Location</code> method).
     * The result should be provided to the CloudFormation Action
     * that is deploying the Stack that the Lambda with this code is part of,
     * in the <code>parameterOverrides</code> property.
     * <p>
     * @param location the location of the object in S3 that represents the Lambda code. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> assign(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.Location location) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(location, "location is required") }));
    }

    /**
     * Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucketNameParam() {
        return software.amazon.jsii.Kernel.get(this, "bucketNameParam", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Determines whether this Code is inline code or not.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsInline() {
        return software.amazon.jsii.Kernel.get(this, "isInline", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getObjectKeyParam() {
        return software.amazon.jsii.Kernel.get(this, "objectKeyParam", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.CfnParametersCode}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.CfnParametersCode> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.lambda.CfnParametersCodeProps.Builder props;

        private Builder() {
        }

        /**
         * The CloudFormation parameter that represents the name of the S3 Bucket where the Lambda code will be located in.
         * <p>
         * Must be of type 'String'.
         * <p>
         * Default: a new parameter will be created
         * <p>
         * @return {@code this}
         * @param bucketNameParam The CloudFormation parameter that represents the name of the S3 Bucket where the Lambda code will be located in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketNameParam(final software.amazon.awscdk.core.CfnParameter bucketNameParam) {
            this.props().bucketNameParam(bucketNameParam);
            return this;
        }

        /**
         * The CloudFormation parameter that represents the path inside the S3 Bucket where the Lambda code will be located at.
         * <p>
         * Must be of type 'String'.
         * <p>
         * Default: a new parameter will be created
         * <p>
         * @return {@code this}
         * @param objectKeyParam The CloudFormation parameter that represents the path inside the S3 Bucket where the Lambda code will be located at. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectKeyParam(final software.amazon.awscdk.core.CfnParameter objectKeyParam) {
            this.props().objectKeyParam(objectKeyParam);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.CfnParametersCode}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.CfnParametersCode build() {
            return new software.amazon.awscdk.services.lambda.CfnParametersCode(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.lambda.CfnParametersCodeProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.lambda.CfnParametersCodeProps.Builder();
            }
            return this.props;
        }
    }
}
