package software.amazon.awscdk.services.lightsail;

/**
 * A CloudFormation `AWS::Lightsail::Instance`.
 * <p>
 * The <code>AWS::Lightsail::Instance</code> resource specifies an Amazon Lightsail instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnInstance cfnInstance = CfnInstance.Builder.create(this, "MyCfnInstance")
 *         .blueprintId("blueprintId")
 *         .bundleId("bundleId")
 *         .instanceName("instanceName")
 *         // the properties below are optional
 *         .addOns(List.of(AddOnProperty.builder()
 *                 .addOnType("addOnType")
 *                 // the properties below are optional
 *                 .autoSnapshotAddOnRequest(AutoSnapshotAddOnProperty.builder()
 *                         .snapshotTimeOfDay("snapshotTimeOfDay")
 *                         .build())
 *                 .status("status")
 *                 .build()))
 *         .availabilityZone("availabilityZone")
 *         .hardware(HardwareProperty.builder()
 *                 .cpuCount(123)
 *                 .disks(List.of(DiskProperty.builder()
 *                         .diskName("diskName")
 *                         .path("path")
 *                         // the properties below are optional
 *                         .attachedTo("attachedTo")
 *                         .attachmentState("attachmentState")
 *                         .iops(123)
 *                         .isSystemDisk(false)
 *                         .sizeInGb("sizeInGb")
 *                         .build()))
 *                 .ramSizeInGb(123)
 *                 .build())
 *         .keyPairName("keyPairName")
 *         .networking(NetworkingProperty.builder()
 *                 .ports(List.of(PortProperty.builder()
 *                         .accessDirection("accessDirection")
 *                         .accessFrom("accessFrom")
 *                         .accessType("accessType")
 *                         .cidrListAliases(List.of("cidrListAliases"))
 *                         .cidrs(List.of("cidrs"))
 *                         .commonName("commonName")
 *                         .fromPort(123)
 *                         .ipv6Cidrs(List.of("ipv6Cidrs"))
 *                         .protocol("protocol")
 *                         .toPort(123)
 *                         .build()))
 *                 // the properties below are optional
 *                 .monthlyTransfer(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userData("userData")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:36.873Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lightsail.$Module.class, fqn = "@aws-cdk/aws-lightsail.CfnInstance")
public class CfnInstance extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lightsail.CfnInstance.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Lightsail::Instance`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInstance(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lightsail.CfnInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The number of vCPUs the instance has.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrHardwareCpuCount() {
        return software.amazon.jsii.Kernel.get(this, "attrHardwareCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of RAM in GB on the instance (for example, `1.0` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrHardwareRamSizeInGb() {
        return software.amazon.jsii.Kernel.get(this, "attrHardwareRamSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the instance (for example, `arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A Boolean value indicating whether the instance has a static IP assigned to it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAttrIsStaticIp() {
        return software.amazon.jsii.Kernel.get(this, "attrIsStaticIp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     * The AWS Region and Availability Zone where the instance is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLocationAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "attrLocationAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Region of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLocationRegionName() {
        return software.amazon.jsii.Kernel.get(this, "attrLocationRegionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The amount of allocated monthly data transfer (in GB) for an instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNetworkingMonthlyTransferGbPerMonthAllocated() {
        return software.amazon.jsii.Kernel.get(this, "attrNetworkingMonthlyTransferGbPerMonthAllocated", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The private IP address of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPrivateIpAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrPrivateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The public IP address of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPublicIpAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrPublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The resource type of the instance (for example, `Instance` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceType() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the SSH key pair used by the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSshKeyName() {
        return software.amazon.jsii.Kernel.get(this, "attrSshKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status code of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrStateCode() {
        return software.amazon.jsii.Kernel.get(this, "attrStateCode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The state of the instance (for example, `running` or `pending` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStateName() {
        return software.amazon.jsii.Kernel.get(this, "attrStateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The support code of the instance.
     * <p>
     * Include this code in your email to support when you have questions about an instance or another resource in Lightsail . This code helps our support team to look up your Lightsail information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSupportCode() {
        return software.amazon.jsii.Kernel.get(this, "attrSupportCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user name for connecting to the instance (for example, `ec2-user` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUserName() {
        return software.amazon.jsii.Kernel.get(this, "attrUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The blueprint ID for the instance (for example, `os_amlinux_2016_03` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBlueprintId() {
        return software.amazon.jsii.Kernel.get(this, "blueprintId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The blueprint ID for the instance (for example, `os_amlinux_2016_03` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBlueprintId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "blueprintId", java.util.Objects.requireNonNull(value, "blueprintId is required"));
    }

    /**
     * The bundle ID for the instance (for example, `micro_1_0` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBundleId() {
        return software.amazon.jsii.Kernel.get(this, "bundleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The bundle ID for the instance (for example, `micro_1_0` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBundleId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bundleId", java.util.Objects.requireNonNull(value, "bundleId is required"));
    }

    /**
     * The name of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceName() {
        return software.amazon.jsii.Kernel.get(this, "instanceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceName", java.util.Objects.requireNonNull(value, "instanceName is required"));
    }

    /**
     * An array of add-ons for the instance.
     * <p>
     * <blockquote>
     * <p>
     * If the instance has an add-on enabled when performing a delete instance request, the add-on is automatically disabled before the instance is deleted.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAddOns() {
        return software.amazon.jsii.Kernel.get(this, "addOns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of add-ons for the instance.
     * <p>
     * <blockquote>
     * <p>
     * If the instance has an add-on enabled when performing a delete instance request, the add-on is automatically disabled before the instance is deleted.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAddOns(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "addOns", value);
    }

    /**
     * An array of add-ons for the instance.
     * <p>
     * <blockquote>
     * <p>
     * If the instance has an add-on enabled when performing a delete instance request, the add-on is automatically disabled before the instance is deleted.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAddOns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.lightsail.CfnInstance.AddOnProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.lightsail.CfnInstance.AddOnProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "addOns", value);
    }

    /**
     * The Availability Zone for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * The hardware properties for the instance, such as the vCPU count, attached disks, and amount of RAM.
     * <p>
     * <blockquote>
     * <p>
     * The instance restarts when performing an attach disk or detach disk request. This resets the public IP address of your instance if a static IP isn't attached to it.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHardware() {
        return software.amazon.jsii.Kernel.get(this, "hardware", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The hardware properties for the instance, such as the vCPU count, attached disks, and amount of RAM.
     * <p>
     * <blockquote>
     * <p>
     * The instance restarts when performing an attach disk or detach disk request. This resets the public IP address of your instance if a static IP isn't attached to it.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHardware(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "hardware", value);
    }

    /**
     * The hardware properties for the instance, such as the vCPU count, attached disks, and amount of RAM.
     * <p>
     * <blockquote>
     * <p>
     * The instance restarts when performing an attach disk or detach disk request. This resets the public IP address of your instance if a static IP isn't attached to it.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHardware(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lightsail.CfnInstance.HardwareProperty value) {
        software.amazon.jsii.Kernel.set(this, "hardware", value);
    }

    /**
     * The name of the key pair to use for the instance.
     * <p>
     * If no key pair name is specified, the Regional Lightsail default key pair is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeyPairName() {
        return software.amazon.jsii.Kernel.get(this, "keyPairName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the key pair to use for the instance.
     * <p>
     * If no key pair name is specified, the Regional Lightsail default key pair is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyPairName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyPairName", value);
    }

    /**
     * The public ports and the monthly amount of data transfer allocated for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworking() {
        return software.amazon.jsii.Kernel.get(this, "networking", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The public ports and the monthly amount of data transfer allocated for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworking(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networking", value);
    }

    /**
     * The public ports and the monthly amount of data transfer allocated for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworking(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lightsail.CfnInstance.NetworkingProperty value) {
        software.amazon.jsii.Kernel.set(this, "networking", value);
    }

    /**
     * The optional launch script for the instance.
     * <p>
     * Specify a launch script to configure an instance with additional user data. For example, you might want to specify <code>apt-get -y update</code> as a launch script.
     * <p>
     * <blockquote>
     * <p>
     * Depending on the blueprint of your instance, the command to get software on your instance varies. Amazon Linux and CentOS use <code>yum</code> , Debian and Ubuntu use <code>apt-get</code> , and FreeBSD uses <code>pkg</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUserData() {
        return software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The optional launch script for the instance.
     * <p>
     * Specify a launch script to configure an instance with additional user data. For example, you might want to specify <code>apt-get -y update</code> as a launch script.
     * <p>
     * <blockquote>
     * <p>
     * Depending on the blueprint of your instance, the command to get software on your instance varies. Amazon Linux and CentOS use <code>yum</code> , Debian and Ubuntu use <code>apt-get</code> , and FreeBSD uses <code>pkg</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserData(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userData", value);
    }
    /**
     * `AddOn` is a property of the [AWS::Lightsail::Instance](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html) resource. It describes the add-ons for an instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * AddOnProperty addOnProperty = AddOnProperty.builder()
     *         .addOnType("addOnType")
     *         // the properties below are optional
     *         .autoSnapshotAddOnRequest(AutoSnapshotAddOnProperty.builder()
     *                 .snapshotTimeOfDay("snapshotTimeOfDay")
     *                 .build())
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lightsail.$Module.class, fqn = "@aws-cdk/aws-lightsail.CfnInstance.AddOnProperty")
    @software.amazon.jsii.Jsii.Proxy(AddOnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AddOnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The add-on type (for example, `AutoSnapshot` ).
         * <p>
         * <blockquote>
         * <p>
         * <code>AutoSnapshot</code> is the only add-on that can be enabled for an instance.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAddOnType();

        /**
         * The parameters for the automatic snapshot add-on, such as the daily time when an automatic snapshot will be created.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoSnapshotAddOnRequest() {
            return null;
        }

        /**
         * The status of the add-on.
         * <p>
         * Valid Values: <code>Enabled</code> | <code>Disabled</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AddOnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AddOnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AddOnProperty> {
            java.lang.String addOnType;
            java.lang.Object autoSnapshotAddOnRequest;
            java.lang.String status;

            /**
             * Sets the value of {@link AddOnProperty#getAddOnType}
             * @param addOnType The add-on type (for example, `AutoSnapshot` ). This parameter is required.
             *                  <blockquote>
             *                  <p>
             *                  <code>AutoSnapshot</code> is the only add-on that can be enabled for an instance.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addOnType(java.lang.String addOnType) {
                this.addOnType = addOnType;
                return this;
            }

            /**
             * Sets the value of {@link AddOnProperty#getAutoSnapshotAddOnRequest}
             * @param autoSnapshotAddOnRequest The parameters for the automatic snapshot add-on, such as the daily time when an automatic snapshot will be created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoSnapshotAddOnRequest(software.amazon.awscdk.core.IResolvable autoSnapshotAddOnRequest) {
                this.autoSnapshotAddOnRequest = autoSnapshotAddOnRequest;
                return this;
            }

            /**
             * Sets the value of {@link AddOnProperty#getAutoSnapshotAddOnRequest}
             * @param autoSnapshotAddOnRequest The parameters for the automatic snapshot add-on, such as the daily time when an automatic snapshot will be created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoSnapshotAddOnRequest(software.amazon.awscdk.services.lightsail.CfnInstance.AutoSnapshotAddOnProperty autoSnapshotAddOnRequest) {
                this.autoSnapshotAddOnRequest = autoSnapshotAddOnRequest;
                return this;
            }

            /**
             * Sets the value of {@link AddOnProperty#getStatus}
             * @param status The status of the add-on.
             *               Valid Values: <code>Enabled</code> | <code>Disabled</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AddOnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AddOnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AddOnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddOnProperty {
            private final java.lang.String addOnType;
            private final java.lang.Object autoSnapshotAddOnRequest;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addOnType = software.amazon.jsii.Kernel.get(this, "addOnType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.autoSnapshotAddOnRequest = software.amazon.jsii.Kernel.get(this, "autoSnapshotAddOnRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addOnType = java.util.Objects.requireNonNull(builder.addOnType, "addOnType is required");
                this.autoSnapshotAddOnRequest = builder.autoSnapshotAddOnRequest;
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getAddOnType() {
                return this.addOnType;
            }

            @Override
            public final java.lang.Object getAutoSnapshotAddOnRequest() {
                return this.autoSnapshotAddOnRequest;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("addOnType", om.valueToTree(this.getAddOnType()));
                if (this.getAutoSnapshotAddOnRequest() != null) {
                    data.set("autoSnapshotAddOnRequest", om.valueToTree(this.getAutoSnapshotAddOnRequest()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-lightsail.CfnInstance.AddOnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AddOnProperty.Jsii$Proxy that = (AddOnProperty.Jsii$Proxy) o;

                if (!addOnType.equals(that.addOnType)) return false;
                if (this.autoSnapshotAddOnRequest != null ? !this.autoSnapshotAddOnRequest.equals(that.autoSnapshotAddOnRequest) : that.autoSnapshotAddOnRequest != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addOnType.hashCode();
                result = 31 * result + (this.autoSnapshotAddOnRequest != null ? this.autoSnapshotAddOnRequest.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `AutoSnapshotAddOn` is a property of the [AddOn](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-addon.html) property. It describes the automatic snapshot add-on for an instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * AutoSnapshotAddOnProperty autoSnapshotAddOnProperty = AutoSnapshotAddOnProperty.builder()
     *         .snapshotTimeOfDay("snapshotTimeOfDay")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lightsail.$Module.class, fqn = "@aws-cdk/aws-lightsail.CfnInstance.AutoSnapshotAddOnProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoSnapshotAddOnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoSnapshotAddOnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The daily time when an automatic snapshot will be created.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be in <code>HH:00</code> format, and in an hourly increment.</li>
         * <li>Specified in Coordinated Universal Time (UTC).</li>
         * <li>The snapshot will be automatically created between the time specified and up to 45 minutes after.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotTimeOfDay() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoSnapshotAddOnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoSnapshotAddOnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoSnapshotAddOnProperty> {
            java.lang.String snapshotTimeOfDay;

            /**
             * Sets the value of {@link AutoSnapshotAddOnProperty#getSnapshotTimeOfDay}
             * @param snapshotTimeOfDay The daily time when an automatic snapshot will be created.
             *                          Constraints:
             *                          <p>
             *                          <ul>
             *                          <li>Must be in <code>HH:00</code> format, and in an hourly increment.</li>
             *                          <li>Specified in Coordinated Universal Time (UTC).</li>
             *                          <li>The snapshot will be automatically created between the time specified and up to 45 minutes after.</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotTimeOfDay(java.lang.String snapshotTimeOfDay) {
                this.snapshotTimeOfDay = snapshotTimeOfDay;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoSnapshotAddOnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoSnapshotAddOnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoSnapshotAddOnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoSnapshotAddOnProperty {
            private final java.lang.String snapshotTimeOfDay;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.snapshotTimeOfDay = software.amazon.jsii.Kernel.get(this, "snapshotTimeOfDay", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.snapshotTimeOfDay = builder.snapshotTimeOfDay;
            }

            @Override
            public final java.lang.String getSnapshotTimeOfDay() {
                return this.snapshotTimeOfDay;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSnapshotTimeOfDay() != null) {
                    data.set("snapshotTimeOfDay", om.valueToTree(this.getSnapshotTimeOfDay()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-lightsail.CfnInstance.AutoSnapshotAddOnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoSnapshotAddOnProperty.Jsii$Proxy that = (AutoSnapshotAddOnProperty.Jsii$Proxy) o;

                return this.snapshotTimeOfDay != null ? this.snapshotTimeOfDay.equals(that.snapshotTimeOfDay) : that.snapshotTimeOfDay == null;
            }

            @Override
            public final int hashCode() {
                int result = this.snapshotTimeOfDay != null ? this.snapshotTimeOfDay.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * `Disk` is a property of the [Hardware](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-hardware.html) property. It describes a disk attached to an instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * DiskProperty diskProperty = DiskProperty.builder()
     *         .diskName("diskName")
     *         .path("path")
     *         // the properties below are optional
     *         .attachedTo("attachedTo")
     *         .attachmentState("attachmentState")
     *         .iops(123)
     *         .isSystemDisk(false)
     *         .sizeInGb("sizeInGb")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lightsail.$Module.class, fqn = "@aws-cdk/aws-lightsail.CfnInstance.DiskProperty")
    @software.amazon.jsii.Jsii.Proxy(DiskProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DiskProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique name of the disk.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDiskName();

        /**
         * The disk path.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPath();

        /**
         * The resources to which the disk is attached.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttachedTo() {
            return null;
        }

        /**
         * (Deprecated) The attachment state of the disk.
         * <p>
         * <blockquote>
         * <p>
         * In releases prior to November 14, 2017, this parameter returned <code>attached</code> for system disks in the API response. It is now deprecated, but still included in the response. Use <code>isAttached</code> instead.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttachmentState() {
            return null;
        }

        /**
         * The input/output operations per second (IOPS) of the disk.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsSystemDisk() {
            return null;
        }

        /**
         * The size of the disk in GB.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSizeInGb() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DiskProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DiskProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DiskProperty> {
            java.lang.String diskName;
            java.lang.String path;
            java.lang.String attachedTo;
            java.lang.String attachmentState;
            java.lang.Number iops;
            java.lang.Object isSystemDisk;
            java.lang.String sizeInGb;

            /**
             * Sets the value of {@link DiskProperty#getDiskName}
             * @param diskName The unique name of the disk. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder diskName(java.lang.String diskName) {
                this.diskName = diskName;
                return this;
            }

            /**
             * Sets the value of {@link DiskProperty#getPath}
             * @param path The disk path. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link DiskProperty#getAttachedTo}
             * @param attachedTo The resources to which the disk is attached.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachedTo(java.lang.String attachedTo) {
                this.attachedTo = attachedTo;
                return this;
            }

            /**
             * Sets the value of {@link DiskProperty#getAttachmentState}
             * @param attachmentState (Deprecated) The attachment state of the disk.
             *                        <blockquote>
             *                        <p>
             *                        In releases prior to November 14, 2017, this parameter returned <code>attached</code> for system disks in the API response. It is now deprecated, but still included in the response. Use <code>isAttached</code> instead.
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachmentState(java.lang.String attachmentState) {
                this.attachmentState = attachmentState;
                return this;
            }

            /**
             * Sets the value of {@link DiskProperty#getIops}
             * @param iops The input/output operations per second (IOPS) of the disk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link DiskProperty#getIsSystemDisk}
             * @param isSystemDisk A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSystemDisk(java.lang.Boolean isSystemDisk) {
                this.isSystemDisk = isSystemDisk;
                return this;
            }

            /**
             * Sets the value of {@link DiskProperty#getIsSystemDisk}
             * @param isSystemDisk A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSystemDisk(software.amazon.awscdk.core.IResolvable isSystemDisk) {
                this.isSystemDisk = isSystemDisk;
                return this;
            }

            /**
             * Sets the value of {@link DiskProperty#getSizeInGb}
             * @param sizeInGb The size of the disk in GB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInGb(java.lang.String sizeInGb) {
                this.sizeInGb = sizeInGb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DiskProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DiskProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DiskProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DiskProperty {
            private final java.lang.String diskName;
            private final java.lang.String path;
            private final java.lang.String attachedTo;
            private final java.lang.String attachmentState;
            private final java.lang.Number iops;
            private final java.lang.Object isSystemDisk;
            private final java.lang.String sizeInGb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.diskName = software.amazon.jsii.Kernel.get(this, "diskName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attachedTo = software.amazon.jsii.Kernel.get(this, "attachedTo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attachmentState = software.amazon.jsii.Kernel.get(this, "attachmentState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.isSystemDisk = software.amazon.jsii.Kernel.get(this, "isSystemDisk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sizeInGb = software.amazon.jsii.Kernel.get(this, "sizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.diskName = java.util.Objects.requireNonNull(builder.diskName, "diskName is required");
                this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
                this.attachedTo = builder.attachedTo;
                this.attachmentState = builder.attachmentState;
                this.iops = builder.iops;
                this.isSystemDisk = builder.isSystemDisk;
                this.sizeInGb = builder.sizeInGb;
            }

            @Override
            public final java.lang.String getDiskName() {
                return this.diskName;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.String getAttachedTo() {
                return this.attachedTo;
            }

            @Override
            public final java.lang.String getAttachmentState() {
                return this.attachmentState;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.Object getIsSystemDisk() {
                return this.isSystemDisk;
            }

            @Override
            public final java.lang.String getSizeInGb() {
                return this.sizeInGb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("diskName", om.valueToTree(this.getDiskName()));
                data.set("path", om.valueToTree(this.getPath()));
                if (this.getAttachedTo() != null) {
                    data.set("attachedTo", om.valueToTree(this.getAttachedTo()));
                }
                if (this.getAttachmentState() != null) {
                    data.set("attachmentState", om.valueToTree(this.getAttachmentState()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getIsSystemDisk() != null) {
                    data.set("isSystemDisk", om.valueToTree(this.getIsSystemDisk()));
                }
                if (this.getSizeInGb() != null) {
                    data.set("sizeInGb", om.valueToTree(this.getSizeInGb()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-lightsail.CfnInstance.DiskProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DiskProperty.Jsii$Proxy that = (DiskProperty.Jsii$Proxy) o;

                if (!diskName.equals(that.diskName)) return false;
                if (!path.equals(that.path)) return false;
                if (this.attachedTo != null ? !this.attachedTo.equals(that.attachedTo) : that.attachedTo != null) return false;
                if (this.attachmentState != null ? !this.attachmentState.equals(that.attachmentState) : that.attachmentState != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.isSystemDisk != null ? !this.isSystemDisk.equals(that.isSystemDisk) : that.isSystemDisk != null) return false;
                return this.sizeInGb != null ? this.sizeInGb.equals(that.sizeInGb) : that.sizeInGb == null;
            }

            @Override
            public final int hashCode() {
                int result = this.diskName.hashCode();
                result = 31 * result + (this.path.hashCode());
                result = 31 * result + (this.attachedTo != null ? this.attachedTo.hashCode() : 0);
                result = 31 * result + (this.attachmentState != null ? this.attachmentState.hashCode() : 0);
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.isSystemDisk != null ? this.isSystemDisk.hashCode() : 0);
                result = 31 * result + (this.sizeInGb != null ? this.sizeInGb.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `Hardware` is a property of the [AWS::Lightsail::Instance](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html) resource. It describes the hardware properties for the instance, such as the vCPU count, attached disks, and amount of RAM.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * HardwareProperty hardwareProperty = HardwareProperty.builder()
     *         .cpuCount(123)
     *         .disks(List.of(DiskProperty.builder()
     *                 .diskName("diskName")
     *                 .path("path")
     *                 // the properties below are optional
     *                 .attachedTo("attachedTo")
     *                 .attachmentState("attachmentState")
     *                 .iops(123)
     *                 .isSystemDisk(false)
     *                 .sizeInGb("sizeInGb")
     *                 .build()))
     *         .ramSizeInGb(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lightsail.$Module.class, fqn = "@aws-cdk/aws-lightsail.CfnInstance.HardwareProperty")
    @software.amazon.jsii.Jsii.Proxy(HardwareProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HardwareProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of vCPUs the instance has.
         * <p>
         * <blockquote>
         * <p>
         * The <code>CpuCount</code> property is read-only and should not be specified in a create instance or update instance request.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCpuCount() {
            return null;
        }

        /**
         * The disks attached to the instance.
         * <p>
         * The instance restarts when performing an attach disk or detach disk request. This resets the public IP address of your instance if a static IP isn't attached to it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisks() {
            return null;
        }

        /**
         * The amount of RAM in GB on the instance (for example, `1.0` ).
         * <p>
         * <blockquote>
         * <p>
         * The <code>RamSizeInGb</code> property is read-only and should not be specified in a create instance or update instance request.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRamSizeInGb() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HardwareProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HardwareProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HardwareProperty> {
            java.lang.Number cpuCount;
            java.lang.Object disks;
            java.lang.Number ramSizeInGb;

            /**
             * Sets the value of {@link HardwareProperty#getCpuCount}
             * @param cpuCount The number of vCPUs the instance has.
             *                 <blockquote>
             *                 <p>
             *                 The <code>CpuCount</code> property is read-only and should not be specified in a create instance or update instance request.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuCount(java.lang.Number cpuCount) {
                this.cpuCount = cpuCount;
                return this;
            }

            /**
             * Sets the value of {@link HardwareProperty#getDisks}
             * @param disks The disks attached to the instance.
             *              The instance restarts when performing an attach disk or detach disk request. This resets the public IP address of your instance if a static IP isn't attached to it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disks(software.amazon.awscdk.core.IResolvable disks) {
                this.disks = disks;
                return this;
            }

            /**
             * Sets the value of {@link HardwareProperty#getDisks}
             * @param disks The disks attached to the instance.
             *              The instance restarts when performing an attach disk or detach disk request. This resets the public IP address of your instance if a static IP isn't attached to it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disks(java.util.List<? extends java.lang.Object> disks) {
                this.disks = disks;
                return this;
            }

            /**
             * Sets the value of {@link HardwareProperty#getRamSizeInGb}
             * @param ramSizeInGb The amount of RAM in GB on the instance (for example, `1.0` ).
             *                    <blockquote>
             *                    <p>
             *                    The <code>RamSizeInGb</code> property is read-only and should not be specified in a create instance or update instance request.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ramSizeInGb(java.lang.Number ramSizeInGb) {
                this.ramSizeInGb = ramSizeInGb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HardwareProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HardwareProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HardwareProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HardwareProperty {
            private final java.lang.Number cpuCount;
            private final java.lang.Object disks;
            private final java.lang.Number ramSizeInGb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpuCount = software.amazon.jsii.Kernel.get(this, "cpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.disks = software.amazon.jsii.Kernel.get(this, "disks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ramSizeInGb = software.amazon.jsii.Kernel.get(this, "ramSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuCount = builder.cpuCount;
                this.disks = builder.disks;
                this.ramSizeInGb = builder.ramSizeInGb;
            }

            @Override
            public final java.lang.Number getCpuCount() {
                return this.cpuCount;
            }

            @Override
            public final java.lang.Object getDisks() {
                return this.disks;
            }

            @Override
            public final java.lang.Number getRamSizeInGb() {
                return this.ramSizeInGb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCpuCount() != null) {
                    data.set("cpuCount", om.valueToTree(this.getCpuCount()));
                }
                if (this.getDisks() != null) {
                    data.set("disks", om.valueToTree(this.getDisks()));
                }
                if (this.getRamSizeInGb() != null) {
                    data.set("ramSizeInGb", om.valueToTree(this.getRamSizeInGb()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-lightsail.CfnInstance.HardwareProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HardwareProperty.Jsii$Proxy that = (HardwareProperty.Jsii$Proxy) o;

                if (this.cpuCount != null ? !this.cpuCount.equals(that.cpuCount) : that.cpuCount != null) return false;
                if (this.disks != null ? !this.disks.equals(that.disks) : that.disks != null) return false;
                return this.ramSizeInGb != null ? this.ramSizeInGb.equals(that.ramSizeInGb) : that.ramSizeInGb == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpuCount != null ? this.cpuCount.hashCode() : 0;
                result = 31 * result + (this.disks != null ? this.disks.hashCode() : 0);
                result = 31 * result + (this.ramSizeInGb != null ? this.ramSizeInGb.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `Location` is a property of the [AWS::Lightsail::Instance](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html) resource. It describes the location for an instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * LocationProperty locationProperty = LocationProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .regionName("regionName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lightsail.$Module.class, fqn = "@aws-cdk/aws-lightsail.CfnInstance.LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Availability Zone for the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The name of the AWS Region for the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegionName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocationProperty> {
            java.lang.String availabilityZone;
            java.lang.String regionName;

            /**
             * Sets the value of {@link LocationProperty#getAvailabilityZone}
             * @param availabilityZone The Availability Zone for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link LocationProperty#getRegionName}
             * @param regionName The name of the AWS Region for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regionName(java.lang.String regionName) {
                this.regionName = regionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocationProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.String regionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.regionName = software.amazon.jsii.Kernel.get(this, "regionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.regionName = builder.regionName;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.String getRegionName() {
                return this.regionName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getRegionName() != null) {
                    data.set("regionName", om.valueToTree(this.getRegionName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-lightsail.CfnInstance.LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocationProperty.Jsii$Proxy that = (LocationProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                return this.regionName != null ? this.regionName.equals(that.regionName) : that.regionName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.regionName != null ? this.regionName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `MonthlyTransfer` is a property of the [Networking](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-networking.html) property. It describes the amount of allocated monthly data transfer (in GB) for an instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * MonthlyTransferProperty monthlyTransferProperty = MonthlyTransferProperty.builder()
     *         .gbPerMonthAllocated("gbPerMonthAllocated")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lightsail.$Module.class, fqn = "@aws-cdk/aws-lightsail.CfnInstance.MonthlyTransferProperty")
    @software.amazon.jsii.Jsii.Proxy(MonthlyTransferProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonthlyTransferProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of allocated monthly data transfer (in GB) for an instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGbPerMonthAllocated() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonthlyTransferProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonthlyTransferProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonthlyTransferProperty> {
            java.lang.String gbPerMonthAllocated;

            /**
             * Sets the value of {@link MonthlyTransferProperty#getGbPerMonthAllocated}
             * @param gbPerMonthAllocated The amount of allocated monthly data transfer (in GB) for an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gbPerMonthAllocated(java.lang.String gbPerMonthAllocated) {
                this.gbPerMonthAllocated = gbPerMonthAllocated;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonthlyTransferProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonthlyTransferProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonthlyTransferProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonthlyTransferProperty {
            private final java.lang.String gbPerMonthAllocated;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.gbPerMonthAllocated = software.amazon.jsii.Kernel.get(this, "gbPerMonthAllocated", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.gbPerMonthAllocated = builder.gbPerMonthAllocated;
            }

            @Override
            public final java.lang.String getGbPerMonthAllocated() {
                return this.gbPerMonthAllocated;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGbPerMonthAllocated() != null) {
                    data.set("gbPerMonthAllocated", om.valueToTree(this.getGbPerMonthAllocated()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-lightsail.CfnInstance.MonthlyTransferProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonthlyTransferProperty.Jsii$Proxy that = (MonthlyTransferProperty.Jsii$Proxy) o;

                return this.gbPerMonthAllocated != null ? this.gbPerMonthAllocated.equals(that.gbPerMonthAllocated) : that.gbPerMonthAllocated == null;
            }

            @Override
            public final int hashCode() {
                int result = this.gbPerMonthAllocated != null ? this.gbPerMonthAllocated.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * `Networking` is a property of the [AWS::Lightsail::Instance](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html) resource. It describes the public ports and the monthly amount of data transfer allocated for the instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * NetworkingProperty networkingProperty = NetworkingProperty.builder()
     *         .ports(List.of(PortProperty.builder()
     *                 .accessDirection("accessDirection")
     *                 .accessFrom("accessFrom")
     *                 .accessType("accessType")
     *                 .cidrListAliases(List.of("cidrListAliases"))
     *                 .cidrs(List.of("cidrs"))
     *                 .commonName("commonName")
     *                 .fromPort(123)
     *                 .ipv6Cidrs(List.of("ipv6Cidrs"))
     *                 .protocol("protocol")
     *                 .toPort(123)
     *                 .build()))
     *         // the properties below are optional
     *         .monthlyTransfer(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lightsail.$Module.class, fqn = "@aws-cdk/aws-lightsail.CfnInstance.NetworkingProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of ports to open on the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPorts();

        /**
         * The monthly amount of data transfer, in GB, allocated for the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMonthlyTransfer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkingProperty> {
            java.lang.Object ports;
            java.lang.Number monthlyTransfer;

            /**
             * Sets the value of {@link NetworkingProperty#getPorts}
             * @param ports An array of ports to open on the instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ports(software.amazon.awscdk.core.IResolvable ports) {
                this.ports = ports;
                return this;
            }

            /**
             * Sets the value of {@link NetworkingProperty#getPorts}
             * @param ports An array of ports to open on the instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ports(java.util.List<? extends java.lang.Object> ports) {
                this.ports = ports;
                return this;
            }

            /**
             * Sets the value of {@link NetworkingProperty#getMonthlyTransfer}
             * @param monthlyTransfer The monthly amount of data transfer, in GB, allocated for the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monthlyTransfer(java.lang.Number monthlyTransfer) {
                this.monthlyTransfer = monthlyTransfer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkingProperty {
            private final java.lang.Object ports;
            private final java.lang.Number monthlyTransfer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ports = software.amazon.jsii.Kernel.get(this, "ports", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monthlyTransfer = software.amazon.jsii.Kernel.get(this, "monthlyTransfer", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ports = java.util.Objects.requireNonNull(builder.ports, "ports is required");
                this.monthlyTransfer = builder.monthlyTransfer;
            }

            @Override
            public final java.lang.Object getPorts() {
                return this.ports;
            }

            @Override
            public final java.lang.Number getMonthlyTransfer() {
                return this.monthlyTransfer;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ports", om.valueToTree(this.getPorts()));
                if (this.getMonthlyTransfer() != null) {
                    data.set("monthlyTransfer", om.valueToTree(this.getMonthlyTransfer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-lightsail.CfnInstance.NetworkingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkingProperty.Jsii$Proxy that = (NetworkingProperty.Jsii$Proxy) o;

                if (!ports.equals(that.ports)) return false;
                return this.monthlyTransfer != null ? this.monthlyTransfer.equals(that.monthlyTransfer) : that.monthlyTransfer == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ports.hashCode();
                result = 31 * result + (this.monthlyTransfer != null ? this.monthlyTransfer.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `Port` is a property of the [Networking](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-instance-networking.html) property. It describes information about ports for an instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * PortProperty portProperty = PortProperty.builder()
     *         .accessDirection("accessDirection")
     *         .accessFrom("accessFrom")
     *         .accessType("accessType")
     *         .cidrListAliases(List.of("cidrListAliases"))
     *         .cidrs(List.of("cidrs"))
     *         .commonName("commonName")
     *         .fromPort(123)
     *         .ipv6Cidrs(List.of("ipv6Cidrs"))
     *         .protocol("protocol")
     *         .toPort(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lightsail.$Module.class, fqn = "@aws-cdk/aws-lightsail.CfnInstance.PortProperty")
    @software.amazon.jsii.Jsii.Proxy(PortProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PortProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The access direction ( `inbound` or `outbound` ).
         * <p>
         * <blockquote>
         * <p>
         * Lightsail currently supports only <code>inbound</code> access direction.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessDirection() {
            return null;
        }

        /**
         * The location from which access is allowed.
         * <p>
         * For example, <code>Anywhere (0.0.0.0/0)</code> , or <code>Custom</code> if a specific IP address or range of IP addresses is allowed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessFrom() {
            return null;
        }

        /**
         * The type of access ( `Public` or `Private` ).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessType() {
            return null;
        }

        /**
         * An alias that defines access for a preconfigured range of IP addresses.
         * <p>
         * The only alias currently supported is <code>lightsail-connect</code> , which allows IP addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCidrListAliases() {
            return null;
        }

        /**
         * The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol.
         * <p>
         * <blockquote>
         * <p>
         * The <code>ipv6Cidrs</code> parameter lists the IPv6 addresses that are allowed to connect to an instance.
         * <p>
         * </blockquote>
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li>To allow the IP address <code>192.0.2.44</code> , specify <code>192.0.2.44</code> or <code>192.0.2.44/32</code> .</li>
         * <li>To allow the IP addresses <code>192.0.2.0</code> to <code>192.0.2.255</code> , specify <code>192.0.2.0/24</code> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCidrs() {
            return null;
        }

        /**
         * The common name of the port information.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCommonName() {
            return null;
        }

        /**
         * The first port in a range of open ports on an instance.
         * <p>
         * Allowed ports:
         * <p>
         * <ul>
         * <li>TCP and UDP - <code>0</code> to <code>65535</code></li>
         * <li>ICMP - The ICMP type for IPv4 addresses. For example, specify <code>8</code> as the <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP code), to enable ICMP Ping.</li>
         * <li>ICMPv6 - The ICMP type for IPv6 addresses. For example, specify <code>128</code> as the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6 code).</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFromPort() {
            return null;
        }

        /**
         * The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol.
         * <p>
         * Only devices with an IPv6 address can connect to an instance through IPv6; otherwise, IPv4 should be used.
         * <p>
         * <blockquote>
         * <p>
         * The <code>cidrs</code> parameter lists the IPv4 addresses that are allowed to connect to an instance.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpv6Cidrs() {
            return null;
        }

        /**
         * The IP protocol name.
         * <p>
         * The name can be one of the following:
         * <p>
         * <ul>
         * <li><code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery of streamed data between applications running on hosts communicating by an IP network. If you have an application that doesn't require reliable data stream service, use UDP instead.</li>
         * <li><code>all</code> - All transport layer protocol types.</li>
         * <li><code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up transmission channels or data paths. Applications that don't require reliable data stream service can use UDP, which provides a connectionless datagram service that emphasizes reduced latency over reliability. If you do require reliable data stream service, use TCP instead.</li>
         * <li><code>icmp</code> - Internet Control Message Protocol (ICMP) is used to send error messages and operational information indicating success or failure when communicating with an instance. For example, an error is indicated when an instance could not be reached. When you specify <code>icmp</code> as the <code>protocol</code> , you must specify the ICMP type using the <code>fromPort</code> parameter, and ICMP code using the <code>toPort</code> parameter.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * The last port in a range of open ports on an instance.
         * <p>
         * Allowed ports:
         * <p>
         * <ul>
         * <li>TCP and UDP - <code>0</code> to <code>65535</code></li>
         * <li>ICMP - The ICMP code for IPv4 addresses. For example, specify <code>8</code> as the <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP code), to enable ICMP Ping.</li>
         * <li>ICMPv6 - The ICMP code for IPv6 addresses. For example, specify <code>128</code> as the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6 code).</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getToPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PortProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PortProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PortProperty> {
            java.lang.String accessDirection;
            java.lang.String accessFrom;
            java.lang.String accessType;
            java.util.List<java.lang.String> cidrListAliases;
            java.util.List<java.lang.String> cidrs;
            java.lang.String commonName;
            java.lang.Number fromPort;
            java.util.List<java.lang.String> ipv6Cidrs;
            java.lang.String protocol;
            java.lang.Number toPort;

            /**
             * Sets the value of {@link PortProperty#getAccessDirection}
             * @param accessDirection The access direction ( `inbound` or `outbound` ).
             *                        <blockquote>
             *                        <p>
             *                        Lightsail currently supports only <code>inbound</code> access direction.
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessDirection(java.lang.String accessDirection) {
                this.accessDirection = accessDirection;
                return this;
            }

            /**
             * Sets the value of {@link PortProperty#getAccessFrom}
             * @param accessFrom The location from which access is allowed.
             *                   For example, <code>Anywhere (0.0.0.0/0)</code> , or <code>Custom</code> if a specific IP address or range of IP addresses is allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessFrom(java.lang.String accessFrom) {
                this.accessFrom = accessFrom;
                return this;
            }

            /**
             * Sets the value of {@link PortProperty#getAccessType}
             * @param accessType The type of access ( `Public` or `Private` ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessType(java.lang.String accessType) {
                this.accessType = accessType;
                return this;
            }

            /**
             * Sets the value of {@link PortProperty#getCidrListAliases}
             * @param cidrListAliases An alias that defines access for a preconfigured range of IP addresses.
             *                        The only alias currently supported is <code>lightsail-connect</code> , which allows IP addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidrListAliases(java.util.List<java.lang.String> cidrListAliases) {
                this.cidrListAliases = cidrListAliases;
                return this;
            }

            /**
             * Sets the value of {@link PortProperty#getCidrs}
             * @param cidrs The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol.
             *              <blockquote>
             *              <p>
             *              The <code>ipv6Cidrs</code> parameter lists the IPv6 addresses that are allowed to connect to an instance.
             *              <p>
             *              </blockquote>
             *              <p>
             *              Examples:
             *              <p>
             *              <ul>
             *              <li>To allow the IP address <code>192.0.2.44</code> , specify <code>192.0.2.44</code> or <code>192.0.2.44/32</code> .</li>
             *              <li>To allow the IP addresses <code>192.0.2.0</code> to <code>192.0.2.255</code> , specify <code>192.0.2.0/24</code> .</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidrs(java.util.List<java.lang.String> cidrs) {
                this.cidrs = cidrs;
                return this;
            }

            /**
             * Sets the value of {@link PortProperty#getCommonName}
             * @param commonName The common name of the port information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder commonName(java.lang.String commonName) {
                this.commonName = commonName;
                return this;
            }

            /**
             * Sets the value of {@link PortProperty#getFromPort}
             * @param fromPort The first port in a range of open ports on an instance.
             *                 Allowed ports:
             *                 <p>
             *                 <ul>
             *                 <li>TCP and UDP - <code>0</code> to <code>65535</code></li>
             *                 <li>ICMP - The ICMP type for IPv4 addresses. For example, specify <code>8</code> as the <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP code), to enable ICMP Ping.</li>
             *                 <li>ICMPv6 - The ICMP type for IPv6 addresses. For example, specify <code>128</code> as the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6 code).</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fromPort(java.lang.Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            /**
             * Sets the value of {@link PortProperty#getIpv6Cidrs}
             * @param ipv6Cidrs The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol.
             *                  Only devices with an IPv6 address can connect to an instance through IPv6; otherwise, IPv4 should be used.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  The <code>cidrs</code> parameter lists the IPv4 addresses that are allowed to connect to an instance.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Cidrs(java.util.List<java.lang.String> ipv6Cidrs) {
                this.ipv6Cidrs = ipv6Cidrs;
                return this;
            }

            /**
             * Sets the value of {@link PortProperty#getProtocol}
             * @param protocol The IP protocol name.
             *                 The name can be one of the following:
             *                 <p>
             *                 <ul>
             *                 <li><code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery of streamed data between applications running on hosts communicating by an IP network. If you have an application that doesn't require reliable data stream service, use UDP instead.</li>
             *                 <li><code>all</code> - All transport layer protocol types.</li>
             *                 <li><code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up transmission channels or data paths. Applications that don't require reliable data stream service can use UDP, which provides a connectionless datagram service that emphasizes reduced latency over reliability. If you do require reliable data stream service, use TCP instead.</li>
             *                 <li><code>icmp</code> - Internet Control Message Protocol (ICMP) is used to send error messages and operational information indicating success or failure when communicating with an instance. For example, an error is indicated when an instance could not be reached. When you specify <code>icmp</code> as the <code>protocol</code> , you must specify the ICMP type using the <code>fromPort</code> parameter, and ICMP code using the <code>toPort</code> parameter.</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link PortProperty#getToPort}
             * @param toPort The last port in a range of open ports on an instance.
             *               Allowed ports:
             *               <p>
             *               <ul>
             *               <li>TCP and UDP - <code>0</code> to <code>65535</code></li>
             *               <li>ICMP - The ICMP code for IPv4 addresses. For example, specify <code>8</code> as the <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP code), to enable ICMP Ping.</li>
             *               <li>ICMPv6 - The ICMP code for IPv6 addresses. For example, specify <code>128</code> as the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6 code).</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toPort(java.lang.Number toPort) {
                this.toPort = toPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PortProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PortProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PortProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortProperty {
            private final java.lang.String accessDirection;
            private final java.lang.String accessFrom;
            private final java.lang.String accessType;
            private final java.util.List<java.lang.String> cidrListAliases;
            private final java.util.List<java.lang.String> cidrs;
            private final java.lang.String commonName;
            private final java.lang.Number fromPort;
            private final java.util.List<java.lang.String> ipv6Cidrs;
            private final java.lang.String protocol;
            private final java.lang.Number toPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessDirection = software.amazon.jsii.Kernel.get(this, "accessDirection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessFrom = software.amazon.jsii.Kernel.get(this, "accessFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessType = software.amazon.jsii.Kernel.get(this, "accessType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cidrListAliases = software.amazon.jsii.Kernel.get(this, "cidrListAliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cidrs = software.amazon.jsii.Kernel.get(this, "cidrs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.commonName = software.amazon.jsii.Kernel.get(this, "commonName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fromPort = software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ipv6Cidrs = software.amazon.jsii.Kernel.get(this, "ipv6Cidrs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.toPort = software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessDirection = builder.accessDirection;
                this.accessFrom = builder.accessFrom;
                this.accessType = builder.accessType;
                this.cidrListAliases = builder.cidrListAliases;
                this.cidrs = builder.cidrs;
                this.commonName = builder.commonName;
                this.fromPort = builder.fromPort;
                this.ipv6Cidrs = builder.ipv6Cidrs;
                this.protocol = builder.protocol;
                this.toPort = builder.toPort;
            }

            @Override
            public final java.lang.String getAccessDirection() {
                return this.accessDirection;
            }

            @Override
            public final java.lang.String getAccessFrom() {
                return this.accessFrom;
            }

            @Override
            public final java.lang.String getAccessType() {
                return this.accessType;
            }

            @Override
            public final java.util.List<java.lang.String> getCidrListAliases() {
                return this.cidrListAliases;
            }

            @Override
            public final java.util.List<java.lang.String> getCidrs() {
                return this.cidrs;
            }

            @Override
            public final java.lang.String getCommonName() {
                return this.commonName;
            }

            @Override
            public final java.lang.Number getFromPort() {
                return this.fromPort;
            }

            @Override
            public final java.util.List<java.lang.String> getIpv6Cidrs() {
                return this.ipv6Cidrs;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.Number getToPort() {
                return this.toPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessDirection() != null) {
                    data.set("accessDirection", om.valueToTree(this.getAccessDirection()));
                }
                if (this.getAccessFrom() != null) {
                    data.set("accessFrom", om.valueToTree(this.getAccessFrom()));
                }
                if (this.getAccessType() != null) {
                    data.set("accessType", om.valueToTree(this.getAccessType()));
                }
                if (this.getCidrListAliases() != null) {
                    data.set("cidrListAliases", om.valueToTree(this.getCidrListAliases()));
                }
                if (this.getCidrs() != null) {
                    data.set("cidrs", om.valueToTree(this.getCidrs()));
                }
                if (this.getCommonName() != null) {
                    data.set("commonName", om.valueToTree(this.getCommonName()));
                }
                if (this.getFromPort() != null) {
                    data.set("fromPort", om.valueToTree(this.getFromPort()));
                }
                if (this.getIpv6Cidrs() != null) {
                    data.set("ipv6Cidrs", om.valueToTree(this.getIpv6Cidrs()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getToPort() != null) {
                    data.set("toPort", om.valueToTree(this.getToPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-lightsail.CfnInstance.PortProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PortProperty.Jsii$Proxy that = (PortProperty.Jsii$Proxy) o;

                if (this.accessDirection != null ? !this.accessDirection.equals(that.accessDirection) : that.accessDirection != null) return false;
                if (this.accessFrom != null ? !this.accessFrom.equals(that.accessFrom) : that.accessFrom != null) return false;
                if (this.accessType != null ? !this.accessType.equals(that.accessType) : that.accessType != null) return false;
                if (this.cidrListAliases != null ? !this.cidrListAliases.equals(that.cidrListAliases) : that.cidrListAliases != null) return false;
                if (this.cidrs != null ? !this.cidrs.equals(that.cidrs) : that.cidrs != null) return false;
                if (this.commonName != null ? !this.commonName.equals(that.commonName) : that.commonName != null) return false;
                if (this.fromPort != null ? !this.fromPort.equals(that.fromPort) : that.fromPort != null) return false;
                if (this.ipv6Cidrs != null ? !this.ipv6Cidrs.equals(that.ipv6Cidrs) : that.ipv6Cidrs != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                return this.toPort != null ? this.toPort.equals(that.toPort) : that.toPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessDirection != null ? this.accessDirection.hashCode() : 0;
                result = 31 * result + (this.accessFrom != null ? this.accessFrom.hashCode() : 0);
                result = 31 * result + (this.accessType != null ? this.accessType.hashCode() : 0);
                result = 31 * result + (this.cidrListAliases != null ? this.cidrListAliases.hashCode() : 0);
                result = 31 * result + (this.cidrs != null ? this.cidrs.hashCode() : 0);
                result = 31 * result + (this.commonName != null ? this.commonName.hashCode() : 0);
                result = 31 * result + (this.fromPort != null ? this.fromPort.hashCode() : 0);
                result = 31 * result + (this.ipv6Cidrs != null ? this.ipv6Cidrs.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.toPort != null ? this.toPort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `State` is a property of the [AWS::Lightsail::Instance](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html) resource. It describes the status code and the state (for example, `running` ) of an instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * StateProperty stateProperty = StateProperty.builder()
     *         .code(123)
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lightsail.$Module.class, fqn = "@aws-cdk/aws-lightsail.CfnInstance.StateProperty")
    @software.amazon.jsii.Jsii.Proxy(StateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The status code of the instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCode() {
            return null;
        }

        /**
         * The state of the instance (for example, `running` or `pending` ).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StateProperty> {
            java.lang.Number code;
            java.lang.String name;

            /**
             * Sets the value of {@link StateProperty#getCode}
             * @param code The status code of the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder code(java.lang.Number code) {
                this.code = code;
                return this;
            }

            /**
             * Sets the value of {@link StateProperty#getName}
             * @param name The state of the instance (for example, `running` or `pending` ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateProperty {
            private final java.lang.Number code;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.code = builder.code;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Number getCode() {
                return this.code;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCode() != null) {
                    data.set("code", om.valueToTree(this.getCode()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-lightsail.CfnInstance.StateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StateProperty.Jsii$Proxy that = (StateProperty.Jsii$Proxy) o;

                if (this.code != null ? !this.code.equals(that.code) : that.code != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.code != null ? this.code.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lightsail.CfnInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lightsail.CfnInstance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lightsail.CfnInstanceProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lightsail.CfnInstanceProps.Builder();
        }

        /**
         * The blueprint ID for the instance (for example, `os_amlinux_2016_03` ).
         * <p>
         * @return {@code this}
         * @param blueprintId The blueprint ID for the instance (for example, `os_amlinux_2016_03` ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blueprintId(final java.lang.String blueprintId) {
            this.props.blueprintId(blueprintId);
            return this;
        }

        /**
         * The bundle ID for the instance (for example, `micro_1_0` ).
         * <p>
         * @return {@code this}
         * @param bundleId The bundle ID for the instance (for example, `micro_1_0` ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundleId(final java.lang.String bundleId) {
            this.props.bundleId(bundleId);
            return this;
        }

        /**
         * The name of the instance.
         * <p>
         * @return {@code this}
         * @param instanceName The name of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceName(final java.lang.String instanceName) {
            this.props.instanceName(instanceName);
            return this;
        }

        /**
         * An array of add-ons for the instance.
         * <p>
         * <blockquote>
         * <p>
         * If the instance has an add-on enabled when performing a delete instance request, the add-on is automatically disabled before the instance is deleted.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param addOns An array of add-ons for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addOns(final software.amazon.awscdk.core.IResolvable addOns) {
            this.props.addOns(addOns);
            return this;
        }
        /**
         * An array of add-ons for the instance.
         * <p>
         * <blockquote>
         * <p>
         * If the instance has an add-on enabled when performing a delete instance request, the add-on is automatically disabled before the instance is deleted.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param addOns An array of add-ons for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addOns(final java.util.List<? extends java.lang.Object> addOns) {
            this.props.addOns(addOns);
            return this;
        }

        /**
         * The Availability Zone for the instance.
         * <p>
         * @return {@code this}
         * @param availabilityZone The Availability Zone for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The hardware properties for the instance, such as the vCPU count, attached disks, and amount of RAM.
         * <p>
         * <blockquote>
         * <p>
         * The instance restarts when performing an attach disk or detach disk request. This resets the public IP address of your instance if a static IP isn't attached to it.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param hardware The hardware properties for the instance, such as the vCPU count, attached disks, and amount of RAM. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hardware(final software.amazon.awscdk.core.IResolvable hardware) {
            this.props.hardware(hardware);
            return this;
        }
        /**
         * The hardware properties for the instance, such as the vCPU count, attached disks, and amount of RAM.
         * <p>
         * <blockquote>
         * <p>
         * The instance restarts when performing an attach disk or detach disk request. This resets the public IP address of your instance if a static IP isn't attached to it.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param hardware The hardware properties for the instance, such as the vCPU count, attached disks, and amount of RAM. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hardware(final software.amazon.awscdk.services.lightsail.CfnInstance.HardwareProperty hardware) {
            this.props.hardware(hardware);
            return this;
        }

        /**
         * The name of the key pair to use for the instance.
         * <p>
         * If no key pair name is specified, the Regional Lightsail default key pair is used.
         * <p>
         * @return {@code this}
         * @param keyPairName The name of the key pair to use for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPairName(final java.lang.String keyPairName) {
            this.props.keyPairName(keyPairName);
            return this;
        }

        /**
         * The public ports and the monthly amount of data transfer allocated for the instance.
         * <p>
         * @return {@code this}
         * @param networking The public ports and the monthly amount of data transfer allocated for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networking(final software.amazon.awscdk.core.IResolvable networking) {
            this.props.networking(networking);
            return this;
        }
        /**
         * The public ports and the monthly amount of data transfer allocated for the instance.
         * <p>
         * @return {@code this}
         * @param networking The public ports and the monthly amount of data transfer allocated for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networking(final software.amazon.awscdk.services.lightsail.CfnInstance.NetworkingProperty networking) {
            this.props.networking(networking);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The optional launch script for the instance.
         * <p>
         * Specify a launch script to configure an instance with additional user data. For example, you might want to specify <code>apt-get -y update</code> as a launch script.
         * <p>
         * <blockquote>
         * <p>
         * Depending on the blueprint of your instance, the command to get software on your instance varies. Amazon Linux and CentOS use <code>yum</code> , Debian and Ubuntu use <code>apt-get</code> , and FreeBSD uses <code>pkg</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param userData The optional launch script for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final java.lang.String userData) {
            this.props.userData(userData);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lightsail.CfnInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lightsail.CfnInstance build() {
            return new software.amazon.awscdk.services.lightsail.CfnInstance(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
