package software.amazon.awscdk.services.location;

/**
 * A CloudFormation `AWS::Location::Map`.
 * <p>
 * The <code>AWS::Location::Map</code> resource specifies a map resource in your AWS account, which provides map tiles of different styles sourced from global location data providers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.location.*;
 * CfnMap cfnMap = CfnMap.Builder.create(this, "MyCfnMap")
 *         .configuration(MapConfigurationProperty.builder()
 *                 .style("style")
 *                 .build())
 *         .mapName("mapName")
 *         // the properties below are optional
 *         .description("description")
 *         .pricingPlan("pricingPlan")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:36.887Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.location.$Module.class, fqn = "@aws-cdk/aws-location.CfnMap")
public class CfnMap extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnMap(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMap(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.location.CfnMap.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Location::Map`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMap(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.location.CfnMapProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS .
     * <p>
     * <ul>
     * <li>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp for when the map resource was created in [ISO 8601](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The data provider for the associated map tiles.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataSource() {
        return software.amazon.jsii.Kernel.get(this, "attrDataSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Synonym for `Arn` .
     * <p>
     * The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS .
     * <p>
     * <ul>
     * <li>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMapArn() {
        return software.amazon.jsii.Kernel.get(this, "attrMapArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp for when the map resource was last updated in [ISO 8601](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specifies the `MapConfiguration` , including the map style, for the map resource that you create.
     * <p>
     * The map style defines the look of maps and the data provider for your map resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the `MapConfiguration` , including the map style, for the map resource that you create.
     * <p>
     * The map style defines the look of maps and the data provider for your map resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.location.CfnMap.MapConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * Specifies the `MapConfiguration` , including the map style, for the map resource that you create.
     * <p>
     * The map style defines the look of maps and the data provider for your map resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * The name for the map resource.
     * <p>
     * Requirements:
     * <p>
     * <ul>
     * <li>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</li>
     * <li>Must be a unique map resource name.</li>
     * <li>No spaces allowed. For example, <code>ExampleMap</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMapName() {
        return software.amazon.jsii.Kernel.get(this, "mapName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for the map resource.
     * <p>
     * Requirements:
     * <p>
     * <ul>
     * <li>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</li>
     * <li>Must be a unique map resource name.</li>
     * <li>No spaces allowed. For example, <code>ExampleMap</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMapName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "mapName", java.util.Objects.requireNonNull(value, "mapName is required"));
    }

    /**
     * An optional description for the map resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional description for the map resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * No longer used. If included, the only allowed value is `RequestBasedUsage` .
     * <p>
     * <em>Allowed Values</em> : <code>RequestBasedUsage</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPricingPlan() {
        return software.amazon.jsii.Kernel.get(this, "pricingPlan", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * No longer used. If included, the only allowed value is `RequestBasedUsage` .
     * <p>
     * <em>Allowed Values</em> : <code>RequestBasedUsage</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPricingPlan(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "pricingPlan", value);
    }
    /**
     * Specifies the map tile style selected from an available provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.location.*;
     * MapConfigurationProperty mapConfigurationProperty = MapConfigurationProperty.builder()
     *         .style("style")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.location.$Module.class, fqn = "@aws-cdk/aws-location.CfnMap.MapConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MapConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MapConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the map style selected from an available data provider.
         * <p>
         * Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri map styles</a> :
         * <p>
         * <ul>
         * <li><code>VectorEsriDarkGrayCanvas</code> – The Esri Dark Gray Canvas map style. A vector basemap with a dark gray, neutral background with minimal colors, labels, and features that's designed to draw attention to your thematic content.</li>
         * <li><code>RasterEsriImagery</code> – The Esri Imagery map style. A raster basemap that provides one meter or better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery worldwide.</li>
         * <li><code>VectorEsriLightGrayCanvas</code> – The Esri Light Gray Canvas map style, which provides a detailed vector basemap with a light gray, neutral background style with minimal colors, labels, and features that's designed to draw attention to your thematic content.</li>
         * <li><code>VectorEsriTopographic</code> – The Esri Light map style, which provides a detailed vector basemap with a classic Esri map style.</li>
         * <li><code>VectorEsriStreets</code> – The Esri World Streets map style, which provides a detailed vector basemap for the world symbolized with a classic Esri street map style. The vector tile layer is similar in content and style to the World Street Map raster map.</li>
         * <li><code>VectorEsriNavigation</code> – The Esri World Navigation map style, which provides a detailed basemap for the world symbolized with a custom navigation map style that's designed for use during the day in mobile devices.</li>
         * </ul>
         * <p>
         * Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies map styles</a> :
         * <p>
         * <ul>
         * <li><code>VectorHereContrast</code> – The HERE Contrast (Berlin) map style is a high contrast detailed base map of the world that blends 3D and 2D rendering.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The <code>VectorHereContrast</code> style has been renamed from <code>VectorHereBerlin</code> . <code>VectorHereBerlin</code> has been deprecated, but will continue to work in applications that use it.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><code>VectorHereExplore</code> – A default HERE map style containing a neutral, global map and its features including roads, buildings, landmarks, and water features. It also now includes a fully designed map of Japan.</li>
         * <li><code>VectorHereExploreTruck</code> – A global map containing truck restrictions and attributes (e.g. width / height / HAZMAT) symbolized with highlighted segments and icons on top of HERE Explore to support use cases within transport and logistics.</li>
         * <li><code>RasterHereExploreSatellite</code> – A global map containing high resolution satellite imagery.</li>
         * <li><code>HybridHereExploreSatellite</code> – A global map displaying the road network, street names, and city labels over satellite imagery. This style will automatically retrieve both raster and vector tiles, and your charges will be based on total tiles retrieved.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Hybrid styles use both vector and raster tiles when rendering the map that you see. This means that more tiles are retrieved than when using either vector or raster tiles alone. Your charges will include all tiles retrieved.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStyle();

        /**
         * @return a {@link Builder} of {@link MapConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MapConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MapConfigurationProperty> {
            java.lang.String style;

            /**
             * Sets the value of {@link MapConfigurationProperty#getStyle}
             * @param style Specifies the map style selected from an available data provider. This parameter is required.
             *              Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri map styles</a> :
             *              <p>
             *              <ul>
             *              <li><code>VectorEsriDarkGrayCanvas</code> – The Esri Dark Gray Canvas map style. A vector basemap with a dark gray, neutral background with minimal colors, labels, and features that's designed to draw attention to your thematic content.</li>
             *              <li><code>RasterEsriImagery</code> – The Esri Imagery map style. A raster basemap that provides one meter or better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery worldwide.</li>
             *              <li><code>VectorEsriLightGrayCanvas</code> – The Esri Light Gray Canvas map style, which provides a detailed vector basemap with a light gray, neutral background style with minimal colors, labels, and features that's designed to draw attention to your thematic content.</li>
             *              <li><code>VectorEsriTopographic</code> – The Esri Light map style, which provides a detailed vector basemap with a classic Esri map style.</li>
             *              <li><code>VectorEsriStreets</code> – The Esri World Streets map style, which provides a detailed vector basemap for the world symbolized with a classic Esri street map style. The vector tile layer is similar in content and style to the World Street Map raster map.</li>
             *              <li><code>VectorEsriNavigation</code> – The Esri World Navigation map style, which provides a detailed basemap for the world symbolized with a custom navigation map style that's designed for use during the day in mobile devices.</li>
             *              </ul>
             *              <p>
             *              Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies map styles</a> :
             *              <p>
             *              <ul>
             *              <li><code>VectorHereContrast</code> – The HERE Contrast (Berlin) map style is a high contrast detailed base map of the world that blends 3D and 2D rendering.</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              The <code>VectorHereContrast</code> style has been renamed from <code>VectorHereBerlin</code> . <code>VectorHereBerlin</code> has been deprecated, but will continue to work in applications that use it.
             *              <p>
             *              </blockquote>
             *              <p>
             *              <ul>
             *              <li><code>VectorHereExplore</code> – A default HERE map style containing a neutral, global map and its features including roads, buildings, landmarks, and water features. It also now includes a fully designed map of Japan.</li>
             *              <li><code>VectorHereExploreTruck</code> – A global map containing truck restrictions and attributes (e.g. width / height / HAZMAT) symbolized with highlighted segments and icons on top of HERE Explore to support use cases within transport and logistics.</li>
             *              <li><code>RasterHereExploreSatellite</code> – A global map containing high resolution satellite imagery.</li>
             *              <li><code>HybridHereExploreSatellite</code> – A global map displaying the road network, street names, and city labels over satellite imagery. This style will automatically retrieve both raster and vector tiles, and your charges will be based on total tiles retrieved.</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              Hybrid styles use both vector and raster tiles when rendering the map that you see. This means that more tiles are retrieved than when using either vector or raster tiles alone. Your charges will include all tiles retrieved.
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder style(java.lang.String style) {
                this.style = style;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MapConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MapConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MapConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MapConfigurationProperty {
            private final java.lang.String style;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.style = software.amazon.jsii.Kernel.get(this, "style", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.style = java.util.Objects.requireNonNull(builder.style, "style is required");
            }

            @Override
            public final java.lang.String getStyle() {
                return this.style;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("style", om.valueToTree(this.getStyle()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-location.CfnMap.MapConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MapConfigurationProperty.Jsii$Proxy that = (MapConfigurationProperty.Jsii$Proxy) o;

                return this.style.equals(that.style);
            }

            @Override
            public final int hashCode() {
                int result = this.style.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.location.CfnMap}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.location.CfnMap> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.location.CfnMapProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.location.CfnMapProps.Builder();
        }

        /**
         * Specifies the `MapConfiguration` , including the map style, for the map resource that you create.
         * <p>
         * The map style defines the look of maps and the data provider for your map resource.
         * <p>
         * @return {@code this}
         * @param configuration Specifies the `MapConfiguration` , including the map style, for the map resource that you create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.location.CfnMap.MapConfigurationProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * Specifies the `MapConfiguration` , including the map style, for the map resource that you create.
         * <p>
         * The map style defines the look of maps and the data provider for your map resource.
         * <p>
         * @return {@code this}
         * @param configuration Specifies the `MapConfiguration` , including the map style, for the map resource that you create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.core.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * The name for the map resource.
         * <p>
         * Requirements:
         * <p>
         * <ul>
         * <li>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</li>
         * <li>Must be a unique map resource name.</li>
         * <li>No spaces allowed. For example, <code>ExampleMap</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param mapName The name for the map resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapName(final java.lang.String mapName) {
            this.props.mapName(mapName);
            return this;
        }

        /**
         * An optional description for the map resource.
         * <p>
         * @return {@code this}
         * @param description An optional description for the map resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * No longer used. If included, the only allowed value is `RequestBasedUsage` .
         * <p>
         * <em>Allowed Values</em> : <code>RequestBasedUsage</code>
         * <p>
         * @return {@code this}
         * @param pricingPlan No longer used. If included, the only allowed value is `RequestBasedUsage` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pricingPlan(final java.lang.String pricingPlan) {
            this.props.pricingPlan(pricingPlan);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.location.CfnMap}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.location.CfnMap build() {
            return new software.amazon.awscdk.services.location.CfnMap(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
