package software.amazon.awscdk.services.logs.destinations;

/**
 * Use a Lambda Function as the destination for a log subscription.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-17T00:39:56.177Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.logs.destinations.$Module.class, fqn = "@aws-cdk/aws-logs-destinations.LambdaDestination")
public class LambdaDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.logs.ILogSubscriptionDestination {

    protected LambdaDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * LambdaDestinationOptions.
     * <p>
     * @param fn This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.destinations.LambdaDestinationOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(fn, "fn is required"), options });
    }

    /**
     * LambdaDestinationOptions.
     * <p>
     * @param fn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(fn, "fn is required") });
    }

    /**
     * Return the properties required to send subscription events to this destination.
     * <p>
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     * <p>
     * The destination may reconfigure its own permissions in response to this
     * function call.
     * <p>
     * @param scope This parameter is required.
     * @param logGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogSubscriptionDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup logGroup) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogSubscriptionDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(logGroup, "logGroup is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.destinations.LambdaDestination}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.destinations.LambdaDestination> {
        /**
         * @return a new instance of {@link Builder}.
         * @param fn This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.lambda.IFunction fn) {
            return new Builder(fn);
        }

        private final software.amazon.awscdk.services.lambda.IFunction fn;
        private software.amazon.awscdk.services.logs.destinations.LambdaDestinationOptions.Builder options;

        private Builder(final software.amazon.awscdk.services.lambda.IFunction fn) {
            this.fn = fn;
        }

        /**
         * Whether or not to add Lambda Permissions.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param addPermissions Whether or not to add Lambda Permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addPermissions(final java.lang.Boolean addPermissions) {
            this.options().addPermissions(addPermissions);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.logs.destinations.LambdaDestination}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.destinations.LambdaDestination build() {
            return new software.amazon.awscdk.services.logs.destinations.LambdaDestination(
                this.fn,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.logs.destinations.LambdaDestinationOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.logs.destinations.LambdaDestinationOptions.Builder();
            }
            return this.options;
        }
    }
}
