package software.amazon.awscdk.services.logs.destinations;

/**
 * Use a Kinesis stream as the destination for a log subscription.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesis.*;
 * import software.amazon.awscdk.services.logs.destinations.*;
 * Stream stream;
 * KinesisDestination kinesisDestination = new KinesisDestination(stream);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-27T11:48:57.674Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.logs.destinations.$Module.class, fqn = "@aws-cdk/aws-logs-destinations.KinesisDestination")
public class KinesisDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.logs.ILogSubscriptionDestination {

    protected KinesisDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KinesisDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param stream This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KinesisDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream stream) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required") });
    }

    /**
     * Return the properties required to send subscription events to this destination.
     * <p>
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     * <p>
     * The destination may reconfigure its own permissions in response to this
     * function call.
     * <p>
     * @param scope This parameter is required.
     * @param _sourceLogGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogSubscriptionDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup _sourceLogGroup) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogSubscriptionDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(_sourceLogGroup, "_sourceLogGroup is required") });
    }
}
