package software.amazon.awscdk.services.logs.destinations;

/**
 * Use a Kinesis stream as the destination for a log subscription.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kinesis.*;
 * import software.amazon.awscdk.services.logs.destinations.*;
 * Role role;
 * Stream stream;
 * KinesisDestination kinesisDestination = KinesisDestination.Builder.create(stream)
 *         .role(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-23T19:56:57.996Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.logs.destinations.$Module.class, fqn = "@aws-cdk/aws-logs-destinations.KinesisDestination")
public class KinesisDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.logs.ILogSubscriptionDestination {

    protected KinesisDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KinesisDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param stream The Kinesis stream to use as destination. This parameter is required.
     * @param props The Kinesis Destination properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KinesisDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream stream, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.destinations.KinesisDestinationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required"), props });
    }

    /**
     * @param stream The Kinesis stream to use as destination. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KinesisDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream stream) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required") });
    }

    /**
     * Return the properties required to send subscription events to this destination.
     * <p>
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     * <p>
     * The destination may reconfigure its own permissions in response to this
     * function call.
     * <p>
     * @param scope This parameter is required.
     * @param _sourceLogGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogSubscriptionDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup _sourceLogGroup) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogSubscriptionDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(_sourceLogGroup, "_sourceLogGroup is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.destinations.KinesisDestination}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.destinations.KinesisDestination> {
        /**
         * @return a new instance of {@link Builder}.
         * @param stream The Kinesis stream to use as destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.kinesis.IStream stream) {
            return new Builder(stream);
        }

        private final software.amazon.awscdk.services.kinesis.IStream stream;
        private software.amazon.awscdk.services.logs.destinations.KinesisDestinationProps.Builder props;

        private Builder(final software.amazon.awscdk.services.kinesis.IStream stream) {
            this.stream = stream;
        }

        /**
         * The role to assume to write log events to the destination.
         * <p>
         * Default: - A new Role is created
         * <p>
         * @return {@code this}
         * @param role The role to assume to write log events to the destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.logs.destinations.KinesisDestination}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.destinations.KinesisDestination build() {
            return new software.amazon.awscdk.services.logs.destinations.KinesisDestination(
                this.stream,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.logs.destinations.KinesisDestinationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.logs.destinations.KinesisDestinationProps.Builder();
            }
            return this.props;
        }
    }
}
