package software.amazon.awscdk.services.logs;

/**
 * Properties for a QueryDefinition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * QueryDefinition.Builder.create(this, "QueryDefinition")
 *         .queryDefinitionName("MyQuery")
 *         .queryString(QueryString.Builder.create()
 *                 .fields(List.of("&#64;timestamp", "&#64;message"))
 *                 .sort("&#64;timestamp desc")
 *                 .limit(20)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:40.037Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.logs.$Module.class, fqn = "@aws-cdk/aws-logs.QueryDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(QueryDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueryDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the query definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueryDefinitionName();

    /**
     * The query string to use for this query definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.QueryString getQueryString();

    /**
     * Specify certain log groups for the query definition.
     * <p>
     * Default: - no specified log groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.logs.ILogGroup> getLogGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link QueryDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueryDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueryDefinitionProps> {
        java.lang.String queryDefinitionName;
        software.amazon.awscdk.services.logs.QueryString queryString;
        java.util.List<software.amazon.awscdk.services.logs.ILogGroup> logGroups;

        /**
         * Sets the value of {@link QueryDefinitionProps#getQueryDefinitionName}
         * @param queryDefinitionName Name of the query definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryDefinitionName(java.lang.String queryDefinitionName) {
            this.queryDefinitionName = queryDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link QueryDefinitionProps#getQueryString}
         * @param queryString The query string to use for this query definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryString(software.amazon.awscdk.services.logs.QueryString queryString) {
            this.queryString = queryString;
            return this;
        }

        /**
         * Sets the value of {@link QueryDefinitionProps#getLogGroups}
         * @param logGroups Specify certain log groups for the query definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder logGroups(java.util.List<? extends software.amazon.awscdk.services.logs.ILogGroup> logGroups) {
            this.logGroups = (java.util.List<software.amazon.awscdk.services.logs.ILogGroup>)logGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueryDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueryDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link QueryDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryDefinitionProps {
        private final java.lang.String queryDefinitionName;
        private final software.amazon.awscdk.services.logs.QueryString queryString;
        private final java.util.List<software.amazon.awscdk.services.logs.ILogGroup> logGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.queryDefinitionName = software.amazon.jsii.Kernel.get(this, "queryDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.QueryString.class));
            this.logGroups = software.amazon.jsii.Kernel.get(this, "logGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.queryDefinitionName = java.util.Objects.requireNonNull(builder.queryDefinitionName, "queryDefinitionName is required");
            this.queryString = java.util.Objects.requireNonNull(builder.queryString, "queryString is required");
            this.logGroups = (java.util.List<software.amazon.awscdk.services.logs.ILogGroup>)builder.logGroups;
        }

        @Override
        public final java.lang.String getQueryDefinitionName() {
            return this.queryDefinitionName;
        }

        @Override
        public final software.amazon.awscdk.services.logs.QueryString getQueryString() {
            return this.queryString;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.logs.ILogGroup> getLogGroups() {
            return this.logGroups;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("queryDefinitionName", om.valueToTree(this.getQueryDefinitionName()));
            data.set("queryString", om.valueToTree(this.getQueryString()));
            if (this.getLogGroups() != null) {
                data.set("logGroups", om.valueToTree(this.getLogGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-logs.QueryDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueryDefinitionProps.Jsii$Proxy that = (QueryDefinitionProps.Jsii$Proxy) o;

            if (!queryDefinitionName.equals(that.queryDefinitionName)) return false;
            if (!queryString.equals(that.queryString)) return false;
            return this.logGroups != null ? this.logGroups.equals(that.logGroups) : that.logGroups == null;
        }

        @Override
        public final int hashCode() {
            int result = this.queryDefinitionName.hashCode();
            result = 31 * result + (this.queryString.hashCode());
            result = 31 * result + (this.logGroups != null ? this.logGroups.hashCode() : 0);
            return result;
        }
    }
}
