package software.amazon.awscdk.services.logs;

/**
 * Define a QueryString.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * QueryDefinition.Builder.create(this, "QueryDefinition")
 *         .queryDefinitionName("MyQuery")
 *         .queryString(QueryString.Builder.create()
 *                 .fields(List.of("&#64;timestamp", "&#64;message"))
 *                 .sort("&#64;timestamp desc")
 *                 .limit(20)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:40.037Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.logs.$Module.class, fqn = "@aws-cdk/aws-logs.QueryString")
public class QueryString extends software.amazon.jsii.JsiiObject {

    protected QueryString(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueryString(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public QueryString(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.QueryStringProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public QueryString() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * String representation of this QueryString.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.QueryString}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.QueryString> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.logs.QueryStringProps.Builder props;

        private Builder() {
        }

        /**
         * Specifies which fields to display in the query results.
         * <p>
         * Default: - no display in QueryString
         * <p>
         * @return {@code this}
         * @param display Specifies which fields to display in the query results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder display(final java.lang.String display) {
            this.props().display(display);
            return this;
        }

        /**
         * Retrieves the specified fields from log events for display.
         * <p>
         * Default: - no fields in QueryString
         * <p>
         * @return {@code this}
         * @param fields Retrieves the specified fields from log events for display. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(final java.util.List<java.lang.String> fields) {
            this.props().fields(fields);
            return this;
        }

        /**
         * Filters the results of a query that's based on one or more conditions.
         * <p>
         * Default: - no filter in QueryString
         * <p>
         * @return {@code this}
         * @param filter Filters the results of a query that's based on one or more conditions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filter(final java.lang.String filter) {
            this.props().filter(filter);
            return this;
        }

        /**
         * Specifies the number of log events returned by the query.
         * <p>
         * Default: - no limit in QueryString
         * <p>
         * @return {@code this}
         * @param limit Specifies the number of log events returned by the query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limit(final java.lang.Number limit) {
            this.props().limit(limit);
            return this;
        }

        /**
         * Extracts data from a log field and creates one or more ephemeral fields that you can process further in the query.
         * <p>
         * Default: - no parse in QueryString
         * <p>
         * @return {@code this}
         * @param parse Extracts data from a log field and creates one or more ephemeral fields that you can process further in the query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parse(final java.lang.String parse) {
            this.props().parse(parse);
            return this;
        }

        /**
         * Sorts the retrieved log events.
         * <p>
         * Default: - no sort in QueryString
         * <p>
         * @return {@code this}
         * @param sort Sorts the retrieved log events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sort(final java.lang.String sort) {
            this.props().sort(sort);
            return this;
        }

        /**
         * Uses log field values to calculate aggregate statistics.
         * <p>
         * Default: - no stats in QueryString
         * <p>
         * @return {@code this}
         * @param stats Uses log field values to calculate aggregate statistics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stats(final java.lang.String stats) {
            this.props().stats(stats);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.logs.QueryString}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.QueryString build() {
            return new software.amazon.awscdk.services.logs.QueryString(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.logs.QueryStringProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.logs.QueryStringProps.Builder();
            }
            return this.props;
        }
    }
}
