package software.amazon.awscdk.services.logs;

/**
 * Retry options for all AWS API calls.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-12T21:08:09.655Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.logs.$Module.class, fqn = "@aws-cdk/aws-logs.LogRetentionRetryOptions")
@software.amazon.jsii.Jsii.Proxy(LogRetentionRetryOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogRetentionRetryOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The base duration to use in the exponential backoff for operation retries.
     * <p>
     * Default: Duration.millis(100) (AWS SDK default)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getBase() {
        return null;
    }

    /**
     * The maximum amount of retries.
     * <p>
     * Default: 3 (AWS SDK default)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetries() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogRetentionRetryOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogRetentionRetryOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogRetentionRetryOptions> {
        private software.amazon.awscdk.core.Duration base;
        private java.lang.Number maxRetries;

        /**
         * Sets the value of {@link LogRetentionRetryOptions#getBase}
         * @param base The base duration to use in the exponential backoff for operation retries.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder base(software.amazon.awscdk.core.Duration base) {
            this.base = base;
            return this;
        }

        /**
         * Sets the value of {@link LogRetentionRetryOptions#getMaxRetries}
         * @param maxRetries The maximum amount of retries.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRetries(java.lang.Number maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogRetentionRetryOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogRetentionRetryOptions build() {
            return new Jsii$Proxy(base, maxRetries);
        }
    }

    /**
     * An implementation for {@link LogRetentionRetryOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogRetentionRetryOptions {
        private final software.amazon.awscdk.core.Duration base;
        private final java.lang.Number maxRetries;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.base = software.amazon.jsii.Kernel.get(this, "base", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.maxRetries = software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.core.Duration base, final java.lang.Number maxRetries) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.base = base;
            this.maxRetries = maxRetries;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getBase() {
            return this.base;
        }

        @Override
        public final java.lang.Number getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBase() != null) {
                data.set("base", om.valueToTree(this.getBase()));
            }
            if (this.getMaxRetries() != null) {
                data.set("maxRetries", om.valueToTree(this.getMaxRetries()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-logs.LogRetentionRetryOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogRetentionRetryOptions.Jsii$Proxy that = (LogRetentionRetryOptions.Jsii$Proxy) o;

            if (this.base != null ? !this.base.equals(that.base) : that.base != null) return false;
            return this.maxRetries != null ? this.maxRetries.equals(that.maxRetries) : that.maxRetries == null;
        }

        @Override
        public final int hashCode() {
            int result = this.base != null ? this.base.hashCode() : 0;
            result = 31 * result + (this.maxRetries != null ? this.maxRetries.hashCode() : 0);
            return result;
        }
    }
}
