package software.amazon.awscdk.services.managedblockchain;

/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.managedblockchain.*;
 * CfnMember cfnMember = CfnMember.Builder.create(this, "MyCfnMember")
 *         .memberConfiguration(MemberConfigurationProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .memberFrameworkConfiguration(MemberFrameworkConfigurationProperty.builder()
 *                         .memberFabricConfiguration(MemberFabricConfigurationProperty.builder()
 *                                 .adminPassword("adminPassword")
 *                                 .adminUsername("adminUsername")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .invitationId("invitationId")
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .framework("framework")
 *                 .frameworkVersion("frameworkVersion")
 *                 .name("name")
 *                 .votingPolicy(VotingPolicyProperty.builder()
 *                         .approvalThresholdPolicy(ApprovalThresholdPolicyProperty.builder()
 *                                 .proposalDurationInHours(123)
 *                                 .thresholdComparator("thresholdComparator")
 *                                 .thresholdPercentage(123)
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .description("description")
 *                 .networkFrameworkConfiguration(NetworkFrameworkConfigurationProperty.builder()
 *                         .networkFabricConfiguration(NetworkFabricConfigurationProperty.builder()
 *                                 .edition("edition")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .networkId("networkId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-15T10:03:43.276Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnMember")
public class CfnMember extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnMember(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMember(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.managedblockchain.CfnMember.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ManagedBlockchain::Member`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMember(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.managedblockchain.CfnMemberProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMemberId() {
        return software.amazon.jsii.Kernel.get(this, "attrMemberId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNetworkId() {
        return software.amazon.jsii.Kernel.get(this, "attrNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::ManagedBlockchain::Member.InvitationId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInvitationId() {
        return software.amazon.jsii.Kernel.get(this, "invitationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::ManagedBlockchain::Member.InvitationId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInvitationId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "invitationId", value);
    }

    /**
     * `AWS::ManagedBlockchain::Member.MemberConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMemberConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "memberConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::ManagedBlockchain::Member.MemberConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemberConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.managedblockchain.CfnMember.MemberConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "memberConfiguration", java.util.Objects.requireNonNull(value, "memberConfiguration is required"));
    }

    /**
     * `AWS::ManagedBlockchain::Member.MemberConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemberConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "memberConfiguration", java.util.Objects.requireNonNull(value, "memberConfiguration is required"));
    }

    /**
     * `AWS::ManagedBlockchain::Member.NetworkConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::ManagedBlockchain::Member.NetworkConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * `AWS::ManagedBlockchain::Member.NetworkConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * `AWS::ManagedBlockchain::Member.NetworkId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNetworkId() {
        return software.amazon.jsii.Kernel.get(this, "networkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::ManagedBlockchain::Member.NetworkId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "networkId", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * ApprovalThresholdPolicyProperty approvalThresholdPolicyProperty = ApprovalThresholdPolicyProperty.builder()
     *         .proposalDurationInHours(123)
     *         .thresholdComparator("thresholdComparator")
     *         .thresholdPercentage(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnMember.ApprovalThresholdPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ApprovalThresholdPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApprovalThresholdPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ProposalDurationInHours`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProposalDurationInHours() {
            return null;
        }

        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ThresholdComparator`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getThresholdComparator() {
            return null;
        }

        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ThresholdPercentage`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThresholdPercentage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApprovalThresholdPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApprovalThresholdPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApprovalThresholdPolicyProperty> {
            java.lang.Number proposalDurationInHours;
            java.lang.String thresholdComparator;
            java.lang.Number thresholdPercentage;

            /**
             * Sets the value of {@link ApprovalThresholdPolicyProperty#getProposalDurationInHours}
             * @param proposalDurationInHours `CfnMember.ApprovalThresholdPolicyProperty.ProposalDurationInHours`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder proposalDurationInHours(java.lang.Number proposalDurationInHours) {
                this.proposalDurationInHours = proposalDurationInHours;
                return this;
            }

            /**
             * Sets the value of {@link ApprovalThresholdPolicyProperty#getThresholdComparator}
             * @param thresholdComparator `CfnMember.ApprovalThresholdPolicyProperty.ThresholdComparator`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thresholdComparator(java.lang.String thresholdComparator) {
                this.thresholdComparator = thresholdComparator;
                return this;
            }

            /**
             * Sets the value of {@link ApprovalThresholdPolicyProperty#getThresholdPercentage}
             * @param thresholdPercentage `CfnMember.ApprovalThresholdPolicyProperty.ThresholdPercentage`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thresholdPercentage(java.lang.Number thresholdPercentage) {
                this.thresholdPercentage = thresholdPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApprovalThresholdPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApprovalThresholdPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApprovalThresholdPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApprovalThresholdPolicyProperty {
            private final java.lang.Number proposalDurationInHours;
            private final java.lang.String thresholdComparator;
            private final java.lang.Number thresholdPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.proposalDurationInHours = software.amazon.jsii.Kernel.get(this, "proposalDurationInHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.thresholdComparator = software.amazon.jsii.Kernel.get(this, "thresholdComparator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.thresholdPercentage = software.amazon.jsii.Kernel.get(this, "thresholdPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.proposalDurationInHours = builder.proposalDurationInHours;
                this.thresholdComparator = builder.thresholdComparator;
                this.thresholdPercentage = builder.thresholdPercentage;
            }

            @Override
            public final java.lang.Number getProposalDurationInHours() {
                return this.proposalDurationInHours;
            }

            @Override
            public final java.lang.String getThresholdComparator() {
                return this.thresholdComparator;
            }

            @Override
            public final java.lang.Number getThresholdPercentage() {
                return this.thresholdPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getProposalDurationInHours() != null) {
                    data.set("proposalDurationInHours", om.valueToTree(this.getProposalDurationInHours()));
                }
                if (this.getThresholdComparator() != null) {
                    data.set("thresholdComparator", om.valueToTree(this.getThresholdComparator()));
                }
                if (this.getThresholdPercentage() != null) {
                    data.set("thresholdPercentage", om.valueToTree(this.getThresholdPercentage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-managedblockchain.CfnMember.ApprovalThresholdPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApprovalThresholdPolicyProperty.Jsii$Proxy that = (ApprovalThresholdPolicyProperty.Jsii$Proxy) o;

                if (this.proposalDurationInHours != null ? !this.proposalDurationInHours.equals(that.proposalDurationInHours) : that.proposalDurationInHours != null) return false;
                if (this.thresholdComparator != null ? !this.thresholdComparator.equals(that.thresholdComparator) : that.thresholdComparator != null) return false;
                return this.thresholdPercentage != null ? this.thresholdPercentage.equals(that.thresholdPercentage) : that.thresholdPercentage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.proposalDurationInHours != null ? this.proposalDurationInHours.hashCode() : 0;
                result = 31 * result + (this.thresholdComparator != null ? this.thresholdComparator.hashCode() : 0);
                result = 31 * result + (this.thresholdPercentage != null ? this.thresholdPercentage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * MemberConfigurationProperty memberConfigurationProperty = MemberConfigurationProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .description("description")
     *         .memberFrameworkConfiguration(MemberFrameworkConfigurationProperty.builder()
     *                 .memberFabricConfiguration(MemberFabricConfigurationProperty.builder()
     *                         .adminPassword("adminPassword")
     *                         .adminUsername("adminUsername")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnMember.MemberConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MemberConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemberConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.MemberConfigurationProperty.Description`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * `CfnMember.MemberConfigurationProperty.MemberFrameworkConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemberFrameworkConfiguration() {
            return null;
        }

        /**
         * `CfnMember.MemberConfigurationProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link MemberConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemberConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemberConfigurationProperty> {
            java.lang.String description;
            java.lang.Object memberFrameworkConfiguration;
            java.lang.String name;

            /**
             * Sets the value of {@link MemberConfigurationProperty#getDescription}
             * @param description `CfnMember.MemberConfigurationProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link MemberConfigurationProperty#getMemberFrameworkConfiguration}
             * @param memberFrameworkConfiguration `CfnMember.MemberConfigurationProperty.MemberFrameworkConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memberFrameworkConfiguration(software.amazon.awscdk.core.IResolvable memberFrameworkConfiguration) {
                this.memberFrameworkConfiguration = memberFrameworkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MemberConfigurationProperty#getMemberFrameworkConfiguration}
             * @param memberFrameworkConfiguration `CfnMember.MemberConfigurationProperty.MemberFrameworkConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memberFrameworkConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.MemberFrameworkConfigurationProperty memberFrameworkConfiguration) {
                this.memberFrameworkConfiguration = memberFrameworkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MemberConfigurationProperty#getName}
             * @param name `CfnMember.MemberConfigurationProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemberConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemberConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemberConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemberConfigurationProperty {
            private final java.lang.String description;
            private final java.lang.Object memberFrameworkConfiguration;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memberFrameworkConfiguration = software.amazon.jsii.Kernel.get(this, "memberFrameworkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.description = builder.description;
                this.memberFrameworkConfiguration = builder.memberFrameworkConfiguration;
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getMemberFrameworkConfiguration() {
                return this.memberFrameworkConfiguration;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getMemberFrameworkConfiguration() != null) {
                    data.set("memberFrameworkConfiguration", om.valueToTree(this.getMemberFrameworkConfiguration()));
                }
                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-managedblockchain.CfnMember.MemberConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemberConfigurationProperty.Jsii$Proxy that = (MemberConfigurationProperty.Jsii$Proxy) o;

                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.memberFrameworkConfiguration != null ? !this.memberFrameworkConfiguration.equals(that.memberFrameworkConfiguration) : that.memberFrameworkConfiguration != null) return false;
                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.memberFrameworkConfiguration != null ? this.memberFrameworkConfiguration.hashCode() : 0);
                result = 31 * result + (this.name.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * MemberFabricConfigurationProperty memberFabricConfigurationProperty = MemberFabricConfigurationProperty.builder()
     *         .adminPassword("adminPassword")
     *         .adminUsername("adminUsername")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnMember.MemberFabricConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MemberFabricConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemberFabricConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.MemberFabricConfigurationProperty.AdminPassword`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAdminPassword();

        /**
         * `CfnMember.MemberFabricConfigurationProperty.AdminUsername`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAdminUsername();

        /**
         * @return a {@link Builder} of {@link MemberFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemberFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemberFabricConfigurationProperty> {
            java.lang.String adminPassword;
            java.lang.String adminUsername;

            /**
             * Sets the value of {@link MemberFabricConfigurationProperty#getAdminPassword}
             * @param adminPassword `CfnMember.MemberFabricConfigurationProperty.AdminPassword`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adminPassword(java.lang.String adminPassword) {
                this.adminPassword = adminPassword;
                return this;
            }

            /**
             * Sets the value of {@link MemberFabricConfigurationProperty#getAdminUsername}
             * @param adminUsername `CfnMember.MemberFabricConfigurationProperty.AdminUsername`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adminUsername(java.lang.String adminUsername) {
                this.adminUsername = adminUsername;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemberFabricConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemberFabricConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemberFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemberFabricConfigurationProperty {
            private final java.lang.String adminPassword;
            private final java.lang.String adminUsername;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adminPassword = software.amazon.jsii.Kernel.get(this, "adminPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adminUsername = software.amazon.jsii.Kernel.get(this, "adminUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adminPassword = java.util.Objects.requireNonNull(builder.adminPassword, "adminPassword is required");
                this.adminUsername = java.util.Objects.requireNonNull(builder.adminUsername, "adminUsername is required");
            }

            @Override
            public final java.lang.String getAdminPassword() {
                return this.adminPassword;
            }

            @Override
            public final java.lang.String getAdminUsername() {
                return this.adminUsername;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("adminPassword", om.valueToTree(this.getAdminPassword()));
                data.set("adminUsername", om.valueToTree(this.getAdminUsername()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-managedblockchain.CfnMember.MemberFabricConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemberFabricConfigurationProperty.Jsii$Proxy that = (MemberFabricConfigurationProperty.Jsii$Proxy) o;

                if (!adminPassword.equals(that.adminPassword)) return false;
                return this.adminUsername.equals(that.adminUsername);
            }

            @Override
            public final int hashCode() {
                int result = this.adminPassword.hashCode();
                result = 31 * result + (this.adminUsername.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * MemberFrameworkConfigurationProperty memberFrameworkConfigurationProperty = MemberFrameworkConfigurationProperty.builder()
     *         .memberFabricConfiguration(MemberFabricConfigurationProperty.builder()
     *                 .adminPassword("adminPassword")
     *                 .adminUsername("adminUsername")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnMember.MemberFrameworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MemberFrameworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemberFrameworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.MemberFrameworkConfigurationProperty.MemberFabricConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemberFabricConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemberFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemberFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemberFrameworkConfigurationProperty> {
            java.lang.Object memberFabricConfiguration;

            /**
             * Sets the value of {@link MemberFrameworkConfigurationProperty#getMemberFabricConfiguration}
             * @param memberFabricConfiguration `CfnMember.MemberFrameworkConfigurationProperty.MemberFabricConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memberFabricConfiguration(software.amazon.awscdk.core.IResolvable memberFabricConfiguration) {
                this.memberFabricConfiguration = memberFabricConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MemberFrameworkConfigurationProperty#getMemberFabricConfiguration}
             * @param memberFabricConfiguration `CfnMember.MemberFrameworkConfigurationProperty.MemberFabricConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memberFabricConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.MemberFabricConfigurationProperty memberFabricConfiguration) {
                this.memberFabricConfiguration = memberFabricConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemberFrameworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemberFrameworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemberFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemberFrameworkConfigurationProperty {
            private final java.lang.Object memberFabricConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.memberFabricConfiguration = software.amazon.jsii.Kernel.get(this, "memberFabricConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.memberFabricConfiguration = builder.memberFabricConfiguration;
            }

            @Override
            public final java.lang.Object getMemberFabricConfiguration() {
                return this.memberFabricConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMemberFabricConfiguration() != null) {
                    data.set("memberFabricConfiguration", om.valueToTree(this.getMemberFabricConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-managedblockchain.CfnMember.MemberFrameworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemberFrameworkConfigurationProperty.Jsii$Proxy that = (MemberFrameworkConfigurationProperty.Jsii$Proxy) o;

                return this.memberFabricConfiguration != null ? this.memberFabricConfiguration.equals(that.memberFabricConfiguration) : that.memberFabricConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.memberFabricConfiguration != null ? this.memberFabricConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .framework("framework")
     *         .frameworkVersion("frameworkVersion")
     *         .name("name")
     *         .votingPolicy(VotingPolicyProperty.builder()
     *                 .approvalThresholdPolicy(ApprovalThresholdPolicyProperty.builder()
     *                         .proposalDurationInHours(123)
     *                         .thresholdComparator("thresholdComparator")
     *                         .thresholdPercentage(123)
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .description("description")
     *         .networkFrameworkConfiguration(NetworkFrameworkConfigurationProperty.builder()
     *                 .networkFabricConfiguration(NetworkFabricConfigurationProperty.builder()
     *                         .edition("edition")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnMember.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.NetworkConfigurationProperty.Description`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * `CfnMember.NetworkConfigurationProperty.Framework`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFramework();

        /**
         * `CfnMember.NetworkConfigurationProperty.FrameworkVersion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFrameworkVersion();

        /**
         * `CfnMember.NetworkConfigurationProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnMember.NetworkConfigurationProperty.NetworkFrameworkConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkFrameworkConfiguration() {
            return null;
        }

        /**
         * `CfnMember.NetworkConfigurationProperty.VotingPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVotingPolicy();

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.lang.String description;
            java.lang.String framework;
            java.lang.String frameworkVersion;
            java.lang.String name;
            java.lang.Object networkFrameworkConfiguration;
            java.lang.Object votingPolicy;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getDescription}
             * @param description `CfnMember.NetworkConfigurationProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getFramework}
             * @param framework `CfnMember.NetworkConfigurationProperty.Framework`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder framework(java.lang.String framework) {
                this.framework = framework;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getFrameworkVersion}
             * @param frameworkVersion `CfnMember.NetworkConfigurationProperty.FrameworkVersion`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frameworkVersion(java.lang.String frameworkVersion) {
                this.frameworkVersion = frameworkVersion;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getName}
             * @param name `CfnMember.NetworkConfigurationProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getNetworkFrameworkConfiguration}
             * @param networkFrameworkConfiguration `CfnMember.NetworkConfigurationProperty.NetworkFrameworkConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkFrameworkConfiguration(software.amazon.awscdk.core.IResolvable networkFrameworkConfiguration) {
                this.networkFrameworkConfiguration = networkFrameworkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getNetworkFrameworkConfiguration}
             * @param networkFrameworkConfiguration `CfnMember.NetworkConfigurationProperty.NetworkFrameworkConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkFrameworkConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkFrameworkConfigurationProperty networkFrameworkConfiguration) {
                this.networkFrameworkConfiguration = networkFrameworkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getVotingPolicy}
             * @param votingPolicy `CfnMember.NetworkConfigurationProperty.VotingPolicy`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder votingPolicy(software.amazon.awscdk.core.IResolvable votingPolicy) {
                this.votingPolicy = votingPolicy;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getVotingPolicy}
             * @param votingPolicy `CfnMember.NetworkConfigurationProperty.VotingPolicy`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder votingPolicy(software.amazon.awscdk.services.managedblockchain.CfnMember.VotingPolicyProperty votingPolicy) {
                this.votingPolicy = votingPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.lang.String description;
            private final java.lang.String framework;
            private final java.lang.String frameworkVersion;
            private final java.lang.String name;
            private final java.lang.Object networkFrameworkConfiguration;
            private final java.lang.Object votingPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.framework = software.amazon.jsii.Kernel.get(this, "framework", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.frameworkVersion = software.amazon.jsii.Kernel.get(this, "frameworkVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkFrameworkConfiguration = software.amazon.jsii.Kernel.get(this, "networkFrameworkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.votingPolicy = software.amazon.jsii.Kernel.get(this, "votingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.description = builder.description;
                this.framework = java.util.Objects.requireNonNull(builder.framework, "framework is required");
                this.frameworkVersion = java.util.Objects.requireNonNull(builder.frameworkVersion, "frameworkVersion is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.networkFrameworkConfiguration = builder.networkFrameworkConfiguration;
                this.votingPolicy = java.util.Objects.requireNonNull(builder.votingPolicy, "votingPolicy is required");
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getFramework() {
                return this.framework;
            }

            @Override
            public final java.lang.String getFrameworkVersion() {
                return this.frameworkVersion;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getNetworkFrameworkConfiguration() {
                return this.networkFrameworkConfiguration;
            }

            @Override
            public final java.lang.Object getVotingPolicy() {
                return this.votingPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                data.set("framework", om.valueToTree(this.getFramework()));
                data.set("frameworkVersion", om.valueToTree(this.getFrameworkVersion()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getNetworkFrameworkConfiguration() != null) {
                    data.set("networkFrameworkConfiguration", om.valueToTree(this.getNetworkFrameworkConfiguration()));
                }
                data.set("votingPolicy", om.valueToTree(this.getVotingPolicy()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-managedblockchain.CfnMember.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (!framework.equals(that.framework)) return false;
                if (!frameworkVersion.equals(that.frameworkVersion)) return false;
                if (!name.equals(that.name)) return false;
                if (this.networkFrameworkConfiguration != null ? !this.networkFrameworkConfiguration.equals(that.networkFrameworkConfiguration) : that.networkFrameworkConfiguration != null) return false;
                return this.votingPolicy.equals(that.votingPolicy);
            }

            @Override
            public final int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.framework.hashCode());
                result = 31 * result + (this.frameworkVersion.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.networkFrameworkConfiguration != null ? this.networkFrameworkConfiguration.hashCode() : 0);
                result = 31 * result + (this.votingPolicy.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * NetworkFabricConfigurationProperty networkFabricConfigurationProperty = NetworkFabricConfigurationProperty.builder()
     *         .edition("edition")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnMember.NetworkFabricConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkFabricConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkFabricConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.NetworkFabricConfigurationProperty.Edition`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEdition();

        /**
         * @return a {@link Builder} of {@link NetworkFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkFabricConfigurationProperty> {
            java.lang.String edition;

            /**
             * Sets the value of {@link NetworkFabricConfigurationProperty#getEdition}
             * @param edition `CfnMember.NetworkFabricConfigurationProperty.Edition`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder edition(java.lang.String edition) {
                this.edition = edition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkFabricConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkFabricConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkFabricConfigurationProperty {
            private final java.lang.String edition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.edition = software.amazon.jsii.Kernel.get(this, "edition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.edition = java.util.Objects.requireNonNull(builder.edition, "edition is required");
            }

            @Override
            public final java.lang.String getEdition() {
                return this.edition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("edition", om.valueToTree(this.getEdition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-managedblockchain.CfnMember.NetworkFabricConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkFabricConfigurationProperty.Jsii$Proxy that = (NetworkFabricConfigurationProperty.Jsii$Proxy) o;

                return this.edition.equals(that.edition);
            }

            @Override
            public final int hashCode() {
                int result = this.edition.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * NetworkFrameworkConfigurationProperty networkFrameworkConfigurationProperty = NetworkFrameworkConfigurationProperty.builder()
     *         .networkFabricConfiguration(NetworkFabricConfigurationProperty.builder()
     *                 .edition("edition")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnMember.NetworkFrameworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkFrameworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkFrameworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.NetworkFrameworkConfigurationProperty.NetworkFabricConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkFabricConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkFrameworkConfigurationProperty> {
            java.lang.Object networkFabricConfiguration;

            /**
             * Sets the value of {@link NetworkFrameworkConfigurationProperty#getNetworkFabricConfiguration}
             * @param networkFabricConfiguration `CfnMember.NetworkFrameworkConfigurationProperty.NetworkFabricConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkFabricConfiguration(software.amazon.awscdk.core.IResolvable networkFabricConfiguration) {
                this.networkFabricConfiguration = networkFabricConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkFrameworkConfigurationProperty#getNetworkFabricConfiguration}
             * @param networkFabricConfiguration `CfnMember.NetworkFrameworkConfigurationProperty.NetworkFabricConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkFabricConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkFabricConfigurationProperty networkFabricConfiguration) {
                this.networkFabricConfiguration = networkFabricConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkFrameworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkFrameworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkFrameworkConfigurationProperty {
            private final java.lang.Object networkFabricConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.networkFabricConfiguration = software.amazon.jsii.Kernel.get(this, "networkFabricConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.networkFabricConfiguration = builder.networkFabricConfiguration;
            }

            @Override
            public final java.lang.Object getNetworkFabricConfiguration() {
                return this.networkFabricConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNetworkFabricConfiguration() != null) {
                    data.set("networkFabricConfiguration", om.valueToTree(this.getNetworkFabricConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-managedblockchain.CfnMember.NetworkFrameworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkFrameworkConfigurationProperty.Jsii$Proxy that = (NetworkFrameworkConfigurationProperty.Jsii$Proxy) o;

                return this.networkFabricConfiguration != null ? this.networkFabricConfiguration.equals(that.networkFabricConfiguration) : that.networkFabricConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.networkFabricConfiguration != null ? this.networkFabricConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * VotingPolicyProperty votingPolicyProperty = VotingPolicyProperty.builder()
     *         .approvalThresholdPolicy(ApprovalThresholdPolicyProperty.builder()
     *                 .proposalDurationInHours(123)
     *                 .thresholdComparator("thresholdComparator")
     *                 .thresholdPercentage(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnMember.VotingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(VotingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VotingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.VotingPolicyProperty.ApprovalThresholdPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApprovalThresholdPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VotingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VotingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VotingPolicyProperty> {
            java.lang.Object approvalThresholdPolicy;

            /**
             * Sets the value of {@link VotingPolicyProperty#getApprovalThresholdPolicy}
             * @param approvalThresholdPolicy `CfnMember.VotingPolicyProperty.ApprovalThresholdPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder approvalThresholdPolicy(software.amazon.awscdk.core.IResolvable approvalThresholdPolicy) {
                this.approvalThresholdPolicy = approvalThresholdPolicy;
                return this;
            }

            /**
             * Sets the value of {@link VotingPolicyProperty#getApprovalThresholdPolicy}
             * @param approvalThresholdPolicy `CfnMember.VotingPolicyProperty.ApprovalThresholdPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder approvalThresholdPolicy(software.amazon.awscdk.services.managedblockchain.CfnMember.ApprovalThresholdPolicyProperty approvalThresholdPolicy) {
                this.approvalThresholdPolicy = approvalThresholdPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VotingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VotingPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VotingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VotingPolicyProperty {
            private final java.lang.Object approvalThresholdPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.approvalThresholdPolicy = software.amazon.jsii.Kernel.get(this, "approvalThresholdPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.approvalThresholdPolicy = builder.approvalThresholdPolicy;
            }

            @Override
            public final java.lang.Object getApprovalThresholdPolicy() {
                return this.approvalThresholdPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApprovalThresholdPolicy() != null) {
                    data.set("approvalThresholdPolicy", om.valueToTree(this.getApprovalThresholdPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-managedblockchain.CfnMember.VotingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VotingPolicyProperty.Jsii$Proxy that = (VotingPolicyProperty.Jsii$Proxy) o;

                return this.approvalThresholdPolicy != null ? this.approvalThresholdPolicy.equals(that.approvalThresholdPolicy) : that.approvalThresholdPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.approvalThresholdPolicy != null ? this.approvalThresholdPolicy.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.managedblockchain.CfnMember}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.managedblockchain.CfnMember> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.managedblockchain.CfnMemberProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.managedblockchain.CfnMemberProps.Builder();
        }

        /**
         * `AWS::ManagedBlockchain::Member.InvitationId`.
         * <p>
         * @return {@code this}
         * @param invitationId `AWS::ManagedBlockchain::Member.InvitationId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invitationId(final java.lang.String invitationId) {
            this.props.invitationId(invitationId);
            return this;
        }

        /**
         * `AWS::ManagedBlockchain::Member.MemberConfiguration`.
         * <p>
         * @return {@code this}
         * @param memberConfiguration `AWS::ManagedBlockchain::Member.MemberConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberConfiguration(final software.amazon.awscdk.services.managedblockchain.CfnMember.MemberConfigurationProperty memberConfiguration) {
            this.props.memberConfiguration(memberConfiguration);
            return this;
        }
        /**
         * `AWS::ManagedBlockchain::Member.MemberConfiguration`.
         * <p>
         * @return {@code this}
         * @param memberConfiguration `AWS::ManagedBlockchain::Member.MemberConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberConfiguration(final software.amazon.awscdk.core.IResolvable memberConfiguration) {
            this.props.memberConfiguration(memberConfiguration);
            return this;
        }

        /**
         * `AWS::ManagedBlockchain::Member.NetworkConfiguration`.
         * <p>
         * @return {@code this}
         * @param networkConfiguration `AWS::ManagedBlockchain::Member.NetworkConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.core.IResolvable networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }
        /**
         * `AWS::ManagedBlockchain::Member.NetworkConfiguration`.
         * <p>
         * @return {@code this}
         * @param networkConfiguration `AWS::ManagedBlockchain::Member.NetworkConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkConfigurationProperty networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        /**
         * `AWS::ManagedBlockchain::Member.NetworkId`.
         * <p>
         * @return {@code this}
         * @param networkId `AWS::ManagedBlockchain::Member.NetworkId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkId(final java.lang.String networkId) {
            this.props.networkId(networkId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.managedblockchain.CfnMember}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.managedblockchain.CfnMember build() {
            return new software.amazon.awscdk.services.managedblockchain.CfnMember(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
