/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.managedblockchain;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.managedblockchain.$Module;
import software.amazon.awscdk.services.managedblockchain.CfnMember;
import software.amazon.awscdk.services.managedblockchain.CfnMemberProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-managedblockchain.CfnMember")
public class CfnMember
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnMember.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnMember(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMember(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnMember(Construct scope, String id, CfnMemberProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    public String getAttrMemberId() {
        return (String)this.jsiiGet("attrMemberId", String.class);
    }

    public String getAttrNetworkId() {
        return (String)this.jsiiGet("attrNetworkId", String.class);
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public Object getMemberConfiguration() {
        return this.jsiiGet("memberConfiguration", Object.class);
    }

    public void setMemberConfiguration(MemberConfigurationProperty value) {
        this.jsiiSet("memberConfiguration", Objects.requireNonNull(value, "memberConfiguration is required"));
    }

    public void setMemberConfiguration(IResolvable value) {
        this.jsiiSet("memberConfiguration", Objects.requireNonNull(value, "memberConfiguration is required"));
    }

    public String getInvitationId() {
        return (String)this.jsiiGet("invitationId", String.class);
    }

    public void setInvitationId(String value) {
        this.jsiiSet("invitationId", value);
    }

    public Object getNetworkConfiguration() {
        return this.jsiiGet("networkConfiguration", Object.class);
    }

    public void setNetworkConfiguration(IResolvable value) {
        this.jsiiSet("networkConfiguration", value);
    }

    public void setNetworkConfiguration(NetworkConfigurationProperty value) {
        this.jsiiSet("networkConfiguration", value);
    }

    public String getNetworkId() {
        return (String)this.jsiiGet("networkId", String.class);
    }

    public void setNetworkId(String value) {
        this.jsiiSet("networkId", value);
    }

    public static interface VotingPolicyProperty
    extends JsiiSerializable {
        public Object getApprovalThresholdPolicy();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object approvalThresholdPolicy;

            public Builder approvalThresholdPolicy(IResolvable approvalThresholdPolicy) {
                this.approvalThresholdPolicy = approvalThresholdPolicy;
                return this;
            }

            public Builder approvalThresholdPolicy(ApprovalThresholdPolicyProperty approvalThresholdPolicy) {
                this.approvalThresholdPolicy = approvalThresholdPolicy;
                return this;
            }

            public VotingPolicyProperty build() {
                return new Jsii.Proxy(this.approvalThresholdPolicy, null);
            }
        }
    }

    public static interface NetworkFrameworkConfigurationProperty
    extends JsiiSerializable {
        public Object getNetworkFabricConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object networkFabricConfiguration;

            public Builder networkFabricConfiguration(IResolvable networkFabricConfiguration) {
                this.networkFabricConfiguration = networkFabricConfiguration;
                return this;
            }

            public Builder networkFabricConfiguration(NetworkFabricConfigurationProperty networkFabricConfiguration) {
                this.networkFabricConfiguration = networkFabricConfiguration;
                return this;
            }

            public NetworkFrameworkConfigurationProperty build() {
                return new Jsii.Proxy(this.networkFabricConfiguration, null);
            }
        }
    }

    public static interface NetworkFabricConfigurationProperty
    extends JsiiSerializable {
        public String getEdition();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String edition;

            public Builder edition(String edition) {
                this.edition = edition;
                return this;
            }

            public NetworkFabricConfigurationProperty build() {
                return new Jsii.Proxy(this.edition, null);
            }
        }
    }

    public static interface NetworkConfigurationProperty
    extends JsiiSerializable {
        public String getFramework();

        public String getFrameworkVersion();

        public String getName();

        public Object getVotingPolicy();

        public String getDescription();

        public Object getNetworkFrameworkConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String framework;
            private String frameworkVersion;
            private String name;
            private Object votingPolicy;
            private String description;
            private Object networkFrameworkConfiguration;

            public Builder framework(String framework) {
                this.framework = framework;
                return this;
            }

            public Builder frameworkVersion(String frameworkVersion) {
                this.frameworkVersion = frameworkVersion;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder votingPolicy(IResolvable votingPolicy) {
                this.votingPolicy = votingPolicy;
                return this;
            }

            public Builder votingPolicy(VotingPolicyProperty votingPolicy) {
                this.votingPolicy = votingPolicy;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder networkFrameworkConfiguration(IResolvable networkFrameworkConfiguration) {
                this.networkFrameworkConfiguration = networkFrameworkConfiguration;
                return this;
            }

            public Builder networkFrameworkConfiguration(NetworkFrameworkConfigurationProperty networkFrameworkConfiguration) {
                this.networkFrameworkConfiguration = networkFrameworkConfiguration;
                return this;
            }

            public NetworkConfigurationProperty build() {
                return new Jsii.Proxy(this.framework, this.frameworkVersion, this.name, this.votingPolicy, this.description, this.networkFrameworkConfiguration, null);
            }
        }
    }

    public static interface MemberFrameworkConfigurationProperty
    extends JsiiSerializable {
        public Object getMemberFabricConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object memberFabricConfiguration;

            public Builder memberFabricConfiguration(IResolvable memberFabricConfiguration) {
                this.memberFabricConfiguration = memberFabricConfiguration;
                return this;
            }

            public Builder memberFabricConfiguration(MemberFabricConfigurationProperty memberFabricConfiguration) {
                this.memberFabricConfiguration = memberFabricConfiguration;
                return this;
            }

            public MemberFrameworkConfigurationProperty build() {
                return new Jsii.Proxy(this.memberFabricConfiguration, null);
            }
        }
    }

    public static interface MemberFabricConfigurationProperty
    extends JsiiSerializable {
        public String getAdminPassword();

        public String getAdminUsername();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String adminPassword;
            private String adminUsername;

            public Builder adminPassword(String adminPassword) {
                this.adminPassword = adminPassword;
                return this;
            }

            public Builder adminUsername(String adminUsername) {
                this.adminUsername = adminUsername;
                return this;
            }

            public MemberFabricConfigurationProperty build() {
                return new Jsii.Proxy(this.adminPassword, this.adminUsername, null);
            }
        }
    }

    public static interface MemberConfigurationProperty
    extends JsiiSerializable {
        public String getName();

        public String getDescription();

        public Object getMemberFrameworkConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;
            private String description;
            private Object memberFrameworkConfiguration;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder memberFrameworkConfiguration(IResolvable memberFrameworkConfiguration) {
                this.memberFrameworkConfiguration = memberFrameworkConfiguration;
                return this;
            }

            public Builder memberFrameworkConfiguration(MemberFrameworkConfigurationProperty memberFrameworkConfiguration) {
                this.memberFrameworkConfiguration = memberFrameworkConfiguration;
                return this;
            }

            public MemberConfigurationProperty build() {
                return new Jsii.Proxy(this.name, this.description, this.memberFrameworkConfiguration, null);
            }
        }
    }

    public static interface ApprovalThresholdPolicyProperty
    extends JsiiSerializable {
        public Number getProposalDurationInHours();

        public String getThresholdComparator();

        public Number getThresholdPercentage();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number proposalDurationInHours;
            private String thresholdComparator;
            private Number thresholdPercentage;

            public Builder proposalDurationInHours(Number proposalDurationInHours) {
                this.proposalDurationInHours = proposalDurationInHours;
                return this;
            }

            public Builder thresholdComparator(String thresholdComparator) {
                this.thresholdComparator = thresholdComparator;
                return this;
            }

            public Builder thresholdPercentage(Number thresholdPercentage) {
                this.thresholdPercentage = thresholdPercentage;
                return this;
            }

            public ApprovalThresholdPolicyProperty build() {
                return new Jsii.Proxy(this.proposalDurationInHours, this.thresholdComparator, this.thresholdPercentage, null);
            }
        }
    }
}

