package software.amazon.awscdk.services.managedblockchain;

/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-28T12:17:29.337Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnMember")
public class CfnMember extends software.amazon.awscdk.core.CfnResource {

    protected CfnMember(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMember(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.managedblockchain.CfnMember.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ManagedBlockchain::Member`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnMember(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.managedblockchain.CfnMemberProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrMemberId() {
        return this.jsiiGet("attrMemberId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrNetworkId() {
        return this.jsiiGet("attrNetworkId", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::ManagedBlockchain::Member.MemberConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getMemberConfiguration() {
        return this.jsiiGet("memberConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::ManagedBlockchain::Member.MemberConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMemberConfiguration(final software.amazon.awscdk.services.managedblockchain.CfnMember.MemberConfigurationProperty value) {
        this.jsiiSet("memberConfiguration", java.util.Objects.requireNonNull(value, "memberConfiguration is required"));
    }

    /**
     * `AWS::ManagedBlockchain::Member.MemberConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMemberConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("memberConfiguration", java.util.Objects.requireNonNull(value, "memberConfiguration is required"));
    }

    /**
     * `AWS::ManagedBlockchain::Member.InvitationId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-invitationid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getInvitationId() {
        return this.jsiiGet("invitationId", java.lang.String.class);
    }

    /**
     * `AWS::ManagedBlockchain::Member.InvitationId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-invitationid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setInvitationId(final java.lang.String value) {
        this.jsiiSet("invitationId", value);
    }

    /**
     * `AWS::ManagedBlockchain::Member.NetworkConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getNetworkConfiguration() {
        return this.jsiiGet("networkConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::ManagedBlockchain::Member.NetworkConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNetworkConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("networkConfiguration", value);
    }

    /**
     * `AWS::ManagedBlockchain::Member.NetworkConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNetworkConfiguration(final software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkConfigurationProperty value) {
        this.jsiiSet("networkConfiguration", value);
    }

    /**
     * `AWS::ManagedBlockchain::Member.NetworkId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getNetworkId() {
        return this.jsiiGet("networkId", java.lang.String.class);
    }

    /**
     * `AWS::ManagedBlockchain::Member.NetworkId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNetworkId(final java.lang.String value) {
        this.jsiiSet("networkId", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ApprovalThresholdPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ProposalDurationInHours`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-proposaldurationinhours
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getProposalDurationInHours();

        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ThresholdComparator`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-thresholdcomparator
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getThresholdComparator();

        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ThresholdPercentage`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-thresholdpercentage
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getThresholdPercentage();

        /**
         * @return a {@link Builder} of {@link ApprovalThresholdPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApprovalThresholdPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Number proposalDurationInHours;
            private java.lang.String thresholdComparator;
            private java.lang.Number thresholdPercentage;

            /**
             * Sets the value of ProposalDurationInHours
             * @param proposalDurationInHours `CfnMember.ApprovalThresholdPolicyProperty.ProposalDurationInHours`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder proposalDurationInHours(java.lang.Number proposalDurationInHours) {
                this.proposalDurationInHours = proposalDurationInHours;
                return this;
            }

            /**
             * Sets the value of ThresholdComparator
             * @param thresholdComparator `CfnMember.ApprovalThresholdPolicyProperty.ThresholdComparator`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder thresholdComparator(java.lang.String thresholdComparator) {
                this.thresholdComparator = thresholdComparator;
                return this;
            }

            /**
             * Sets the value of ThresholdPercentage
             * @param thresholdPercentage `CfnMember.ApprovalThresholdPolicyProperty.ThresholdPercentage`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder thresholdPercentage(java.lang.Number thresholdPercentage) {
                this.thresholdPercentage = thresholdPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApprovalThresholdPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ApprovalThresholdPolicyProperty build() {
                return new Jsii$Proxy(proposalDurationInHours, thresholdComparator, thresholdPercentage);
            }
        }

        /**
         * An implementation for {@link ApprovalThresholdPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApprovalThresholdPolicyProperty {
            private final java.lang.Number proposalDurationInHours;
            private final java.lang.String thresholdComparator;
            private final java.lang.Number thresholdPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.proposalDurationInHours = this.jsiiGet("proposalDurationInHours", java.lang.Number.class);
                this.thresholdComparator = this.jsiiGet("thresholdComparator", java.lang.String.class);
                this.thresholdPercentage = this.jsiiGet("thresholdPercentage", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Number proposalDurationInHours, java.lang.String thresholdComparator, java.lang.Number thresholdPercentage) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.proposalDurationInHours = proposalDurationInHours;
                this.thresholdComparator = thresholdComparator;
                this.thresholdPercentage = thresholdPercentage;
            }

            @Override
            public java.lang.Number getProposalDurationInHours() {
                return this.proposalDurationInHours;
            }

            @Override
            public java.lang.String getThresholdComparator() {
                return this.thresholdComparator;
            }

            @Override
            public java.lang.Number getThresholdPercentage() {
                return this.thresholdPercentage;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getProposalDurationInHours() != null) {
                    obj.set("proposalDurationInHours", om.valueToTree(this.getProposalDurationInHours()));
                }
                if (this.getThresholdComparator() != null) {
                    obj.set("thresholdComparator", om.valueToTree(this.getThresholdComparator()));
                }
                if (this.getThresholdPercentage() != null) {
                    obj.set("thresholdPercentage", om.valueToTree(this.getThresholdPercentage()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApprovalThresholdPolicyProperty.Jsii$Proxy that = (ApprovalThresholdPolicyProperty.Jsii$Proxy) o;

                if (this.proposalDurationInHours != null ? !this.proposalDurationInHours.equals(that.proposalDurationInHours) : that.proposalDurationInHours != null) return false;
                if (this.thresholdComparator != null ? !this.thresholdComparator.equals(that.thresholdComparator) : that.thresholdComparator != null) return false;
                return this.thresholdPercentage != null ? this.thresholdPercentage.equals(that.thresholdPercentage) : that.thresholdPercentage == null;
            }

            @Override
            public int hashCode() {
                int result = this.proposalDurationInHours != null ? this.proposalDurationInHours.hashCode() : 0;
                result = 31 * result + (this.thresholdComparator != null ? this.thresholdComparator.hashCode() : 0);
                result = 31 * result + (this.thresholdPercentage != null ? this.thresholdPercentage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MemberConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.MemberConfigurationProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * `CfnMember.MemberConfigurationProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDescription();

        /**
         * `CfnMember.MemberConfigurationProperty.MemberFrameworkConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-memberframeworkconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getMemberFrameworkConfiguration();

        /**
         * @return a {@link Builder} of {@link MemberConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemberConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;
            private java.lang.String description;
            private java.lang.Object memberFrameworkConfiguration;

            /**
             * Sets the value of Name
             * @param name `CfnMember.MemberConfigurationProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of Description
             * @param description `CfnMember.MemberConfigurationProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of MemberFrameworkConfiguration
             * @param memberFrameworkConfiguration `CfnMember.MemberConfigurationProperty.MemberFrameworkConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder memberFrameworkConfiguration(software.amazon.awscdk.core.IResolvable memberFrameworkConfiguration) {
                this.memberFrameworkConfiguration = memberFrameworkConfiguration;
                return this;
            }

            /**
             * Sets the value of MemberFrameworkConfiguration
             * @param memberFrameworkConfiguration `CfnMember.MemberConfigurationProperty.MemberFrameworkConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder memberFrameworkConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.MemberFrameworkConfigurationProperty memberFrameworkConfiguration) {
                this.memberFrameworkConfiguration = memberFrameworkConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemberConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MemberConfigurationProperty build() {
                return new Jsii$Proxy(name, description, memberFrameworkConfiguration);
            }
        }

        /**
         * An implementation for {@link MemberConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemberConfigurationProperty {
            private final java.lang.String name;
            private final java.lang.String description;
            private final java.lang.Object memberFrameworkConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.description = this.jsiiGet("description", java.lang.String.class);
                this.memberFrameworkConfiguration = this.jsiiGet("memberFrameworkConfiguration", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String name, java.lang.String description, java.lang.Object memberFrameworkConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.description = description;
                this.memberFrameworkConfiguration = memberFrameworkConfiguration;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public java.lang.Object getMemberFrameworkConfiguration() {
                return this.memberFrameworkConfiguration;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("name", om.valueToTree(this.getName()));
                if (this.getDescription() != null) {
                    obj.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getMemberFrameworkConfiguration() != null) {
                    obj.set("memberFrameworkConfiguration", om.valueToTree(this.getMemberFrameworkConfiguration()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemberConfigurationProperty.Jsii$Proxy that = (MemberConfigurationProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.memberFrameworkConfiguration != null ? this.memberFrameworkConfiguration.equals(that.memberFrameworkConfiguration) : that.memberFrameworkConfiguration == null;
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.memberFrameworkConfiguration != null ? this.memberFrameworkConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MemberFabricConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.MemberFabricConfigurationProperty.AdminPassword`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html#cfn-managedblockchain-member-memberfabricconfiguration-adminpassword
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAdminPassword();

        /**
         * `CfnMember.MemberFabricConfigurationProperty.AdminUsername`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html#cfn-managedblockchain-member-memberfabricconfiguration-adminusername
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAdminUsername();

        /**
         * @return a {@link Builder} of {@link MemberFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemberFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String adminPassword;
            private java.lang.String adminUsername;

            /**
             * Sets the value of AdminPassword
             * @param adminPassword `CfnMember.MemberFabricConfigurationProperty.AdminPassword`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder adminPassword(java.lang.String adminPassword) {
                this.adminPassword = adminPassword;
                return this;
            }

            /**
             * Sets the value of AdminUsername
             * @param adminUsername `CfnMember.MemberFabricConfigurationProperty.AdminUsername`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder adminUsername(java.lang.String adminUsername) {
                this.adminUsername = adminUsername;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemberFabricConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MemberFabricConfigurationProperty build() {
                return new Jsii$Proxy(adminPassword, adminUsername);
            }
        }

        /**
         * An implementation for {@link MemberFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemberFabricConfigurationProperty {
            private final java.lang.String adminPassword;
            private final java.lang.String adminUsername;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.adminPassword = this.jsiiGet("adminPassword", java.lang.String.class);
                this.adminUsername = this.jsiiGet("adminUsername", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String adminPassword, java.lang.String adminUsername) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adminPassword = java.util.Objects.requireNonNull(adminPassword, "adminPassword is required");
                this.adminUsername = java.util.Objects.requireNonNull(adminUsername, "adminUsername is required");
            }

            @Override
            public java.lang.String getAdminPassword() {
                return this.adminPassword;
            }

            @Override
            public java.lang.String getAdminUsername() {
                return this.adminUsername;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("adminPassword", om.valueToTree(this.getAdminPassword()));
                obj.set("adminUsername", om.valueToTree(this.getAdminUsername()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemberFabricConfigurationProperty.Jsii$Proxy that = (MemberFabricConfigurationProperty.Jsii$Proxy) o;

                if (!adminPassword.equals(that.adminPassword)) return false;
                return this.adminUsername.equals(that.adminUsername);
            }

            @Override
            public int hashCode() {
                int result = this.adminPassword.hashCode();
                result = 31 * result + (this.adminUsername.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberframeworkconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MemberFrameworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.MemberFrameworkConfigurationProperty.MemberFabricConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberframeworkconfiguration.html#cfn-managedblockchain-member-memberframeworkconfiguration-memberfabricconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getMemberFabricConfiguration();

        /**
         * @return a {@link Builder} of {@link MemberFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemberFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object memberFabricConfiguration;

            /**
             * Sets the value of MemberFabricConfiguration
             * @param memberFabricConfiguration `CfnMember.MemberFrameworkConfigurationProperty.MemberFabricConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder memberFabricConfiguration(software.amazon.awscdk.core.IResolvable memberFabricConfiguration) {
                this.memberFabricConfiguration = memberFabricConfiguration;
                return this;
            }

            /**
             * Sets the value of MemberFabricConfiguration
             * @param memberFabricConfiguration `CfnMember.MemberFrameworkConfigurationProperty.MemberFabricConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder memberFabricConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.MemberFabricConfigurationProperty memberFabricConfiguration) {
                this.memberFabricConfiguration = memberFabricConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemberFrameworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MemberFrameworkConfigurationProperty build() {
                return new Jsii$Proxy(memberFabricConfiguration);
            }
        }

        /**
         * An implementation for {@link MemberFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemberFrameworkConfigurationProperty {
            private final java.lang.Object memberFabricConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.memberFabricConfiguration = this.jsiiGet("memberFabricConfiguration", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object memberFabricConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.memberFabricConfiguration = memberFabricConfiguration;
            }

            @Override
            public java.lang.Object getMemberFabricConfiguration() {
                return this.memberFabricConfiguration;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getMemberFabricConfiguration() != null) {
                    obj.set("memberFabricConfiguration", om.valueToTree(this.getMemberFabricConfiguration()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemberFrameworkConfigurationProperty.Jsii$Proxy that = (MemberFrameworkConfigurationProperty.Jsii$Proxy) o;

                return this.memberFabricConfiguration != null ? this.memberFabricConfiguration.equals(that.memberFabricConfiguration) : that.memberFabricConfiguration == null;
            }

            @Override
            public int hashCode() {
                int result = this.memberFabricConfiguration != null ? this.memberFabricConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.NetworkConfigurationProperty.Framework`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-framework
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getFramework();

        /**
         * `CfnMember.NetworkConfigurationProperty.FrameworkVersion`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-frameworkversion
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getFrameworkVersion();

        /**
         * `CfnMember.NetworkConfigurationProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * `CfnMember.NetworkConfigurationProperty.VotingPolicy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-votingpolicy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getVotingPolicy();

        /**
         * `CfnMember.NetworkConfigurationProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDescription();

        /**
         * `CfnMember.NetworkConfigurationProperty.NetworkFrameworkConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-networkframeworkconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getNetworkFrameworkConfiguration();

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String framework;
            private java.lang.String frameworkVersion;
            private java.lang.String name;
            private java.lang.Object votingPolicy;
            private java.lang.String description;
            private java.lang.Object networkFrameworkConfiguration;

            /**
             * Sets the value of Framework
             * @param framework `CfnMember.NetworkConfigurationProperty.Framework`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder framework(java.lang.String framework) {
                this.framework = framework;
                return this;
            }

            /**
             * Sets the value of FrameworkVersion
             * @param frameworkVersion `CfnMember.NetworkConfigurationProperty.FrameworkVersion`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder frameworkVersion(java.lang.String frameworkVersion) {
                this.frameworkVersion = frameworkVersion;
                return this;
            }

            /**
             * Sets the value of Name
             * @param name `CfnMember.NetworkConfigurationProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of VotingPolicy
             * @param votingPolicy `CfnMember.NetworkConfigurationProperty.VotingPolicy`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder votingPolicy(software.amazon.awscdk.core.IResolvable votingPolicy) {
                this.votingPolicy = votingPolicy;
                return this;
            }

            /**
             * Sets the value of VotingPolicy
             * @param votingPolicy `CfnMember.NetworkConfigurationProperty.VotingPolicy`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder votingPolicy(software.amazon.awscdk.services.managedblockchain.CfnMember.VotingPolicyProperty votingPolicy) {
                this.votingPolicy = votingPolicy;
                return this;
            }

            /**
             * Sets the value of Description
             * @param description `CfnMember.NetworkConfigurationProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of NetworkFrameworkConfiguration
             * @param networkFrameworkConfiguration `CfnMember.NetworkConfigurationProperty.NetworkFrameworkConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder networkFrameworkConfiguration(software.amazon.awscdk.core.IResolvable networkFrameworkConfiguration) {
                this.networkFrameworkConfiguration = networkFrameworkConfiguration;
                return this;
            }

            /**
             * Sets the value of NetworkFrameworkConfiguration
             * @param networkFrameworkConfiguration `CfnMember.NetworkConfigurationProperty.NetworkFrameworkConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder networkFrameworkConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkFrameworkConfigurationProperty networkFrameworkConfiguration) {
                this.networkFrameworkConfiguration = networkFrameworkConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(framework, frameworkVersion, name, votingPolicy, description, networkFrameworkConfiguration);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.lang.String framework;
            private final java.lang.String frameworkVersion;
            private final java.lang.String name;
            private final java.lang.Object votingPolicy;
            private final java.lang.String description;
            private final java.lang.Object networkFrameworkConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.framework = this.jsiiGet("framework", java.lang.String.class);
                this.frameworkVersion = this.jsiiGet("frameworkVersion", java.lang.String.class);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.votingPolicy = this.jsiiGet("votingPolicy", java.lang.Object.class);
                this.description = this.jsiiGet("description", java.lang.String.class);
                this.networkFrameworkConfiguration = this.jsiiGet("networkFrameworkConfiguration", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String framework, java.lang.String frameworkVersion, java.lang.String name, java.lang.Object votingPolicy, java.lang.String description, java.lang.Object networkFrameworkConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.framework = java.util.Objects.requireNonNull(framework, "framework is required");
                this.frameworkVersion = java.util.Objects.requireNonNull(frameworkVersion, "frameworkVersion is required");
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.votingPolicy = java.util.Objects.requireNonNull(votingPolicy, "votingPolicy is required");
                this.description = description;
                this.networkFrameworkConfiguration = networkFrameworkConfiguration;
            }

            @Override
            public java.lang.String getFramework() {
                return this.framework;
            }

            @Override
            public java.lang.String getFrameworkVersion() {
                return this.frameworkVersion;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.Object getVotingPolicy() {
                return this.votingPolicy;
            }

            @Override
            public java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public java.lang.Object getNetworkFrameworkConfiguration() {
                return this.networkFrameworkConfiguration;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("framework", om.valueToTree(this.getFramework()));
                obj.set("frameworkVersion", om.valueToTree(this.getFrameworkVersion()));
                obj.set("name", om.valueToTree(this.getName()));
                obj.set("votingPolicy", om.valueToTree(this.getVotingPolicy()));
                if (this.getDescription() != null) {
                    obj.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getNetworkFrameworkConfiguration() != null) {
                    obj.set("networkFrameworkConfiguration", om.valueToTree(this.getNetworkFrameworkConfiguration()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                if (!framework.equals(that.framework)) return false;
                if (!frameworkVersion.equals(that.frameworkVersion)) return false;
                if (!name.equals(that.name)) return false;
                if (!votingPolicy.equals(that.votingPolicy)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.networkFrameworkConfiguration != null ? this.networkFrameworkConfiguration.equals(that.networkFrameworkConfiguration) : that.networkFrameworkConfiguration == null;
            }

            @Override
            public int hashCode() {
                int result = this.framework.hashCode();
                result = 31 * result + (this.frameworkVersion.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.votingPolicy.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.networkFrameworkConfiguration != null ? this.networkFrameworkConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkfabricconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NetworkFabricConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.NetworkFabricConfigurationProperty.Edition`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkfabricconfiguration.html#cfn-managedblockchain-member-networkfabricconfiguration-edition
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getEdition();

        /**
         * @return a {@link Builder} of {@link NetworkFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String edition;

            /**
             * Sets the value of Edition
             * @param edition `CfnMember.NetworkFabricConfigurationProperty.Edition`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder edition(java.lang.String edition) {
                this.edition = edition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkFabricConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NetworkFabricConfigurationProperty build() {
                return new Jsii$Proxy(edition);
            }
        }

        /**
         * An implementation for {@link NetworkFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkFabricConfigurationProperty {
            private final java.lang.String edition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.edition = this.jsiiGet("edition", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String edition) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.edition = java.util.Objects.requireNonNull(edition, "edition is required");
            }

            @Override
            public java.lang.String getEdition() {
                return this.edition;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("edition", om.valueToTree(this.getEdition()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkFabricConfigurationProperty.Jsii$Proxy that = (NetworkFabricConfigurationProperty.Jsii$Proxy) o;

                return this.edition.equals(that.edition);
            }

            @Override
            public int hashCode() {
                int result = this.edition.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkframeworkconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NetworkFrameworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.NetworkFrameworkConfigurationProperty.NetworkFabricConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkframeworkconfiguration.html#cfn-managedblockchain-member-networkframeworkconfiguration-networkfabricconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getNetworkFabricConfiguration();

        /**
         * @return a {@link Builder} of {@link NetworkFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object networkFabricConfiguration;

            /**
             * Sets the value of NetworkFabricConfiguration
             * @param networkFabricConfiguration `CfnMember.NetworkFrameworkConfigurationProperty.NetworkFabricConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder networkFabricConfiguration(software.amazon.awscdk.core.IResolvable networkFabricConfiguration) {
                this.networkFabricConfiguration = networkFabricConfiguration;
                return this;
            }

            /**
             * Sets the value of NetworkFabricConfiguration
             * @param networkFabricConfiguration `CfnMember.NetworkFrameworkConfigurationProperty.NetworkFabricConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder networkFabricConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkFabricConfigurationProperty networkFabricConfiguration) {
                this.networkFabricConfiguration = networkFabricConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkFrameworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NetworkFrameworkConfigurationProperty build() {
                return new Jsii$Proxy(networkFabricConfiguration);
            }
        }

        /**
         * An implementation for {@link NetworkFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkFrameworkConfigurationProperty {
            private final java.lang.Object networkFabricConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.networkFabricConfiguration = this.jsiiGet("networkFabricConfiguration", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object networkFabricConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.networkFabricConfiguration = networkFabricConfiguration;
            }

            @Override
            public java.lang.Object getNetworkFabricConfiguration() {
                return this.networkFabricConfiguration;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getNetworkFabricConfiguration() != null) {
                    obj.set("networkFabricConfiguration", om.valueToTree(this.getNetworkFabricConfiguration()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkFrameworkConfigurationProperty.Jsii$Proxy that = (NetworkFrameworkConfigurationProperty.Jsii$Proxy) o;

                return this.networkFabricConfiguration != null ? this.networkFabricConfiguration.equals(that.networkFabricConfiguration) : that.networkFabricConfiguration == null;
            }

            @Override
            public int hashCode() {
                int result = this.networkFabricConfiguration != null ? this.networkFabricConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-votingpolicy.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface VotingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMember.VotingPolicyProperty.ApprovalThresholdPolicy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-votingpolicy.html#cfn-managedblockchain-member-votingpolicy-approvalthresholdpolicy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getApprovalThresholdPolicy();

        /**
         * @return a {@link Builder} of {@link VotingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VotingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object approvalThresholdPolicy;

            /**
             * Sets the value of ApprovalThresholdPolicy
             * @param approvalThresholdPolicy `CfnMember.VotingPolicyProperty.ApprovalThresholdPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder approvalThresholdPolicy(software.amazon.awscdk.core.IResolvable approvalThresholdPolicy) {
                this.approvalThresholdPolicy = approvalThresholdPolicy;
                return this;
            }

            /**
             * Sets the value of ApprovalThresholdPolicy
             * @param approvalThresholdPolicy `CfnMember.VotingPolicyProperty.ApprovalThresholdPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder approvalThresholdPolicy(software.amazon.awscdk.services.managedblockchain.CfnMember.ApprovalThresholdPolicyProperty approvalThresholdPolicy) {
                this.approvalThresholdPolicy = approvalThresholdPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VotingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public VotingPolicyProperty build() {
                return new Jsii$Proxy(approvalThresholdPolicy);
            }
        }

        /**
         * An implementation for {@link VotingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VotingPolicyProperty {
            private final java.lang.Object approvalThresholdPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.approvalThresholdPolicy = this.jsiiGet("approvalThresholdPolicy", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object approvalThresholdPolicy) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.approvalThresholdPolicy = approvalThresholdPolicy;
            }

            @Override
            public java.lang.Object getApprovalThresholdPolicy() {
                return this.approvalThresholdPolicy;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getApprovalThresholdPolicy() != null) {
                    obj.set("approvalThresholdPolicy", om.valueToTree(this.getApprovalThresholdPolicy()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VotingPolicyProperty.Jsii$Proxy that = (VotingPolicyProperty.Jsii$Proxy) o;

                return this.approvalThresholdPolicy != null ? this.approvalThresholdPolicy.equals(that.approvalThresholdPolicy) : that.approvalThresholdPolicy == null;
            }

            @Override
            public int hashCode() {
                int result = this.approvalThresholdPolicy != null ? this.approvalThresholdPolicy.hashCode() : 0;
                return result;
            }
        }
    }
}
