package software.amazon.awscdk.services.managedblockchain;

/**
 * Properties for defining a `CfnNode`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.managedblockchain.*;
 * CfnNodeProps cfnNodeProps = CfnNodeProps.builder()
 *         .networkId("networkId")
 *         .nodeConfiguration(NodeConfigurationProperty.builder()
 *                 .availabilityZone("availabilityZone")
 *                 .instanceType("instanceType")
 *                 .build())
 *         // the properties below are optional
 *         .memberId("memberId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:15.559Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnNodeProps")
@software.amazon.jsii.Jsii.Proxy(CfnNodeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNodeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier of the network for the node.
     * <p>
     * Ethereum public networks have the following <code>NetworkId</code> s:
     * <p>
     * <ul>
     * <li><code>n-ethereum-mainnet</code></li>
     * <li><code>n-ethereum-goerli</code></li>
     * <li><code>n-ethereum-rinkeby</code></li>
     * <li><code>n-ethereum-ropsten</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkId();

    /**
     * Configuration properties of a peer node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getNodeConfiguration();

    /**
     * The unique identifier of the member to which the node belongs.
     * <p>
     * Applies only to Hyperledger Fabric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMemberId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNodeProps> {
        java.lang.String networkId;
        java.lang.Object nodeConfiguration;
        java.lang.String memberId;

        /**
         * Sets the value of {@link CfnNodeProps#getNetworkId}
         * @param networkId The unique identifier of the network for the node. This parameter is required.
         *                  Ethereum public networks have the following <code>NetworkId</code> s:
         *                  <p>
         *                  <ul>
         *                  <li><code>n-ethereum-mainnet</code></li>
         *                  <li><code>n-ethereum-goerli</code></li>
         *                  <li><code>n-ethereum-rinkeby</code></li>
         *                  <li><code>n-ethereum-ropsten</code></li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkId(java.lang.String networkId) {
            this.networkId = networkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodeProps#getNodeConfiguration}
         * @param nodeConfiguration Configuration properties of a peer node. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeConfiguration(software.amazon.awscdk.core.IResolvable nodeConfiguration) {
            this.nodeConfiguration = nodeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodeProps#getNodeConfiguration}
         * @param nodeConfiguration Configuration properties of a peer node. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeConfiguration(software.amazon.awscdk.services.managedblockchain.CfnNode.NodeConfigurationProperty nodeConfiguration) {
            this.nodeConfiguration = nodeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodeProps#getMemberId}
         * @param memberId The unique identifier of the member to which the node belongs.
         *                 Applies only to Hyperledger Fabric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberId(java.lang.String memberId) {
            this.memberId = memberId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNodeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNodeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNodeProps {
        private final java.lang.String networkId;
        private final java.lang.Object nodeConfiguration;
        private final java.lang.String memberId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.networkId = software.amazon.jsii.Kernel.get(this, "networkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nodeConfiguration = software.amazon.jsii.Kernel.get(this, "nodeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.memberId = software.amazon.jsii.Kernel.get(this, "memberId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkId = java.util.Objects.requireNonNull(builder.networkId, "networkId is required");
            this.nodeConfiguration = java.util.Objects.requireNonNull(builder.nodeConfiguration, "nodeConfiguration is required");
            this.memberId = builder.memberId;
        }

        @Override
        public final java.lang.String getNetworkId() {
            return this.networkId;
        }

        @Override
        public final java.lang.Object getNodeConfiguration() {
            return this.nodeConfiguration;
        }

        @Override
        public final java.lang.String getMemberId() {
            return this.memberId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("networkId", om.valueToTree(this.getNetworkId()));
            data.set("nodeConfiguration", om.valueToTree(this.getNodeConfiguration()));
            if (this.getMemberId() != null) {
                data.set("memberId", om.valueToTree(this.getMemberId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-managedblockchain.CfnNodeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNodeProps.Jsii$Proxy that = (CfnNodeProps.Jsii$Proxy) o;

            if (!networkId.equals(that.networkId)) return false;
            if (!nodeConfiguration.equals(that.nodeConfiguration)) return false;
            return this.memberId != null ? this.memberId.equals(that.memberId) : that.memberId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.networkId.hashCode();
            result = 31 * result + (this.nodeConfiguration.hashCode());
            result = 31 * result + (this.memberId != null ? this.memberId.hashCode() : 0);
            return result;
        }
    }
}
