package software.amazon.awscdk.services.managedblockchain;

/**
 * A CloudFormation `AWS::ManagedBlockchain::Node`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:11:15.950Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnNode")
public class CfnNode extends software.amazon.awscdk.core.CfnResource {

    protected CfnNode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnNode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.managedblockchain.CfnNode.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::ManagedBlockchain::Node`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnNode(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.managedblockchain.CfnNodeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrMemberId() {
        return this.jsiiGet("attrMemberId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrNetworkId() {
        return this.jsiiGet("attrNetworkId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrNodeId() {
        return this.jsiiGet("attrNodeId", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::ManagedBlockchain::Node.MemberId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-memberid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getMemberId() {
        return this.jsiiGet("memberId", java.lang.String.class);
    }

    /**
     * `AWS::ManagedBlockchain::Node.MemberId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-memberid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMemberId(final java.lang.String value) {
        this.jsiiSet("memberId", java.util.Objects.requireNonNull(value, "memberId is required"));
    }

    /**
     * `AWS::ManagedBlockchain::Node.NetworkId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-networkid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getNetworkId() {
        return this.jsiiGet("networkId", java.lang.String.class);
    }

    /**
     * `AWS::ManagedBlockchain::Node.NetworkId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-networkid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNetworkId(final java.lang.String value) {
        this.jsiiSet("networkId", java.util.Objects.requireNonNull(value, "networkId is required"));
    }

    /**
     * `AWS::ManagedBlockchain::Node.NodeConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-nodeconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getNodeConfiguration() {
        return this.jsiiGet("nodeConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::ManagedBlockchain::Node.NodeConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-nodeconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNodeConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("nodeConfiguration", java.util.Objects.requireNonNull(value, "nodeConfiguration is required"));
    }

    /**
     * `AWS::ManagedBlockchain::Node.NodeConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-nodeconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNodeConfiguration(final software.amazon.awscdk.services.managedblockchain.CfnNode.NodeConfigurationProperty value) {
        this.jsiiSet("nodeConfiguration", java.util.Objects.requireNonNull(value, "nodeConfiguration is required"));
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-node-nodeconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnNode.NodeConfigurationProperty.AvailabilityZone`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-node-nodeconfiguration.html#cfn-managedblockchain-node-nodeconfiguration-availabilityzone
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAvailabilityZone();

        /**
         * `CfnNode.NodeConfigurationProperty.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-node-nodeconfiguration.html#cfn-managedblockchain-node-nodeconfiguration-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInstanceType();

        /**
         * @return a {@link Builder} of {@link NodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String availabilityZone;
            private java.lang.String instanceType;

            /**
             * Sets the value of AvailabilityZone
             * @param availabilityZone `CfnNode.NodeConfigurationProperty.AvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of InstanceType
             * @param instanceType `CfnNode.NodeConfigurationProperty.InstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NodeConfigurationProperty build() {
                return new Jsii$Proxy(availabilityZone, instanceType);
            }

        }

        /**
         * An implementation for {@link NodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeConfigurationProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.String instanceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.availabilityZone = this.jsiiGet("availabilityZone", java.lang.String.class);
                this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String availabilityZone, java.lang.String instanceType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = java.util.Objects.requireNonNull(availabilityZone, "availabilityZone is required");
                this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
            }

            @Override
            public java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeConfigurationProperty.Jsii$Proxy that = (NodeConfigurationProperty.Jsii$Proxy) o;

                if (!availabilityZone.equals(that.availabilityZone)) return false;
                return this.instanceType.equals(that.instanceType);
            }

            @Override
            public int hashCode() {
                int result = this.availabilityZone.hashCode();
                result = 31 * result + (this.instanceType.hashCode());
                return result;
            }

        }
    }
}
