package software.amazon.awscdk.services.mediaconnect;

/**
 * A CloudFormation `AWS::MediaConnect::Flow`.
 * <p>
 * The AWS::MediaConnect::Flow resource defines a connection between one or more video sources and one or more outputs. For each flow, you specify the transport protocol to use, encryption information, and details for any outputs or entitlements that you want. AWS Elemental MediaConnect returns an ingest endpoint where you can send your live video as a single unicast stream. The service replicates and distributes the video to every output that you specify, whether inside or outside the AWS Cloud. You can also set up entitlements on a flow to allow other AWS accounts to access your content.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnFlow cfnFlow = CfnFlow.Builder.create(this, "MyCfnFlow")
 *         .name("name")
 *         .source(SourceProperty.builder()
 *                 .decryption(EncryptionProperty.builder()
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .algorithm("algorithm")
 *                         .constantInitializationVector("constantInitializationVector")
 *                         .deviceId("deviceId")
 *                         .keyType("keyType")
 *                         .region("region")
 *                         .resourceId("resourceId")
 *                         .secretArn("secretArn")
 *                         .url("url")
 *                         .build())
 *                 .description("description")
 *                 .entitlementArn("entitlementArn")
 *                 .ingestIp("ingestIp")
 *                 .ingestPort(123)
 *                 .maxBitrate(123)
 *                 .maxLatency(123)
 *                 .minLatency(123)
 *                 .name("name")
 *                 .protocol("protocol")
 *                 .sourceArn("sourceArn")
 *                 .sourceIngestPort("sourceIngestPort")
 *                 .streamId("streamId")
 *                 .vpcInterfaceName("vpcInterfaceName")
 *                 .whitelistCidr("whitelistCidr")
 *                 .build())
 *         // the properties below are optional
 *         .availabilityZone("availabilityZone")
 *         .sourceFailoverConfig(FailoverConfigProperty.builder()
 *                 .recoveryWindow(123)
 *                 .state("state")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:36.965Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.mediaconnect.$Module.class, fqn = "@aws-cdk/aws-mediaconnect.CfnFlow")
public class CfnFlow extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnFlow(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlow(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediaconnect.CfnFlow.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::MediaConnect::Flow`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFlow(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediaconnect.CfnFlowProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFlowArn() {
        return software.amazon.jsii.Kernel.get(this, "attrFlowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone that the flow was created in.
     * <p>
     * These options are limited to the Availability Zones within the current AWS Region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFlowAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "attrFlowAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP address that the flow listens on for incoming content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSourceIngestIp() {
        return software.amazon.jsii.Kernel.get(this, "attrSourceIngestIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSourceSourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSourceSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port that the flow will be listening on for incoming content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSourceSourceIngestPort() {
        return software.amazon.jsii.Kernel.get(this, "attrSourceSourceIngestPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The settings for the source that you want to use for the new flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSource() {
        return software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for the source that you want to use for the new flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediaconnect.CfnFlow.SourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * The settings for the source that you want to use for the new flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * The Availability Zone that you want to create the flow in.
     * <p>
     * These options are limited to the Availability Zones within the current AWS Region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone that you want to create the flow in.
     * <p>
     * These options are limited to the Availability Zones within the current AWS Region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * The settings for source failover.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceFailoverConfig() {
        return software.amazon.jsii.Kernel.get(this, "sourceFailoverConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for source failover.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceFailoverConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceFailoverConfig", value);
    }

    /**
     * The settings for source failover.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceFailoverConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnFlow.FailoverConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceFailoverConfig", value);
    }
    /**
     * Information about the encryption of the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * EncryptionProperty encryptionProperty = EncryptionProperty.builder()
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .algorithm("algorithm")
     *         .constantInitializationVector("constantInitializationVector")
     *         .deviceId("deviceId")
     *         .keyType("keyType")
     *         .region("region")
     *         .resourceId("resourceId")
     *         .secretArn("secretArn")
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.mediaconnect.$Module.class, fqn = "@aws-cdk/aws-mediaconnect.CfnFlow.EncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the role that you created during setup (when you set up MediaConnect as a trusted entity).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlgorithm() {
            return null;
        }

        /**
         * A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content.
         * <p>
         * This parameter is not valid for static key encryption.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConstantInitializationVector() {
            return null;
        }

        /**
         * The value of one of the devices that you configured with your digital rights management (DRM) platform key provider.
         * <p>
         * This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceId() {
            return null;
        }

        /**
         * The type of key that is used for the encryption.
         * <p>
         * If you don't specify a <code>keyType</code> value, the service uses the default setting ( <code>static-key</code> ).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyType() {
            return null;
        }

        /**
         * The AWS Region that the API Gateway proxy endpoint was created in.
         * <p>
         * This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * An identifier for the content.
         * <p>
         * The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceId() {
            return null;
        }

        /**
         * The ARN of the secret that you created in AWS Secrets Manager to store the encryption key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * The URL from the API Gateway proxy that you set up to talk to your key server.
         * <p>
         * This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionProperty> {
            java.lang.String roleArn;
            java.lang.String algorithm;
            java.lang.String constantInitializationVector;
            java.lang.String deviceId;
            java.lang.String keyType;
            java.lang.String region;
            java.lang.String resourceId;
            java.lang.String secretArn;
            java.lang.String url;

            /**
             * Sets the value of {@link EncryptionProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the role that you created during setup (when you set up MediaConnect as a trusted entity). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getAlgorithm}
             * @param algorithm The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithm(java.lang.String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getConstantInitializationVector}
             * @param constantInitializationVector A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content.
             *                                     This parameter is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constantInitializationVector(java.lang.String constantInitializationVector) {
                this.constantInitializationVector = constantInitializationVector;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getDeviceId}
             * @param deviceId The value of one of the devices that you configured with your digital rights management (DRM) platform key provider.
             *                 This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceId(java.lang.String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getKeyType}
             * @param keyType The type of key that is used for the encryption.
             *                If you don't specify a <code>keyType</code> value, the service uses the default setting ( <code>static-key</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyType(java.lang.String keyType) {
                this.keyType = keyType;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getRegion}
             * @param region The AWS Region that the API Gateway proxy endpoint was created in.
             *               This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getResourceId}
             * @param resourceId An identifier for the content.
             *                   The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.lang.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getSecretArn}
             * @param secretArn The ARN of the secret that you created in AWS Secrets Manager to store the encryption key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getUrl}
             * @param url The URL from the API Gateway proxy that you set up to talk to your key server.
             *            This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionProperty {
            private final java.lang.String roleArn;
            private final java.lang.String algorithm;
            private final java.lang.String constantInitializationVector;
            private final java.lang.String deviceId;
            private final java.lang.String keyType;
            private final java.lang.String region;
            private final java.lang.String resourceId;
            private final java.lang.String secretArn;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.algorithm = software.amazon.jsii.Kernel.get(this, "algorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.constantInitializationVector = software.amazon.jsii.Kernel.get(this, "constantInitializationVector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deviceId = software.amazon.jsii.Kernel.get(this, "deviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyType = software.amazon.jsii.Kernel.get(this, "keyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.algorithm = builder.algorithm;
                this.constantInitializationVector = builder.constantInitializationVector;
                this.deviceId = builder.deviceId;
                this.keyType = builder.keyType;
                this.region = builder.region;
                this.resourceId = builder.resourceId;
                this.secretArn = builder.secretArn;
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public final java.lang.String getConstantInitializationVector() {
                return this.constantInitializationVector;
            }

            @Override
            public final java.lang.String getDeviceId() {
                return this.deviceId;
            }

            @Override
            public final java.lang.String getKeyType() {
                return this.keyType;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getAlgorithm() != null) {
                    data.set("algorithm", om.valueToTree(this.getAlgorithm()));
                }
                if (this.getConstantInitializationVector() != null) {
                    data.set("constantInitializationVector", om.valueToTree(this.getConstantInitializationVector()));
                }
                if (this.getDeviceId() != null) {
                    data.set("deviceId", om.valueToTree(this.getDeviceId()));
                }
                if (this.getKeyType() != null) {
                    data.set("keyType", om.valueToTree(this.getKeyType()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }
                if (this.getResourceId() != null) {
                    data.set("resourceId", om.valueToTree(this.getResourceId()));
                }
                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-mediaconnect.CfnFlow.EncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionProperty.Jsii$Proxy that = (EncryptionProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (this.algorithm != null ? !this.algorithm.equals(that.algorithm) : that.algorithm != null) return false;
                if (this.constantInitializationVector != null ? !this.constantInitializationVector.equals(that.constantInitializationVector) : that.constantInitializationVector != null) return false;
                if (this.deviceId != null ? !this.deviceId.equals(that.deviceId) : that.deviceId != null) return false;
                if (this.keyType != null ? !this.keyType.equals(that.keyType) : that.keyType != null) return false;
                if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
                if (this.resourceId != null ? !this.resourceId.equals(that.resourceId) : that.resourceId != null) return false;
                if (this.secretArn != null ? !this.secretArn.equals(that.secretArn) : that.secretArn != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
                result = 31 * result + (this.constantInitializationVector != null ? this.constantInitializationVector.hashCode() : 0);
                result = 31 * result + (this.deviceId != null ? this.deviceId.hashCode() : 0);
                result = 31 * result + (this.keyType != null ? this.keyType.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
                result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for source failover.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * FailoverConfigProperty failoverConfigProperty = FailoverConfigProperty.builder()
     *         .recoveryWindow(123)
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.mediaconnect.$Module.class, fqn = "@aws-cdk/aws-mediaconnect.CfnFlow.FailoverConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FailoverConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FailoverConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The size of the buffer (delay) that the service maintains.
         * <p>
         * A larger buffer means a longer delay in transmitting the stream, but more room for error correction. A smaller buffer means a shorter delay, but less room for error correction.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRecoveryWindow() {
            return null;
        }

        /**
         * The state of source failover on the flow.
         * <p>
         * If the state is disabled, the flow can have only one source. If the state is enabled, the flow can have one or two sources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FailoverConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FailoverConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FailoverConfigProperty> {
            java.lang.Number recoveryWindow;
            java.lang.String state;

            /**
             * Sets the value of {@link FailoverConfigProperty#getRecoveryWindow}
             * @param recoveryWindow The size of the buffer (delay) that the service maintains.
             *                       A larger buffer means a longer delay in transmitting the stream, but more room for error correction. A smaller buffer means a shorter delay, but less room for error correction.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recoveryWindow(java.lang.Number recoveryWindow) {
                this.recoveryWindow = recoveryWindow;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConfigProperty#getState}
             * @param state The state of source failover on the flow.
             *              If the state is disabled, the flow can have only one source. If the state is enabled, the flow can have one or two sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FailoverConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FailoverConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FailoverConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FailoverConfigProperty {
            private final java.lang.Number recoveryWindow;
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recoveryWindow = software.amazon.jsii.Kernel.get(this, "recoveryWindow", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recoveryWindow = builder.recoveryWindow;
                this.state = builder.state;
            }

            @Override
            public final java.lang.Number getRecoveryWindow() {
                return this.recoveryWindow;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRecoveryWindow() != null) {
                    data.set("recoveryWindow", om.valueToTree(this.getRecoveryWindow()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-mediaconnect.CfnFlow.FailoverConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FailoverConfigProperty.Jsii$Proxy that = (FailoverConfigProperty.Jsii$Proxy) o;

                if (this.recoveryWindow != null ? !this.recoveryWindow.equals(that.recoveryWindow) : that.recoveryWindow != null) return false;
                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recoveryWindow != null ? this.recoveryWindow.hashCode() : 0;
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details of the sources of the flow.
     * <p>
     * If you are creating a flow with a VPC source, you must first create the flow with a temporary standard source by doing the following:
     * <p>
     * <ul>
     * <li>Use CloudFormation to create a flow with a standard source that uses the flow’s public IP address.</li>
     * <li>Use CloudFormation to create the VPC interface to add to this flow. This can also be done as part of the previous step.</li>
     * <li>After CloudFormation has created the flow and the VPC interface, update the source to point to the VPC interface that you created.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SourceProperty sourceProperty = SourceProperty.builder()
     *         .decryption(EncryptionProperty.builder()
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .algorithm("algorithm")
     *                 .constantInitializationVector("constantInitializationVector")
     *                 .deviceId("deviceId")
     *                 .keyType("keyType")
     *                 .region("region")
     *                 .resourceId("resourceId")
     *                 .secretArn("secretArn")
     *                 .url("url")
     *                 .build())
     *         .description("description")
     *         .entitlementArn("entitlementArn")
     *         .ingestIp("ingestIp")
     *         .ingestPort(123)
     *         .maxBitrate(123)
     *         .maxLatency(123)
     *         .minLatency(123)
     *         .name("name")
     *         .protocol("protocol")
     *         .sourceArn("sourceArn")
     *         .sourceIngestPort("sourceIngestPort")
     *         .streamId("streamId")
     *         .vpcInterfaceName("vpcInterfaceName")
     *         .whitelistCidr("whitelistCidr")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.mediaconnect.$Module.class, fqn = "@aws-cdk/aws-mediaconnect.CfnFlow.SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of encryption that is used on the content ingested from the source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecryption() {
            return null;
        }

        /**
         * A description of the source.
         * <p>
         * This description is not visible outside of the current AWS account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account.
         * <p>
         * The entitlement is set by the content originator and the ARN is generated as part of the originator’s flow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntitlementArn() {
            return null;
        }

        /**
         * The IP address that the flow listens on for incoming content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIngestIp() {
            return null;
        }

        /**
         * The port that the flow listens on for incoming content.
         * <p>
         * If the protocol of the source is Zixi, the port must be set to 2088.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIngestPort() {
            return null;
        }

        /**
         * The maximum bitrate for RIST, RTP, and RTP-FEC streams.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBitrate() {
            return null;
        }

        /**
         * The maximum latency in milliseconds for a RIST or Zixi-based source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxLatency() {
            return null;
        }

        /**
         * The minimum latency in milliseconds for SRT-based streams.
         * <p>
         * In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinLatency() {
            return null;
        }

        /**
         * The name of the source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The protocol that is used by the source.
         * <p>
         * For a full list of available protocols, see: <a href="https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-source.html#v1-flows-flowarn-source-prop-setsourcerequest-protocol">Source protocols</a> in the <em>AWS Elemental MediaConnect API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * The ARN of the source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceArn() {
            return null;
        }

        /**
         * The port that the flow will be listening on for incoming content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceIngestPort() {
            return null;
        }

        /**
         * The stream ID that you want to use for the transport.
         * <p>
         * This parameter applies only to Zixi-based streams.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamId() {
            return null;
        }

        /**
         * The name of the VPC interface that the source content comes from.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcInterfaceName() {
            return null;
        }

        /**
         * The range of IP addresses that are allowed to contribute content to your source.
         * <p>
         * Format the IP addresses as a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWhitelistCidr() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceProperty> {
            java.lang.Object decryption;
            java.lang.String description;
            java.lang.String entitlementArn;
            java.lang.String ingestIp;
            java.lang.Number ingestPort;
            java.lang.Number maxBitrate;
            java.lang.Number maxLatency;
            java.lang.Number minLatency;
            java.lang.String name;
            java.lang.String protocol;
            java.lang.String sourceArn;
            java.lang.String sourceIngestPort;
            java.lang.String streamId;
            java.lang.String vpcInterfaceName;
            java.lang.String whitelistCidr;

            /**
             * Sets the value of {@link SourceProperty#getDecryption}
             * @param decryption The type of encryption that is used on the content ingested from the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decryption(software.amazon.awscdk.core.IResolvable decryption) {
                this.decryption = decryption;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getDecryption}
             * @param decryption The type of encryption that is used on the content ingested from the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decryption(software.amazon.awscdk.services.mediaconnect.CfnFlow.EncryptionProperty decryption) {
                this.decryption = decryption;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getDescription}
             * @param description A description of the source.
             *                    This description is not visible outside of the current AWS account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getEntitlementArn}
             * @param entitlementArn The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account.
             *                       The entitlement is set by the content originator and the ARN is generated as part of the originator’s flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entitlementArn(java.lang.String entitlementArn) {
                this.entitlementArn = entitlementArn;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getIngestIp}
             * @param ingestIp The IP address that the flow listens on for incoming content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingestIp(java.lang.String ingestIp) {
                this.ingestIp = ingestIp;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getIngestPort}
             * @param ingestPort The port that the flow listens on for incoming content.
             *                   If the protocol of the source is Zixi, the port must be set to 2088.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingestPort(java.lang.Number ingestPort) {
                this.ingestPort = ingestPort;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getMaxBitrate}
             * @param maxBitrate The maximum bitrate for RIST, RTP, and RTP-FEC streams.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxBitrate(java.lang.Number maxBitrate) {
                this.maxBitrate = maxBitrate;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getMaxLatency}
             * @param maxLatency The maximum latency in milliseconds for a RIST or Zixi-based source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxLatency(java.lang.Number maxLatency) {
                this.maxLatency = maxLatency;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getMinLatency}
             * @param minLatency The minimum latency in milliseconds for SRT-based streams.
             *                   In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minLatency(java.lang.Number minLatency) {
                this.minLatency = minLatency;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getName}
             * @param name The name of the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getProtocol}
             * @param protocol The protocol that is used by the source.
             *                 For a full list of available protocols, see: <a href="https://docs.aws.amazon.com/mediaconnect/latest/api/v1-flows-flowarn-source.html#v1-flows-flowarn-source-prop-setsourcerequest-protocol">Source protocols</a> in the <em>AWS Elemental MediaConnect API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceArn}
             * @param sourceArn The ARN of the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceArn(java.lang.String sourceArn) {
                this.sourceArn = sourceArn;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceIngestPort}
             * @param sourceIngestPort The port that the flow will be listening on for incoming content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceIngestPort(java.lang.String sourceIngestPort) {
                this.sourceIngestPort = sourceIngestPort;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getStreamId}
             * @param streamId The stream ID that you want to use for the transport.
             *                 This parameter applies only to Zixi-based streams.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamId(java.lang.String streamId) {
                this.streamId = streamId;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getVpcInterfaceName}
             * @param vpcInterfaceName The name of the VPC interface that the source content comes from.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcInterfaceName(java.lang.String vpcInterfaceName) {
                this.vpcInterfaceName = vpcInterfaceName;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getWhitelistCidr}
             * @param whitelistCidr The range of IP addresses that are allowed to contribute content to your source.
             *                      Format the IP addresses as a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder whitelistCidr(java.lang.String whitelistCidr) {
                this.whitelistCidr = whitelistCidr;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceProperty {
            private final java.lang.Object decryption;
            private final java.lang.String description;
            private final java.lang.String entitlementArn;
            private final java.lang.String ingestIp;
            private final java.lang.Number ingestPort;
            private final java.lang.Number maxBitrate;
            private final java.lang.Number maxLatency;
            private final java.lang.Number minLatency;
            private final java.lang.String name;
            private final java.lang.String protocol;
            private final java.lang.String sourceArn;
            private final java.lang.String sourceIngestPort;
            private final java.lang.String streamId;
            private final java.lang.String vpcInterfaceName;
            private final java.lang.String whitelistCidr;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.decryption = software.amazon.jsii.Kernel.get(this, "decryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.entitlementArn = software.amazon.jsii.Kernel.get(this, "entitlementArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ingestIp = software.amazon.jsii.Kernel.get(this, "ingestIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ingestPort = software.amazon.jsii.Kernel.get(this, "ingestPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxBitrate = software.amazon.jsii.Kernel.get(this, "maxBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxLatency = software.amazon.jsii.Kernel.get(this, "maxLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minLatency = software.amazon.jsii.Kernel.get(this, "minLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceArn = software.amazon.jsii.Kernel.get(this, "sourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceIngestPort = software.amazon.jsii.Kernel.get(this, "sourceIngestPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.streamId = software.amazon.jsii.Kernel.get(this, "streamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcInterfaceName = software.amazon.jsii.Kernel.get(this, "vpcInterfaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.whitelistCidr = software.amazon.jsii.Kernel.get(this, "whitelistCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.decryption = builder.decryption;
                this.description = builder.description;
                this.entitlementArn = builder.entitlementArn;
                this.ingestIp = builder.ingestIp;
                this.ingestPort = builder.ingestPort;
                this.maxBitrate = builder.maxBitrate;
                this.maxLatency = builder.maxLatency;
                this.minLatency = builder.minLatency;
                this.name = builder.name;
                this.protocol = builder.protocol;
                this.sourceArn = builder.sourceArn;
                this.sourceIngestPort = builder.sourceIngestPort;
                this.streamId = builder.streamId;
                this.vpcInterfaceName = builder.vpcInterfaceName;
                this.whitelistCidr = builder.whitelistCidr;
            }

            @Override
            public final java.lang.Object getDecryption() {
                return this.decryption;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getEntitlementArn() {
                return this.entitlementArn;
            }

            @Override
            public final java.lang.String getIngestIp() {
                return this.ingestIp;
            }

            @Override
            public final java.lang.Number getIngestPort() {
                return this.ingestPort;
            }

            @Override
            public final java.lang.Number getMaxBitrate() {
                return this.maxBitrate;
            }

            @Override
            public final java.lang.Number getMaxLatency() {
                return this.maxLatency;
            }

            @Override
            public final java.lang.Number getMinLatency() {
                return this.minLatency;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.String getSourceArn() {
                return this.sourceArn;
            }

            @Override
            public final java.lang.String getSourceIngestPort() {
                return this.sourceIngestPort;
            }

            @Override
            public final java.lang.String getStreamId() {
                return this.streamId;
            }

            @Override
            public final java.lang.String getVpcInterfaceName() {
                return this.vpcInterfaceName;
            }

            @Override
            public final java.lang.String getWhitelistCidr() {
                return this.whitelistCidr;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDecryption() != null) {
                    data.set("decryption", om.valueToTree(this.getDecryption()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getEntitlementArn() != null) {
                    data.set("entitlementArn", om.valueToTree(this.getEntitlementArn()));
                }
                if (this.getIngestIp() != null) {
                    data.set("ingestIp", om.valueToTree(this.getIngestIp()));
                }
                if (this.getIngestPort() != null) {
                    data.set("ingestPort", om.valueToTree(this.getIngestPort()));
                }
                if (this.getMaxBitrate() != null) {
                    data.set("maxBitrate", om.valueToTree(this.getMaxBitrate()));
                }
                if (this.getMaxLatency() != null) {
                    data.set("maxLatency", om.valueToTree(this.getMaxLatency()));
                }
                if (this.getMinLatency() != null) {
                    data.set("minLatency", om.valueToTree(this.getMinLatency()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getSourceArn() != null) {
                    data.set("sourceArn", om.valueToTree(this.getSourceArn()));
                }
                if (this.getSourceIngestPort() != null) {
                    data.set("sourceIngestPort", om.valueToTree(this.getSourceIngestPort()));
                }
                if (this.getStreamId() != null) {
                    data.set("streamId", om.valueToTree(this.getStreamId()));
                }
                if (this.getVpcInterfaceName() != null) {
                    data.set("vpcInterfaceName", om.valueToTree(this.getVpcInterfaceName()));
                }
                if (this.getWhitelistCidr() != null) {
                    data.set("whitelistCidr", om.valueToTree(this.getWhitelistCidr()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-mediaconnect.CfnFlow.SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceProperty.Jsii$Proxy that = (SourceProperty.Jsii$Proxy) o;

                if (this.decryption != null ? !this.decryption.equals(that.decryption) : that.decryption != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.entitlementArn != null ? !this.entitlementArn.equals(that.entitlementArn) : that.entitlementArn != null) return false;
                if (this.ingestIp != null ? !this.ingestIp.equals(that.ingestIp) : that.ingestIp != null) return false;
                if (this.ingestPort != null ? !this.ingestPort.equals(that.ingestPort) : that.ingestPort != null) return false;
                if (this.maxBitrate != null ? !this.maxBitrate.equals(that.maxBitrate) : that.maxBitrate != null) return false;
                if (this.maxLatency != null ? !this.maxLatency.equals(that.maxLatency) : that.maxLatency != null) return false;
                if (this.minLatency != null ? !this.minLatency.equals(that.minLatency) : that.minLatency != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                if (this.sourceArn != null ? !this.sourceArn.equals(that.sourceArn) : that.sourceArn != null) return false;
                if (this.sourceIngestPort != null ? !this.sourceIngestPort.equals(that.sourceIngestPort) : that.sourceIngestPort != null) return false;
                if (this.streamId != null ? !this.streamId.equals(that.streamId) : that.streamId != null) return false;
                if (this.vpcInterfaceName != null ? !this.vpcInterfaceName.equals(that.vpcInterfaceName) : that.vpcInterfaceName != null) return false;
                return this.whitelistCidr != null ? this.whitelistCidr.equals(that.whitelistCidr) : that.whitelistCidr == null;
            }

            @Override
            public final int hashCode() {
                int result = this.decryption != null ? this.decryption.hashCode() : 0;
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.entitlementArn != null ? this.entitlementArn.hashCode() : 0);
                result = 31 * result + (this.ingestIp != null ? this.ingestIp.hashCode() : 0);
                result = 31 * result + (this.ingestPort != null ? this.ingestPort.hashCode() : 0);
                result = 31 * result + (this.maxBitrate != null ? this.maxBitrate.hashCode() : 0);
                result = 31 * result + (this.maxLatency != null ? this.maxLatency.hashCode() : 0);
                result = 31 * result + (this.minLatency != null ? this.minLatency.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.sourceArn != null ? this.sourceArn.hashCode() : 0);
                result = 31 * result + (this.sourceIngestPort != null ? this.sourceIngestPort.hashCode() : 0);
                result = 31 * result + (this.streamId != null ? this.streamId.hashCode() : 0);
                result = 31 * result + (this.vpcInterfaceName != null ? this.vpcInterfaceName.hashCode() : 0);
                result = 31 * result + (this.whitelistCidr != null ? this.whitelistCidr.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediaconnect.CfnFlow}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediaconnect.CfnFlow> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediaconnect.CfnFlowProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediaconnect.CfnFlowProps.Builder();
        }

        /**
         * The name of the flow.
         * <p>
         * @return {@code this}
         * @param name The name of the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The settings for the source that you want to use for the new flow.
         * <p>
         * @return {@code this}
         * @param source The settings for the source that you want to use for the new flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.services.mediaconnect.CfnFlow.SourceProperty source) {
            this.props.source(source);
            return this;
        }
        /**
         * The settings for the source that you want to use for the new flow.
         * <p>
         * @return {@code this}
         * @param source The settings for the source that you want to use for the new flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.core.IResolvable source) {
            this.props.source(source);
            return this;
        }

        /**
         * The Availability Zone that you want to create the flow in.
         * <p>
         * These options are limited to the Availability Zones within the current AWS Region.
         * <p>
         * @return {@code this}
         * @param availabilityZone The Availability Zone that you want to create the flow in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The settings for source failover.
         * <p>
         * @return {@code this}
         * @param sourceFailoverConfig The settings for source failover. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFailoverConfig(final software.amazon.awscdk.core.IResolvable sourceFailoverConfig) {
            this.props.sourceFailoverConfig(sourceFailoverConfig);
            return this;
        }
        /**
         * The settings for source failover.
         * <p>
         * @return {@code this}
         * @param sourceFailoverConfig The settings for source failover. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFailoverConfig(final software.amazon.awscdk.services.mediaconnect.CfnFlow.FailoverConfigProperty sourceFailoverConfig) {
            this.props.sourceFailoverConfig(sourceFailoverConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.mediaconnect.CfnFlow}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediaconnect.CfnFlow build() {
            return new software.amazon.awscdk.services.mediaconnect.CfnFlow(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
