/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.mediaconnect;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.mediaconnect.$Module;
import software.amazon.awscdk.services.mediaconnect.CfnFlowOutput;
import software.amazon.awscdk.services.mediaconnect.CfnFlowOutputProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-mediaconnect.CfnFlowOutput")
public class CfnFlowOutput
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFlowOutput.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFlowOutput(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlowOutput(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFlowOutput(@NotNull Construct scope, @NotNull String id, @NotNull CfnFlowOutputProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrOutputArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrOutputArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getFlowArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"flowArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setFlowArn(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"flowArn", (Object)Objects.requireNonNull(value, "flowArn is required"));
    }

    @NotNull
    public String getProtocol() {
        return (String)Kernel.get((Object)((Object)this), (String)"protocol", (NativeType)NativeType.forClass(String.class));
    }

    public void setProtocol(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"protocol", (Object)Objects.requireNonNull(value, "protocol is required"));
    }

    @Nullable
    public List<String> getCidrAllowList() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"cidrAllowList", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setCidrAllowList(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"cidrAllowList", value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)((Object)this), (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"description", (Object)value);
    }

    @Nullable
    public String getDestination() {
        return (String)Kernel.get((Object)((Object)this), (String)"destination", (NativeType)NativeType.forClass(String.class));
    }

    public void setDestination(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"destination", (Object)value);
    }

    @Nullable
    public Object getEncryption() {
        return Kernel.get((Object)((Object)this), (String)"encryption", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEncryption(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"encryption", (Object)value);
    }

    public void setEncryption(@Nullable EncryptionProperty value) {
        Kernel.set((Object)((Object)this), (String)"encryption", (Object)value);
    }

    @Nullable
    public Number getMaxLatency() {
        return (Number)Kernel.get((Object)((Object)this), (String)"maxLatency", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxLatency(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"maxLatency", (Object)value);
    }

    @Nullable
    public Number getMinLatency() {
        return (Number)Kernel.get((Object)((Object)this), (String)"minLatency", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMinLatency(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"minLatency", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"name", (Object)value);
    }

    @Nullable
    public Number getPort() {
        return (Number)Kernel.get((Object)((Object)this), (String)"port", (NativeType)NativeType.forClass(Number.class));
    }

    public void setPort(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"port", (Object)value);
    }

    @Nullable
    public String getRemoteId() {
        return (String)Kernel.get((Object)((Object)this), (String)"remoteId", (NativeType)NativeType.forClass(String.class));
    }

    public void setRemoteId(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"remoteId", (Object)value);
    }

    @Nullable
    public Number getSmoothingLatency() {
        return (Number)Kernel.get((Object)((Object)this), (String)"smoothingLatency", (NativeType)NativeType.forClass(Number.class));
    }

    public void setSmoothingLatency(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"smoothingLatency", (Object)value);
    }

    @Nullable
    public String getStreamId() {
        return (String)Kernel.get((Object)((Object)this), (String)"streamId", (NativeType)NativeType.forClass(String.class));
    }

    public void setStreamId(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"streamId", (Object)value);
    }

    @Nullable
    public Object getVpcInterfaceAttachment() {
        return Kernel.get((Object)((Object)this), (String)"vpcInterfaceAttachment", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVpcInterfaceAttachment(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"vpcInterfaceAttachment", (Object)value);
    }

    public void setVpcInterfaceAttachment(@Nullable VpcInterfaceAttachmentProperty value) {
        Kernel.set((Object)((Object)this), (String)"vpcInterfaceAttachment", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFlowOutput> {
        private final Construct scope;
        private final String id;
        private final CfnFlowOutputProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFlowOutputProps.Builder();
        }

        public Builder flowArn(String flowArn) {
            this.props.flowArn(flowArn);
            return this;
        }

        public Builder protocol(String protocol) {
            this.props.protocol(protocol);
            return this;
        }

        public Builder cidrAllowList(List<String> cidrAllowList) {
            this.props.cidrAllowList(cidrAllowList);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder destination(String destination) {
            this.props.destination(destination);
            return this;
        }

        public Builder encryption(IResolvable encryption) {
            this.props.encryption(encryption);
            return this;
        }

        public Builder encryption(EncryptionProperty encryption) {
            this.props.encryption(encryption);
            return this;
        }

        public Builder maxLatency(Number maxLatency) {
            this.props.maxLatency(maxLatency);
            return this;
        }

        public Builder minLatency(Number minLatency) {
            this.props.minLatency(minLatency);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.props.remoteId(remoteId);
            return this;
        }

        public Builder smoothingLatency(Number smoothingLatency) {
            this.props.smoothingLatency(smoothingLatency);
            return this;
        }

        public Builder streamId(String streamId) {
            this.props.streamId(streamId);
            return this;
        }

        public Builder vpcInterfaceAttachment(IResolvable vpcInterfaceAttachment) {
            this.props.vpcInterfaceAttachment(vpcInterfaceAttachment);
            return this;
        }

        public Builder vpcInterfaceAttachment(VpcInterfaceAttachmentProperty vpcInterfaceAttachment) {
            this.props.vpcInterfaceAttachment(vpcInterfaceAttachment);
            return this;
        }

        public CfnFlowOutput build() {
            return new CfnFlowOutput(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-mediaconnect.CfnFlowOutput.VpcInterfaceAttachmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcInterfaceAttachmentProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVpcInterfaceName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcInterfaceAttachmentProperty> {
            String vpcInterfaceName;

            public Builder vpcInterfaceName(String vpcInterfaceName) {
                this.vpcInterfaceName = vpcInterfaceName;
                return this;
            }

            public VpcInterfaceAttachmentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-mediaconnect.CfnFlowOutput.EncryptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @NotNull
        public String getSecretArn();

        @Nullable
        default public String getAlgorithm() {
            return null;
        }

        @Nullable
        default public String getKeyType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionProperty> {
            String roleArn;
            String secretArn;
            String algorithm;
            String keyType;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder algorithm(String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            public Builder keyType(String keyType) {
                this.keyType = keyType;
                return this;
            }

            public EncryptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

