/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.medialive;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.medialive.$Module;
import software.amazon.awscdk.services.medialive.CfnChannel;
import software.amazon.awscdk.services.medialive.CfnChannelProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel")
public class CfnChannel
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnChannel.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnChannel(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnChannel(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnChannel(@NotNull Construct scope, @NotNull String id, @Nullable CfnChannelProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnChannel(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getAttrInputs() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"attrInputs", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @Nullable
    public Object getCdiInputSpecification() {
        return Kernel.get((Object)((Object)this), (String)"cdiInputSpecification", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCdiInputSpecification(@Nullable CdiInputSpecificationProperty value) {
        Kernel.set((Object)((Object)this), (String)"cdiInputSpecification", (Object)value);
    }

    public void setCdiInputSpecification(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"cdiInputSpecification", (Object)value);
    }

    @Nullable
    public String getChannelClass() {
        return (String)Kernel.get((Object)((Object)this), (String)"channelClass", (NativeType)NativeType.forClass(String.class));
    }

    public void setChannelClass(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"channelClass", (Object)value);
    }

    @Nullable
    public Object getDestinations() {
        return Kernel.get((Object)((Object)this), (String)"destinations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDestinations(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"destinations", (Object)value);
    }

    public void setDestinations(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"destinations", value);
    }

    @Nullable
    public Object getEncoderSettings() {
        return Kernel.get((Object)((Object)this), (String)"encoderSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEncoderSettings(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"encoderSettings", (Object)value);
    }

    public void setEncoderSettings(@Nullable EncoderSettingsProperty value) {
        Kernel.set((Object)((Object)this), (String)"encoderSettings", (Object)value);
    }

    @Nullable
    public Object getInputAttachments() {
        return Kernel.get((Object)((Object)this), (String)"inputAttachments", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInputAttachments(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"inputAttachments", (Object)value);
    }

    public void setInputAttachments(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"inputAttachments", value);
    }

    @Nullable
    public Object getInputSpecification() {
        return Kernel.get((Object)((Object)this), (String)"inputSpecification", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInputSpecification(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"inputSpecification", (Object)value);
    }

    public void setInputSpecification(@Nullable InputSpecificationProperty value) {
        Kernel.set((Object)((Object)this), (String)"inputSpecification", (Object)value);
    }

    @Nullable
    public String getLogLevel() {
        return (String)Kernel.get((Object)((Object)this), (String)"logLevel", (NativeType)NativeType.forClass(String.class));
    }

    public void setLogLevel(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"logLevel", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"name", (Object)value);
    }

    @Nullable
    public String getRoleArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"roleArn", (Object)value);
    }

    @Nullable
    public Object getVpc() {
        return Kernel.get((Object)((Object)this), (String)"vpc", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVpc(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"vpc", (Object)value);
    }

    public void setVpc(@Nullable VpcOutputSettingsProperty value) {
        Kernel.set((Object)((Object)this), (String)"vpc", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnChannel> {
        private final Construct scope;
        private final String id;
        private CfnChannelProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder cdiInputSpecification(CdiInputSpecificationProperty cdiInputSpecification) {
            this.props().cdiInputSpecification(cdiInputSpecification);
            return this;
        }

        public Builder cdiInputSpecification(IResolvable cdiInputSpecification) {
            this.props().cdiInputSpecification(cdiInputSpecification);
            return this;
        }

        public Builder channelClass(String channelClass) {
            this.props().channelClass(channelClass);
            return this;
        }

        public Builder destinations(IResolvable destinations) {
            this.props().destinations(destinations);
            return this;
        }

        public Builder destinations(List<? extends Object> destinations) {
            this.props().destinations(destinations);
            return this;
        }

        public Builder encoderSettings(IResolvable encoderSettings) {
            this.props().encoderSettings(encoderSettings);
            return this;
        }

        public Builder encoderSettings(EncoderSettingsProperty encoderSettings) {
            this.props().encoderSettings(encoderSettings);
            return this;
        }

        public Builder inputAttachments(IResolvable inputAttachments) {
            this.props().inputAttachments(inputAttachments);
            return this;
        }

        public Builder inputAttachments(List<? extends Object> inputAttachments) {
            this.props().inputAttachments(inputAttachments);
            return this;
        }

        public Builder inputSpecification(IResolvable inputSpecification) {
            this.props().inputSpecification(inputSpecification);
            return this;
        }

        public Builder inputSpecification(InputSpecificationProperty inputSpecification) {
            this.props().inputSpecification(inputSpecification);
            return this;
        }

        public Builder logLevel(String logLevel) {
            this.props().logLevel(logLevel);
            return this;
        }

        public Builder name(String name) {
            this.props().name(name);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props().roleArn(roleArn);
            return this;
        }

        public Builder tags(Object tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder vpc(IResolvable vpc) {
            this.props().vpc(vpc);
            return this;
        }

        public Builder vpc(VpcOutputSettingsProperty vpc) {
            this.props().vpc(vpc);
            return this;
        }

        public CfnChannel build() {
            return new CfnChannel(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnChannelProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnChannelProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.WebvttDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebvttDestinationSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebvttDestinationSettingsProperty> {
            public WebvttDestinationSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.WavSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WavSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBitDepth() {
            return null;
        }

        @Nullable
        default public String getCodingMode() {
            return null;
        }

        @Nullable
        default public Number getSampleRate() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WavSettingsProperty> {
            private Number bitDepth;
            private String codingMode;
            private Number sampleRate;

            public Builder bitDepth(Number bitDepth) {
                this.bitDepth = bitDepth;
                return this;
            }

            public Builder codingMode(String codingMode) {
                this.codingMode = codingMode;
                return this;
            }

            public Builder sampleRate(Number sampleRate) {
                this.sampleRate = sampleRate;
                return this;
            }

            public WavSettingsProperty build() {
                return new Jsii.Proxy(this.bitDepth, this.codingMode, this.sampleRate);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.VpcOutputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcOutputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getPublicAddressAllocationIds() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        @Nullable
        default public List<String> getSubnetIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcOutputSettingsProperty> {
            private List<String> publicAddressAllocationIds;
            private List<String> securityGroupIds;
            private List<String> subnetIds;

            public Builder publicAddressAllocationIds(List<String> publicAddressAllocationIds) {
                this.publicAddressAllocationIds = publicAddressAllocationIds;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public VpcOutputSettingsProperty build() {
                return new Jsii.Proxy(this.publicAddressAllocationIds, this.securityGroupIds, this.subnetIds);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.VideoSelectorSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VideoSelectorSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getVideoSelectorPid() {
            return null;
        }

        @Nullable
        default public Object getVideoSelectorProgramId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VideoSelectorSettingsProperty> {
            private Object videoSelectorPid;
            private Object videoSelectorProgramId;

            public Builder videoSelectorPid(IResolvable videoSelectorPid) {
                this.videoSelectorPid = videoSelectorPid;
                return this;
            }

            public Builder videoSelectorPid(VideoSelectorPidProperty videoSelectorPid) {
                this.videoSelectorPid = videoSelectorPid;
                return this;
            }

            public Builder videoSelectorProgramId(IResolvable videoSelectorProgramId) {
                this.videoSelectorProgramId = videoSelectorProgramId;
                return this;
            }

            public Builder videoSelectorProgramId(VideoSelectorProgramIdProperty videoSelectorProgramId) {
                this.videoSelectorProgramId = videoSelectorProgramId;
                return this;
            }

            public VideoSelectorSettingsProperty build() {
                return new Jsii.Proxy(this.videoSelectorPid, this.videoSelectorProgramId);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.VideoSelectorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VideoSelectorProperty
    extends JsiiSerializable {
        @Nullable
        default public String getColorSpace() {
            return null;
        }

        @Nullable
        default public String getColorSpaceUsage() {
            return null;
        }

        @Nullable
        default public Object getSelectorSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VideoSelectorProperty> {
            private String colorSpace;
            private String colorSpaceUsage;
            private Object selectorSettings;

            public Builder colorSpace(String colorSpace) {
                this.colorSpace = colorSpace;
                return this;
            }

            public Builder colorSpaceUsage(String colorSpaceUsage) {
                this.colorSpaceUsage = colorSpaceUsage;
                return this;
            }

            public Builder selectorSettings(IResolvable selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            public Builder selectorSettings(VideoSelectorSettingsProperty selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            public VideoSelectorProperty build() {
                return new Jsii.Proxy(this.colorSpace, this.colorSpaceUsage, this.selectorSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.VideoSelectorProgramIdProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VideoSelectorProgramIdProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getProgramId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VideoSelectorProgramIdProperty> {
            private Number programId;

            public Builder programId(Number programId) {
                this.programId = programId;
                return this;
            }

            public VideoSelectorProgramIdProperty build() {
                return new Jsii.Proxy(this.programId);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.VideoSelectorPidProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VideoSelectorPidProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getPid() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VideoSelectorPidProperty> {
            private Number pid;

            public Builder pid(Number pid) {
                this.pid = pid;
                return this;
            }

            public VideoSelectorPidProperty build() {
                return new Jsii.Proxy(this.pid);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.VideoDescriptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VideoDescriptionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCodecSettings() {
            return null;
        }

        @Nullable
        default public Number getHeight() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getRespondToAfd() {
            return null;
        }

        @Nullable
        default public String getScalingBehavior() {
            return null;
        }

        @Nullable
        default public Number getSharpness() {
            return null;
        }

        @Nullable
        default public Number getWidth() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VideoDescriptionProperty> {
            private Object codecSettings;
            private Number height;
            private String name;
            private String respondToAfd;
            private String scalingBehavior;
            private Number sharpness;
            private Number width;

            public Builder codecSettings(IResolvable codecSettings) {
                this.codecSettings = codecSettings;
                return this;
            }

            public Builder codecSettings(VideoCodecSettingsProperty codecSettings) {
                this.codecSettings = codecSettings;
                return this;
            }

            public Builder height(Number height) {
                this.height = height;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder respondToAfd(String respondToAfd) {
                this.respondToAfd = respondToAfd;
                return this;
            }

            public Builder scalingBehavior(String scalingBehavior) {
                this.scalingBehavior = scalingBehavior;
                return this;
            }

            public Builder sharpness(Number sharpness) {
                this.sharpness = sharpness;
                return this;
            }

            public Builder width(Number width) {
                this.width = width;
                return this;
            }

            public VideoDescriptionProperty build() {
                return new Jsii.Proxy(this.codecSettings, this.height, this.name, this.respondToAfd, this.scalingBehavior, this.sharpness, this.width);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.VideoCodecSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VideoCodecSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFrameCaptureSettings() {
            return null;
        }

        @Nullable
        default public Object getH264Settings() {
            return null;
        }

        @Nullable
        default public Object getH265Settings() {
            return null;
        }

        @Nullable
        default public Object getMpeg2Settings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VideoCodecSettingsProperty> {
            private Object frameCaptureSettings;
            private Object h264Settings;
            private Object h265Settings;
            private Object mpeg2Settings;

            public Builder frameCaptureSettings(IResolvable frameCaptureSettings) {
                this.frameCaptureSettings = frameCaptureSettings;
                return this;
            }

            public Builder frameCaptureSettings(FrameCaptureSettingsProperty frameCaptureSettings) {
                this.frameCaptureSettings = frameCaptureSettings;
                return this;
            }

            public Builder h264Settings(IResolvable h264Settings) {
                this.h264Settings = h264Settings;
                return this;
            }

            public Builder h264Settings(H264SettingsProperty h264Settings) {
                this.h264Settings = h264Settings;
                return this;
            }

            public Builder h265Settings(IResolvable h265Settings) {
                this.h265Settings = h265Settings;
                return this;
            }

            public Builder h265Settings(H265SettingsProperty h265Settings) {
                this.h265Settings = h265Settings;
                return this;
            }

            public Builder mpeg2Settings(IResolvable mpeg2Settings) {
                this.mpeg2Settings = mpeg2Settings;
                return this;
            }

            public Builder mpeg2Settings(Mpeg2SettingsProperty mpeg2Settings) {
                this.mpeg2Settings = mpeg2Settings;
                return this;
            }

            public VideoCodecSettingsProperty build() {
                return new Jsii.Proxy(this.frameCaptureSettings, this.h264Settings, this.h265Settings, this.mpeg2Settings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.VideoBlackFailoverSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VideoBlackFailoverSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBlackDetectThreshold() {
            return null;
        }

        @Nullable
        default public Number getVideoBlackThresholdMsec() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VideoBlackFailoverSettingsProperty> {
            private Number blackDetectThreshold;
            private Number videoBlackThresholdMsec;

            public Builder blackDetectThreshold(Number blackDetectThreshold) {
                this.blackDetectThreshold = blackDetectThreshold;
                return this;
            }

            public Builder videoBlackThresholdMsec(Number videoBlackThresholdMsec) {
                this.videoBlackThresholdMsec = videoBlackThresholdMsec;
                return this;
            }

            public VideoBlackFailoverSettingsProperty build() {
                return new Jsii.Proxy(this.blackDetectThreshold, this.videoBlackThresholdMsec);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.UdpOutputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UdpOutputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBufferMsec() {
            return null;
        }

        @Nullable
        default public Object getContainerSettings() {
            return null;
        }

        @Nullable
        default public Object getDestination() {
            return null;
        }

        @Nullable
        default public Object getFecOutputSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UdpOutputSettingsProperty> {
            private Number bufferMsec;
            private Object containerSettings;
            private Object destination;
            private Object fecOutputSettings;

            public Builder bufferMsec(Number bufferMsec) {
                this.bufferMsec = bufferMsec;
                return this;
            }

            public Builder containerSettings(IResolvable containerSettings) {
                this.containerSettings = containerSettings;
                return this;
            }

            public Builder containerSettings(UdpContainerSettingsProperty containerSettings) {
                this.containerSettings = containerSettings;
                return this;
            }

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder fecOutputSettings(IResolvable fecOutputSettings) {
                this.fecOutputSettings = fecOutputSettings;
                return this;
            }

            public Builder fecOutputSettings(FecOutputSettingsProperty fecOutputSettings) {
                this.fecOutputSettings = fecOutputSettings;
                return this;
            }

            public UdpOutputSettingsProperty build() {
                return new Jsii.Proxy(this.bufferMsec, this.containerSettings, this.destination, this.fecOutputSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.UdpGroupSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UdpGroupSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getInputLossAction() {
            return null;
        }

        @Nullable
        default public String getTimedMetadataId3Frame() {
            return null;
        }

        @Nullable
        default public Number getTimedMetadataId3Period() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UdpGroupSettingsProperty> {
            private String inputLossAction;
            private String timedMetadataId3Frame;
            private Number timedMetadataId3Period;

            public Builder inputLossAction(String inputLossAction) {
                this.inputLossAction = inputLossAction;
                return this;
            }

            public Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
                this.timedMetadataId3Frame = timedMetadataId3Frame;
                return this;
            }

            public Builder timedMetadataId3Period(Number timedMetadataId3Period) {
                this.timedMetadataId3Period = timedMetadataId3Period;
                return this;
            }

            public UdpGroupSettingsProperty build() {
                return new Jsii.Proxy(this.inputLossAction, this.timedMetadataId3Frame, this.timedMetadataId3Period);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.UdpContainerSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UdpContainerSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getM2TsSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UdpContainerSettingsProperty> {
            private Object m2TsSettings;

            public Builder m2TsSettings(IResolvable m2TsSettings) {
                this.m2TsSettings = m2TsSettings;
                return this;
            }

            public Builder m2TsSettings(M2tsSettingsProperty m2TsSettings) {
                this.m2TsSettings = m2TsSettings;
                return this;
            }

            public UdpContainerSettingsProperty build() {
                return new Jsii.Proxy(this.m2TsSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.TtmlDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TtmlDestinationSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getStyleControl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TtmlDestinationSettingsProperty> {
            private String styleControl;

            public Builder styleControl(String styleControl) {
                this.styleControl = styleControl;
                return this;
            }

            public TtmlDestinationSettingsProperty build() {
                return new Jsii.Proxy(this.styleControl);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.TimecodeConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimecodeConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSource() {
            return null;
        }

        @Nullable
        default public Number getSyncThreshold() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimecodeConfigProperty> {
            private String source;
            private Number syncThreshold;

            public Builder source(String source) {
                this.source = source;
                return this;
            }

            public Builder syncThreshold(Number syncThreshold) {
                this.syncThreshold = syncThreshold;
                return this;
            }

            public TimecodeConfigProperty build() {
                return new Jsii.Proxy(this.source, this.syncThreshold);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.TemporalFilterSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TemporalFilterSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPostFilterSharpening() {
            return null;
        }

        @Nullable
        default public String getStrength() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TemporalFilterSettingsProperty> {
            private String postFilterSharpening;
            private String strength;

            public Builder postFilterSharpening(String postFilterSharpening) {
                this.postFilterSharpening = postFilterSharpening;
                return this;
            }

            public Builder strength(String strength) {
                this.strength = strength;
                return this;
            }

            public TemporalFilterSettingsProperty build() {
                return new Jsii.Proxy(this.postFilterSharpening, this.strength);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.TeletextSourceSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TeletextSourceSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPageNumber() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TeletextSourceSettingsProperty> {
            private String pageNumber;

            public Builder pageNumber(String pageNumber) {
                this.pageNumber = pageNumber;
                return this;
            }

            public TeletextSourceSettingsProperty build() {
                return new Jsii.Proxy(this.pageNumber);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.TeletextDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TeletextDestinationSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TeletextDestinationSettingsProperty> {
            public TeletextDestinationSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.StaticKeySettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StaticKeySettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getKeyProviderServer() {
            return null;
        }

        @Nullable
        default public String getStaticKeyValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StaticKeySettingsProperty> {
            private Object keyProviderServer;
            private String staticKeyValue;

            public Builder keyProviderServer(IResolvable keyProviderServer) {
                this.keyProviderServer = keyProviderServer;
                return this;
            }

            public Builder keyProviderServer(InputLocationProperty keyProviderServer) {
                this.keyProviderServer = keyProviderServer;
                return this;
            }

            public Builder staticKeyValue(String staticKeyValue) {
                this.staticKeyValue = staticKeyValue;
                return this;
            }

            public StaticKeySettingsProperty build() {
                return new Jsii.Proxy(this.keyProviderServer, this.staticKeyValue);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.StandardHlsSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StandardHlsSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAudioRenditionSets() {
            return null;
        }

        @Nullable
        default public Object getM3U8Settings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StandardHlsSettingsProperty> {
            private String audioRenditionSets;
            private Object m3U8Settings;

            public Builder audioRenditionSets(String audioRenditionSets) {
                this.audioRenditionSets = audioRenditionSets;
                return this;
            }

            public Builder m3U8Settings(IResolvable m3U8Settings) {
                this.m3U8Settings = m3U8Settings;
                return this;
            }

            public Builder m3U8Settings(M3u8SettingsProperty m3U8Settings) {
                this.m3U8Settings = m3U8Settings;
                return this;
            }

            public StandardHlsSettingsProperty build() {
                return new Jsii.Proxy(this.audioRenditionSets, this.m3U8Settings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.SmpteTtDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SmpteTtDestinationSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SmpteTtDestinationSettingsProperty> {
            public SmpteTtDestinationSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Scte35TimeSignalAposProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Scte35TimeSignalAposProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getAdAvailOffset() {
            return null;
        }

        @Nullable
        default public String getNoRegionalBlackoutFlag() {
            return null;
        }

        @Nullable
        default public String getWebDeliveryAllowedFlag() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Scte35TimeSignalAposProperty> {
            private Number adAvailOffset;
            private String noRegionalBlackoutFlag;
            private String webDeliveryAllowedFlag;

            public Builder adAvailOffset(Number adAvailOffset) {
                this.adAvailOffset = adAvailOffset;
                return this;
            }

            public Builder noRegionalBlackoutFlag(String noRegionalBlackoutFlag) {
                this.noRegionalBlackoutFlag = noRegionalBlackoutFlag;
                return this;
            }

            public Builder webDeliveryAllowedFlag(String webDeliveryAllowedFlag) {
                this.webDeliveryAllowedFlag = webDeliveryAllowedFlag;
                return this;
            }

            public Scte35TimeSignalAposProperty build() {
                return new Jsii.Proxy(this.adAvailOffset, this.noRegionalBlackoutFlag, this.webDeliveryAllowedFlag);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Scte35SpliceInsertProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Scte35SpliceInsertProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getAdAvailOffset() {
            return null;
        }

        @Nullable
        default public String getNoRegionalBlackoutFlag() {
            return null;
        }

        @Nullable
        default public String getWebDeliveryAllowedFlag() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Scte35SpliceInsertProperty> {
            private Number adAvailOffset;
            private String noRegionalBlackoutFlag;
            private String webDeliveryAllowedFlag;

            public Builder adAvailOffset(Number adAvailOffset) {
                this.adAvailOffset = adAvailOffset;
                return this;
            }

            public Builder noRegionalBlackoutFlag(String noRegionalBlackoutFlag) {
                this.noRegionalBlackoutFlag = noRegionalBlackoutFlag;
                return this;
            }

            public Builder webDeliveryAllowedFlag(String webDeliveryAllowedFlag) {
                this.webDeliveryAllowedFlag = webDeliveryAllowedFlag;
                return this;
            }

            public Scte35SpliceInsertProperty build() {
                return new Jsii.Proxy(this.adAvailOffset, this.noRegionalBlackoutFlag, this.webDeliveryAllowedFlag);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Scte27SourceSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Scte27SourceSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getPid() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Scte27SourceSettingsProperty> {
            private Number pid;

            public Builder pid(Number pid) {
                this.pid = pid;
                return this;
            }

            public Scte27SourceSettingsProperty build() {
                return new Jsii.Proxy(this.pid);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Scte27DestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Scte27DestinationSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Scte27DestinationSettingsProperty> {
            public Scte27DestinationSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Scte20SourceSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Scte20SourceSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConvert608To708() {
            return null;
        }

        @Nullable
        default public Number getSource608ChannelNumber() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Scte20SourceSettingsProperty> {
            private String convert608To708;
            private Number source608ChannelNumber;

            public Builder convert608To708(String convert608To708) {
                this.convert608To708 = convert608To708;
                return this;
            }

            public Builder source608ChannelNumber(Number source608ChannelNumber) {
                this.source608ChannelNumber = source608ChannelNumber;
                return this;
            }

            public Scte20SourceSettingsProperty build() {
                return new Jsii.Proxy(this.convert608To708, this.source608ChannelNumber);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Scte20PlusEmbeddedDestinationSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Scte20PlusEmbeddedDestinationSettingsProperty> {
            public Scte20PlusEmbeddedDestinationSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.RtmpOutputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RtmpOutputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCertificateMode() {
            return null;
        }

        @Nullable
        default public Number getConnectionRetryInterval() {
            return null;
        }

        @Nullable
        default public Object getDestination() {
            return null;
        }

        @Nullable
        default public Number getNumRetries() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RtmpOutputSettingsProperty> {
            private String certificateMode;
            private Number connectionRetryInterval;
            private Object destination;
            private Number numRetries;

            public Builder certificateMode(String certificateMode) {
                this.certificateMode = certificateMode;
                return this;
            }

            public Builder connectionRetryInterval(Number connectionRetryInterval) {
                this.connectionRetryInterval = connectionRetryInterval;
                return this;
            }

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder numRetries(Number numRetries) {
                this.numRetries = numRetries;
                return this;
            }

            public RtmpOutputSettingsProperty build() {
                return new Jsii.Proxy(this.certificateMode, this.connectionRetryInterval, this.destination, this.numRetries);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.RtmpGroupSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RtmpGroupSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAdMarkers() {
            return null;
        }

        @Nullable
        default public String getAuthenticationScheme() {
            return null;
        }

        @Nullable
        default public String getCacheFullBehavior() {
            return null;
        }

        @Nullable
        default public Number getCacheLength() {
            return null;
        }

        @Nullable
        default public String getCaptionData() {
            return null;
        }

        @Nullable
        default public String getInputLossAction() {
            return null;
        }

        @Nullable
        default public Number getRestartDelay() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RtmpGroupSettingsProperty> {
            private List<String> adMarkers;
            private String authenticationScheme;
            private String cacheFullBehavior;
            private Number cacheLength;
            private String captionData;
            private String inputLossAction;
            private Number restartDelay;

            public Builder adMarkers(List<String> adMarkers) {
                this.adMarkers = adMarkers;
                return this;
            }

            public Builder authenticationScheme(String authenticationScheme) {
                this.authenticationScheme = authenticationScheme;
                return this;
            }

            public Builder cacheFullBehavior(String cacheFullBehavior) {
                this.cacheFullBehavior = cacheFullBehavior;
                return this;
            }

            public Builder cacheLength(Number cacheLength) {
                this.cacheLength = cacheLength;
                return this;
            }

            public Builder captionData(String captionData) {
                this.captionData = captionData;
                return this;
            }

            public Builder inputLossAction(String inputLossAction) {
                this.inputLossAction = inputLossAction;
                return this;
            }

            public Builder restartDelay(Number restartDelay) {
                this.restartDelay = restartDelay;
                return this;
            }

            public RtmpGroupSettingsProperty build() {
                return new Jsii.Proxy(this.adMarkers, this.authenticationScheme, this.cacheFullBehavior, this.cacheLength, this.captionData, this.inputLossAction, this.restartDelay);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.RtmpCaptionInfoDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RtmpCaptionInfoDestinationSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RtmpCaptionInfoDestinationSettingsProperty> {
            public RtmpCaptionInfoDestinationSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.RemixSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RemixSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getChannelMappings() {
            return null;
        }

        @Nullable
        default public Number getChannelsIn() {
            return null;
        }

        @Nullable
        default public Number getChannelsOut() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RemixSettingsProperty> {
            private Object channelMappings;
            private Number channelsIn;
            private Number channelsOut;

            public Builder channelMappings(IResolvable channelMappings) {
                this.channelMappings = channelMappings;
                return this;
            }

            public Builder channelMappings(List<? extends Object> channelMappings) {
                this.channelMappings = channelMappings;
                return this;
            }

            public Builder channelsIn(Number channelsIn) {
                this.channelsIn = channelsIn;
                return this;
            }

            public Builder channelsOut(Number channelsOut) {
                this.channelsOut = channelsOut;
                return this;
            }

            public RemixSettingsProperty build() {
                return new Jsii.Proxy(this.channelMappings, this.channelsIn, this.channelsOut);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Rec709SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Rec709SettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Rec709SettingsProperty> {
            public Rec709SettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Rec601SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Rec601SettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Rec601SettingsProperty> {
            public Rec601SettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.RawSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RawSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RawSettingsProperty> {
            public RawSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.PassThroughSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PassThroughSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PassThroughSettingsProperty> {
            public PassThroughSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.OutputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getArchiveOutputSettings() {
            return null;
        }

        @Nullable
        default public Object getFrameCaptureOutputSettings() {
            return null;
        }

        @Nullable
        default public Object getHlsOutputSettings() {
            return null;
        }

        @Nullable
        default public Object getMediaPackageOutputSettings() {
            return null;
        }

        @Nullable
        default public Object getMsSmoothOutputSettings() {
            return null;
        }

        @Nullable
        default public Object getMultiplexOutputSettings() {
            return null;
        }

        @Nullable
        default public Object getRtmpOutputSettings() {
            return null;
        }

        @Nullable
        default public Object getUdpOutputSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputSettingsProperty> {
            private Object archiveOutputSettings;
            private Object frameCaptureOutputSettings;
            private Object hlsOutputSettings;
            private Object mediaPackageOutputSettings;
            private Object msSmoothOutputSettings;
            private Object multiplexOutputSettings;
            private Object rtmpOutputSettings;
            private Object udpOutputSettings;

            public Builder archiveOutputSettings(IResolvable archiveOutputSettings) {
                this.archiveOutputSettings = archiveOutputSettings;
                return this;
            }

            public Builder archiveOutputSettings(ArchiveOutputSettingsProperty archiveOutputSettings) {
                this.archiveOutputSettings = archiveOutputSettings;
                return this;
            }

            public Builder frameCaptureOutputSettings(IResolvable frameCaptureOutputSettings) {
                this.frameCaptureOutputSettings = frameCaptureOutputSettings;
                return this;
            }

            public Builder frameCaptureOutputSettings(FrameCaptureOutputSettingsProperty frameCaptureOutputSettings) {
                this.frameCaptureOutputSettings = frameCaptureOutputSettings;
                return this;
            }

            public Builder hlsOutputSettings(IResolvable hlsOutputSettings) {
                this.hlsOutputSettings = hlsOutputSettings;
                return this;
            }

            public Builder hlsOutputSettings(HlsOutputSettingsProperty hlsOutputSettings) {
                this.hlsOutputSettings = hlsOutputSettings;
                return this;
            }

            public Builder mediaPackageOutputSettings(IResolvable mediaPackageOutputSettings) {
                this.mediaPackageOutputSettings = mediaPackageOutputSettings;
                return this;
            }

            public Builder mediaPackageOutputSettings(MediaPackageOutputSettingsProperty mediaPackageOutputSettings) {
                this.mediaPackageOutputSettings = mediaPackageOutputSettings;
                return this;
            }

            public Builder msSmoothOutputSettings(IResolvable msSmoothOutputSettings) {
                this.msSmoothOutputSettings = msSmoothOutputSettings;
                return this;
            }

            public Builder msSmoothOutputSettings(MsSmoothOutputSettingsProperty msSmoothOutputSettings) {
                this.msSmoothOutputSettings = msSmoothOutputSettings;
                return this;
            }

            public Builder multiplexOutputSettings(IResolvable multiplexOutputSettings) {
                this.multiplexOutputSettings = multiplexOutputSettings;
                return this;
            }

            public Builder multiplexOutputSettings(MultiplexOutputSettingsProperty multiplexOutputSettings) {
                this.multiplexOutputSettings = multiplexOutputSettings;
                return this;
            }

            public Builder rtmpOutputSettings(IResolvable rtmpOutputSettings) {
                this.rtmpOutputSettings = rtmpOutputSettings;
                return this;
            }

            public Builder rtmpOutputSettings(RtmpOutputSettingsProperty rtmpOutputSettings) {
                this.rtmpOutputSettings = rtmpOutputSettings;
                return this;
            }

            public Builder udpOutputSettings(IResolvable udpOutputSettings) {
                this.udpOutputSettings = udpOutputSettings;
                return this;
            }

            public Builder udpOutputSettings(UdpOutputSettingsProperty udpOutputSettings) {
                this.udpOutputSettings = udpOutputSettings;
                return this;
            }

            public OutputSettingsProperty build() {
                return new Jsii.Proxy(this.archiveOutputSettings, this.frameCaptureOutputSettings, this.hlsOutputSettings, this.mediaPackageOutputSettings, this.msSmoothOutputSettings, this.multiplexOutputSettings, this.rtmpOutputSettings, this.udpOutputSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.OutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAudioDescriptionNames() {
            return null;
        }

        @Nullable
        default public List<String> getCaptionDescriptionNames() {
            return null;
        }

        @Nullable
        default public String getOutputName() {
            return null;
        }

        @Nullable
        default public Object getOutputSettings() {
            return null;
        }

        @Nullable
        default public String getVideoDescriptionName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputProperty> {
            private List<String> audioDescriptionNames;
            private List<String> captionDescriptionNames;
            private String outputName;
            private Object outputSettings;
            private String videoDescriptionName;

            public Builder audioDescriptionNames(List<String> audioDescriptionNames) {
                this.audioDescriptionNames = audioDescriptionNames;
                return this;
            }

            public Builder captionDescriptionNames(List<String> captionDescriptionNames) {
                this.captionDescriptionNames = captionDescriptionNames;
                return this;
            }

            public Builder outputName(String outputName) {
                this.outputName = outputName;
                return this;
            }

            public Builder outputSettings(IResolvable outputSettings) {
                this.outputSettings = outputSettings;
                return this;
            }

            public Builder outputSettings(OutputSettingsProperty outputSettings) {
                this.outputSettings = outputSettings;
                return this;
            }

            public Builder videoDescriptionName(String videoDescriptionName) {
                this.videoDescriptionName = videoDescriptionName;
                return this;
            }

            public OutputProperty build() {
                return new Jsii.Proxy(this.audioDescriptionNames, this.captionDescriptionNames, this.outputName, this.outputSettings, this.videoDescriptionName);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.OutputLocationRefProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputLocationRefProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDestinationRefId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputLocationRefProperty> {
            private String destinationRefId;

            public Builder destinationRefId(String destinationRefId) {
                this.destinationRefId = destinationRefId;
                return this;
            }

            public OutputLocationRefProperty build() {
                return new Jsii.Proxy(this.destinationRefId);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.OutputGroupSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputGroupSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getArchiveGroupSettings() {
            return null;
        }

        @Nullable
        default public Object getFrameCaptureGroupSettings() {
            return null;
        }

        @Nullable
        default public Object getHlsGroupSettings() {
            return null;
        }

        @Nullable
        default public Object getMediaPackageGroupSettings() {
            return null;
        }

        @Nullable
        default public Object getMsSmoothGroupSettings() {
            return null;
        }

        @Nullable
        default public Object getMultiplexGroupSettings() {
            return null;
        }

        @Nullable
        default public Object getRtmpGroupSettings() {
            return null;
        }

        @Nullable
        default public Object getUdpGroupSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputGroupSettingsProperty> {
            private Object archiveGroupSettings;
            private Object frameCaptureGroupSettings;
            private Object hlsGroupSettings;
            private Object mediaPackageGroupSettings;
            private Object msSmoothGroupSettings;
            private Object multiplexGroupSettings;
            private Object rtmpGroupSettings;
            private Object udpGroupSettings;

            public Builder archiveGroupSettings(IResolvable archiveGroupSettings) {
                this.archiveGroupSettings = archiveGroupSettings;
                return this;
            }

            public Builder archiveGroupSettings(ArchiveGroupSettingsProperty archiveGroupSettings) {
                this.archiveGroupSettings = archiveGroupSettings;
                return this;
            }

            public Builder frameCaptureGroupSettings(IResolvable frameCaptureGroupSettings) {
                this.frameCaptureGroupSettings = frameCaptureGroupSettings;
                return this;
            }

            public Builder frameCaptureGroupSettings(FrameCaptureGroupSettingsProperty frameCaptureGroupSettings) {
                this.frameCaptureGroupSettings = frameCaptureGroupSettings;
                return this;
            }

            public Builder hlsGroupSettings(IResolvable hlsGroupSettings) {
                this.hlsGroupSettings = hlsGroupSettings;
                return this;
            }

            public Builder hlsGroupSettings(HlsGroupSettingsProperty hlsGroupSettings) {
                this.hlsGroupSettings = hlsGroupSettings;
                return this;
            }

            public Builder mediaPackageGroupSettings(IResolvable mediaPackageGroupSettings) {
                this.mediaPackageGroupSettings = mediaPackageGroupSettings;
                return this;
            }

            public Builder mediaPackageGroupSettings(MediaPackageGroupSettingsProperty mediaPackageGroupSettings) {
                this.mediaPackageGroupSettings = mediaPackageGroupSettings;
                return this;
            }

            public Builder msSmoothGroupSettings(IResolvable msSmoothGroupSettings) {
                this.msSmoothGroupSettings = msSmoothGroupSettings;
                return this;
            }

            public Builder msSmoothGroupSettings(MsSmoothGroupSettingsProperty msSmoothGroupSettings) {
                this.msSmoothGroupSettings = msSmoothGroupSettings;
                return this;
            }

            public Builder multiplexGroupSettings(IResolvable multiplexGroupSettings) {
                this.multiplexGroupSettings = multiplexGroupSettings;
                return this;
            }

            public Builder multiplexGroupSettings(MultiplexGroupSettingsProperty multiplexGroupSettings) {
                this.multiplexGroupSettings = multiplexGroupSettings;
                return this;
            }

            public Builder rtmpGroupSettings(IResolvable rtmpGroupSettings) {
                this.rtmpGroupSettings = rtmpGroupSettings;
                return this;
            }

            public Builder rtmpGroupSettings(RtmpGroupSettingsProperty rtmpGroupSettings) {
                this.rtmpGroupSettings = rtmpGroupSettings;
                return this;
            }

            public Builder udpGroupSettings(IResolvable udpGroupSettings) {
                this.udpGroupSettings = udpGroupSettings;
                return this;
            }

            public Builder udpGroupSettings(UdpGroupSettingsProperty udpGroupSettings) {
                this.udpGroupSettings = udpGroupSettings;
                return this;
            }

            public OutputGroupSettingsProperty build() {
                return new Jsii.Proxy(this.archiveGroupSettings, this.frameCaptureGroupSettings, this.hlsGroupSettings, this.mediaPackageGroupSettings, this.msSmoothGroupSettings, this.multiplexGroupSettings, this.rtmpGroupSettings, this.udpGroupSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.OutputGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputGroupProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getOutputGroupSettings() {
            return null;
        }

        @Nullable
        default public Object getOutputs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputGroupProperty> {
            private String name;
            private Object outputGroupSettings;
            private Object outputs;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder outputGroupSettings(IResolvable outputGroupSettings) {
                this.outputGroupSettings = outputGroupSettings;
                return this;
            }

            public Builder outputGroupSettings(OutputGroupSettingsProperty outputGroupSettings) {
                this.outputGroupSettings = outputGroupSettings;
                return this;
            }

            public Builder outputs(IResolvable outputs) {
                this.outputs = outputs;
                return this;
            }

            public Builder outputs(List<? extends Object> outputs) {
                this.outputs = outputs;
                return this;
            }

            public OutputGroupProperty build() {
                return new Jsii.Proxy(this.name, this.outputGroupSettings, this.outputs);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.OutputDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputDestinationSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPasswordParam() {
            return null;
        }

        @Nullable
        default public String getStreamName() {
            return null;
        }

        @Nullable
        default public String getUrl() {
            return null;
        }

        @Nullable
        default public String getUsername() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputDestinationSettingsProperty> {
            private String passwordParam;
            private String streamName;
            private String url;
            private String username;

            public Builder passwordParam(String passwordParam) {
                this.passwordParam = passwordParam;
                return this;
            }

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public OutputDestinationSettingsProperty build() {
                return new Jsii.Proxy(this.passwordParam, this.streamName, this.url, this.username);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.OutputDestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputDestinationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getId() {
            return null;
        }

        @Nullable
        default public Object getMediaPackageSettings() {
            return null;
        }

        @Nullable
        default public Object getMultiplexSettings() {
            return null;
        }

        @Nullable
        default public Object getSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputDestinationProperty> {
            private String id;
            private Object mediaPackageSettings;
            private Object multiplexSettings;
            private Object settings;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder mediaPackageSettings(IResolvable mediaPackageSettings) {
                this.mediaPackageSettings = mediaPackageSettings;
                return this;
            }

            public Builder mediaPackageSettings(List<? extends Object> mediaPackageSettings) {
                this.mediaPackageSettings = mediaPackageSettings;
                return this;
            }

            public Builder multiplexSettings(IResolvable multiplexSettings) {
                this.multiplexSettings = multiplexSettings;
                return this;
            }

            public Builder multiplexSettings(MultiplexProgramChannelDestinationSettingsProperty multiplexSettings) {
                this.multiplexSettings = multiplexSettings;
                return this;
            }

            public Builder settings(IResolvable settings) {
                this.settings = settings;
                return this;
            }

            public Builder settings(List<? extends Object> settings) {
                this.settings = settings;
                return this;
            }

            public OutputDestinationProperty build() {
                return new Jsii.Proxy(this.id, this.mediaPackageSettings, this.multiplexSettings, this.settings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.NielsenConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NielsenConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDistributorId() {
            return null;
        }

        @Nullable
        default public String getNielsenPcmToId3Tagging() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NielsenConfigurationProperty> {
            private String distributorId;
            private String nielsenPcmToId3Tagging;

            public Builder distributorId(String distributorId) {
                this.distributorId = distributorId;
                return this;
            }

            public Builder nielsenPcmToId3Tagging(String nielsenPcmToId3Tagging) {
                this.nielsenPcmToId3Tagging = nielsenPcmToId3Tagging;
                return this;
            }

            public NielsenConfigurationProperty build() {
                return new Jsii.Proxy(this.distributorId, this.nielsenPcmToId3Tagging);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.NetworkInputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkInputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getHlsInputSettings() {
            return null;
        }

        @Nullable
        default public String getServerValidation() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkInputSettingsProperty> {
            private Object hlsInputSettings;
            private String serverValidation;

            public Builder hlsInputSettings(IResolvable hlsInputSettings) {
                this.hlsInputSettings = hlsInputSettings;
                return this;
            }

            public Builder hlsInputSettings(HlsInputSettingsProperty hlsInputSettings) {
                this.hlsInputSettings = hlsInputSettings;
                return this;
            }

            public Builder serverValidation(String serverValidation) {
                this.serverValidation = serverValidation;
                return this;
            }

            public NetworkInputSettingsProperty build() {
                return new Jsii.Proxy(this.hlsInputSettings, this.serverValidation);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.MultiplexProgramChannelDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MultiplexProgramChannelDestinationSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMultiplexId() {
            return null;
        }

        @Nullable
        default public String getProgramName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MultiplexProgramChannelDestinationSettingsProperty> {
            private String multiplexId;
            private String programName;

            public Builder multiplexId(String multiplexId) {
                this.multiplexId = multiplexId;
                return this;
            }

            public Builder programName(String programName) {
                this.programName = programName;
                return this;
            }

            public MultiplexProgramChannelDestinationSettingsProperty build() {
                return new Jsii.Proxy(this.multiplexId, this.programName);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.MultiplexOutputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MultiplexOutputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDestination() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MultiplexOutputSettingsProperty> {
            private Object destination;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            public MultiplexOutputSettingsProperty build() {
                return new Jsii.Proxy(this.destination);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.MultiplexGroupSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MultiplexGroupSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MultiplexGroupSettingsProperty> {
            public MultiplexGroupSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.MsSmoothOutputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MsSmoothOutputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getH265PackagingType() {
            return null;
        }

        @Nullable
        default public String getNameModifier() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MsSmoothOutputSettingsProperty> {
            private String h265PackagingType;
            private String nameModifier;

            public Builder h265PackagingType(String h265PackagingType) {
                this.h265PackagingType = h265PackagingType;
                return this;
            }

            public Builder nameModifier(String nameModifier) {
                this.nameModifier = nameModifier;
                return this;
            }

            public MsSmoothOutputSettingsProperty build() {
                return new Jsii.Proxy(this.h265PackagingType, this.nameModifier);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.MsSmoothGroupSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MsSmoothGroupSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAcquisitionPointId() {
            return null;
        }

        @Nullable
        default public String getAudioOnlyTimecodeControl() {
            return null;
        }

        @Nullable
        default public String getCertificateMode() {
            return null;
        }

        @Nullable
        default public Number getConnectionRetryInterval() {
            return null;
        }

        @Nullable
        default public Object getDestination() {
            return null;
        }

        @Nullable
        default public String getEventId() {
            return null;
        }

        @Nullable
        default public String getEventIdMode() {
            return null;
        }

        @Nullable
        default public String getEventStopBehavior() {
            return null;
        }

        @Nullable
        default public Number getFilecacheDuration() {
            return null;
        }

        @Nullable
        default public Number getFragmentLength() {
            return null;
        }

        @Nullable
        default public String getInputLossAction() {
            return null;
        }

        @Nullable
        default public Number getNumRetries() {
            return null;
        }

        @Nullable
        default public Number getRestartDelay() {
            return null;
        }

        @Nullable
        default public String getSegmentationMode() {
            return null;
        }

        @Nullable
        default public Number getSendDelayMs() {
            return null;
        }

        @Nullable
        default public String getSparseTrackType() {
            return null;
        }

        @Nullable
        default public String getStreamManifestBehavior() {
            return null;
        }

        @Nullable
        default public String getTimestampOffset() {
            return null;
        }

        @Nullable
        default public String getTimestampOffsetMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MsSmoothGroupSettingsProperty> {
            private String acquisitionPointId;
            private String audioOnlyTimecodeControl;
            private String certificateMode;
            private Number connectionRetryInterval;
            private Object destination;
            private String eventId;
            private String eventIdMode;
            private String eventStopBehavior;
            private Number filecacheDuration;
            private Number fragmentLength;
            private String inputLossAction;
            private Number numRetries;
            private Number restartDelay;
            private String segmentationMode;
            private Number sendDelayMs;
            private String sparseTrackType;
            private String streamManifestBehavior;
            private String timestampOffset;
            private String timestampOffsetMode;

            public Builder acquisitionPointId(String acquisitionPointId) {
                this.acquisitionPointId = acquisitionPointId;
                return this;
            }

            public Builder audioOnlyTimecodeControl(String audioOnlyTimecodeControl) {
                this.audioOnlyTimecodeControl = audioOnlyTimecodeControl;
                return this;
            }

            public Builder certificateMode(String certificateMode) {
                this.certificateMode = certificateMode;
                return this;
            }

            public Builder connectionRetryInterval(Number connectionRetryInterval) {
                this.connectionRetryInterval = connectionRetryInterval;
                return this;
            }

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder eventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public Builder eventIdMode(String eventIdMode) {
                this.eventIdMode = eventIdMode;
                return this;
            }

            public Builder eventStopBehavior(String eventStopBehavior) {
                this.eventStopBehavior = eventStopBehavior;
                return this;
            }

            public Builder filecacheDuration(Number filecacheDuration) {
                this.filecacheDuration = filecacheDuration;
                return this;
            }

            public Builder fragmentLength(Number fragmentLength) {
                this.fragmentLength = fragmentLength;
                return this;
            }

            public Builder inputLossAction(String inputLossAction) {
                this.inputLossAction = inputLossAction;
                return this;
            }

            public Builder numRetries(Number numRetries) {
                this.numRetries = numRetries;
                return this;
            }

            public Builder restartDelay(Number restartDelay) {
                this.restartDelay = restartDelay;
                return this;
            }

            public Builder segmentationMode(String segmentationMode) {
                this.segmentationMode = segmentationMode;
                return this;
            }

            public Builder sendDelayMs(Number sendDelayMs) {
                this.sendDelayMs = sendDelayMs;
                return this;
            }

            public Builder sparseTrackType(String sparseTrackType) {
                this.sparseTrackType = sparseTrackType;
                return this;
            }

            public Builder streamManifestBehavior(String streamManifestBehavior) {
                this.streamManifestBehavior = streamManifestBehavior;
                return this;
            }

            public Builder timestampOffset(String timestampOffset) {
                this.timestampOffset = timestampOffset;
                return this;
            }

            public Builder timestampOffsetMode(String timestampOffsetMode) {
                this.timestampOffsetMode = timestampOffsetMode;
                return this;
            }

            public MsSmoothGroupSettingsProperty build() {
                return new Jsii.Proxy(this.acquisitionPointId, this.audioOnlyTimecodeControl, this.certificateMode, this.connectionRetryInterval, this.destination, this.eventId, this.eventIdMode, this.eventStopBehavior, this.filecacheDuration, this.fragmentLength, this.inputLossAction, this.numRetries, this.restartDelay, this.segmentationMode, this.sendDelayMs, this.sparseTrackType, this.streamManifestBehavior, this.timestampOffset, this.timestampOffsetMode);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Mpeg2SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Mpeg2SettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAdaptiveQuantization() {
            return null;
        }

        @Nullable
        default public String getAfdSignaling() {
            return null;
        }

        @Nullable
        default public String getColorMetadata() {
            return null;
        }

        @Nullable
        default public String getColorSpace() {
            return null;
        }

        @Nullable
        default public String getDisplayAspectRatio() {
            return null;
        }

        @Nullable
        default public Object getFilterSettings() {
            return null;
        }

        @Nullable
        default public String getFixedAfd() {
            return null;
        }

        @Nullable
        default public Number getFramerateDenominator() {
            return null;
        }

        @Nullable
        default public Number getFramerateNumerator() {
            return null;
        }

        @Nullable
        default public Number getGopClosedCadence() {
            return null;
        }

        @Nullable
        default public Number getGopNumBFrames() {
            return null;
        }

        @Nullable
        default public Number getGopSize() {
            return null;
        }

        @Nullable
        default public String getGopSizeUnits() {
            return null;
        }

        @Nullable
        default public String getScanType() {
            return null;
        }

        @Nullable
        default public String getSubgopLength() {
            return null;
        }

        @Nullable
        default public String getTimecodeInsertion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Mpeg2SettingsProperty> {
            private String adaptiveQuantization;
            private String afdSignaling;
            private String colorMetadata;
            private String colorSpace;
            private String displayAspectRatio;
            private Object filterSettings;
            private String fixedAfd;
            private Number framerateDenominator;
            private Number framerateNumerator;
            private Number gopClosedCadence;
            private Number gopNumBFrames;
            private Number gopSize;
            private String gopSizeUnits;
            private String scanType;
            private String subgopLength;
            private String timecodeInsertion;

            public Builder adaptiveQuantization(String adaptiveQuantization) {
                this.adaptiveQuantization = adaptiveQuantization;
                return this;
            }

            public Builder afdSignaling(String afdSignaling) {
                this.afdSignaling = afdSignaling;
                return this;
            }

            public Builder colorMetadata(String colorMetadata) {
                this.colorMetadata = colorMetadata;
                return this;
            }

            public Builder colorSpace(String colorSpace) {
                this.colorSpace = colorSpace;
                return this;
            }

            public Builder displayAspectRatio(String displayAspectRatio) {
                this.displayAspectRatio = displayAspectRatio;
                return this;
            }

            public Builder filterSettings(IResolvable filterSettings) {
                this.filterSettings = filterSettings;
                return this;
            }

            public Builder filterSettings(Mpeg2FilterSettingsProperty filterSettings) {
                this.filterSettings = filterSettings;
                return this;
            }

            public Builder fixedAfd(String fixedAfd) {
                this.fixedAfd = fixedAfd;
                return this;
            }

            public Builder framerateDenominator(Number framerateDenominator) {
                this.framerateDenominator = framerateDenominator;
                return this;
            }

            public Builder framerateNumerator(Number framerateNumerator) {
                this.framerateNumerator = framerateNumerator;
                return this;
            }

            public Builder gopClosedCadence(Number gopClosedCadence) {
                this.gopClosedCadence = gopClosedCadence;
                return this;
            }

            public Builder gopNumBFrames(Number gopNumBFrames) {
                this.gopNumBFrames = gopNumBFrames;
                return this;
            }

            public Builder gopSize(Number gopSize) {
                this.gopSize = gopSize;
                return this;
            }

            public Builder gopSizeUnits(String gopSizeUnits) {
                this.gopSizeUnits = gopSizeUnits;
                return this;
            }

            public Builder scanType(String scanType) {
                this.scanType = scanType;
                return this;
            }

            public Builder subgopLength(String subgopLength) {
                this.subgopLength = subgopLength;
                return this;
            }

            public Builder timecodeInsertion(String timecodeInsertion) {
                this.timecodeInsertion = timecodeInsertion;
                return this;
            }

            public Mpeg2SettingsProperty build() {
                return new Jsii.Proxy(this.adaptiveQuantization, this.afdSignaling, this.colorMetadata, this.colorSpace, this.displayAspectRatio, this.filterSettings, this.fixedAfd, this.framerateDenominator, this.framerateNumerator, this.gopClosedCadence, this.gopNumBFrames, this.gopSize, this.gopSizeUnits, this.scanType, this.subgopLength, this.timecodeInsertion);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Mpeg2FilterSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Mpeg2FilterSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTemporalFilterSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Mpeg2FilterSettingsProperty> {
            private Object temporalFilterSettings;

            public Builder temporalFilterSettings(IResolvable temporalFilterSettings) {
                this.temporalFilterSettings = temporalFilterSettings;
                return this;
            }

            public Builder temporalFilterSettings(TemporalFilterSettingsProperty temporalFilterSettings) {
                this.temporalFilterSettings = temporalFilterSettings;
                return this;
            }

            public Mpeg2FilterSettingsProperty build() {
                return new Jsii.Proxy(this.temporalFilterSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Mp2SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Mp2SettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBitrate() {
            return null;
        }

        @Nullable
        default public String getCodingMode() {
            return null;
        }

        @Nullable
        default public Number getSampleRate() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Mp2SettingsProperty> {
            private Number bitrate;
            private String codingMode;
            private Number sampleRate;

            public Builder bitrate(Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            public Builder codingMode(String codingMode) {
                this.codingMode = codingMode;
                return this;
            }

            public Builder sampleRate(Number sampleRate) {
                this.sampleRate = sampleRate;
                return this;
            }

            public Mp2SettingsProperty build() {
                return new Jsii.Proxy(this.bitrate, this.codingMode, this.sampleRate);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.MediaPackageOutputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MediaPackageOutputSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MediaPackageOutputSettingsProperty> {
            public MediaPackageOutputSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.MediaPackageOutputDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MediaPackageOutputDestinationSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getChannelId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MediaPackageOutputDestinationSettingsProperty> {
            private String channelId;

            public Builder channelId(String channelId) {
                this.channelId = channelId;
                return this;
            }

            public MediaPackageOutputDestinationSettingsProperty build() {
                return new Jsii.Proxy(this.channelId);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.MediaPackageGroupSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MediaPackageGroupSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDestination() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MediaPackageGroupSettingsProperty> {
            private Object destination;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            public MediaPackageGroupSettingsProperty build() {
                return new Jsii.Proxy(this.destination);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.M3u8SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface M3u8SettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getAudioFramesPerPes() {
            return null;
        }

        @Nullable
        default public String getAudioPids() {
            return null;
        }

        @Nullable
        default public String getEcmPid() {
            return null;
        }

        @Nullable
        default public String getNielsenId3Behavior() {
            return null;
        }

        @Nullable
        default public Number getPatInterval() {
            return null;
        }

        @Nullable
        default public String getPcrControl() {
            return null;
        }

        @Nullable
        default public Number getPcrPeriod() {
            return null;
        }

        @Nullable
        default public String getPcrPid() {
            return null;
        }

        @Nullable
        default public Number getPmtInterval() {
            return null;
        }

        @Nullable
        default public String getPmtPid() {
            return null;
        }

        @Nullable
        default public Number getProgramNum() {
            return null;
        }

        @Nullable
        default public String getScte35Behavior() {
            return null;
        }

        @Nullable
        default public String getScte35Pid() {
            return null;
        }

        @Nullable
        default public String getTimedMetadataBehavior() {
            return null;
        }

        @Nullable
        default public String getTimedMetadataPid() {
            return null;
        }

        @Nullable
        default public Number getTransportStreamId() {
            return null;
        }

        @Nullable
        default public String getVideoPid() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<M3u8SettingsProperty> {
            private Number audioFramesPerPes;
            private String audioPids;
            private String ecmPid;
            private String nielsenId3Behavior;
            private Number patInterval;
            private String pcrControl;
            private Number pcrPeriod;
            private String pcrPid;
            private Number pmtInterval;
            private String pmtPid;
            private Number programNum;
            private String scte35Behavior;
            private String scte35Pid;
            private String timedMetadataBehavior;
            private String timedMetadataPid;
            private Number transportStreamId;
            private String videoPid;

            public Builder audioFramesPerPes(Number audioFramesPerPes) {
                this.audioFramesPerPes = audioFramesPerPes;
                return this;
            }

            public Builder audioPids(String audioPids) {
                this.audioPids = audioPids;
                return this;
            }

            public Builder ecmPid(String ecmPid) {
                this.ecmPid = ecmPid;
                return this;
            }

            public Builder nielsenId3Behavior(String nielsenId3Behavior) {
                this.nielsenId3Behavior = nielsenId3Behavior;
                return this;
            }

            public Builder patInterval(Number patInterval) {
                this.patInterval = patInterval;
                return this;
            }

            public Builder pcrControl(String pcrControl) {
                this.pcrControl = pcrControl;
                return this;
            }

            public Builder pcrPeriod(Number pcrPeriod) {
                this.pcrPeriod = pcrPeriod;
                return this;
            }

            public Builder pcrPid(String pcrPid) {
                this.pcrPid = pcrPid;
                return this;
            }

            public Builder pmtInterval(Number pmtInterval) {
                this.pmtInterval = pmtInterval;
                return this;
            }

            public Builder pmtPid(String pmtPid) {
                this.pmtPid = pmtPid;
                return this;
            }

            public Builder programNum(Number programNum) {
                this.programNum = programNum;
                return this;
            }

            public Builder scte35Behavior(String scte35Behavior) {
                this.scte35Behavior = scte35Behavior;
                return this;
            }

            public Builder scte35Pid(String scte35Pid) {
                this.scte35Pid = scte35Pid;
                return this;
            }

            public Builder timedMetadataBehavior(String timedMetadataBehavior) {
                this.timedMetadataBehavior = timedMetadataBehavior;
                return this;
            }

            public Builder timedMetadataPid(String timedMetadataPid) {
                this.timedMetadataPid = timedMetadataPid;
                return this;
            }

            public Builder transportStreamId(Number transportStreamId) {
                this.transportStreamId = transportStreamId;
                return this;
            }

            public Builder videoPid(String videoPid) {
                this.videoPid = videoPid;
                return this;
            }

            public M3u8SettingsProperty build() {
                return new Jsii.Proxy(this.audioFramesPerPes, this.audioPids, this.ecmPid, this.nielsenId3Behavior, this.patInterval, this.pcrControl, this.pcrPeriod, this.pcrPid, this.pmtInterval, this.pmtPid, this.programNum, this.scte35Behavior, this.scte35Pid, this.timedMetadataBehavior, this.timedMetadataPid, this.transportStreamId, this.videoPid);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.M2tsSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface M2tsSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAbsentInputAudioBehavior() {
            return null;
        }

        @Nullable
        default public String getArib() {
            return null;
        }

        @Nullable
        default public String getAribCaptionsPid() {
            return null;
        }

        @Nullable
        default public String getAribCaptionsPidControl() {
            return null;
        }

        @Nullable
        default public String getAudioBufferModel() {
            return null;
        }

        @Nullable
        default public Number getAudioFramesPerPes() {
            return null;
        }

        @Nullable
        default public String getAudioPids() {
            return null;
        }

        @Nullable
        default public String getAudioStreamType() {
            return null;
        }

        @Nullable
        default public Number getBitrate() {
            return null;
        }

        @Nullable
        default public String getBufferModel() {
            return null;
        }

        @Nullable
        default public String getCcDescriptor() {
            return null;
        }

        @Nullable
        default public Object getDvbNitSettings() {
            return null;
        }

        @Nullable
        default public Object getDvbSdtSettings() {
            return null;
        }

        @Nullable
        default public String getDvbSubPids() {
            return null;
        }

        @Nullable
        default public Object getDvbTdtSettings() {
            return null;
        }

        @Nullable
        default public String getDvbTeletextPid() {
            return null;
        }

        @Nullable
        default public String getEbif() {
            return null;
        }

        @Nullable
        default public String getEbpAudioInterval() {
            return null;
        }

        @Nullable
        default public Number getEbpLookaheadMs() {
            return null;
        }

        @Nullable
        default public String getEbpPlacement() {
            return null;
        }

        @Nullable
        default public String getEcmPid() {
            return null;
        }

        @Nullable
        default public String getEsRateInPes() {
            return null;
        }

        @Nullable
        default public String getEtvPlatformPid() {
            return null;
        }

        @Nullable
        default public String getEtvSignalPid() {
            return null;
        }

        @Nullable
        default public Number getFragmentTime() {
            return null;
        }

        @Nullable
        default public String getKlv() {
            return null;
        }

        @Nullable
        default public String getKlvDataPids() {
            return null;
        }

        @Nullable
        default public String getNielsenId3Behavior() {
            return null;
        }

        @Nullable
        default public Number getNullPacketBitrate() {
            return null;
        }

        @Nullable
        default public Number getPatInterval() {
            return null;
        }

        @Nullable
        default public String getPcrControl() {
            return null;
        }

        @Nullable
        default public Number getPcrPeriod() {
            return null;
        }

        @Nullable
        default public String getPcrPid() {
            return null;
        }

        @Nullable
        default public Number getPmtInterval() {
            return null;
        }

        @Nullable
        default public String getPmtPid() {
            return null;
        }

        @Nullable
        default public Number getProgramNum() {
            return null;
        }

        @Nullable
        default public String getRateMode() {
            return null;
        }

        @Nullable
        default public String getScte27Pids() {
            return null;
        }

        @Nullable
        default public String getScte35Control() {
            return null;
        }

        @Nullable
        default public String getScte35Pid() {
            return null;
        }

        @Nullable
        default public String getSegmentationMarkers() {
            return null;
        }

        @Nullable
        default public String getSegmentationStyle() {
            return null;
        }

        @Nullable
        default public Number getSegmentationTime() {
            return null;
        }

        @Nullable
        default public String getTimedMetadataBehavior() {
            return null;
        }

        @Nullable
        default public String getTimedMetadataPid() {
            return null;
        }

        @Nullable
        default public Number getTransportStreamId() {
            return null;
        }

        @Nullable
        default public String getVideoPid() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<M2tsSettingsProperty> {
            private String absentInputAudioBehavior;
            private String arib;
            private String aribCaptionsPid;
            private String aribCaptionsPidControl;
            private String audioBufferModel;
            private Number audioFramesPerPes;
            private String audioPids;
            private String audioStreamType;
            private Number bitrate;
            private String bufferModel;
            private String ccDescriptor;
            private Object dvbNitSettings;
            private Object dvbSdtSettings;
            private String dvbSubPids;
            private Object dvbTdtSettings;
            private String dvbTeletextPid;
            private String ebif;
            private String ebpAudioInterval;
            private Number ebpLookaheadMs;
            private String ebpPlacement;
            private String ecmPid;
            private String esRateInPes;
            private String etvPlatformPid;
            private String etvSignalPid;
            private Number fragmentTime;
            private String klv;
            private String klvDataPids;
            private String nielsenId3Behavior;
            private Number nullPacketBitrate;
            private Number patInterval;
            private String pcrControl;
            private Number pcrPeriod;
            private String pcrPid;
            private Number pmtInterval;
            private String pmtPid;
            private Number programNum;
            private String rateMode;
            private String scte27Pids;
            private String scte35Control;
            private String scte35Pid;
            private String segmentationMarkers;
            private String segmentationStyle;
            private Number segmentationTime;
            private String timedMetadataBehavior;
            private String timedMetadataPid;
            private Number transportStreamId;
            private String videoPid;

            public Builder absentInputAudioBehavior(String absentInputAudioBehavior) {
                this.absentInputAudioBehavior = absentInputAudioBehavior;
                return this;
            }

            public Builder arib(String arib) {
                this.arib = arib;
                return this;
            }

            public Builder aribCaptionsPid(String aribCaptionsPid) {
                this.aribCaptionsPid = aribCaptionsPid;
                return this;
            }

            public Builder aribCaptionsPidControl(String aribCaptionsPidControl) {
                this.aribCaptionsPidControl = aribCaptionsPidControl;
                return this;
            }

            public Builder audioBufferModel(String audioBufferModel) {
                this.audioBufferModel = audioBufferModel;
                return this;
            }

            public Builder audioFramesPerPes(Number audioFramesPerPes) {
                this.audioFramesPerPes = audioFramesPerPes;
                return this;
            }

            public Builder audioPids(String audioPids) {
                this.audioPids = audioPids;
                return this;
            }

            public Builder audioStreamType(String audioStreamType) {
                this.audioStreamType = audioStreamType;
                return this;
            }

            public Builder bitrate(Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            public Builder bufferModel(String bufferModel) {
                this.bufferModel = bufferModel;
                return this;
            }

            public Builder ccDescriptor(String ccDescriptor) {
                this.ccDescriptor = ccDescriptor;
                return this;
            }

            public Builder dvbNitSettings(IResolvable dvbNitSettings) {
                this.dvbNitSettings = dvbNitSettings;
                return this;
            }

            public Builder dvbNitSettings(DvbNitSettingsProperty dvbNitSettings) {
                this.dvbNitSettings = dvbNitSettings;
                return this;
            }

            public Builder dvbSdtSettings(IResolvable dvbSdtSettings) {
                this.dvbSdtSettings = dvbSdtSettings;
                return this;
            }

            public Builder dvbSdtSettings(DvbSdtSettingsProperty dvbSdtSettings) {
                this.dvbSdtSettings = dvbSdtSettings;
                return this;
            }

            public Builder dvbSubPids(String dvbSubPids) {
                this.dvbSubPids = dvbSubPids;
                return this;
            }

            public Builder dvbTdtSettings(IResolvable dvbTdtSettings) {
                this.dvbTdtSettings = dvbTdtSettings;
                return this;
            }

            public Builder dvbTdtSettings(DvbTdtSettingsProperty dvbTdtSettings) {
                this.dvbTdtSettings = dvbTdtSettings;
                return this;
            }

            public Builder dvbTeletextPid(String dvbTeletextPid) {
                this.dvbTeletextPid = dvbTeletextPid;
                return this;
            }

            public Builder ebif(String ebif) {
                this.ebif = ebif;
                return this;
            }

            public Builder ebpAudioInterval(String ebpAudioInterval) {
                this.ebpAudioInterval = ebpAudioInterval;
                return this;
            }

            public Builder ebpLookaheadMs(Number ebpLookaheadMs) {
                this.ebpLookaheadMs = ebpLookaheadMs;
                return this;
            }

            public Builder ebpPlacement(String ebpPlacement) {
                this.ebpPlacement = ebpPlacement;
                return this;
            }

            public Builder ecmPid(String ecmPid) {
                this.ecmPid = ecmPid;
                return this;
            }

            public Builder esRateInPes(String esRateInPes) {
                this.esRateInPes = esRateInPes;
                return this;
            }

            public Builder etvPlatformPid(String etvPlatformPid) {
                this.etvPlatformPid = etvPlatformPid;
                return this;
            }

            public Builder etvSignalPid(String etvSignalPid) {
                this.etvSignalPid = etvSignalPid;
                return this;
            }

            public Builder fragmentTime(Number fragmentTime) {
                this.fragmentTime = fragmentTime;
                return this;
            }

            public Builder klv(String klv) {
                this.klv = klv;
                return this;
            }

            public Builder klvDataPids(String klvDataPids) {
                this.klvDataPids = klvDataPids;
                return this;
            }

            public Builder nielsenId3Behavior(String nielsenId3Behavior) {
                this.nielsenId3Behavior = nielsenId3Behavior;
                return this;
            }

            public Builder nullPacketBitrate(Number nullPacketBitrate) {
                this.nullPacketBitrate = nullPacketBitrate;
                return this;
            }

            public Builder patInterval(Number patInterval) {
                this.patInterval = patInterval;
                return this;
            }

            public Builder pcrControl(String pcrControl) {
                this.pcrControl = pcrControl;
                return this;
            }

            public Builder pcrPeriod(Number pcrPeriod) {
                this.pcrPeriod = pcrPeriod;
                return this;
            }

            public Builder pcrPid(String pcrPid) {
                this.pcrPid = pcrPid;
                return this;
            }

            public Builder pmtInterval(Number pmtInterval) {
                this.pmtInterval = pmtInterval;
                return this;
            }

            public Builder pmtPid(String pmtPid) {
                this.pmtPid = pmtPid;
                return this;
            }

            public Builder programNum(Number programNum) {
                this.programNum = programNum;
                return this;
            }

            public Builder rateMode(String rateMode) {
                this.rateMode = rateMode;
                return this;
            }

            public Builder scte27Pids(String scte27Pids) {
                this.scte27Pids = scte27Pids;
                return this;
            }

            public Builder scte35Control(String scte35Control) {
                this.scte35Control = scte35Control;
                return this;
            }

            public Builder scte35Pid(String scte35Pid) {
                this.scte35Pid = scte35Pid;
                return this;
            }

            public Builder segmentationMarkers(String segmentationMarkers) {
                this.segmentationMarkers = segmentationMarkers;
                return this;
            }

            public Builder segmentationStyle(String segmentationStyle) {
                this.segmentationStyle = segmentationStyle;
                return this;
            }

            public Builder segmentationTime(Number segmentationTime) {
                this.segmentationTime = segmentationTime;
                return this;
            }

            public Builder timedMetadataBehavior(String timedMetadataBehavior) {
                this.timedMetadataBehavior = timedMetadataBehavior;
                return this;
            }

            public Builder timedMetadataPid(String timedMetadataPid) {
                this.timedMetadataPid = timedMetadataPid;
                return this;
            }

            public Builder transportStreamId(Number transportStreamId) {
                this.transportStreamId = transportStreamId;
                return this;
            }

            public Builder videoPid(String videoPid) {
                this.videoPid = videoPid;
                return this;
            }

            public M2tsSettingsProperty build() {
                return new Jsii.Proxy(this.absentInputAudioBehavior, this.arib, this.aribCaptionsPid, this.aribCaptionsPidControl, this.audioBufferModel, this.audioFramesPerPes, this.audioPids, this.audioStreamType, this.bitrate, this.bufferModel, this.ccDescriptor, this.dvbNitSettings, this.dvbSdtSettings, this.dvbSubPids, this.dvbTdtSettings, this.dvbTeletextPid, this.ebif, this.ebpAudioInterval, this.ebpLookaheadMs, this.ebpPlacement, this.ecmPid, this.esRateInPes, this.etvPlatformPid, this.etvSignalPid, this.fragmentTime, this.klv, this.klvDataPids, this.nielsenId3Behavior, this.nullPacketBitrate, this.patInterval, this.pcrControl, this.pcrPeriod, this.pcrPid, this.pmtInterval, this.pmtPid, this.programNum, this.rateMode, this.scte27Pids, this.scte35Control, this.scte35Pid, this.segmentationMarkers, this.segmentationStyle, this.segmentationTime, this.timedMetadataBehavior, this.timedMetadataPid, this.transportStreamId, this.videoPid);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.KeyProviderSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeyProviderSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getStaticKeySettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KeyProviderSettingsProperty> {
            private Object staticKeySettings;

            public Builder staticKeySettings(IResolvable staticKeySettings) {
                this.staticKeySettings = staticKeySettings;
                return this;
            }

            public Builder staticKeySettings(StaticKeySettingsProperty staticKeySettings) {
                this.staticKeySettings = staticKeySettings;
                return this;
            }

            public KeyProviderSettingsProperty build() {
                return new Jsii.Proxy(this.staticKeySettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.InputSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCodec() {
            return null;
        }

        @Nullable
        default public String getMaximumBitrate() {
            return null;
        }

        @Nullable
        default public String getResolution() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputSpecificationProperty> {
            private String codec;
            private String maximumBitrate;
            private String resolution;

            public Builder codec(String codec) {
                this.codec = codec;
                return this;
            }

            public Builder maximumBitrate(String maximumBitrate) {
                this.maximumBitrate = maximumBitrate;
                return this;
            }

            public Builder resolution(String resolution) {
                this.resolution = resolution;
                return this;
            }

            public InputSpecificationProperty build() {
                return new Jsii.Proxy(this.codec, this.maximumBitrate, this.resolution);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.InputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAudioSelectors() {
            return null;
        }

        @Nullable
        default public Object getCaptionSelectors() {
            return null;
        }

        @Nullable
        default public String getDeblockFilter() {
            return null;
        }

        @Nullable
        default public String getDenoiseFilter() {
            return null;
        }

        @Nullable
        default public Number getFilterStrength() {
            return null;
        }

        @Nullable
        default public String getInputFilter() {
            return null;
        }

        @Nullable
        default public Object getNetworkInputSettings() {
            return null;
        }

        @Nullable
        default public String getSmpte2038DataPreference() {
            return null;
        }

        @Nullable
        default public String getSourceEndBehavior() {
            return null;
        }

        @Nullable
        default public Object getVideoSelector() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputSettingsProperty> {
            private Object audioSelectors;
            private Object captionSelectors;
            private String deblockFilter;
            private String denoiseFilter;
            private Number filterStrength;
            private String inputFilter;
            private Object networkInputSettings;
            private String smpte2038DataPreference;
            private String sourceEndBehavior;
            private Object videoSelector;

            public Builder audioSelectors(IResolvable audioSelectors) {
                this.audioSelectors = audioSelectors;
                return this;
            }

            public Builder audioSelectors(List<? extends Object> audioSelectors) {
                this.audioSelectors = audioSelectors;
                return this;
            }

            public Builder captionSelectors(IResolvable captionSelectors) {
                this.captionSelectors = captionSelectors;
                return this;
            }

            public Builder captionSelectors(List<? extends Object> captionSelectors) {
                this.captionSelectors = captionSelectors;
                return this;
            }

            public Builder deblockFilter(String deblockFilter) {
                this.deblockFilter = deblockFilter;
                return this;
            }

            public Builder denoiseFilter(String denoiseFilter) {
                this.denoiseFilter = denoiseFilter;
                return this;
            }

            public Builder filterStrength(Number filterStrength) {
                this.filterStrength = filterStrength;
                return this;
            }

            public Builder inputFilter(String inputFilter) {
                this.inputFilter = inputFilter;
                return this;
            }

            public Builder networkInputSettings(IResolvable networkInputSettings) {
                this.networkInputSettings = networkInputSettings;
                return this;
            }

            public Builder networkInputSettings(NetworkInputSettingsProperty networkInputSettings) {
                this.networkInputSettings = networkInputSettings;
                return this;
            }

            public Builder smpte2038DataPreference(String smpte2038DataPreference) {
                this.smpte2038DataPreference = smpte2038DataPreference;
                return this;
            }

            public Builder sourceEndBehavior(String sourceEndBehavior) {
                this.sourceEndBehavior = sourceEndBehavior;
                return this;
            }

            public Builder videoSelector(IResolvable videoSelector) {
                this.videoSelector = videoSelector;
                return this;
            }

            public Builder videoSelector(VideoSelectorProperty videoSelector) {
                this.videoSelector = videoSelector;
                return this;
            }

            public InputSettingsProperty build() {
                return new Jsii.Proxy(this.audioSelectors, this.captionSelectors, this.deblockFilter, this.denoiseFilter, this.filterStrength, this.inputFilter, this.networkInputSettings, this.smpte2038DataPreference, this.sourceEndBehavior, this.videoSelector);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.InputLossFailoverSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputLossFailoverSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getInputLossThresholdMsec() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputLossFailoverSettingsProperty> {
            private Number inputLossThresholdMsec;

            public Builder inputLossThresholdMsec(Number inputLossThresholdMsec) {
                this.inputLossThresholdMsec = inputLossThresholdMsec;
                return this;
            }

            public InputLossFailoverSettingsProperty build() {
                return new Jsii.Proxy(this.inputLossThresholdMsec);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.InputLossBehaviorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputLossBehaviorProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBlackFrameMsec() {
            return null;
        }

        @Nullable
        default public String getInputLossImageColor() {
            return null;
        }

        @Nullable
        default public Object getInputLossImageSlate() {
            return null;
        }

        @Nullable
        default public String getInputLossImageType() {
            return null;
        }

        @Nullable
        default public Number getRepeatFrameMsec() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputLossBehaviorProperty> {
            private Number blackFrameMsec;
            private String inputLossImageColor;
            private Object inputLossImageSlate;
            private String inputLossImageType;
            private Number repeatFrameMsec;

            public Builder blackFrameMsec(Number blackFrameMsec) {
                this.blackFrameMsec = blackFrameMsec;
                return this;
            }

            public Builder inputLossImageColor(String inputLossImageColor) {
                this.inputLossImageColor = inputLossImageColor;
                return this;
            }

            public Builder inputLossImageSlate(IResolvable inputLossImageSlate) {
                this.inputLossImageSlate = inputLossImageSlate;
                return this;
            }

            public Builder inputLossImageSlate(InputLocationProperty inputLossImageSlate) {
                this.inputLossImageSlate = inputLossImageSlate;
                return this;
            }

            public Builder inputLossImageType(String inputLossImageType) {
                this.inputLossImageType = inputLossImageType;
                return this;
            }

            public Builder repeatFrameMsec(Number repeatFrameMsec) {
                this.repeatFrameMsec = repeatFrameMsec;
                return this;
            }

            public InputLossBehaviorProperty build() {
                return new Jsii.Proxy(this.blackFrameMsec, this.inputLossImageColor, this.inputLossImageSlate, this.inputLossImageType, this.repeatFrameMsec);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.InputLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPasswordParam() {
            return null;
        }

        @Nullable
        default public String getUri() {
            return null;
        }

        @Nullable
        default public String getUsername() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputLocationProperty> {
            private String passwordParam;
            private String uri;
            private String username;

            public Builder passwordParam(String passwordParam) {
                this.passwordParam = passwordParam;
                return this;
            }

            public Builder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public InputLocationProperty build() {
                return new Jsii.Proxy(this.passwordParam, this.uri, this.username);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.InputChannelLevelProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputChannelLevelProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getGain() {
            return null;
        }

        @Nullable
        default public Number getInputChannel() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputChannelLevelProperty> {
            private Number gain;
            private Number inputChannel;

            public Builder gain(Number gain) {
                this.gain = gain;
                return this;
            }

            public Builder inputChannel(Number inputChannel) {
                this.inputChannel = inputChannel;
                return this;
            }

            public InputChannelLevelProperty build() {
                return new Jsii.Proxy(this.gain, this.inputChannel);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.InputAttachmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputAttachmentProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAutomaticInputFailoverSettings() {
            return null;
        }

        @Nullable
        default public String getInputAttachmentName() {
            return null;
        }

        @Nullable
        default public String getInputId() {
            return null;
        }

        @Nullable
        default public Object getInputSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputAttachmentProperty> {
            private Object automaticInputFailoverSettings;
            private String inputAttachmentName;
            private String inputId;
            private Object inputSettings;

            public Builder automaticInputFailoverSettings(IResolvable automaticInputFailoverSettings) {
                this.automaticInputFailoverSettings = automaticInputFailoverSettings;
                return this;
            }

            public Builder automaticInputFailoverSettings(AutomaticInputFailoverSettingsProperty automaticInputFailoverSettings) {
                this.automaticInputFailoverSettings = automaticInputFailoverSettings;
                return this;
            }

            public Builder inputAttachmentName(String inputAttachmentName) {
                this.inputAttachmentName = inputAttachmentName;
                return this;
            }

            public Builder inputId(String inputId) {
                this.inputId = inputId;
                return this;
            }

            public Builder inputSettings(IResolvable inputSettings) {
                this.inputSettings = inputSettings;
                return this;
            }

            public Builder inputSettings(InputSettingsProperty inputSettings) {
                this.inputSettings = inputSettings;
                return this;
            }

            public InputAttachmentProperty build() {
                return new Jsii.Proxy(this.automaticInputFailoverSettings, this.inputAttachmentName, this.inputId, this.inputSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.HlsWebdavSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HlsWebdavSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getConnectionRetryInterval() {
            return null;
        }

        @Nullable
        default public Number getFilecacheDuration() {
            return null;
        }

        @Nullable
        default public String getHttpTransferMode() {
            return null;
        }

        @Nullable
        default public Number getNumRetries() {
            return null;
        }

        @Nullable
        default public Number getRestartDelay() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HlsWebdavSettingsProperty> {
            private Number connectionRetryInterval;
            private Number filecacheDuration;
            private String httpTransferMode;
            private Number numRetries;
            private Number restartDelay;

            public Builder connectionRetryInterval(Number connectionRetryInterval) {
                this.connectionRetryInterval = connectionRetryInterval;
                return this;
            }

            public Builder filecacheDuration(Number filecacheDuration) {
                this.filecacheDuration = filecacheDuration;
                return this;
            }

            public Builder httpTransferMode(String httpTransferMode) {
                this.httpTransferMode = httpTransferMode;
                return this;
            }

            public Builder numRetries(Number numRetries) {
                this.numRetries = numRetries;
                return this;
            }

            public Builder restartDelay(Number restartDelay) {
                this.restartDelay = restartDelay;
                return this;
            }

            public HlsWebdavSettingsProperty build() {
                return new Jsii.Proxy(this.connectionRetryInterval, this.filecacheDuration, this.httpTransferMode, this.numRetries, this.restartDelay);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.HlsSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HlsSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAudioOnlyHlsSettings() {
            return null;
        }

        @Nullable
        default public Object getFmp4HlsSettings() {
            return null;
        }

        @Nullable
        default public Object getStandardHlsSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HlsSettingsProperty> {
            private Object audioOnlyHlsSettings;
            private Object fmp4HlsSettings;
            private Object standardHlsSettings;

            public Builder audioOnlyHlsSettings(IResolvable audioOnlyHlsSettings) {
                this.audioOnlyHlsSettings = audioOnlyHlsSettings;
                return this;
            }

            public Builder audioOnlyHlsSettings(AudioOnlyHlsSettingsProperty audioOnlyHlsSettings) {
                this.audioOnlyHlsSettings = audioOnlyHlsSettings;
                return this;
            }

            public Builder fmp4HlsSettings(IResolvable fmp4HlsSettings) {
                this.fmp4HlsSettings = fmp4HlsSettings;
                return this;
            }

            public Builder fmp4HlsSettings(Fmp4HlsSettingsProperty fmp4HlsSettings) {
                this.fmp4HlsSettings = fmp4HlsSettings;
                return this;
            }

            public Builder standardHlsSettings(IResolvable standardHlsSettings) {
                this.standardHlsSettings = standardHlsSettings;
                return this;
            }

            public Builder standardHlsSettings(StandardHlsSettingsProperty standardHlsSettings) {
                this.standardHlsSettings = standardHlsSettings;
                return this;
            }

            public HlsSettingsProperty build() {
                return new Jsii.Proxy(this.audioOnlyHlsSettings, this.fmp4HlsSettings, this.standardHlsSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.HlsOutputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HlsOutputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getH265PackagingType() {
            return null;
        }

        @Nullable
        default public Object getHlsSettings() {
            return null;
        }

        @Nullable
        default public String getNameModifier() {
            return null;
        }

        @Nullable
        default public String getSegmentModifier() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HlsOutputSettingsProperty> {
            private String h265PackagingType;
            private Object hlsSettings;
            private String nameModifier;
            private String segmentModifier;

            public Builder h265PackagingType(String h265PackagingType) {
                this.h265PackagingType = h265PackagingType;
                return this;
            }

            public Builder hlsSettings(IResolvable hlsSettings) {
                this.hlsSettings = hlsSettings;
                return this;
            }

            public Builder hlsSettings(HlsSettingsProperty hlsSettings) {
                this.hlsSettings = hlsSettings;
                return this;
            }

            public Builder nameModifier(String nameModifier) {
                this.nameModifier = nameModifier;
                return this;
            }

            public Builder segmentModifier(String segmentModifier) {
                this.segmentModifier = segmentModifier;
                return this;
            }

            public HlsOutputSettingsProperty build() {
                return new Jsii.Proxy(this.h265PackagingType, this.hlsSettings, this.nameModifier, this.segmentModifier);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.HlsMediaStoreSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HlsMediaStoreSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getConnectionRetryInterval() {
            return null;
        }

        @Nullable
        default public Number getFilecacheDuration() {
            return null;
        }

        @Nullable
        default public String getMediaStoreStorageClass() {
            return null;
        }

        @Nullable
        default public Number getNumRetries() {
            return null;
        }

        @Nullable
        default public Number getRestartDelay() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HlsMediaStoreSettingsProperty> {
            private Number connectionRetryInterval;
            private Number filecacheDuration;
            private String mediaStoreStorageClass;
            private Number numRetries;
            private Number restartDelay;

            public Builder connectionRetryInterval(Number connectionRetryInterval) {
                this.connectionRetryInterval = connectionRetryInterval;
                return this;
            }

            public Builder filecacheDuration(Number filecacheDuration) {
                this.filecacheDuration = filecacheDuration;
                return this;
            }

            public Builder mediaStoreStorageClass(String mediaStoreStorageClass) {
                this.mediaStoreStorageClass = mediaStoreStorageClass;
                return this;
            }

            public Builder numRetries(Number numRetries) {
                this.numRetries = numRetries;
                return this;
            }

            public Builder restartDelay(Number restartDelay) {
                this.restartDelay = restartDelay;
                return this;
            }

            public HlsMediaStoreSettingsProperty build() {
                return new Jsii.Proxy(this.connectionRetryInterval, this.filecacheDuration, this.mediaStoreStorageClass, this.numRetries, this.restartDelay);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.HlsInputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HlsInputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBandwidth() {
            return null;
        }

        @Nullable
        default public Number getBufferSegments() {
            return null;
        }

        @Nullable
        default public Number getRetries() {
            return null;
        }

        @Nullable
        default public Number getRetryInterval() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HlsInputSettingsProperty> {
            private Number bandwidth;
            private Number bufferSegments;
            private Number retries;
            private Number retryInterval;

            public Builder bandwidth(Number bandwidth) {
                this.bandwidth = bandwidth;
                return this;
            }

            public Builder bufferSegments(Number bufferSegments) {
                this.bufferSegments = bufferSegments;
                return this;
            }

            public Builder retries(Number retries) {
                this.retries = retries;
                return this;
            }

            public Builder retryInterval(Number retryInterval) {
                this.retryInterval = retryInterval;
                return this;
            }

            public HlsInputSettingsProperty build() {
                return new Jsii.Proxy(this.bandwidth, this.bufferSegments, this.retries, this.retryInterval);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.HlsGroupSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HlsGroupSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAdMarkers() {
            return null;
        }

        @Nullable
        default public String getBaseUrlContent() {
            return null;
        }

        @Nullable
        default public String getBaseUrlContent1() {
            return null;
        }

        @Nullable
        default public String getBaseUrlManifest() {
            return null;
        }

        @Nullable
        default public String getBaseUrlManifest1() {
            return null;
        }

        @Nullable
        default public Object getCaptionLanguageMappings() {
            return null;
        }

        @Nullable
        default public String getCaptionLanguageSetting() {
            return null;
        }

        @Nullable
        default public String getClientCache() {
            return null;
        }

        @Nullable
        default public String getCodecSpecification() {
            return null;
        }

        @Nullable
        default public String getConstantIv() {
            return null;
        }

        @Nullable
        default public Object getDestination() {
            return null;
        }

        @Nullable
        default public String getDirectoryStructure() {
            return null;
        }

        @Nullable
        default public String getDiscontinuityTags() {
            return null;
        }

        @Nullable
        default public String getEncryptionType() {
            return null;
        }

        @Nullable
        default public Object getHlsCdnSettings() {
            return null;
        }

        @Nullable
        default public String getHlsId3SegmentTagging() {
            return null;
        }

        @Nullable
        default public String getIFrameOnlyPlaylists() {
            return null;
        }

        @Nullable
        default public String getIncompleteSegmentBehavior() {
            return null;
        }

        @Nullable
        default public Number getIndexNSegments() {
            return null;
        }

        @Nullable
        default public String getInputLossAction() {
            return null;
        }

        @Nullable
        default public String getIvInManifest() {
            return null;
        }

        @Nullable
        default public String getIvSource() {
            return null;
        }

        @Nullable
        default public Number getKeepSegments() {
            return null;
        }

        @Nullable
        default public String getKeyFormat() {
            return null;
        }

        @Nullable
        default public String getKeyFormatVersions() {
            return null;
        }

        @Nullable
        default public Object getKeyProviderSettings() {
            return null;
        }

        @Nullable
        default public String getManifestCompression() {
            return null;
        }

        @Nullable
        default public String getManifestDurationFormat() {
            return null;
        }

        @Nullable
        default public Number getMinSegmentLength() {
            return null;
        }

        @Nullable
        default public String getMode() {
            return null;
        }

        @Nullable
        default public String getOutputSelection() {
            return null;
        }

        @Nullable
        default public String getProgramDateTime() {
            return null;
        }

        @Nullable
        default public Number getProgramDateTimePeriod() {
            return null;
        }

        @Nullable
        default public String getRedundantManifest() {
            return null;
        }

        @Nullable
        default public String getSegmentationMode() {
            return null;
        }

        @Nullable
        default public Number getSegmentLength() {
            return null;
        }

        @Nullable
        default public Number getSegmentsPerSubdirectory() {
            return null;
        }

        @Nullable
        default public String getStreamInfResolution() {
            return null;
        }

        @Nullable
        default public String getTimedMetadataId3Frame() {
            return null;
        }

        @Nullable
        default public Number getTimedMetadataId3Period() {
            return null;
        }

        @Nullable
        default public Number getTimestampDeltaMilliseconds() {
            return null;
        }

        @Nullable
        default public String getTsFileMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HlsGroupSettingsProperty> {
            private List<String> adMarkers;
            private String baseUrlContent;
            private String baseUrlContent1;
            private String baseUrlManifest;
            private String baseUrlManifest1;
            private Object captionLanguageMappings;
            private String captionLanguageSetting;
            private String clientCache;
            private String codecSpecification;
            private String constantIv;
            private Object destination;
            private String directoryStructure;
            private String discontinuityTags;
            private String encryptionType;
            private Object hlsCdnSettings;
            private String hlsId3SegmentTagging;
            private String iFrameOnlyPlaylists;
            private String incompleteSegmentBehavior;
            private Number indexNSegments;
            private String inputLossAction;
            private String ivInManifest;
            private String ivSource;
            private Number keepSegments;
            private String keyFormat;
            private String keyFormatVersions;
            private Object keyProviderSettings;
            private String manifestCompression;
            private String manifestDurationFormat;
            private Number minSegmentLength;
            private String mode;
            private String outputSelection;
            private String programDateTime;
            private Number programDateTimePeriod;
            private String redundantManifest;
            private String segmentationMode;
            private Number segmentLength;
            private Number segmentsPerSubdirectory;
            private String streamInfResolution;
            private String timedMetadataId3Frame;
            private Number timedMetadataId3Period;
            private Number timestampDeltaMilliseconds;
            private String tsFileMode;

            public Builder adMarkers(List<String> adMarkers) {
                this.adMarkers = adMarkers;
                return this;
            }

            public Builder baseUrlContent(String baseUrlContent) {
                this.baseUrlContent = baseUrlContent;
                return this;
            }

            public Builder baseUrlContent1(String baseUrlContent1) {
                this.baseUrlContent1 = baseUrlContent1;
                return this;
            }

            public Builder baseUrlManifest(String baseUrlManifest) {
                this.baseUrlManifest = baseUrlManifest;
                return this;
            }

            public Builder baseUrlManifest1(String baseUrlManifest1) {
                this.baseUrlManifest1 = baseUrlManifest1;
                return this;
            }

            public Builder captionLanguageMappings(IResolvable captionLanguageMappings) {
                this.captionLanguageMappings = captionLanguageMappings;
                return this;
            }

            public Builder captionLanguageMappings(List<? extends Object> captionLanguageMappings) {
                this.captionLanguageMappings = captionLanguageMappings;
                return this;
            }

            public Builder captionLanguageSetting(String captionLanguageSetting) {
                this.captionLanguageSetting = captionLanguageSetting;
                return this;
            }

            public Builder clientCache(String clientCache) {
                this.clientCache = clientCache;
                return this;
            }

            public Builder codecSpecification(String codecSpecification) {
                this.codecSpecification = codecSpecification;
                return this;
            }

            public Builder constantIv(String constantIv) {
                this.constantIv = constantIv;
                return this;
            }

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder directoryStructure(String directoryStructure) {
                this.directoryStructure = directoryStructure;
                return this;
            }

            public Builder discontinuityTags(String discontinuityTags) {
                this.discontinuityTags = discontinuityTags;
                return this;
            }

            public Builder encryptionType(String encryptionType) {
                this.encryptionType = encryptionType;
                return this;
            }

            public Builder hlsCdnSettings(IResolvable hlsCdnSettings) {
                this.hlsCdnSettings = hlsCdnSettings;
                return this;
            }

            public Builder hlsCdnSettings(HlsCdnSettingsProperty hlsCdnSettings) {
                this.hlsCdnSettings = hlsCdnSettings;
                return this;
            }

            public Builder hlsId3SegmentTagging(String hlsId3SegmentTagging) {
                this.hlsId3SegmentTagging = hlsId3SegmentTagging;
                return this;
            }

            public Builder iFrameOnlyPlaylists(String iFrameOnlyPlaylists) {
                this.iFrameOnlyPlaylists = iFrameOnlyPlaylists;
                return this;
            }

            public Builder incompleteSegmentBehavior(String incompleteSegmentBehavior) {
                this.incompleteSegmentBehavior = incompleteSegmentBehavior;
                return this;
            }

            public Builder indexNSegments(Number indexNSegments) {
                this.indexNSegments = indexNSegments;
                return this;
            }

            public Builder inputLossAction(String inputLossAction) {
                this.inputLossAction = inputLossAction;
                return this;
            }

            public Builder ivInManifest(String ivInManifest) {
                this.ivInManifest = ivInManifest;
                return this;
            }

            public Builder ivSource(String ivSource) {
                this.ivSource = ivSource;
                return this;
            }

            public Builder keepSegments(Number keepSegments) {
                this.keepSegments = keepSegments;
                return this;
            }

            public Builder keyFormat(String keyFormat) {
                this.keyFormat = keyFormat;
                return this;
            }

            public Builder keyFormatVersions(String keyFormatVersions) {
                this.keyFormatVersions = keyFormatVersions;
                return this;
            }

            public Builder keyProviderSettings(IResolvable keyProviderSettings) {
                this.keyProviderSettings = keyProviderSettings;
                return this;
            }

            public Builder keyProviderSettings(KeyProviderSettingsProperty keyProviderSettings) {
                this.keyProviderSettings = keyProviderSettings;
                return this;
            }

            public Builder manifestCompression(String manifestCompression) {
                this.manifestCompression = manifestCompression;
                return this;
            }

            public Builder manifestDurationFormat(String manifestDurationFormat) {
                this.manifestDurationFormat = manifestDurationFormat;
                return this;
            }

            public Builder minSegmentLength(Number minSegmentLength) {
                this.minSegmentLength = minSegmentLength;
                return this;
            }

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder outputSelection(String outputSelection) {
                this.outputSelection = outputSelection;
                return this;
            }

            public Builder programDateTime(String programDateTime) {
                this.programDateTime = programDateTime;
                return this;
            }

            public Builder programDateTimePeriod(Number programDateTimePeriod) {
                this.programDateTimePeriod = programDateTimePeriod;
                return this;
            }

            public Builder redundantManifest(String redundantManifest) {
                this.redundantManifest = redundantManifest;
                return this;
            }

            public Builder segmentationMode(String segmentationMode) {
                this.segmentationMode = segmentationMode;
                return this;
            }

            public Builder segmentLength(Number segmentLength) {
                this.segmentLength = segmentLength;
                return this;
            }

            public Builder segmentsPerSubdirectory(Number segmentsPerSubdirectory) {
                this.segmentsPerSubdirectory = segmentsPerSubdirectory;
                return this;
            }

            public Builder streamInfResolution(String streamInfResolution) {
                this.streamInfResolution = streamInfResolution;
                return this;
            }

            public Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
                this.timedMetadataId3Frame = timedMetadataId3Frame;
                return this;
            }

            public Builder timedMetadataId3Period(Number timedMetadataId3Period) {
                this.timedMetadataId3Period = timedMetadataId3Period;
                return this;
            }

            public Builder timestampDeltaMilliseconds(Number timestampDeltaMilliseconds) {
                this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
                return this;
            }

            public Builder tsFileMode(String tsFileMode) {
                this.tsFileMode = tsFileMode;
                return this;
            }

            public HlsGroupSettingsProperty build() {
                return new Jsii.Proxy(this.adMarkers, this.baseUrlContent, this.baseUrlContent1, this.baseUrlManifest, this.baseUrlManifest1, this.captionLanguageMappings, this.captionLanguageSetting, this.clientCache, this.codecSpecification, this.constantIv, this.destination, this.directoryStructure, this.discontinuityTags, this.encryptionType, this.hlsCdnSettings, this.hlsId3SegmentTagging, this.iFrameOnlyPlaylists, this.incompleteSegmentBehavior, this.indexNSegments, this.inputLossAction, this.ivInManifest, this.ivSource, this.keepSegments, this.keyFormat, this.keyFormatVersions, this.keyProviderSettings, this.manifestCompression, this.manifestDurationFormat, this.minSegmentLength, this.mode, this.outputSelection, this.programDateTime, this.programDateTimePeriod, this.redundantManifest, this.segmentationMode, this.segmentLength, this.segmentsPerSubdirectory, this.streamInfResolution, this.timedMetadataId3Frame, this.timedMetadataId3Period, this.timestampDeltaMilliseconds, this.tsFileMode);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.HlsCdnSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HlsCdnSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getHlsAkamaiSettings() {
            return null;
        }

        @Nullable
        default public Object getHlsBasicPutSettings() {
            return null;
        }

        @Nullable
        default public Object getHlsMediaStoreSettings() {
            return null;
        }

        @Nullable
        default public Object getHlsWebdavSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HlsCdnSettingsProperty> {
            private Object hlsAkamaiSettings;
            private Object hlsBasicPutSettings;
            private Object hlsMediaStoreSettings;
            private Object hlsWebdavSettings;

            public Builder hlsAkamaiSettings(IResolvable hlsAkamaiSettings) {
                this.hlsAkamaiSettings = hlsAkamaiSettings;
                return this;
            }

            public Builder hlsAkamaiSettings(HlsAkamaiSettingsProperty hlsAkamaiSettings) {
                this.hlsAkamaiSettings = hlsAkamaiSettings;
                return this;
            }

            public Builder hlsBasicPutSettings(IResolvable hlsBasicPutSettings) {
                this.hlsBasicPutSettings = hlsBasicPutSettings;
                return this;
            }

            public Builder hlsBasicPutSettings(HlsBasicPutSettingsProperty hlsBasicPutSettings) {
                this.hlsBasicPutSettings = hlsBasicPutSettings;
                return this;
            }

            public Builder hlsMediaStoreSettings(IResolvable hlsMediaStoreSettings) {
                this.hlsMediaStoreSettings = hlsMediaStoreSettings;
                return this;
            }

            public Builder hlsMediaStoreSettings(HlsMediaStoreSettingsProperty hlsMediaStoreSettings) {
                this.hlsMediaStoreSettings = hlsMediaStoreSettings;
                return this;
            }

            public Builder hlsWebdavSettings(IResolvable hlsWebdavSettings) {
                this.hlsWebdavSettings = hlsWebdavSettings;
                return this;
            }

            public Builder hlsWebdavSettings(HlsWebdavSettingsProperty hlsWebdavSettings) {
                this.hlsWebdavSettings = hlsWebdavSettings;
                return this;
            }

            public HlsCdnSettingsProperty build() {
                return new Jsii.Proxy(this.hlsAkamaiSettings, this.hlsBasicPutSettings, this.hlsMediaStoreSettings, this.hlsWebdavSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.HlsBasicPutSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HlsBasicPutSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getConnectionRetryInterval() {
            return null;
        }

        @Nullable
        default public Number getFilecacheDuration() {
            return null;
        }

        @Nullable
        default public Number getNumRetries() {
            return null;
        }

        @Nullable
        default public Number getRestartDelay() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HlsBasicPutSettingsProperty> {
            private Number connectionRetryInterval;
            private Number filecacheDuration;
            private Number numRetries;
            private Number restartDelay;

            public Builder connectionRetryInterval(Number connectionRetryInterval) {
                this.connectionRetryInterval = connectionRetryInterval;
                return this;
            }

            public Builder filecacheDuration(Number filecacheDuration) {
                this.filecacheDuration = filecacheDuration;
                return this;
            }

            public Builder numRetries(Number numRetries) {
                this.numRetries = numRetries;
                return this;
            }

            public Builder restartDelay(Number restartDelay) {
                this.restartDelay = restartDelay;
                return this;
            }

            public HlsBasicPutSettingsProperty build() {
                return new Jsii.Proxy(this.connectionRetryInterval, this.filecacheDuration, this.numRetries, this.restartDelay);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.HlsAkamaiSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HlsAkamaiSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getConnectionRetryInterval() {
            return null;
        }

        @Nullable
        default public Number getFilecacheDuration() {
            return null;
        }

        @Nullable
        default public String getHttpTransferMode() {
            return null;
        }

        @Nullable
        default public Number getNumRetries() {
            return null;
        }

        @Nullable
        default public Number getRestartDelay() {
            return null;
        }

        @Nullable
        default public String getSalt() {
            return null;
        }

        @Nullable
        default public String getToken() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HlsAkamaiSettingsProperty> {
            private Number connectionRetryInterval;
            private Number filecacheDuration;
            private String httpTransferMode;
            private Number numRetries;
            private Number restartDelay;
            private String salt;
            private String token;

            public Builder connectionRetryInterval(Number connectionRetryInterval) {
                this.connectionRetryInterval = connectionRetryInterval;
                return this;
            }

            public Builder filecacheDuration(Number filecacheDuration) {
                this.filecacheDuration = filecacheDuration;
                return this;
            }

            public Builder httpTransferMode(String httpTransferMode) {
                this.httpTransferMode = httpTransferMode;
                return this;
            }

            public Builder numRetries(Number numRetries) {
                this.numRetries = numRetries;
                return this;
            }

            public Builder restartDelay(Number restartDelay) {
                this.restartDelay = restartDelay;
                return this;
            }

            public Builder salt(String salt) {
                this.salt = salt;
                return this;
            }

            public Builder token(String token) {
                this.token = token;
                return this;
            }

            public HlsAkamaiSettingsProperty build() {
                return new Jsii.Proxy(this.connectionRetryInterval, this.filecacheDuration, this.httpTransferMode, this.numRetries, this.restartDelay, this.salt, this.token);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Hdr10SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Hdr10SettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMaxCll() {
            return null;
        }

        @Nullable
        default public Number getMaxFall() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Hdr10SettingsProperty> {
            private Number maxCll;
            private Number maxFall;

            public Builder maxCll(Number maxCll) {
                this.maxCll = maxCll;
                return this;
            }

            public Builder maxFall(Number maxFall) {
                this.maxFall = maxFall;
                return this;
            }

            public Hdr10SettingsProperty build() {
                return new Jsii.Proxy(this.maxCll, this.maxFall);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.H265SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface H265SettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAdaptiveQuantization() {
            return null;
        }

        @Nullable
        default public String getAfdSignaling() {
            return null;
        }

        @Nullable
        default public String getAlternativeTransferFunction() {
            return null;
        }

        @Nullable
        default public Number getBitrate() {
            return null;
        }

        @Nullable
        default public Number getBufSize() {
            return null;
        }

        @Nullable
        default public String getColorMetadata() {
            return null;
        }

        @Nullable
        default public Object getColorSpaceSettings() {
            return null;
        }

        @Nullable
        default public Object getFilterSettings() {
            return null;
        }

        @Nullable
        default public String getFixedAfd() {
            return null;
        }

        @Nullable
        default public String getFlickerAq() {
            return null;
        }

        @Nullable
        default public Number getFramerateDenominator() {
            return null;
        }

        @Nullable
        default public Number getFramerateNumerator() {
            return null;
        }

        @Nullable
        default public Number getGopClosedCadence() {
            return null;
        }

        @Nullable
        default public Number getGopSize() {
            return null;
        }

        @Nullable
        default public String getGopSizeUnits() {
            return null;
        }

        @Nullable
        default public String getLevel() {
            return null;
        }

        @Nullable
        default public String getLookAheadRateControl() {
            return null;
        }

        @Nullable
        default public Number getMaxBitrate() {
            return null;
        }

        @Nullable
        default public Number getMinIInterval() {
            return null;
        }

        @Nullable
        default public Number getParDenominator() {
            return null;
        }

        @Nullable
        default public Number getParNumerator() {
            return null;
        }

        @Nullable
        default public String getProfile() {
            return null;
        }

        @Nullable
        default public Number getQvbrQualityLevel() {
            return null;
        }

        @Nullable
        default public String getRateControlMode() {
            return null;
        }

        @Nullable
        default public String getScanType() {
            return null;
        }

        @Nullable
        default public String getSceneChangeDetect() {
            return null;
        }

        @Nullable
        default public Number getSlices() {
            return null;
        }

        @Nullable
        default public String getTier() {
            return null;
        }

        @Nullable
        default public String getTimecodeInsertion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<H265SettingsProperty> {
            private String adaptiveQuantization;
            private String afdSignaling;
            private String alternativeTransferFunction;
            private Number bitrate;
            private Number bufSize;
            private String colorMetadata;
            private Object colorSpaceSettings;
            private Object filterSettings;
            private String fixedAfd;
            private String flickerAq;
            private Number framerateDenominator;
            private Number framerateNumerator;
            private Number gopClosedCadence;
            private Number gopSize;
            private String gopSizeUnits;
            private String level;
            private String lookAheadRateControl;
            private Number maxBitrate;
            private Number minIInterval;
            private Number parDenominator;
            private Number parNumerator;
            private String profile;
            private Number qvbrQualityLevel;
            private String rateControlMode;
            private String scanType;
            private String sceneChangeDetect;
            private Number slices;
            private String tier;
            private String timecodeInsertion;

            public Builder adaptiveQuantization(String adaptiveQuantization) {
                this.adaptiveQuantization = adaptiveQuantization;
                return this;
            }

            public Builder afdSignaling(String afdSignaling) {
                this.afdSignaling = afdSignaling;
                return this;
            }

            public Builder alternativeTransferFunction(String alternativeTransferFunction) {
                this.alternativeTransferFunction = alternativeTransferFunction;
                return this;
            }

            public Builder bitrate(Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            public Builder bufSize(Number bufSize) {
                this.bufSize = bufSize;
                return this;
            }

            public Builder colorMetadata(String colorMetadata) {
                this.colorMetadata = colorMetadata;
                return this;
            }

            public Builder colorSpaceSettings(IResolvable colorSpaceSettings) {
                this.colorSpaceSettings = colorSpaceSettings;
                return this;
            }

            public Builder colorSpaceSettings(H265ColorSpaceSettingsProperty colorSpaceSettings) {
                this.colorSpaceSettings = colorSpaceSettings;
                return this;
            }

            public Builder filterSettings(IResolvable filterSettings) {
                this.filterSettings = filterSettings;
                return this;
            }

            public Builder filterSettings(H265FilterSettingsProperty filterSettings) {
                this.filterSettings = filterSettings;
                return this;
            }

            public Builder fixedAfd(String fixedAfd) {
                this.fixedAfd = fixedAfd;
                return this;
            }

            public Builder flickerAq(String flickerAq) {
                this.flickerAq = flickerAq;
                return this;
            }

            public Builder framerateDenominator(Number framerateDenominator) {
                this.framerateDenominator = framerateDenominator;
                return this;
            }

            public Builder framerateNumerator(Number framerateNumerator) {
                this.framerateNumerator = framerateNumerator;
                return this;
            }

            public Builder gopClosedCadence(Number gopClosedCadence) {
                this.gopClosedCadence = gopClosedCadence;
                return this;
            }

            public Builder gopSize(Number gopSize) {
                this.gopSize = gopSize;
                return this;
            }

            public Builder gopSizeUnits(String gopSizeUnits) {
                this.gopSizeUnits = gopSizeUnits;
                return this;
            }

            public Builder level(String level) {
                this.level = level;
                return this;
            }

            public Builder lookAheadRateControl(String lookAheadRateControl) {
                this.lookAheadRateControl = lookAheadRateControl;
                return this;
            }

            public Builder maxBitrate(Number maxBitrate) {
                this.maxBitrate = maxBitrate;
                return this;
            }

            public Builder minIInterval(Number minIInterval) {
                this.minIInterval = minIInterval;
                return this;
            }

            public Builder parDenominator(Number parDenominator) {
                this.parDenominator = parDenominator;
                return this;
            }

            public Builder parNumerator(Number parNumerator) {
                this.parNumerator = parNumerator;
                return this;
            }

            public Builder profile(String profile) {
                this.profile = profile;
                return this;
            }

            public Builder qvbrQualityLevel(Number qvbrQualityLevel) {
                this.qvbrQualityLevel = qvbrQualityLevel;
                return this;
            }

            public Builder rateControlMode(String rateControlMode) {
                this.rateControlMode = rateControlMode;
                return this;
            }

            public Builder scanType(String scanType) {
                this.scanType = scanType;
                return this;
            }

            public Builder sceneChangeDetect(String sceneChangeDetect) {
                this.sceneChangeDetect = sceneChangeDetect;
                return this;
            }

            public Builder slices(Number slices) {
                this.slices = slices;
                return this;
            }

            public Builder tier(String tier) {
                this.tier = tier;
                return this;
            }

            public Builder timecodeInsertion(String timecodeInsertion) {
                this.timecodeInsertion = timecodeInsertion;
                return this;
            }

            public H265SettingsProperty build() {
                return new Jsii.Proxy(this.adaptiveQuantization, this.afdSignaling, this.alternativeTransferFunction, this.bitrate, this.bufSize, this.colorMetadata, this.colorSpaceSettings, this.filterSettings, this.fixedAfd, this.flickerAq, this.framerateDenominator, this.framerateNumerator, this.gopClosedCadence, this.gopSize, this.gopSizeUnits, this.level, this.lookAheadRateControl, this.maxBitrate, this.minIInterval, this.parDenominator, this.parNumerator, this.profile, this.qvbrQualityLevel, this.rateControlMode, this.scanType, this.sceneChangeDetect, this.slices, this.tier, this.timecodeInsertion);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.H265FilterSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface H265FilterSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTemporalFilterSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<H265FilterSettingsProperty> {
            private Object temporalFilterSettings;

            public Builder temporalFilterSettings(IResolvable temporalFilterSettings) {
                this.temporalFilterSettings = temporalFilterSettings;
                return this;
            }

            public Builder temporalFilterSettings(TemporalFilterSettingsProperty temporalFilterSettings) {
                this.temporalFilterSettings = temporalFilterSettings;
                return this;
            }

            public H265FilterSettingsProperty build() {
                return new Jsii.Proxy(this.temporalFilterSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.H265ColorSpaceSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface H265ColorSpaceSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColorSpacePassthroughSettings() {
            return null;
        }

        @Nullable
        default public Object getHdr10Settings() {
            return null;
        }

        @Nullable
        default public Object getRec601Settings() {
            return null;
        }

        @Nullable
        default public Object getRec709Settings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<H265ColorSpaceSettingsProperty> {
            private Object colorSpacePassthroughSettings;
            private Object hdr10Settings;
            private Object rec601Settings;
            private Object rec709Settings;

            public Builder colorSpacePassthroughSettings(IResolvable colorSpacePassthroughSettings) {
                this.colorSpacePassthroughSettings = colorSpacePassthroughSettings;
                return this;
            }

            public Builder colorSpacePassthroughSettings(ColorSpacePassthroughSettingsProperty colorSpacePassthroughSettings) {
                this.colorSpacePassthroughSettings = colorSpacePassthroughSettings;
                return this;
            }

            public Builder hdr10Settings(IResolvable hdr10Settings) {
                this.hdr10Settings = hdr10Settings;
                return this;
            }

            public Builder hdr10Settings(Hdr10SettingsProperty hdr10Settings) {
                this.hdr10Settings = hdr10Settings;
                return this;
            }

            public Builder rec601Settings(IResolvable rec601Settings) {
                this.rec601Settings = rec601Settings;
                return this;
            }

            public Builder rec601Settings(Rec601SettingsProperty rec601Settings) {
                this.rec601Settings = rec601Settings;
                return this;
            }

            public Builder rec709Settings(IResolvable rec709Settings) {
                this.rec709Settings = rec709Settings;
                return this;
            }

            public Builder rec709Settings(Rec709SettingsProperty rec709Settings) {
                this.rec709Settings = rec709Settings;
                return this;
            }

            public H265ColorSpaceSettingsProperty build() {
                return new Jsii.Proxy(this.colorSpacePassthroughSettings, this.hdr10Settings, this.rec601Settings, this.rec709Settings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.H264SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface H264SettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAdaptiveQuantization() {
            return null;
        }

        @Nullable
        default public String getAfdSignaling() {
            return null;
        }

        @Nullable
        default public Number getBitrate() {
            return null;
        }

        @Nullable
        default public Number getBufFillPct() {
            return null;
        }

        @Nullable
        default public Number getBufSize() {
            return null;
        }

        @Nullable
        default public String getColorMetadata() {
            return null;
        }

        @Nullable
        default public Object getColorSpaceSettings() {
            return null;
        }

        @Nullable
        default public String getEntropyEncoding() {
            return null;
        }

        @Nullable
        default public Object getFilterSettings() {
            return null;
        }

        @Nullable
        default public String getFixedAfd() {
            return null;
        }

        @Nullable
        default public String getFlickerAq() {
            return null;
        }

        @Nullable
        default public String getForceFieldPictures() {
            return null;
        }

        @Nullable
        default public String getFramerateControl() {
            return null;
        }

        @Nullable
        default public Number getFramerateDenominator() {
            return null;
        }

        @Nullable
        default public Number getFramerateNumerator() {
            return null;
        }

        @Nullable
        default public String getGopBReference() {
            return null;
        }

        @Nullable
        default public Number getGopClosedCadence() {
            return null;
        }

        @Nullable
        default public Number getGopNumBFrames() {
            return null;
        }

        @Nullable
        default public Number getGopSize() {
            return null;
        }

        @Nullable
        default public String getGopSizeUnits() {
            return null;
        }

        @Nullable
        default public String getLevel() {
            return null;
        }

        @Nullable
        default public String getLookAheadRateControl() {
            return null;
        }

        @Nullable
        default public Number getMaxBitrate() {
            return null;
        }

        @Nullable
        default public Number getMinIInterval() {
            return null;
        }

        @Nullable
        default public Number getNumRefFrames() {
            return null;
        }

        @Nullable
        default public String getParControl() {
            return null;
        }

        @Nullable
        default public Number getParDenominator() {
            return null;
        }

        @Nullable
        default public Number getParNumerator() {
            return null;
        }

        @Nullable
        default public String getProfile() {
            return null;
        }

        @Nullable
        default public String getQualityLevel() {
            return null;
        }

        @Nullable
        default public Number getQvbrQualityLevel() {
            return null;
        }

        @Nullable
        default public String getRateControlMode() {
            return null;
        }

        @Nullable
        default public String getScanType() {
            return null;
        }

        @Nullable
        default public String getSceneChangeDetect() {
            return null;
        }

        @Nullable
        default public Number getSlices() {
            return null;
        }

        @Nullable
        default public Number getSoftness() {
            return null;
        }

        @Nullable
        default public String getSpatialAq() {
            return null;
        }

        @Nullable
        default public String getSubgopLength() {
            return null;
        }

        @Nullable
        default public String getSyntax() {
            return null;
        }

        @Nullable
        default public String getTemporalAq() {
            return null;
        }

        @Nullable
        default public String getTimecodeInsertion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<H264SettingsProperty> {
            private String adaptiveQuantization;
            private String afdSignaling;
            private Number bitrate;
            private Number bufFillPct;
            private Number bufSize;
            private String colorMetadata;
            private Object colorSpaceSettings;
            private String entropyEncoding;
            private Object filterSettings;
            private String fixedAfd;
            private String flickerAq;
            private String forceFieldPictures;
            private String framerateControl;
            private Number framerateDenominator;
            private Number framerateNumerator;
            private String gopBReference;
            private Number gopClosedCadence;
            private Number gopNumBFrames;
            private Number gopSize;
            private String gopSizeUnits;
            private String level;
            private String lookAheadRateControl;
            private Number maxBitrate;
            private Number minIInterval;
            private Number numRefFrames;
            private String parControl;
            private Number parDenominator;
            private Number parNumerator;
            private String profile;
            private String qualityLevel;
            private Number qvbrQualityLevel;
            private String rateControlMode;
            private String scanType;
            private String sceneChangeDetect;
            private Number slices;
            private Number softness;
            private String spatialAq;
            private String subgopLength;
            private String syntax;
            private String temporalAq;
            private String timecodeInsertion;

            public Builder adaptiveQuantization(String adaptiveQuantization) {
                this.adaptiveQuantization = adaptiveQuantization;
                return this;
            }

            public Builder afdSignaling(String afdSignaling) {
                this.afdSignaling = afdSignaling;
                return this;
            }

            public Builder bitrate(Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            public Builder bufFillPct(Number bufFillPct) {
                this.bufFillPct = bufFillPct;
                return this;
            }

            public Builder bufSize(Number bufSize) {
                this.bufSize = bufSize;
                return this;
            }

            public Builder colorMetadata(String colorMetadata) {
                this.colorMetadata = colorMetadata;
                return this;
            }

            public Builder colorSpaceSettings(IResolvable colorSpaceSettings) {
                this.colorSpaceSettings = colorSpaceSettings;
                return this;
            }

            public Builder colorSpaceSettings(H264ColorSpaceSettingsProperty colorSpaceSettings) {
                this.colorSpaceSettings = colorSpaceSettings;
                return this;
            }

            public Builder entropyEncoding(String entropyEncoding) {
                this.entropyEncoding = entropyEncoding;
                return this;
            }

            public Builder filterSettings(IResolvable filterSettings) {
                this.filterSettings = filterSettings;
                return this;
            }

            public Builder filterSettings(H264FilterSettingsProperty filterSettings) {
                this.filterSettings = filterSettings;
                return this;
            }

            public Builder fixedAfd(String fixedAfd) {
                this.fixedAfd = fixedAfd;
                return this;
            }

            public Builder flickerAq(String flickerAq) {
                this.flickerAq = flickerAq;
                return this;
            }

            public Builder forceFieldPictures(String forceFieldPictures) {
                this.forceFieldPictures = forceFieldPictures;
                return this;
            }

            public Builder framerateControl(String framerateControl) {
                this.framerateControl = framerateControl;
                return this;
            }

            public Builder framerateDenominator(Number framerateDenominator) {
                this.framerateDenominator = framerateDenominator;
                return this;
            }

            public Builder framerateNumerator(Number framerateNumerator) {
                this.framerateNumerator = framerateNumerator;
                return this;
            }

            public Builder gopBReference(String gopBReference) {
                this.gopBReference = gopBReference;
                return this;
            }

            public Builder gopClosedCadence(Number gopClosedCadence) {
                this.gopClosedCadence = gopClosedCadence;
                return this;
            }

            public Builder gopNumBFrames(Number gopNumBFrames) {
                this.gopNumBFrames = gopNumBFrames;
                return this;
            }

            public Builder gopSize(Number gopSize) {
                this.gopSize = gopSize;
                return this;
            }

            public Builder gopSizeUnits(String gopSizeUnits) {
                this.gopSizeUnits = gopSizeUnits;
                return this;
            }

            public Builder level(String level) {
                this.level = level;
                return this;
            }

            public Builder lookAheadRateControl(String lookAheadRateControl) {
                this.lookAheadRateControl = lookAheadRateControl;
                return this;
            }

            public Builder maxBitrate(Number maxBitrate) {
                this.maxBitrate = maxBitrate;
                return this;
            }

            public Builder minIInterval(Number minIInterval) {
                this.minIInterval = minIInterval;
                return this;
            }

            public Builder numRefFrames(Number numRefFrames) {
                this.numRefFrames = numRefFrames;
                return this;
            }

            public Builder parControl(String parControl) {
                this.parControl = parControl;
                return this;
            }

            public Builder parDenominator(Number parDenominator) {
                this.parDenominator = parDenominator;
                return this;
            }

            public Builder parNumerator(Number parNumerator) {
                this.parNumerator = parNumerator;
                return this;
            }

            public Builder profile(String profile) {
                this.profile = profile;
                return this;
            }

            public Builder qualityLevel(String qualityLevel) {
                this.qualityLevel = qualityLevel;
                return this;
            }

            public Builder qvbrQualityLevel(Number qvbrQualityLevel) {
                this.qvbrQualityLevel = qvbrQualityLevel;
                return this;
            }

            public Builder rateControlMode(String rateControlMode) {
                this.rateControlMode = rateControlMode;
                return this;
            }

            public Builder scanType(String scanType) {
                this.scanType = scanType;
                return this;
            }

            public Builder sceneChangeDetect(String sceneChangeDetect) {
                this.sceneChangeDetect = sceneChangeDetect;
                return this;
            }

            public Builder slices(Number slices) {
                this.slices = slices;
                return this;
            }

            public Builder softness(Number softness) {
                this.softness = softness;
                return this;
            }

            public Builder spatialAq(String spatialAq) {
                this.spatialAq = spatialAq;
                return this;
            }

            public Builder subgopLength(String subgopLength) {
                this.subgopLength = subgopLength;
                return this;
            }

            public Builder syntax(String syntax) {
                this.syntax = syntax;
                return this;
            }

            public Builder temporalAq(String temporalAq) {
                this.temporalAq = temporalAq;
                return this;
            }

            public Builder timecodeInsertion(String timecodeInsertion) {
                this.timecodeInsertion = timecodeInsertion;
                return this;
            }

            public H264SettingsProperty build() {
                return new Jsii.Proxy(this.adaptiveQuantization, this.afdSignaling, this.bitrate, this.bufFillPct, this.bufSize, this.colorMetadata, this.colorSpaceSettings, this.entropyEncoding, this.filterSettings, this.fixedAfd, this.flickerAq, this.forceFieldPictures, this.framerateControl, this.framerateDenominator, this.framerateNumerator, this.gopBReference, this.gopClosedCadence, this.gopNumBFrames, this.gopSize, this.gopSizeUnits, this.level, this.lookAheadRateControl, this.maxBitrate, this.minIInterval, this.numRefFrames, this.parControl, this.parDenominator, this.parNumerator, this.profile, this.qualityLevel, this.qvbrQualityLevel, this.rateControlMode, this.scanType, this.sceneChangeDetect, this.slices, this.softness, this.spatialAq, this.subgopLength, this.syntax, this.temporalAq, this.timecodeInsertion);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.H264FilterSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface H264FilterSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTemporalFilterSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<H264FilterSettingsProperty> {
            private Object temporalFilterSettings;

            public Builder temporalFilterSettings(IResolvable temporalFilterSettings) {
                this.temporalFilterSettings = temporalFilterSettings;
                return this;
            }

            public Builder temporalFilterSettings(TemporalFilterSettingsProperty temporalFilterSettings) {
                this.temporalFilterSettings = temporalFilterSettings;
                return this;
            }

            public H264FilterSettingsProperty build() {
                return new Jsii.Proxy(this.temporalFilterSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.H264ColorSpaceSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface H264ColorSpaceSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColorSpacePassthroughSettings() {
            return null;
        }

        @Nullable
        default public Object getRec601Settings() {
            return null;
        }

        @Nullable
        default public Object getRec709Settings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<H264ColorSpaceSettingsProperty> {
            private Object colorSpacePassthroughSettings;
            private Object rec601Settings;
            private Object rec709Settings;

            public Builder colorSpacePassthroughSettings(IResolvable colorSpacePassthroughSettings) {
                this.colorSpacePassthroughSettings = colorSpacePassthroughSettings;
                return this;
            }

            public Builder colorSpacePassthroughSettings(ColorSpacePassthroughSettingsProperty colorSpacePassthroughSettings) {
                this.colorSpacePassthroughSettings = colorSpacePassthroughSettings;
                return this;
            }

            public Builder rec601Settings(IResolvable rec601Settings) {
                this.rec601Settings = rec601Settings;
                return this;
            }

            public Builder rec601Settings(Rec601SettingsProperty rec601Settings) {
                this.rec601Settings = rec601Settings;
                return this;
            }

            public Builder rec709Settings(IResolvable rec709Settings) {
                this.rec709Settings = rec709Settings;
                return this;
            }

            public Builder rec709Settings(Rec709SettingsProperty rec709Settings) {
                this.rec709Settings = rec709Settings;
                return this;
            }

            public H264ColorSpaceSettingsProperty build() {
                return new Jsii.Proxy(this.colorSpacePassthroughSettings, this.rec601Settings, this.rec709Settings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.GlobalConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GlobalConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getInitialAudioGain() {
            return null;
        }

        @Nullable
        default public String getInputEndAction() {
            return null;
        }

        @Nullable
        default public Object getInputLossBehavior() {
            return null;
        }

        @Nullable
        default public String getOutputLockingMode() {
            return null;
        }

        @Nullable
        default public String getOutputTimingSource() {
            return null;
        }

        @Nullable
        default public String getSupportLowFramerateInputs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GlobalConfigurationProperty> {
            private Number initialAudioGain;
            private String inputEndAction;
            private Object inputLossBehavior;
            private String outputLockingMode;
            private String outputTimingSource;
            private String supportLowFramerateInputs;

            public Builder initialAudioGain(Number initialAudioGain) {
                this.initialAudioGain = initialAudioGain;
                return this;
            }

            public Builder inputEndAction(String inputEndAction) {
                this.inputEndAction = inputEndAction;
                return this;
            }

            public Builder inputLossBehavior(IResolvable inputLossBehavior) {
                this.inputLossBehavior = inputLossBehavior;
                return this;
            }

            public Builder inputLossBehavior(InputLossBehaviorProperty inputLossBehavior) {
                this.inputLossBehavior = inputLossBehavior;
                return this;
            }

            public Builder outputLockingMode(String outputLockingMode) {
                this.outputLockingMode = outputLockingMode;
                return this;
            }

            public Builder outputTimingSource(String outputTimingSource) {
                this.outputTimingSource = outputTimingSource;
                return this;
            }

            public Builder supportLowFramerateInputs(String supportLowFramerateInputs) {
                this.supportLowFramerateInputs = supportLowFramerateInputs;
                return this;
            }

            public GlobalConfigurationProperty build() {
                return new Jsii.Proxy(this.initialAudioGain, this.inputEndAction, this.inputLossBehavior, this.outputLockingMode, this.outputTimingSource, this.supportLowFramerateInputs);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.FrameCaptureSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FrameCaptureSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCaptureInterval() {
            return null;
        }

        @Nullable
        default public String getCaptureIntervalUnits() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FrameCaptureSettingsProperty> {
            private Number captureInterval;
            private String captureIntervalUnits;

            public Builder captureInterval(Number captureInterval) {
                this.captureInterval = captureInterval;
                return this;
            }

            public Builder captureIntervalUnits(String captureIntervalUnits) {
                this.captureIntervalUnits = captureIntervalUnits;
                return this;
            }

            public FrameCaptureSettingsProperty build() {
                return new Jsii.Proxy(this.captureInterval, this.captureIntervalUnits);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.FrameCaptureOutputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FrameCaptureOutputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getNameModifier() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FrameCaptureOutputSettingsProperty> {
            private String nameModifier;

            public Builder nameModifier(String nameModifier) {
                this.nameModifier = nameModifier;
                return this;
            }

            public FrameCaptureOutputSettingsProperty build() {
                return new Jsii.Proxy(this.nameModifier);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.FrameCaptureGroupSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FrameCaptureGroupSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDestination() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FrameCaptureGroupSettingsProperty> {
            private Object destination;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            public FrameCaptureGroupSettingsProperty build() {
                return new Jsii.Proxy(this.destination);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Fmp4HlsSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Fmp4HlsSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAudioRenditionSets() {
            return null;
        }

        @Nullable
        default public String getNielsenId3Behavior() {
            return null;
        }

        @Nullable
        default public String getTimedMetadataBehavior() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Fmp4HlsSettingsProperty> {
            private String audioRenditionSets;
            private String nielsenId3Behavior;
            private String timedMetadataBehavior;

            public Builder audioRenditionSets(String audioRenditionSets) {
                this.audioRenditionSets = audioRenditionSets;
                return this;
            }

            public Builder nielsenId3Behavior(String nielsenId3Behavior) {
                this.nielsenId3Behavior = nielsenId3Behavior;
                return this;
            }

            public Builder timedMetadataBehavior(String timedMetadataBehavior) {
                this.timedMetadataBehavior = timedMetadataBehavior;
                return this;
            }

            public Fmp4HlsSettingsProperty build() {
                return new Jsii.Proxy(this.audioRenditionSets, this.nielsenId3Behavior, this.timedMetadataBehavior);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.FecOutputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FecOutputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getColumnDepth() {
            return null;
        }

        @Nullable
        default public String getIncludeFec() {
            return null;
        }

        @Nullable
        default public Number getRowLength() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FecOutputSettingsProperty> {
            private Number columnDepth;
            private String includeFec;
            private Number rowLength;

            public Builder columnDepth(Number columnDepth) {
                this.columnDepth = columnDepth;
                return this;
            }

            public Builder includeFec(String includeFec) {
                this.includeFec = includeFec;
                return this;
            }

            public Builder rowLength(Number rowLength) {
                this.rowLength = rowLength;
                return this;
            }

            public FecOutputSettingsProperty build() {
                return new Jsii.Proxy(this.columnDepth, this.includeFec, this.rowLength);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.FeatureActivationsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FeatureActivationsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getInputPrepareScheduleActions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FeatureActivationsProperty> {
            private String inputPrepareScheduleActions;

            public Builder inputPrepareScheduleActions(String inputPrepareScheduleActions) {
                this.inputPrepareScheduleActions = inputPrepareScheduleActions;
                return this;
            }

            public FeatureActivationsProperty build() {
                return new Jsii.Proxy(this.inputPrepareScheduleActions);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.FailoverConditionSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FailoverConditionSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAudioSilenceSettings() {
            return null;
        }

        @Nullable
        default public Object getInputLossSettings() {
            return null;
        }

        @Nullable
        default public Object getVideoBlackSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FailoverConditionSettingsProperty> {
            private Object audioSilenceSettings;
            private Object inputLossSettings;
            private Object videoBlackSettings;

            public Builder audioSilenceSettings(IResolvable audioSilenceSettings) {
                this.audioSilenceSettings = audioSilenceSettings;
                return this;
            }

            public Builder audioSilenceSettings(AudioSilenceFailoverSettingsProperty audioSilenceSettings) {
                this.audioSilenceSettings = audioSilenceSettings;
                return this;
            }

            public Builder inputLossSettings(IResolvable inputLossSettings) {
                this.inputLossSettings = inputLossSettings;
                return this;
            }

            public Builder inputLossSettings(InputLossFailoverSettingsProperty inputLossSettings) {
                this.inputLossSettings = inputLossSettings;
                return this;
            }

            public Builder videoBlackSettings(IResolvable videoBlackSettings) {
                this.videoBlackSettings = videoBlackSettings;
                return this;
            }

            public Builder videoBlackSettings(VideoBlackFailoverSettingsProperty videoBlackSettings) {
                this.videoBlackSettings = videoBlackSettings;
                return this;
            }

            public FailoverConditionSettingsProperty build() {
                return new Jsii.Proxy(this.audioSilenceSettings, this.inputLossSettings, this.videoBlackSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.FailoverConditionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FailoverConditionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFailoverConditionSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FailoverConditionProperty> {
            private Object failoverConditionSettings;

            public Builder failoverConditionSettings(IResolvable failoverConditionSettings) {
                this.failoverConditionSettings = failoverConditionSettings;
                return this;
            }

            public Builder failoverConditionSettings(FailoverConditionSettingsProperty failoverConditionSettings) {
                this.failoverConditionSettings = failoverConditionSettings;
                return this;
            }

            public FailoverConditionProperty build() {
                return new Jsii.Proxy(this.failoverConditionSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.EncoderSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncoderSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAudioDescriptions() {
            return null;
        }

        @Nullable
        default public Object getAvailBlanking() {
            return null;
        }

        @Nullable
        default public Object getAvailConfiguration() {
            return null;
        }

        @Nullable
        default public Object getBlackoutSlate() {
            return null;
        }

        @Nullable
        default public Object getCaptionDescriptions() {
            return null;
        }

        @Nullable
        default public Object getFeatureActivations() {
            return null;
        }

        @Nullable
        default public Object getGlobalConfiguration() {
            return null;
        }

        @Nullable
        default public Object getNielsenConfiguration() {
            return null;
        }

        @Nullable
        default public Object getOutputGroups() {
            return null;
        }

        @Nullable
        default public Object getTimecodeConfig() {
            return null;
        }

        @Nullable
        default public Object getVideoDescriptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncoderSettingsProperty> {
            private Object audioDescriptions;
            private Object availBlanking;
            private Object availConfiguration;
            private Object blackoutSlate;
            private Object captionDescriptions;
            private Object featureActivations;
            private Object globalConfiguration;
            private Object nielsenConfiguration;
            private Object outputGroups;
            private Object timecodeConfig;
            private Object videoDescriptions;

            public Builder audioDescriptions(IResolvable audioDescriptions) {
                this.audioDescriptions = audioDescriptions;
                return this;
            }

            public Builder audioDescriptions(List<? extends Object> audioDescriptions) {
                this.audioDescriptions = audioDescriptions;
                return this;
            }

            public Builder availBlanking(IResolvable availBlanking) {
                this.availBlanking = availBlanking;
                return this;
            }

            public Builder availBlanking(AvailBlankingProperty availBlanking) {
                this.availBlanking = availBlanking;
                return this;
            }

            public Builder availConfiguration(IResolvable availConfiguration) {
                this.availConfiguration = availConfiguration;
                return this;
            }

            public Builder availConfiguration(AvailConfigurationProperty availConfiguration) {
                this.availConfiguration = availConfiguration;
                return this;
            }

            public Builder blackoutSlate(IResolvable blackoutSlate) {
                this.blackoutSlate = blackoutSlate;
                return this;
            }

            public Builder blackoutSlate(BlackoutSlateProperty blackoutSlate) {
                this.blackoutSlate = blackoutSlate;
                return this;
            }

            public Builder captionDescriptions(IResolvable captionDescriptions) {
                this.captionDescriptions = captionDescriptions;
                return this;
            }

            public Builder captionDescriptions(List<? extends Object> captionDescriptions) {
                this.captionDescriptions = captionDescriptions;
                return this;
            }

            public Builder featureActivations(IResolvable featureActivations) {
                this.featureActivations = featureActivations;
                return this;
            }

            public Builder featureActivations(FeatureActivationsProperty featureActivations) {
                this.featureActivations = featureActivations;
                return this;
            }

            public Builder globalConfiguration(IResolvable globalConfiguration) {
                this.globalConfiguration = globalConfiguration;
                return this;
            }

            public Builder globalConfiguration(GlobalConfigurationProperty globalConfiguration) {
                this.globalConfiguration = globalConfiguration;
                return this;
            }

            public Builder nielsenConfiguration(IResolvable nielsenConfiguration) {
                this.nielsenConfiguration = nielsenConfiguration;
                return this;
            }

            public Builder nielsenConfiguration(NielsenConfigurationProperty nielsenConfiguration) {
                this.nielsenConfiguration = nielsenConfiguration;
                return this;
            }

            public Builder outputGroups(IResolvable outputGroups) {
                this.outputGroups = outputGroups;
                return this;
            }

            public Builder outputGroups(List<? extends Object> outputGroups) {
                this.outputGroups = outputGroups;
                return this;
            }

            public Builder timecodeConfig(IResolvable timecodeConfig) {
                this.timecodeConfig = timecodeConfig;
                return this;
            }

            public Builder timecodeConfig(TimecodeConfigProperty timecodeConfig) {
                this.timecodeConfig = timecodeConfig;
                return this;
            }

            public Builder videoDescriptions(IResolvable videoDescriptions) {
                this.videoDescriptions = videoDescriptions;
                return this;
            }

            public Builder videoDescriptions(List<? extends Object> videoDescriptions) {
                this.videoDescriptions = videoDescriptions;
                return this;
            }

            public EncoderSettingsProperty build() {
                return new Jsii.Proxy(this.audioDescriptions, this.availBlanking, this.availConfiguration, this.blackoutSlate, this.captionDescriptions, this.featureActivations, this.globalConfiguration, this.nielsenConfiguration, this.outputGroups, this.timecodeConfig, this.videoDescriptions);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.EmbeddedSourceSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EmbeddedSourceSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConvert608To708() {
            return null;
        }

        @Nullable
        default public String getScte20Detection() {
            return null;
        }

        @Nullable
        default public Number getSource608ChannelNumber() {
            return null;
        }

        @Nullable
        default public Number getSource608TrackNumber() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EmbeddedSourceSettingsProperty> {
            private String convert608To708;
            private String scte20Detection;
            private Number source608ChannelNumber;
            private Number source608TrackNumber;

            public Builder convert608To708(String convert608To708) {
                this.convert608To708 = convert608To708;
                return this;
            }

            public Builder scte20Detection(String scte20Detection) {
                this.scte20Detection = scte20Detection;
                return this;
            }

            public Builder source608ChannelNumber(Number source608ChannelNumber) {
                this.source608ChannelNumber = source608ChannelNumber;
                return this;
            }

            public Builder source608TrackNumber(Number source608TrackNumber) {
                this.source608TrackNumber = source608TrackNumber;
                return this;
            }

            public EmbeddedSourceSettingsProperty build() {
                return new Jsii.Proxy(this.convert608To708, this.scte20Detection, this.source608ChannelNumber, this.source608TrackNumber);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EmbeddedPlusScte20DestinationSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EmbeddedPlusScte20DestinationSettingsProperty> {
            public EmbeddedPlusScte20DestinationSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.EmbeddedDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EmbeddedDestinationSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EmbeddedDestinationSettingsProperty> {
            public EmbeddedDestinationSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.EbuTtDDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbuTtDDestinationSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getFillLineGap() {
            return null;
        }

        @Nullable
        default public String getFontFamily() {
            return null;
        }

        @Nullable
        default public String getStyleControl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbuTtDDestinationSettingsProperty> {
            private String fillLineGap;
            private String fontFamily;
            private String styleControl;

            public Builder fillLineGap(String fillLineGap) {
                this.fillLineGap = fillLineGap;
                return this;
            }

            public Builder fontFamily(String fontFamily) {
                this.fontFamily = fontFamily;
                return this;
            }

            public Builder styleControl(String styleControl) {
                this.styleControl = styleControl;
                return this;
            }

            public EbuTtDDestinationSettingsProperty build() {
                return new Jsii.Proxy(this.fillLineGap, this.fontFamily, this.styleControl);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Eac3SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Eac3SettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAttenuationControl() {
            return null;
        }

        @Nullable
        default public Number getBitrate() {
            return null;
        }

        @Nullable
        default public String getBitstreamMode() {
            return null;
        }

        @Nullable
        default public String getCodingMode() {
            return null;
        }

        @Nullable
        default public String getDcFilter() {
            return null;
        }

        @Nullable
        default public Number getDialnorm() {
            return null;
        }

        @Nullable
        default public String getDrcLine() {
            return null;
        }

        @Nullable
        default public String getDrcRf() {
            return null;
        }

        @Nullable
        default public String getLfeControl() {
            return null;
        }

        @Nullable
        default public String getLfeFilter() {
            return null;
        }

        @Nullable
        default public Number getLoRoCenterMixLevel() {
            return null;
        }

        @Nullable
        default public Number getLoRoSurroundMixLevel() {
            return null;
        }

        @Nullable
        default public Number getLtRtCenterMixLevel() {
            return null;
        }

        @Nullable
        default public Number getLtRtSurroundMixLevel() {
            return null;
        }

        @Nullable
        default public String getMetadataControl() {
            return null;
        }

        @Nullable
        default public String getPassthroughControl() {
            return null;
        }

        @Nullable
        default public String getPhaseControl() {
            return null;
        }

        @Nullable
        default public String getStereoDownmix() {
            return null;
        }

        @Nullable
        default public String getSurroundExMode() {
            return null;
        }

        @Nullable
        default public String getSurroundMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Eac3SettingsProperty> {
            private String attenuationControl;
            private Number bitrate;
            private String bitstreamMode;
            private String codingMode;
            private String dcFilter;
            private Number dialnorm;
            private String drcLine;
            private String drcRf;
            private String lfeControl;
            private String lfeFilter;
            private Number loRoCenterMixLevel;
            private Number loRoSurroundMixLevel;
            private Number ltRtCenterMixLevel;
            private Number ltRtSurroundMixLevel;
            private String metadataControl;
            private String passthroughControl;
            private String phaseControl;
            private String stereoDownmix;
            private String surroundExMode;
            private String surroundMode;

            public Builder attenuationControl(String attenuationControl) {
                this.attenuationControl = attenuationControl;
                return this;
            }

            public Builder bitrate(Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            public Builder bitstreamMode(String bitstreamMode) {
                this.bitstreamMode = bitstreamMode;
                return this;
            }

            public Builder codingMode(String codingMode) {
                this.codingMode = codingMode;
                return this;
            }

            public Builder dcFilter(String dcFilter) {
                this.dcFilter = dcFilter;
                return this;
            }

            public Builder dialnorm(Number dialnorm) {
                this.dialnorm = dialnorm;
                return this;
            }

            public Builder drcLine(String drcLine) {
                this.drcLine = drcLine;
                return this;
            }

            public Builder drcRf(String drcRf) {
                this.drcRf = drcRf;
                return this;
            }

            public Builder lfeControl(String lfeControl) {
                this.lfeControl = lfeControl;
                return this;
            }

            public Builder lfeFilter(String lfeFilter) {
                this.lfeFilter = lfeFilter;
                return this;
            }

            public Builder loRoCenterMixLevel(Number loRoCenterMixLevel) {
                this.loRoCenterMixLevel = loRoCenterMixLevel;
                return this;
            }

            public Builder loRoSurroundMixLevel(Number loRoSurroundMixLevel) {
                this.loRoSurroundMixLevel = loRoSurroundMixLevel;
                return this;
            }

            public Builder ltRtCenterMixLevel(Number ltRtCenterMixLevel) {
                this.ltRtCenterMixLevel = ltRtCenterMixLevel;
                return this;
            }

            public Builder ltRtSurroundMixLevel(Number ltRtSurroundMixLevel) {
                this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
                return this;
            }

            public Builder metadataControl(String metadataControl) {
                this.metadataControl = metadataControl;
                return this;
            }

            public Builder passthroughControl(String passthroughControl) {
                this.passthroughControl = passthroughControl;
                return this;
            }

            public Builder phaseControl(String phaseControl) {
                this.phaseControl = phaseControl;
                return this;
            }

            public Builder stereoDownmix(String stereoDownmix) {
                this.stereoDownmix = stereoDownmix;
                return this;
            }

            public Builder surroundExMode(String surroundExMode) {
                this.surroundExMode = surroundExMode;
                return this;
            }

            public Builder surroundMode(String surroundMode) {
                this.surroundMode = surroundMode;
                return this;
            }

            public Eac3SettingsProperty build() {
                return new Jsii.Proxy(this.attenuationControl, this.bitrate, this.bitstreamMode, this.codingMode, this.dcFilter, this.dialnorm, this.drcLine, this.drcRf, this.lfeControl, this.lfeFilter, this.loRoCenterMixLevel, this.loRoSurroundMixLevel, this.ltRtCenterMixLevel, this.ltRtSurroundMixLevel, this.metadataControl, this.passthroughControl, this.phaseControl, this.stereoDownmix, this.surroundExMode, this.surroundMode);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.DvbTdtSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DvbTdtSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getRepInterval() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DvbTdtSettingsProperty> {
            private Number repInterval;

            public Builder repInterval(Number repInterval) {
                this.repInterval = repInterval;
                return this;
            }

            public DvbTdtSettingsProperty build() {
                return new Jsii.Proxy(this.repInterval);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.DvbSubSourceSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DvbSubSourceSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getPid() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DvbSubSourceSettingsProperty> {
            private Number pid;

            public Builder pid(Number pid) {
                this.pid = pid;
                return this;
            }

            public DvbSubSourceSettingsProperty build() {
                return new Jsii.Proxy(this.pid);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.DvbSubDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DvbSubDestinationSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAlignment() {
            return null;
        }

        @Nullable
        default public String getBackgroundColor() {
            return null;
        }

        @Nullable
        default public Number getBackgroundOpacity() {
            return null;
        }

        @Nullable
        default public Object getFont() {
            return null;
        }

        @Nullable
        default public String getFontColor() {
            return null;
        }

        @Nullable
        default public Number getFontOpacity() {
            return null;
        }

        @Nullable
        default public Number getFontResolution() {
            return null;
        }

        @Nullable
        default public String getFontSize() {
            return null;
        }

        @Nullable
        default public String getOutlineColor() {
            return null;
        }

        @Nullable
        default public Number getOutlineSize() {
            return null;
        }

        @Nullable
        default public String getShadowColor() {
            return null;
        }

        @Nullable
        default public Number getShadowOpacity() {
            return null;
        }

        @Nullable
        default public Number getShadowXOffset() {
            return null;
        }

        @Nullable
        default public Number getShadowYOffset() {
            return null;
        }

        @Nullable
        default public String getTeletextGridControl() {
            return null;
        }

        @Nullable
        default public Number getXPosition() {
            return null;
        }

        @Nullable
        default public Number getYPosition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DvbSubDestinationSettingsProperty> {
            private String alignment;
            private String backgroundColor;
            private Number backgroundOpacity;
            private Object font;
            private String fontColor;
            private Number fontOpacity;
            private Number fontResolution;
            private String fontSize;
            private String outlineColor;
            private Number outlineSize;
            private String shadowColor;
            private Number shadowOpacity;
            private Number shadowXOffset;
            private Number shadowYOffset;
            private String teletextGridControl;
            private Number xPosition;
            private Number yPosition;

            public Builder alignment(String alignment) {
                this.alignment = alignment;
                return this;
            }

            public Builder backgroundColor(String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Builder backgroundOpacity(Number backgroundOpacity) {
                this.backgroundOpacity = backgroundOpacity;
                return this;
            }

            public Builder font(IResolvable font) {
                this.font = font;
                return this;
            }

            public Builder font(InputLocationProperty font) {
                this.font = font;
                return this;
            }

            public Builder fontColor(String fontColor) {
                this.fontColor = fontColor;
                return this;
            }

            public Builder fontOpacity(Number fontOpacity) {
                this.fontOpacity = fontOpacity;
                return this;
            }

            public Builder fontResolution(Number fontResolution) {
                this.fontResolution = fontResolution;
                return this;
            }

            public Builder fontSize(String fontSize) {
                this.fontSize = fontSize;
                return this;
            }

            public Builder outlineColor(String outlineColor) {
                this.outlineColor = outlineColor;
                return this;
            }

            public Builder outlineSize(Number outlineSize) {
                this.outlineSize = outlineSize;
                return this;
            }

            public Builder shadowColor(String shadowColor) {
                this.shadowColor = shadowColor;
                return this;
            }

            public Builder shadowOpacity(Number shadowOpacity) {
                this.shadowOpacity = shadowOpacity;
                return this;
            }

            public Builder shadowXOffset(Number shadowXOffset) {
                this.shadowXOffset = shadowXOffset;
                return this;
            }

            public Builder shadowYOffset(Number shadowYOffset) {
                this.shadowYOffset = shadowYOffset;
                return this;
            }

            public Builder teletextGridControl(String teletextGridControl) {
                this.teletextGridControl = teletextGridControl;
                return this;
            }

            public Builder xPosition(Number xPosition) {
                this.xPosition = xPosition;
                return this;
            }

            public Builder yPosition(Number yPosition) {
                this.yPosition = yPosition;
                return this;
            }

            public DvbSubDestinationSettingsProperty build() {
                return new Jsii.Proxy(this.alignment, this.backgroundColor, this.backgroundOpacity, this.font, this.fontColor, this.fontOpacity, this.fontResolution, this.fontSize, this.outlineColor, this.outlineSize, this.shadowColor, this.shadowOpacity, this.shadowXOffset, this.shadowYOffset, this.teletextGridControl, this.xPosition, this.yPosition);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.DvbSdtSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DvbSdtSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getOutputSdt() {
            return null;
        }

        @Nullable
        default public Number getRepInterval() {
            return null;
        }

        @Nullable
        default public String getServiceName() {
            return null;
        }

        @Nullable
        default public String getServiceProviderName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DvbSdtSettingsProperty> {
            private String outputSdt;
            private Number repInterval;
            private String serviceName;
            private String serviceProviderName;

            public Builder outputSdt(String outputSdt) {
                this.outputSdt = outputSdt;
                return this;
            }

            public Builder repInterval(Number repInterval) {
                this.repInterval = repInterval;
                return this;
            }

            public Builder serviceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            public Builder serviceProviderName(String serviceProviderName) {
                this.serviceProviderName = serviceProviderName;
                return this;
            }

            public DvbSdtSettingsProperty build() {
                return new Jsii.Proxy(this.outputSdt, this.repInterval, this.serviceName, this.serviceProviderName);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.DvbNitSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DvbNitSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getNetworkId() {
            return null;
        }

        @Nullable
        default public String getNetworkName() {
            return null;
        }

        @Nullable
        default public Number getRepInterval() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DvbNitSettingsProperty> {
            private Number networkId;
            private String networkName;
            private Number repInterval;

            public Builder networkId(Number networkId) {
                this.networkId = networkId;
                return this;
            }

            public Builder networkName(String networkName) {
                this.networkName = networkName;
                return this;
            }

            public Builder repInterval(Number repInterval) {
                this.repInterval = repInterval;
                return this;
            }

            public DvbNitSettingsProperty build() {
                return new Jsii.Proxy(this.networkId, this.networkName, this.repInterval);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.ColorSpacePassthroughSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColorSpacePassthroughSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColorSpacePassthroughSettingsProperty> {
            public ColorSpacePassthroughSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.CdiInputSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CdiInputSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getResolution() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CdiInputSpecificationProperty> {
            private String resolution;

            public Builder resolution(String resolution) {
                this.resolution = resolution;
                return this;
            }

            public CdiInputSpecificationProperty build() {
                return new Jsii.Proxy(this.resolution);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.CaptionSelectorSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CaptionSelectorSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAncillarySourceSettings() {
            return null;
        }

        @Nullable
        default public Object getAribSourceSettings() {
            return null;
        }

        @Nullable
        default public Object getDvbSubSourceSettings() {
            return null;
        }

        @Nullable
        default public Object getEmbeddedSourceSettings() {
            return null;
        }

        @Nullable
        default public Object getScte20SourceSettings() {
            return null;
        }

        @Nullable
        default public Object getScte27SourceSettings() {
            return null;
        }

        @Nullable
        default public Object getTeletextSourceSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CaptionSelectorSettingsProperty> {
            private Object ancillarySourceSettings;
            private Object aribSourceSettings;
            private Object dvbSubSourceSettings;
            private Object embeddedSourceSettings;
            private Object scte20SourceSettings;
            private Object scte27SourceSettings;
            private Object teletextSourceSettings;

            public Builder ancillarySourceSettings(IResolvable ancillarySourceSettings) {
                this.ancillarySourceSettings = ancillarySourceSettings;
                return this;
            }

            public Builder ancillarySourceSettings(AncillarySourceSettingsProperty ancillarySourceSettings) {
                this.ancillarySourceSettings = ancillarySourceSettings;
                return this;
            }

            public Builder aribSourceSettings(IResolvable aribSourceSettings) {
                this.aribSourceSettings = aribSourceSettings;
                return this;
            }

            public Builder aribSourceSettings(AribSourceSettingsProperty aribSourceSettings) {
                this.aribSourceSettings = aribSourceSettings;
                return this;
            }

            public Builder dvbSubSourceSettings(IResolvable dvbSubSourceSettings) {
                this.dvbSubSourceSettings = dvbSubSourceSettings;
                return this;
            }

            public Builder dvbSubSourceSettings(DvbSubSourceSettingsProperty dvbSubSourceSettings) {
                this.dvbSubSourceSettings = dvbSubSourceSettings;
                return this;
            }

            public Builder embeddedSourceSettings(IResolvable embeddedSourceSettings) {
                this.embeddedSourceSettings = embeddedSourceSettings;
                return this;
            }

            public Builder embeddedSourceSettings(EmbeddedSourceSettingsProperty embeddedSourceSettings) {
                this.embeddedSourceSettings = embeddedSourceSettings;
                return this;
            }

            public Builder scte20SourceSettings(IResolvable scte20SourceSettings) {
                this.scte20SourceSettings = scte20SourceSettings;
                return this;
            }

            public Builder scte20SourceSettings(Scte20SourceSettingsProperty scte20SourceSettings) {
                this.scte20SourceSettings = scte20SourceSettings;
                return this;
            }

            public Builder scte27SourceSettings(IResolvable scte27SourceSettings) {
                this.scte27SourceSettings = scte27SourceSettings;
                return this;
            }

            public Builder scte27SourceSettings(Scte27SourceSettingsProperty scte27SourceSettings) {
                this.scte27SourceSettings = scte27SourceSettings;
                return this;
            }

            public Builder teletextSourceSettings(IResolvable teletextSourceSettings) {
                this.teletextSourceSettings = teletextSourceSettings;
                return this;
            }

            public Builder teletextSourceSettings(TeletextSourceSettingsProperty teletextSourceSettings) {
                this.teletextSourceSettings = teletextSourceSettings;
                return this;
            }

            public CaptionSelectorSettingsProperty build() {
                return new Jsii.Proxy(this.ancillarySourceSettings, this.aribSourceSettings, this.dvbSubSourceSettings, this.embeddedSourceSettings, this.scte20SourceSettings, this.scte27SourceSettings, this.teletextSourceSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.CaptionSelectorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CaptionSelectorProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLanguageCode() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getSelectorSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CaptionSelectorProperty> {
            private String languageCode;
            private String name;
            private Object selectorSettings;

            public Builder languageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder selectorSettings(IResolvable selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            public Builder selectorSettings(CaptionSelectorSettingsProperty selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            public CaptionSelectorProperty build() {
                return new Jsii.Proxy(this.languageCode, this.name, this.selectorSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.CaptionLanguageMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CaptionLanguageMappingProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCaptionChannel() {
            return null;
        }

        @Nullable
        default public String getLanguageCode() {
            return null;
        }

        @Nullable
        default public String getLanguageDescription() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CaptionLanguageMappingProperty> {
            private Number captionChannel;
            private String languageCode;
            private String languageDescription;

            public Builder captionChannel(Number captionChannel) {
                this.captionChannel = captionChannel;
                return this;
            }

            public Builder languageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public Builder languageDescription(String languageDescription) {
                this.languageDescription = languageDescription;
                return this;
            }

            public CaptionLanguageMappingProperty build() {
                return new Jsii.Proxy(this.captionChannel, this.languageCode, this.languageDescription);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.CaptionDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CaptionDestinationSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAribDestinationSettings() {
            return null;
        }

        @Nullable
        default public Object getBurnInDestinationSettings() {
            return null;
        }

        @Nullable
        default public Object getDvbSubDestinationSettings() {
            return null;
        }

        @Nullable
        default public Object getEbuTtDDestinationSettings() {
            return null;
        }

        @Nullable
        default public Object getEmbeddedDestinationSettings() {
            return null;
        }

        @Nullable
        default public Object getEmbeddedPlusScte20DestinationSettings() {
            return null;
        }

        @Nullable
        default public Object getRtmpCaptionInfoDestinationSettings() {
            return null;
        }

        @Nullable
        default public Object getScte20PlusEmbeddedDestinationSettings() {
            return null;
        }

        @Nullable
        default public Object getScte27DestinationSettings() {
            return null;
        }

        @Nullable
        default public Object getSmpteTtDestinationSettings() {
            return null;
        }

        @Nullable
        default public Object getTeletextDestinationSettings() {
            return null;
        }

        @Nullable
        default public Object getTtmlDestinationSettings() {
            return null;
        }

        @Nullable
        default public Object getWebvttDestinationSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CaptionDestinationSettingsProperty> {
            private Object aribDestinationSettings;
            private Object burnInDestinationSettings;
            private Object dvbSubDestinationSettings;
            private Object ebuTtDDestinationSettings;
            private Object embeddedDestinationSettings;
            private Object embeddedPlusScte20DestinationSettings;
            private Object rtmpCaptionInfoDestinationSettings;
            private Object scte20PlusEmbeddedDestinationSettings;
            private Object scte27DestinationSettings;
            private Object smpteTtDestinationSettings;
            private Object teletextDestinationSettings;
            private Object ttmlDestinationSettings;
            private Object webvttDestinationSettings;

            public Builder aribDestinationSettings(IResolvable aribDestinationSettings) {
                this.aribDestinationSettings = aribDestinationSettings;
                return this;
            }

            public Builder aribDestinationSettings(AribDestinationSettingsProperty aribDestinationSettings) {
                this.aribDestinationSettings = aribDestinationSettings;
                return this;
            }

            public Builder burnInDestinationSettings(IResolvable burnInDestinationSettings) {
                this.burnInDestinationSettings = burnInDestinationSettings;
                return this;
            }

            public Builder burnInDestinationSettings(BurnInDestinationSettingsProperty burnInDestinationSettings) {
                this.burnInDestinationSettings = burnInDestinationSettings;
                return this;
            }

            public Builder dvbSubDestinationSettings(IResolvable dvbSubDestinationSettings) {
                this.dvbSubDestinationSettings = dvbSubDestinationSettings;
                return this;
            }

            public Builder dvbSubDestinationSettings(DvbSubDestinationSettingsProperty dvbSubDestinationSettings) {
                this.dvbSubDestinationSettings = dvbSubDestinationSettings;
                return this;
            }

            public Builder ebuTtDDestinationSettings(IResolvable ebuTtDDestinationSettings) {
                this.ebuTtDDestinationSettings = ebuTtDDestinationSettings;
                return this;
            }

            public Builder ebuTtDDestinationSettings(EbuTtDDestinationSettingsProperty ebuTtDDestinationSettings) {
                this.ebuTtDDestinationSettings = ebuTtDDestinationSettings;
                return this;
            }

            public Builder embeddedDestinationSettings(IResolvable embeddedDestinationSettings) {
                this.embeddedDestinationSettings = embeddedDestinationSettings;
                return this;
            }

            public Builder embeddedDestinationSettings(EmbeddedDestinationSettingsProperty embeddedDestinationSettings) {
                this.embeddedDestinationSettings = embeddedDestinationSettings;
                return this;
            }

            public Builder embeddedPlusScte20DestinationSettings(IResolvable embeddedPlusScte20DestinationSettings) {
                this.embeddedPlusScte20DestinationSettings = embeddedPlusScte20DestinationSettings;
                return this;
            }

            public Builder embeddedPlusScte20DestinationSettings(EmbeddedPlusScte20DestinationSettingsProperty embeddedPlusScte20DestinationSettings) {
                this.embeddedPlusScte20DestinationSettings = embeddedPlusScte20DestinationSettings;
                return this;
            }

            public Builder rtmpCaptionInfoDestinationSettings(IResolvable rtmpCaptionInfoDestinationSettings) {
                this.rtmpCaptionInfoDestinationSettings = rtmpCaptionInfoDestinationSettings;
                return this;
            }

            public Builder rtmpCaptionInfoDestinationSettings(RtmpCaptionInfoDestinationSettingsProperty rtmpCaptionInfoDestinationSettings) {
                this.rtmpCaptionInfoDestinationSettings = rtmpCaptionInfoDestinationSettings;
                return this;
            }

            public Builder scte20PlusEmbeddedDestinationSettings(IResolvable scte20PlusEmbeddedDestinationSettings) {
                this.scte20PlusEmbeddedDestinationSettings = scte20PlusEmbeddedDestinationSettings;
                return this;
            }

            public Builder scte20PlusEmbeddedDestinationSettings(Scte20PlusEmbeddedDestinationSettingsProperty scte20PlusEmbeddedDestinationSettings) {
                this.scte20PlusEmbeddedDestinationSettings = scte20PlusEmbeddedDestinationSettings;
                return this;
            }

            public Builder scte27DestinationSettings(IResolvable scte27DestinationSettings) {
                this.scte27DestinationSettings = scte27DestinationSettings;
                return this;
            }

            public Builder scte27DestinationSettings(Scte27DestinationSettingsProperty scte27DestinationSettings) {
                this.scte27DestinationSettings = scte27DestinationSettings;
                return this;
            }

            public Builder smpteTtDestinationSettings(IResolvable smpteTtDestinationSettings) {
                this.smpteTtDestinationSettings = smpteTtDestinationSettings;
                return this;
            }

            public Builder smpteTtDestinationSettings(SmpteTtDestinationSettingsProperty smpteTtDestinationSettings) {
                this.smpteTtDestinationSettings = smpteTtDestinationSettings;
                return this;
            }

            public Builder teletextDestinationSettings(IResolvable teletextDestinationSettings) {
                this.teletextDestinationSettings = teletextDestinationSettings;
                return this;
            }

            public Builder teletextDestinationSettings(TeletextDestinationSettingsProperty teletextDestinationSettings) {
                this.teletextDestinationSettings = teletextDestinationSettings;
                return this;
            }

            public Builder ttmlDestinationSettings(IResolvable ttmlDestinationSettings) {
                this.ttmlDestinationSettings = ttmlDestinationSettings;
                return this;
            }

            public Builder ttmlDestinationSettings(TtmlDestinationSettingsProperty ttmlDestinationSettings) {
                this.ttmlDestinationSettings = ttmlDestinationSettings;
                return this;
            }

            public Builder webvttDestinationSettings(IResolvable webvttDestinationSettings) {
                this.webvttDestinationSettings = webvttDestinationSettings;
                return this;
            }

            public Builder webvttDestinationSettings(WebvttDestinationSettingsProperty webvttDestinationSettings) {
                this.webvttDestinationSettings = webvttDestinationSettings;
                return this;
            }

            public CaptionDestinationSettingsProperty build() {
                return new Jsii.Proxy(this.aribDestinationSettings, this.burnInDestinationSettings, this.dvbSubDestinationSettings, this.ebuTtDDestinationSettings, this.embeddedDestinationSettings, this.embeddedPlusScte20DestinationSettings, this.rtmpCaptionInfoDestinationSettings, this.scte20PlusEmbeddedDestinationSettings, this.scte27DestinationSettings, this.smpteTtDestinationSettings, this.teletextDestinationSettings, this.ttmlDestinationSettings, this.webvttDestinationSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.CaptionDescriptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CaptionDescriptionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCaptionSelectorName() {
            return null;
        }

        @Nullable
        default public Object getDestinationSettings() {
            return null;
        }

        @Nullable
        default public String getLanguageCode() {
            return null;
        }

        @Nullable
        default public String getLanguageDescription() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CaptionDescriptionProperty> {
            private String captionSelectorName;
            private Object destinationSettings;
            private String languageCode;
            private String languageDescription;
            private String name;

            public Builder captionSelectorName(String captionSelectorName) {
                this.captionSelectorName = captionSelectorName;
                return this;
            }

            public Builder destinationSettings(IResolvable destinationSettings) {
                this.destinationSettings = destinationSettings;
                return this;
            }

            public Builder destinationSettings(CaptionDestinationSettingsProperty destinationSettings) {
                this.destinationSettings = destinationSettings;
                return this;
            }

            public Builder languageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public Builder languageDescription(String languageDescription) {
                this.languageDescription = languageDescription;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public CaptionDescriptionProperty build() {
                return new Jsii.Proxy(this.captionSelectorName, this.destinationSettings, this.languageCode, this.languageDescription, this.name);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.BurnInDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BurnInDestinationSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAlignment() {
            return null;
        }

        @Nullable
        default public String getBackgroundColor() {
            return null;
        }

        @Nullable
        default public Number getBackgroundOpacity() {
            return null;
        }

        @Nullable
        default public Object getFont() {
            return null;
        }

        @Nullable
        default public String getFontColor() {
            return null;
        }

        @Nullable
        default public Number getFontOpacity() {
            return null;
        }

        @Nullable
        default public Number getFontResolution() {
            return null;
        }

        @Nullable
        default public String getFontSize() {
            return null;
        }

        @Nullable
        default public String getOutlineColor() {
            return null;
        }

        @Nullable
        default public Number getOutlineSize() {
            return null;
        }

        @Nullable
        default public String getShadowColor() {
            return null;
        }

        @Nullable
        default public Number getShadowOpacity() {
            return null;
        }

        @Nullable
        default public Number getShadowXOffset() {
            return null;
        }

        @Nullable
        default public Number getShadowYOffset() {
            return null;
        }

        @Nullable
        default public String getTeletextGridControl() {
            return null;
        }

        @Nullable
        default public Number getXPosition() {
            return null;
        }

        @Nullable
        default public Number getYPosition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BurnInDestinationSettingsProperty> {
            private String alignment;
            private String backgroundColor;
            private Number backgroundOpacity;
            private Object font;
            private String fontColor;
            private Number fontOpacity;
            private Number fontResolution;
            private String fontSize;
            private String outlineColor;
            private Number outlineSize;
            private String shadowColor;
            private Number shadowOpacity;
            private Number shadowXOffset;
            private Number shadowYOffset;
            private String teletextGridControl;
            private Number xPosition;
            private Number yPosition;

            public Builder alignment(String alignment) {
                this.alignment = alignment;
                return this;
            }

            public Builder backgroundColor(String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Builder backgroundOpacity(Number backgroundOpacity) {
                this.backgroundOpacity = backgroundOpacity;
                return this;
            }

            public Builder font(IResolvable font) {
                this.font = font;
                return this;
            }

            public Builder font(InputLocationProperty font) {
                this.font = font;
                return this;
            }

            public Builder fontColor(String fontColor) {
                this.fontColor = fontColor;
                return this;
            }

            public Builder fontOpacity(Number fontOpacity) {
                this.fontOpacity = fontOpacity;
                return this;
            }

            public Builder fontResolution(Number fontResolution) {
                this.fontResolution = fontResolution;
                return this;
            }

            public Builder fontSize(String fontSize) {
                this.fontSize = fontSize;
                return this;
            }

            public Builder outlineColor(String outlineColor) {
                this.outlineColor = outlineColor;
                return this;
            }

            public Builder outlineSize(Number outlineSize) {
                this.outlineSize = outlineSize;
                return this;
            }

            public Builder shadowColor(String shadowColor) {
                this.shadowColor = shadowColor;
                return this;
            }

            public Builder shadowOpacity(Number shadowOpacity) {
                this.shadowOpacity = shadowOpacity;
                return this;
            }

            public Builder shadowXOffset(Number shadowXOffset) {
                this.shadowXOffset = shadowXOffset;
                return this;
            }

            public Builder shadowYOffset(Number shadowYOffset) {
                this.shadowYOffset = shadowYOffset;
                return this;
            }

            public Builder teletextGridControl(String teletextGridControl) {
                this.teletextGridControl = teletextGridControl;
                return this;
            }

            public Builder xPosition(Number xPosition) {
                this.xPosition = xPosition;
                return this;
            }

            public Builder yPosition(Number yPosition) {
                this.yPosition = yPosition;
                return this;
            }

            public BurnInDestinationSettingsProperty build() {
                return new Jsii.Proxy(this.alignment, this.backgroundColor, this.backgroundOpacity, this.font, this.fontColor, this.fontOpacity, this.fontResolution, this.fontSize, this.outlineColor, this.outlineSize, this.shadowColor, this.shadowOpacity, this.shadowXOffset, this.shadowYOffset, this.teletextGridControl, this.xPosition, this.yPosition);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.BlackoutSlateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BlackoutSlateProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBlackoutSlateImage() {
            return null;
        }

        @Nullable
        default public String getNetworkEndBlackout() {
            return null;
        }

        @Nullable
        default public Object getNetworkEndBlackoutImage() {
            return null;
        }

        @Nullable
        default public String getNetworkId() {
            return null;
        }

        @Nullable
        default public String getState() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BlackoutSlateProperty> {
            private Object blackoutSlateImage;
            private String networkEndBlackout;
            private Object networkEndBlackoutImage;
            private String networkId;
            private String state;

            public Builder blackoutSlateImage(IResolvable blackoutSlateImage) {
                this.blackoutSlateImage = blackoutSlateImage;
                return this;
            }

            public Builder blackoutSlateImage(InputLocationProperty blackoutSlateImage) {
                this.blackoutSlateImage = blackoutSlateImage;
                return this;
            }

            public Builder networkEndBlackout(String networkEndBlackout) {
                this.networkEndBlackout = networkEndBlackout;
                return this;
            }

            public Builder networkEndBlackoutImage(IResolvable networkEndBlackoutImage) {
                this.networkEndBlackoutImage = networkEndBlackoutImage;
                return this;
            }

            public Builder networkEndBlackoutImage(InputLocationProperty networkEndBlackoutImage) {
                this.networkEndBlackoutImage = networkEndBlackoutImage;
                return this;
            }

            public Builder networkId(String networkId) {
                this.networkId = networkId;
                return this;
            }

            public Builder state(String state) {
                this.state = state;
                return this;
            }

            public BlackoutSlateProperty build() {
                return new Jsii.Proxy(this.blackoutSlateImage, this.networkEndBlackout, this.networkEndBlackoutImage, this.networkId, this.state);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AvailSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AvailSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getScte35SpliceInsert() {
            return null;
        }

        @Nullable
        default public Object getScte35TimeSignalApos() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AvailSettingsProperty> {
            private Object scte35SpliceInsert;
            private Object scte35TimeSignalApos;

            public Builder scte35SpliceInsert(IResolvable scte35SpliceInsert) {
                this.scte35SpliceInsert = scte35SpliceInsert;
                return this;
            }

            public Builder scte35SpliceInsert(Scte35SpliceInsertProperty scte35SpliceInsert) {
                this.scte35SpliceInsert = scte35SpliceInsert;
                return this;
            }

            public Builder scte35TimeSignalApos(IResolvable scte35TimeSignalApos) {
                this.scte35TimeSignalApos = scte35TimeSignalApos;
                return this;
            }

            public Builder scte35TimeSignalApos(Scte35TimeSignalAposProperty scte35TimeSignalApos) {
                this.scte35TimeSignalApos = scte35TimeSignalApos;
                return this;
            }

            public AvailSettingsProperty build() {
                return new Jsii.Proxy(this.scte35SpliceInsert, this.scte35TimeSignalApos);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AvailConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AvailConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAvailSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AvailConfigurationProperty> {
            private Object availSettings;

            public Builder availSettings(IResolvable availSettings) {
                this.availSettings = availSettings;
                return this;
            }

            public Builder availSettings(AvailSettingsProperty availSettings) {
                this.availSettings = availSettings;
                return this;
            }

            public AvailConfigurationProperty build() {
                return new Jsii.Proxy(this.availSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AvailBlankingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AvailBlankingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAvailBlankingImage() {
            return null;
        }

        @Nullable
        default public String getState() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AvailBlankingProperty> {
            private Object availBlankingImage;
            private String state;

            public Builder availBlankingImage(IResolvable availBlankingImage) {
                this.availBlankingImage = availBlankingImage;
                return this;
            }

            public Builder availBlankingImage(InputLocationProperty availBlankingImage) {
                this.availBlankingImage = availBlankingImage;
                return this;
            }

            public Builder state(String state) {
                this.state = state;
                return this;
            }

            public AvailBlankingProperty build() {
                return new Jsii.Proxy(this.availBlankingImage, this.state);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AutomaticInputFailoverSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutomaticInputFailoverSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getErrorClearTimeMsec() {
            return null;
        }

        @Nullable
        default public Object getFailoverConditions() {
            return null;
        }

        @Nullable
        default public String getInputPreference() {
            return null;
        }

        @Nullable
        default public String getSecondaryInputId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutomaticInputFailoverSettingsProperty> {
            private Number errorClearTimeMsec;
            private Object failoverConditions;
            private String inputPreference;
            private String secondaryInputId;

            public Builder errorClearTimeMsec(Number errorClearTimeMsec) {
                this.errorClearTimeMsec = errorClearTimeMsec;
                return this;
            }

            public Builder failoverConditions(IResolvable failoverConditions) {
                this.failoverConditions = failoverConditions;
                return this;
            }

            public Builder failoverConditions(List<? extends Object> failoverConditions) {
                this.failoverConditions = failoverConditions;
                return this;
            }

            public Builder inputPreference(String inputPreference) {
                this.inputPreference = inputPreference;
                return this;
            }

            public Builder secondaryInputId(String secondaryInputId) {
                this.secondaryInputId = secondaryInputId;
                return this;
            }

            public AutomaticInputFailoverSettingsProperty build() {
                return new Jsii.Proxy(this.errorClearTimeMsec, this.failoverConditions, this.inputPreference, this.secondaryInputId);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AudioTrackSelectionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AudioTrackSelectionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTracks() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AudioTrackSelectionProperty> {
            private Object tracks;

            public Builder tracks(IResolvable tracks) {
                this.tracks = tracks;
                return this;
            }

            public Builder tracks(List<? extends Object> tracks) {
                this.tracks = tracks;
                return this;
            }

            public AudioTrackSelectionProperty build() {
                return new Jsii.Proxy(this.tracks);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AudioTrackProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AudioTrackProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getTrack() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AudioTrackProperty> {
            private Number track;

            public Builder track(Number track) {
                this.track = track;
                return this;
            }

            public AudioTrackProperty build() {
                return new Jsii.Proxy(this.track);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AudioSilenceFailoverSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AudioSilenceFailoverSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAudioSelectorName() {
            return null;
        }

        @Nullable
        default public Number getAudioSilenceThresholdMsec() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AudioSilenceFailoverSettingsProperty> {
            private String audioSelectorName;
            private Number audioSilenceThresholdMsec;

            public Builder audioSelectorName(String audioSelectorName) {
                this.audioSelectorName = audioSelectorName;
                return this;
            }

            public Builder audioSilenceThresholdMsec(Number audioSilenceThresholdMsec) {
                this.audioSilenceThresholdMsec = audioSilenceThresholdMsec;
                return this;
            }

            public AudioSilenceFailoverSettingsProperty build() {
                return new Jsii.Proxy(this.audioSelectorName, this.audioSilenceThresholdMsec);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AudioSelectorSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AudioSelectorSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAudioLanguageSelection() {
            return null;
        }

        @Nullable
        default public Object getAudioPidSelection() {
            return null;
        }

        @Nullable
        default public Object getAudioTrackSelection() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AudioSelectorSettingsProperty> {
            private Object audioLanguageSelection;
            private Object audioPidSelection;
            private Object audioTrackSelection;

            public Builder audioLanguageSelection(IResolvable audioLanguageSelection) {
                this.audioLanguageSelection = audioLanguageSelection;
                return this;
            }

            public Builder audioLanguageSelection(AudioLanguageSelectionProperty audioLanguageSelection) {
                this.audioLanguageSelection = audioLanguageSelection;
                return this;
            }

            public Builder audioPidSelection(IResolvable audioPidSelection) {
                this.audioPidSelection = audioPidSelection;
                return this;
            }

            public Builder audioPidSelection(AudioPidSelectionProperty audioPidSelection) {
                this.audioPidSelection = audioPidSelection;
                return this;
            }

            public Builder audioTrackSelection(IResolvable audioTrackSelection) {
                this.audioTrackSelection = audioTrackSelection;
                return this;
            }

            public Builder audioTrackSelection(AudioTrackSelectionProperty audioTrackSelection) {
                this.audioTrackSelection = audioTrackSelection;
                return this;
            }

            public AudioSelectorSettingsProperty build() {
                return new Jsii.Proxy(this.audioLanguageSelection, this.audioPidSelection, this.audioTrackSelection);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AudioSelectorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AudioSelectorProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getSelectorSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AudioSelectorProperty> {
            private String name;
            private Object selectorSettings;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder selectorSettings(IResolvable selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            public Builder selectorSettings(AudioSelectorSettingsProperty selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            public AudioSelectorProperty build() {
                return new Jsii.Proxy(this.name, this.selectorSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AudioPidSelectionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AudioPidSelectionProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getPid() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AudioPidSelectionProperty> {
            private Number pid;

            public Builder pid(Number pid) {
                this.pid = pid;
                return this;
            }

            public AudioPidSelectionProperty build() {
                return new Jsii.Proxy(this.pid);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AudioOnlyHlsSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AudioOnlyHlsSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAudioGroupId() {
            return null;
        }

        @Nullable
        default public Object getAudioOnlyImage() {
            return null;
        }

        @Nullable
        default public String getAudioTrackType() {
            return null;
        }

        @Nullable
        default public String getSegmentType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AudioOnlyHlsSettingsProperty> {
            private String audioGroupId;
            private Object audioOnlyImage;
            private String audioTrackType;
            private String segmentType;

            public Builder audioGroupId(String audioGroupId) {
                this.audioGroupId = audioGroupId;
                return this;
            }

            public Builder audioOnlyImage(IResolvable audioOnlyImage) {
                this.audioOnlyImage = audioOnlyImage;
                return this;
            }

            public Builder audioOnlyImage(InputLocationProperty audioOnlyImage) {
                this.audioOnlyImage = audioOnlyImage;
                return this;
            }

            public Builder audioTrackType(String audioTrackType) {
                this.audioTrackType = audioTrackType;
                return this;
            }

            public Builder segmentType(String segmentType) {
                this.segmentType = segmentType;
                return this;
            }

            public AudioOnlyHlsSettingsProperty build() {
                return new Jsii.Proxy(this.audioGroupId, this.audioOnlyImage, this.audioTrackType, this.segmentType);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AudioNormalizationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AudioNormalizationSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAlgorithm() {
            return null;
        }

        @Nullable
        default public String getAlgorithmControl() {
            return null;
        }

        @Nullable
        default public Number getTargetLkfs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AudioNormalizationSettingsProperty> {
            private String algorithm;
            private String algorithmControl;
            private Number targetLkfs;

            public Builder algorithm(String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            public Builder algorithmControl(String algorithmControl) {
                this.algorithmControl = algorithmControl;
                return this;
            }

            public Builder targetLkfs(Number targetLkfs) {
                this.targetLkfs = targetLkfs;
                return this;
            }

            public AudioNormalizationSettingsProperty build() {
                return new Jsii.Proxy(this.algorithm, this.algorithmControl, this.targetLkfs);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AudioLanguageSelectionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AudioLanguageSelectionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLanguageCode() {
            return null;
        }

        @Nullable
        default public String getLanguageSelectionPolicy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AudioLanguageSelectionProperty> {
            private String languageCode;
            private String languageSelectionPolicy;

            public Builder languageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public Builder languageSelectionPolicy(String languageSelectionPolicy) {
                this.languageSelectionPolicy = languageSelectionPolicy;
                return this;
            }

            public AudioLanguageSelectionProperty build() {
                return new Jsii.Proxy(this.languageCode, this.languageSelectionPolicy);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AudioDescriptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AudioDescriptionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAudioNormalizationSettings() {
            return null;
        }

        @Nullable
        default public String getAudioSelectorName() {
            return null;
        }

        @Nullable
        default public String getAudioType() {
            return null;
        }

        @Nullable
        default public String getAudioTypeControl() {
            return null;
        }

        @Nullable
        default public Object getCodecSettings() {
            return null;
        }

        @Nullable
        default public String getLanguageCode() {
            return null;
        }

        @Nullable
        default public String getLanguageCodeControl() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getRemixSettings() {
            return null;
        }

        @Nullable
        default public String getStreamName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AudioDescriptionProperty> {
            private Object audioNormalizationSettings;
            private String audioSelectorName;
            private String audioType;
            private String audioTypeControl;
            private Object codecSettings;
            private String languageCode;
            private String languageCodeControl;
            private String name;
            private Object remixSettings;
            private String streamName;

            public Builder audioNormalizationSettings(IResolvable audioNormalizationSettings) {
                this.audioNormalizationSettings = audioNormalizationSettings;
                return this;
            }

            public Builder audioNormalizationSettings(AudioNormalizationSettingsProperty audioNormalizationSettings) {
                this.audioNormalizationSettings = audioNormalizationSettings;
                return this;
            }

            public Builder audioSelectorName(String audioSelectorName) {
                this.audioSelectorName = audioSelectorName;
                return this;
            }

            public Builder audioType(String audioType) {
                this.audioType = audioType;
                return this;
            }

            public Builder audioTypeControl(String audioTypeControl) {
                this.audioTypeControl = audioTypeControl;
                return this;
            }

            public Builder codecSettings(IResolvable codecSettings) {
                this.codecSettings = codecSettings;
                return this;
            }

            public Builder codecSettings(AudioCodecSettingsProperty codecSettings) {
                this.codecSettings = codecSettings;
                return this;
            }

            public Builder languageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public Builder languageCodeControl(String languageCodeControl) {
                this.languageCodeControl = languageCodeControl;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder remixSettings(IResolvable remixSettings) {
                this.remixSettings = remixSettings;
                return this;
            }

            public Builder remixSettings(RemixSettingsProperty remixSettings) {
                this.remixSettings = remixSettings;
                return this;
            }

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public AudioDescriptionProperty build() {
                return new Jsii.Proxy(this.audioNormalizationSettings, this.audioSelectorName, this.audioType, this.audioTypeControl, this.codecSettings, this.languageCode, this.languageCodeControl, this.name, this.remixSettings, this.streamName);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AudioCodecSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AudioCodecSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAacSettings() {
            return null;
        }

        @Nullable
        default public Object getAc3Settings() {
            return null;
        }

        @Nullable
        default public Object getEac3Settings() {
            return null;
        }

        @Nullable
        default public Object getMp2Settings() {
            return null;
        }

        @Nullable
        default public Object getPassThroughSettings() {
            return null;
        }

        @Nullable
        default public Object getWavSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AudioCodecSettingsProperty> {
            private Object aacSettings;
            private Object ac3Settings;
            private Object eac3Settings;
            private Object mp2Settings;
            private Object passThroughSettings;
            private Object wavSettings;

            public Builder aacSettings(IResolvable aacSettings) {
                this.aacSettings = aacSettings;
                return this;
            }

            public Builder aacSettings(AacSettingsProperty aacSettings) {
                this.aacSettings = aacSettings;
                return this;
            }

            public Builder ac3Settings(IResolvable ac3Settings) {
                this.ac3Settings = ac3Settings;
                return this;
            }

            public Builder ac3Settings(Ac3SettingsProperty ac3Settings) {
                this.ac3Settings = ac3Settings;
                return this;
            }

            public Builder eac3Settings(IResolvable eac3Settings) {
                this.eac3Settings = eac3Settings;
                return this;
            }

            public Builder eac3Settings(Eac3SettingsProperty eac3Settings) {
                this.eac3Settings = eac3Settings;
                return this;
            }

            public Builder mp2Settings(IResolvable mp2Settings) {
                this.mp2Settings = mp2Settings;
                return this;
            }

            public Builder mp2Settings(Mp2SettingsProperty mp2Settings) {
                this.mp2Settings = mp2Settings;
                return this;
            }

            public Builder passThroughSettings(IResolvable passThroughSettings) {
                this.passThroughSettings = passThroughSettings;
                return this;
            }

            public Builder passThroughSettings(PassThroughSettingsProperty passThroughSettings) {
                this.passThroughSettings = passThroughSettings;
                return this;
            }

            public Builder wavSettings(IResolvable wavSettings) {
                this.wavSettings = wavSettings;
                return this;
            }

            public Builder wavSettings(WavSettingsProperty wavSettings) {
                this.wavSettings = wavSettings;
                return this;
            }

            public AudioCodecSettingsProperty build() {
                return new Jsii.Proxy(this.aacSettings, this.ac3Settings, this.eac3Settings, this.mp2Settings, this.passThroughSettings, this.wavSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AudioChannelMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AudioChannelMappingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getInputChannelLevels() {
            return null;
        }

        @Nullable
        default public Number getOutputChannel() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AudioChannelMappingProperty> {
            private Object inputChannelLevels;
            private Number outputChannel;

            public Builder inputChannelLevels(IResolvable inputChannelLevels) {
                this.inputChannelLevels = inputChannelLevels;
                return this;
            }

            public Builder inputChannelLevels(List<? extends Object> inputChannelLevels) {
                this.inputChannelLevels = inputChannelLevels;
                return this;
            }

            public Builder outputChannel(Number outputChannel) {
                this.outputChannel = outputChannel;
                return this;
            }

            public AudioChannelMappingProperty build() {
                return new Jsii.Proxy(this.inputChannelLevels, this.outputChannel);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AribSourceSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AribSourceSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AribSourceSettingsProperty> {
            public AribSourceSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AribDestinationSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AribDestinationSettingsProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AribDestinationSettingsProperty> {
            public AribDestinationSettingsProperty build() {
                return new Jsii.Proxy();
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.ArchiveOutputSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArchiveOutputSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getContainerSettings() {
            return null;
        }

        @Nullable
        default public String getExtension() {
            return null;
        }

        @Nullable
        default public String getNameModifier() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArchiveOutputSettingsProperty> {
            private Object containerSettings;
            private String extension;
            private String nameModifier;

            public Builder containerSettings(IResolvable containerSettings) {
                this.containerSettings = containerSettings;
                return this;
            }

            public Builder containerSettings(ArchiveContainerSettingsProperty containerSettings) {
                this.containerSettings = containerSettings;
                return this;
            }

            public Builder extension(String extension) {
                this.extension = extension;
                return this;
            }

            public Builder nameModifier(String nameModifier) {
                this.nameModifier = nameModifier;
                return this;
            }

            public ArchiveOutputSettingsProperty build() {
                return new Jsii.Proxy(this.containerSettings, this.extension, this.nameModifier);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.ArchiveGroupSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArchiveGroupSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDestination() {
            return null;
        }

        @Nullable
        default public Number getRolloverInterval() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArchiveGroupSettingsProperty> {
            private Object destination;
            private Number rolloverInterval;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder rolloverInterval(Number rolloverInterval) {
                this.rolloverInterval = rolloverInterval;
                return this;
            }

            public ArchiveGroupSettingsProperty build() {
                return new Jsii.Proxy(this.destination, this.rolloverInterval);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.ArchiveContainerSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArchiveContainerSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getM2TsSettings() {
            return null;
        }

        @Nullable
        default public Object getRawSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArchiveContainerSettingsProperty> {
            private Object m2TsSettings;
            private Object rawSettings;

            public Builder m2TsSettings(IResolvable m2TsSettings) {
                this.m2TsSettings = m2TsSettings;
                return this;
            }

            public Builder m2TsSettings(M2tsSettingsProperty m2TsSettings) {
                this.m2TsSettings = m2TsSettings;
                return this;
            }

            public Builder rawSettings(IResolvable rawSettings) {
                this.rawSettings = rawSettings;
                return this;
            }

            public Builder rawSettings(RawSettingsProperty rawSettings) {
                this.rawSettings = rawSettings;
                return this;
            }

            public ArchiveContainerSettingsProperty build() {
                return new Jsii.Proxy(this.m2TsSettings, this.rawSettings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AncillarySourceSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AncillarySourceSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getSourceAncillaryChannelNumber() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AncillarySourceSettingsProperty> {
            private Number sourceAncillaryChannelNumber;

            public Builder sourceAncillaryChannelNumber(Number sourceAncillaryChannelNumber) {
                this.sourceAncillaryChannelNumber = sourceAncillaryChannelNumber;
                return this;
            }

            public AncillarySourceSettingsProperty build() {
                return new Jsii.Proxy(this.sourceAncillaryChannelNumber);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.Ac3SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Ac3SettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBitrate() {
            return null;
        }

        @Nullable
        default public String getBitstreamMode() {
            return null;
        }

        @Nullable
        default public String getCodingMode() {
            return null;
        }

        @Nullable
        default public Number getDialnorm() {
            return null;
        }

        @Nullable
        default public String getDrcProfile() {
            return null;
        }

        @Nullable
        default public String getLfeFilter() {
            return null;
        }

        @Nullable
        default public String getMetadataControl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Ac3SettingsProperty> {
            private Number bitrate;
            private String bitstreamMode;
            private String codingMode;
            private Number dialnorm;
            private String drcProfile;
            private String lfeFilter;
            private String metadataControl;

            public Builder bitrate(Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            public Builder bitstreamMode(String bitstreamMode) {
                this.bitstreamMode = bitstreamMode;
                return this;
            }

            public Builder codingMode(String codingMode) {
                this.codingMode = codingMode;
                return this;
            }

            public Builder dialnorm(Number dialnorm) {
                this.dialnorm = dialnorm;
                return this;
            }

            public Builder drcProfile(String drcProfile) {
                this.drcProfile = drcProfile;
                return this;
            }

            public Builder lfeFilter(String lfeFilter) {
                this.lfeFilter = lfeFilter;
                return this;
            }

            public Builder metadataControl(String metadataControl) {
                this.metadataControl = metadataControl;
                return this;
            }

            public Ac3SettingsProperty build() {
                return new Jsii.Proxy(this.bitrate, this.bitstreamMode, this.codingMode, this.dialnorm, this.drcProfile, this.lfeFilter, this.metadataControl);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-medialive.CfnChannel.AacSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AacSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBitrate() {
            return null;
        }

        @Nullable
        default public String getCodingMode() {
            return null;
        }

        @Nullable
        default public String getInputType() {
            return null;
        }

        @Nullable
        default public String getProfile() {
            return null;
        }

        @Nullable
        default public String getRateControlMode() {
            return null;
        }

        @Nullable
        default public String getRawFormat() {
            return null;
        }

        @Nullable
        default public Number getSampleRate() {
            return null;
        }

        @Nullable
        default public String getSpec() {
            return null;
        }

        @Nullable
        default public String getVbrQuality() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AacSettingsProperty> {
            private Number bitrate;
            private String codingMode;
            private String inputType;
            private String profile;
            private String rateControlMode;
            private String rawFormat;
            private Number sampleRate;
            private String spec;
            private String vbrQuality;

            public Builder bitrate(Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            public Builder codingMode(String codingMode) {
                this.codingMode = codingMode;
                return this;
            }

            public Builder inputType(String inputType) {
                this.inputType = inputType;
                return this;
            }

            public Builder profile(String profile) {
                this.profile = profile;
                return this;
            }

            public Builder rateControlMode(String rateControlMode) {
                this.rateControlMode = rateControlMode;
                return this;
            }

            public Builder rawFormat(String rawFormat) {
                this.rawFormat = rawFormat;
                return this;
            }

            public Builder sampleRate(Number sampleRate) {
                this.sampleRate = sampleRate;
                return this;
            }

            public Builder spec(String spec) {
                this.spec = spec;
                return this;
            }

            public Builder vbrQuality(String vbrQuality) {
                this.vbrQuality = vbrQuality;
                return this;
            }

            public AacSettingsProperty build() {
                return new Jsii.Proxy(this.bitrate, this.codingMode, this.inputType, this.profile, this.rateControlMode, this.rawFormat, this.sampleRate, this.spec, this.vbrQuality);
            }
        }
    }
}

