/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.amplify;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.amplify.CfnApp;
import software.amazon.awscdk.services.amplify.CfnAppProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_amplify.CfnApp")
public class CfnApp
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApp.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnApp(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApp(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApp(@NotNull Construct scope, @NotNull String id, @NotNull CfnAppProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAppId() {
        return (String)this.jsiiGet("attrAppId", String.class);
    }

    @NotNull
    public String getAttrAppName() {
        return (String)this.jsiiGet("attrAppName", String.class);
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    public String getAttrDefaultDomain() {
        return (String)this.jsiiGet("attrDefaultDomain", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @NotNull
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@NotNull String value) {
        this.jsiiSet("name", Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getAccessToken() {
        return (String)this.jsiiGet("accessToken", String.class);
    }

    public void setAccessToken(@Nullable String value) {
        this.jsiiSet("accessToken", value);
    }

    @Nullable
    public Object getAutoBranchCreationConfig() {
        return this.jsiiGet("autoBranchCreationConfig", Object.class);
    }

    public void setAutoBranchCreationConfig(@Nullable AutoBranchCreationConfigProperty value) {
        this.jsiiSet("autoBranchCreationConfig", value);
    }

    public void setAutoBranchCreationConfig(@Nullable IResolvable value) {
        this.jsiiSet("autoBranchCreationConfig", value);
    }

    @Nullable
    public Object getBasicAuthConfig() {
        return this.jsiiGet("basicAuthConfig", Object.class);
    }

    public void setBasicAuthConfig(@Nullable BasicAuthConfigProperty value) {
        this.jsiiSet("basicAuthConfig", value);
    }

    public void setBasicAuthConfig(@Nullable IResolvable value) {
        this.jsiiSet("basicAuthConfig", value);
    }

    @Nullable
    public String getBuildSpec() {
        return (String)this.jsiiGet("buildSpec", String.class);
    }

    public void setBuildSpec(@Nullable String value) {
        this.jsiiSet("buildSpec", value);
    }

    @Nullable
    public Object getCustomRules() {
        return this.jsiiGet("customRules", Object.class);
    }

    public void setCustomRules(@Nullable IResolvable value) {
        this.jsiiSet("customRules", value);
    }

    public void setCustomRules(@Nullable List<Object> value) {
        this.jsiiSet("customRules", value);
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public Object getEnableBranchAutoDeletion() {
        return this.jsiiGet("enableBranchAutoDeletion", Object.class);
    }

    public void setEnableBranchAutoDeletion(@Nullable Boolean value) {
        this.jsiiSet("enableBranchAutoDeletion", value);
    }

    public void setEnableBranchAutoDeletion(@Nullable IResolvable value) {
        this.jsiiSet("enableBranchAutoDeletion", value);
    }

    @Nullable
    public Object getEnvironmentVariables() {
        return this.jsiiGet("environmentVariables", Object.class);
    }

    public void setEnvironmentVariables(@Nullable IResolvable value) {
        this.jsiiSet("environmentVariables", value);
    }

    public void setEnvironmentVariables(@Nullable List<Object> value) {
        this.jsiiSet("environmentVariables", value);
    }

    @Nullable
    public String getIamServiceRole() {
        return (String)this.jsiiGet("iamServiceRole", String.class);
    }

    public void setIamServiceRole(@Nullable String value) {
        this.jsiiSet("iamServiceRole", value);
    }

    @Nullable
    public String getOauthToken() {
        return (String)this.jsiiGet("oauthToken", String.class);
    }

    public void setOauthToken(@Nullable String value) {
        this.jsiiSet("oauthToken", value);
    }

    @Nullable
    public String getRepository() {
        return (String)this.jsiiGet("repository", String.class);
    }

    public void setRepository(@Nullable String value) {
        this.jsiiSet("repository", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApp> {
        private final Construct scope;
        private final String id;
        private final CfnAppProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAppProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.props.accessToken(accessToken);
            return this;
        }

        public Builder autoBranchCreationConfig(AutoBranchCreationConfigProperty autoBranchCreationConfig) {
            this.props.autoBranchCreationConfig(autoBranchCreationConfig);
            return this;
        }

        public Builder autoBranchCreationConfig(IResolvable autoBranchCreationConfig) {
            this.props.autoBranchCreationConfig(autoBranchCreationConfig);
            return this;
        }

        public Builder basicAuthConfig(BasicAuthConfigProperty basicAuthConfig) {
            this.props.basicAuthConfig(basicAuthConfig);
            return this;
        }

        public Builder basicAuthConfig(IResolvable basicAuthConfig) {
            this.props.basicAuthConfig(basicAuthConfig);
            return this;
        }

        public Builder buildSpec(String buildSpec) {
            this.props.buildSpec(buildSpec);
            return this;
        }

        public Builder customRules(IResolvable customRules) {
            this.props.customRules(customRules);
            return this;
        }

        public Builder customRules(List<Object> customRules) {
            this.props.customRules(customRules);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder enableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.props.enableBranchAutoDeletion(enableBranchAutoDeletion);
            return this;
        }

        public Builder enableBranchAutoDeletion(IResolvable enableBranchAutoDeletion) {
            this.props.enableBranchAutoDeletion(enableBranchAutoDeletion);
            return this;
        }

        public Builder environmentVariables(IResolvable environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        public Builder environmentVariables(List<Object> environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        public Builder iamServiceRole(String iamServiceRole) {
            this.props.iamServiceRole(iamServiceRole);
            return this;
        }

        public Builder oauthToken(String oauthToken) {
            this.props.oauthToken(oauthToken);
            return this;
        }

        public Builder repository(String repository) {
            this.props.repository(repository);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnApp build() {
            return new CfnApp(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_amplify.CfnApp.EnvironmentVariableProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentVariableProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentVariableProperty> {
            private String name;
            private String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EnvironmentVariableProperty build() {
                return new Jsii.Proxy(this.name, this.value, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_amplify.CfnApp.CustomRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomRuleProperty
    extends JsiiSerializable {
        @NotNull
        public String getSource();

        @NotNull
        public String getTarget();

        @Nullable
        default public String getCondition() {
            return null;
        }

        @Nullable
        default public String getStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomRuleProperty> {
            private String source;
            private String target;
            private String condition;
            private String status;

            public Builder source(String source) {
                this.source = source;
                return this;
            }

            public Builder target(String target) {
                this.target = target;
                return this;
            }

            public Builder condition(String condition) {
                this.condition = condition;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public CustomRuleProperty build() {
                return new Jsii.Proxy(this.source, this.target, this.condition, this.status, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_amplify.CfnApp.BasicAuthConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BasicAuthConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnableBasicAuth() {
            return null;
        }

        @Nullable
        default public String getPassword() {
            return null;
        }

        @Nullable
        default public String getUsername() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BasicAuthConfigProperty> {
            private Object enableBasicAuth;
            private String password;
            private String username;

            public Builder enableBasicAuth(Boolean enableBasicAuth) {
                this.enableBasicAuth = enableBasicAuth;
                return this;
            }

            public Builder enableBasicAuth(IResolvable enableBasicAuth) {
                this.enableBasicAuth = enableBasicAuth;
                return this;
            }

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public BasicAuthConfigProperty build() {
                return new Jsii.Proxy(this.enableBasicAuth, this.password, this.username, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_amplify.CfnApp.AutoBranchCreationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoBranchCreationConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAutoBranchCreationPatterns() {
            return null;
        }

        @Nullable
        default public Object getBasicAuthConfig() {
            return null;
        }

        @Nullable
        default public String getBuildSpec() {
            return null;
        }

        @Nullable
        default public Object getEnableAutoBranchCreation() {
            return null;
        }

        @Nullable
        default public Object getEnableAutoBuild() {
            return null;
        }

        @Nullable
        default public Object getEnablePullRequestPreview() {
            return null;
        }

        @Nullable
        default public Object getEnvironmentVariables() {
            return null;
        }

        @Nullable
        default public String getPullRequestEnvironmentName() {
            return null;
        }

        @Nullable
        default public String getStage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoBranchCreationConfigProperty> {
            private List<String> autoBranchCreationPatterns;
            private Object basicAuthConfig;
            private String buildSpec;
            private Object enableAutoBranchCreation;
            private Object enableAutoBuild;
            private Object enablePullRequestPreview;
            private Object environmentVariables;
            private String pullRequestEnvironmentName;
            private String stage;

            public Builder autoBranchCreationPatterns(List<String> autoBranchCreationPatterns) {
                this.autoBranchCreationPatterns = autoBranchCreationPatterns;
                return this;
            }

            public Builder basicAuthConfig(BasicAuthConfigProperty basicAuthConfig) {
                this.basicAuthConfig = basicAuthConfig;
                return this;
            }

            public Builder basicAuthConfig(IResolvable basicAuthConfig) {
                this.basicAuthConfig = basicAuthConfig;
                return this;
            }

            public Builder buildSpec(String buildSpec) {
                this.buildSpec = buildSpec;
                return this;
            }

            public Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation) {
                this.enableAutoBranchCreation = enableAutoBranchCreation;
                return this;
            }

            public Builder enableAutoBranchCreation(IResolvable enableAutoBranchCreation) {
                this.enableAutoBranchCreation = enableAutoBranchCreation;
                return this;
            }

            public Builder enableAutoBuild(Boolean enableAutoBuild) {
                this.enableAutoBuild = enableAutoBuild;
                return this;
            }

            public Builder enableAutoBuild(IResolvable enableAutoBuild) {
                this.enableAutoBuild = enableAutoBuild;
                return this;
            }

            public Builder enablePullRequestPreview(Boolean enablePullRequestPreview) {
                this.enablePullRequestPreview = enablePullRequestPreview;
                return this;
            }

            public Builder enablePullRequestPreview(IResolvable enablePullRequestPreview) {
                this.enablePullRequestPreview = enablePullRequestPreview;
                return this;
            }

            public Builder environmentVariables(IResolvable environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            public Builder environmentVariables(List<Object> environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            public Builder pullRequestEnvironmentName(String pullRequestEnvironmentName) {
                this.pullRequestEnvironmentName = pullRequestEnvironmentName;
                return this;
            }

            public Builder stage(String stage) {
                this.stage = stage;
                return this;
            }

            public AutoBranchCreationConfigProperty build() {
                return new Jsii.Proxy(this.autoBranchCreationPatterns, this.basicAuthConfig, this.buildSpec, this.enableAutoBranchCreation, this.enableAutoBuild, this.enablePullRequestPreview, this.environmentVariables, this.pullRequestEnvironmentName, this.stage, null);
            }
        }
    }
}

