/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appmesh;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.appmesh.CfnVirtualNode;
import software.amazon.awscdk.services.appmesh.IMesh;
import software.amazon.awscdk.services.appmesh.IVirtualNode;
import software.amazon.awscdk.services.appmesh.IVirtualService;
import software.amazon.awscdk.services.appmesh.VirtualNodeListener;
import software.amazon.awscdk.services.appmesh.VirtualNodeProps;
import software.amazon.awscdk.services.servicediscovery.IService;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appmesh.VirtualNode")
public class VirtualNode
extends Resource
implements IVirtualNode {
    protected VirtualNode(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualNode(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public VirtualNode(@NotNull Construct scope, @NotNull String id, @NotNull VirtualNodeProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IVirtualNode fromVirtualNodeArn(@NotNull Construct scope, @NotNull String id, @NotNull String virtualNodeArn) {
        return (IVirtualNode)JsiiObject.jsiiStaticCall(VirtualNode.class, (String)"fromVirtualNodeArn", IVirtualNode.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(virtualNodeArn, "virtualNodeArn is required")});
    }

    @NotNull
    public static IVirtualNode fromVirtualNodeName(@NotNull Construct scope, @NotNull String id, @NotNull String meshName, @NotNull String virtualNodeName) {
        return (IVirtualNode)JsiiObject.jsiiStaticCall(VirtualNode.class, (String)"fromVirtualNodeName", IVirtualNode.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(meshName, "meshName is required"), Objects.requireNonNull(virtualNodeName, "virtualNodeName is required")});
    }

    @Override
    public void addBackends(IVirtualService ... props) {
        this.jsiiCall("addBackends", NativeType.VOID, Arrays.stream(props).toArray(Object[]::new));
    }

    @Override
    public void addListeners(VirtualNodeListener ... listeners) {
        this.jsiiCall("addListeners", NativeType.VOID, Arrays.stream(listeners).toArray(Object[]::new));
    }

    @NotNull
    protected List<CfnVirtualNode.BackendProperty> getBackends() {
        return Collections.unmodifiableList((List)this.jsiiGet("backends", NativeType.listOf((NativeType)NativeType.forClass(CfnVirtualNode.BackendProperty.class))));
    }

    @NotNull
    protected List<CfnVirtualNode.ListenerProperty> getListeners() {
        return Collections.unmodifiableList((List)this.jsiiGet("listeners", NativeType.listOf((NativeType)NativeType.forClass(CfnVirtualNode.ListenerProperty.class))));
    }

    @NotNull
    public IMesh getMesh() {
        return (IMesh)this.jsiiGet("mesh", IMesh.class);
    }

    @Override
    @NotNull
    public String getVirtualNodeArn() {
        return (String)this.jsiiGet("virtualNodeArn", String.class);
    }

    @Override
    @NotNull
    public String getVirtualNodeName() {
        return (String)this.jsiiGet("virtualNodeName", String.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<VirtualNode> {
        private final Construct scope;
        private final String id;
        private final VirtualNodeProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new VirtualNodeProps.Builder();
        }

        public Builder backends(List<IVirtualService> backends) {
            this.props.backends(backends);
            return this;
        }

        public Builder cloudMapService(IService cloudMapService) {
            this.props.cloudMapService(cloudMapService);
            return this;
        }

        public Builder cloudMapServiceInstanceAttributes(Map<String, String> cloudMapServiceInstanceAttributes) {
            this.props.cloudMapServiceInstanceAttributes(cloudMapServiceInstanceAttributes);
            return this;
        }

        public Builder dnsHostName(String dnsHostName) {
            this.props.dnsHostName(dnsHostName);
            return this;
        }

        public Builder listener(VirtualNodeListener listener) {
            this.props.listener(listener);
            return this;
        }

        public Builder virtualNodeName(String virtualNodeName) {
            this.props.virtualNodeName(virtualNodeName);
            return this;
        }

        public Builder mesh(IMesh mesh) {
            this.props.mesh(mesh);
            return this;
        }

        public VirtualNode build() {
            return new VirtualNode(this.scope, this.id, this.props.build());
        }
    }
}

