/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appsync;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.appsync.AuthorizationConfig;
import software.amazon.awscdk.services.appsync.CfnGraphQLSchema;
import software.amazon.awscdk.services.appsync.GraphQLApiProps;
import software.amazon.awscdk.services.appsync.GraphqlApiAttributes;
import software.amazon.awscdk.services.appsync.GraphqlApiBase;
import software.amazon.awscdk.services.appsync.IGraphqlApi;
import software.amazon.awscdk.services.appsync.IamResource;
import software.amazon.awscdk.services.appsync.LogConfig;
import software.amazon.awscdk.services.appsync.ObjectType;
import software.amazon.awscdk.services.appsync.ObjectTypeProps;
import software.amazon.awscdk.services.appsync.SchemaDefinition;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_appsync.GraphQLApi")
public class GraphQLApi
extends GraphqlApiBase {
    protected GraphQLApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GraphQLApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public GraphQLApi(@NotNull Construct scope, @NotNull String id, @NotNull GraphQLApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IGraphqlApi fromGraphqlApiAttributes(@NotNull Construct scope, @NotNull String id, @NotNull GraphqlApiAttributes attrs) {
        return (IGraphqlApi)JsiiObject.jsiiStaticCall(GraphQLApi.class, (String)"fromGraphqlApiAttributes", IGraphqlApi.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public Boolean addSchemaDependency(@NotNull CfnResource construct) {
        return (Boolean)this.jsiiCall("addSchemaDependency", Boolean.class, new Object[]{Objects.requireNonNull(construct, "construct is required")});
    }

    @NotNull
    public ObjectType addType(@NotNull String name, @NotNull ObjectTypeProps props) {
        return (ObjectType)((Object)this.jsiiCall("addType", ObjectType.class, new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(props, "props is required")}));
    }

    public void appendToSchema(@NotNull String addition, @Nullable String delimiter) {
        this.jsiiCall("appendToSchema", NativeType.VOID, new Object[]{Objects.requireNonNull(addition, "addition is required"), delimiter});
    }

    public void appendToSchema(@NotNull String addition) {
        this.jsiiCall("appendToSchema", NativeType.VOID, new Object[]{Objects.requireNonNull(addition, "addition is required")});
    }

    @NotNull
    public Grant grant(@NotNull IGrantable grantee, @NotNull IamResource resources, String ... actions) {
        return (Grant)this.jsiiCall("grant", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required"), Objects.requireNonNull(resources, "resources is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    @NotNull
    public Grant grantMutation(@NotNull IGrantable grantee, String ... fields) {
        return (Grant)this.jsiiCall("grantMutation", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(fields)).toArray(Object[]::new));
    }

    @NotNull
    public Grant grantQuery(@NotNull IGrantable grantee, String ... fields) {
        return (Grant)this.jsiiCall("grantQuery", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(fields)).toArray(Object[]::new));
    }

    @NotNull
    public Grant grantSubscription(@NotNull IGrantable grantee, String ... fields) {
        return (Grant)this.jsiiCall("grantSubscription", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(fields)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public String getApiId() {
        return (String)this.jsiiGet("apiId", String.class);
    }

    @Override
    @NotNull
    public String getArn() {
        return (String)this.jsiiGet("arn", String.class);
    }

    @NotNull
    public String getGraphQlUrl() {
        return (String)this.jsiiGet("graphQlUrl", String.class);
    }

    @NotNull
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    @NotNull
    public CfnGraphQLSchema getSchema() {
        return (CfnGraphQLSchema)this.jsiiGet("schema", CfnGraphQLSchema.class);
    }

    @Nullable
    public String getApiKey() {
        return (String)this.jsiiGet("apiKey", String.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<GraphQLApi> {
        private final Construct scope;
        private final String id;
        private final GraphQLApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new GraphQLApiProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder schemaDefinition(SchemaDefinition schemaDefinition) {
            this.props.schemaDefinition(schemaDefinition);
            return this;
        }

        public Builder authorizationConfig(AuthorizationConfig authorizationConfig) {
            this.props.authorizationConfig(authorizationConfig);
            return this;
        }

        public Builder logConfig(LogConfig logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }

        public Builder schemaDefinitionFile(String schemaDefinitionFile) {
            this.props.schemaDefinitionFile(schemaDefinitionFile);
            return this;
        }

        public Builder xrayEnabled(Boolean xrayEnabled) {
            this.props.xrayEnabled(xrayEnabled);
            return this;
        }

        public GraphQLApi build() {
            return new GraphQLApi(this.scope, this.id, this.props.build());
        }
    }
}

