/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.autoscaling;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.autoscaling.AutoScalingGroupProps;
import software.amazon.awscdk.services.autoscaling.BasicLifecycleHookProps;
import software.amazon.awscdk.services.autoscaling.BasicScheduledActionProps;
import software.amazon.awscdk.services.autoscaling.BasicStepScalingPolicyProps;
import software.amazon.awscdk.services.autoscaling.BlockDevice;
import software.amazon.awscdk.services.autoscaling.CpuUtilizationScalingProps;
import software.amazon.awscdk.services.autoscaling.GroupMetrics;
import software.amazon.awscdk.services.autoscaling.HealthCheck;
import software.amazon.awscdk.services.autoscaling.IAutoScalingGroup;
import software.amazon.awscdk.services.autoscaling.LifecycleHook;
import software.amazon.awscdk.services.autoscaling.MetricTargetTrackingProps;
import software.amazon.awscdk.services.autoscaling.Monitoring;
import software.amazon.awscdk.services.autoscaling.NetworkUtilizationScalingProps;
import software.amazon.awscdk.services.autoscaling.NotificationConfiguration;
import software.amazon.awscdk.services.autoscaling.RequestCountScalingProps;
import software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration;
import software.amazon.awscdk.services.autoscaling.ScheduledAction;
import software.amazon.awscdk.services.autoscaling.StepScalingPolicy;
import software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy;
import software.amazon.awscdk.services.autoscaling.UpdateType;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.OperatingSystemType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.UserData;
import software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_autoscaling.AutoScalingGroup")
public class AutoScalingGroup
extends Resource
implements ILoadBalancerTarget,
IConnectable,
IApplicationLoadBalancerTarget,
INetworkLoadBalancerTarget,
IAutoScalingGroup {
    protected AutoScalingGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AutoScalingGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AutoScalingGroup(@NotNull Construct scope, @NotNull String id, @NotNull AutoScalingGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IAutoScalingGroup fromAutoScalingGroupName(@NotNull Construct scope, @NotNull String id, @NotNull String autoScalingGroupName) {
        return (IAutoScalingGroup)JsiiObject.jsiiStaticCall(AutoScalingGroup.class, (String)"fromAutoScalingGroupName", IAutoScalingGroup.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(autoScalingGroupName, "autoScalingGroupName is required")});
    }

    @Override
    @NotNull
    public LifecycleHook addLifecycleHook(@NotNull String id, @NotNull BasicLifecycleHookProps props) {
        return (LifecycleHook)this.jsiiCall("addLifecycleHook", LifecycleHook.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addSecurityGroup(@NotNull ISecurityGroup securityGroup) {
        this.jsiiCall("addSecurityGroup", NativeType.VOID, new Object[]{Objects.requireNonNull(securityGroup, "securityGroup is required")});
    }

    public void addToRolePolicy(@NotNull PolicyStatement statement) {
        this.jsiiCall("addToRolePolicy", NativeType.VOID, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    public void addUserData(String ... commands) {
        this.jsiiCall("addUserData", NativeType.VOID, Arrays.stream(commands).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public LoadBalancerTargetProps attachToApplicationTargetGroup(@NotNull IApplicationTargetGroup targetGroup) {
        return (LoadBalancerTargetProps)this.jsiiCall("attachToApplicationTargetGroup", LoadBalancerTargetProps.class, new Object[]{Objects.requireNonNull(targetGroup, "targetGroup is required")});
    }

    @Override
    public void attachToClassicLB(@NotNull LoadBalancer loadBalancer) {
        this.jsiiCall("attachToClassicLB", NativeType.VOID, new Object[]{Objects.requireNonNull(loadBalancer, "loadBalancer is required")});
    }

    @Override
    @NotNull
    public LoadBalancerTargetProps attachToNetworkTargetGroup(@NotNull INetworkTargetGroup targetGroup) {
        return (LoadBalancerTargetProps)this.jsiiCall("attachToNetworkTargetGroup", LoadBalancerTargetProps.class, new Object[]{Objects.requireNonNull(targetGroup, "targetGroup is required")});
    }

    @Override
    @NotNull
    public TargetTrackingScalingPolicy scaleOnCpuUtilization(@NotNull String id, @NotNull CpuUtilizationScalingProps props) {
        return (TargetTrackingScalingPolicy)this.jsiiCall("scaleOnCpuUtilization", TargetTrackingScalingPolicy.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public TargetTrackingScalingPolicy scaleOnIncomingBytes(@NotNull String id, @NotNull NetworkUtilizationScalingProps props) {
        return (TargetTrackingScalingPolicy)this.jsiiCall("scaleOnIncomingBytes", TargetTrackingScalingPolicy.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public StepScalingPolicy scaleOnMetric(@NotNull String id, @NotNull BasicStepScalingPolicyProps props) {
        return (StepScalingPolicy)this.jsiiCall("scaleOnMetric", StepScalingPolicy.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public TargetTrackingScalingPolicy scaleOnOutgoingBytes(@NotNull String id, @NotNull NetworkUtilizationScalingProps props) {
        return (TargetTrackingScalingPolicy)this.jsiiCall("scaleOnOutgoingBytes", TargetTrackingScalingPolicy.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public TargetTrackingScalingPolicy scaleOnRequestCount(@NotNull String id, @NotNull RequestCountScalingProps props) {
        return (TargetTrackingScalingPolicy)this.jsiiCall("scaleOnRequestCount", TargetTrackingScalingPolicy.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public ScheduledAction scaleOnSchedule(@NotNull String id, @NotNull BasicScheduledActionProps props) {
        return (ScheduledAction)this.jsiiCall("scaleOnSchedule", ScheduledAction.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public TargetTrackingScalingPolicy scaleToTrackMetric(@NotNull String id, @NotNull MetricTargetTrackingProps props) {
        return (TargetTrackingScalingPolicy)this.jsiiCall("scaleToTrackMetric", TargetTrackingScalingPolicy.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public String getAutoScalingGroupArn() {
        return (String)this.jsiiGet("autoScalingGroupArn", String.class);
    }

    @Override
    @NotNull
    public String getAutoScalingGroupName() {
        return (String)this.jsiiGet("autoScalingGroupName", String.class);
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)this.jsiiGet("grantPrincipal", IPrincipal.class);
    }

    @Override
    @NotNull
    public OperatingSystemType getOsType() {
        return (OperatingSystemType)((Object)this.jsiiGet("osType", OperatingSystemType.class));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)this.jsiiGet("role", IRole.class);
    }

    @NotNull
    public UserData getUserData() {
        return (UserData)((Object)this.jsiiGet("userData", UserData.class));
    }

    @Nullable
    public Duration getMaxInstanceLifetime() {
        return (Duration)((Object)this.jsiiGet("maxInstanceLifetime", Duration.class));
    }

    @Nullable
    public String getSpotPrice() {
        return (String)this.jsiiGet("spotPrice", String.class);
    }

    @Nullable
    protected ApplicationTargetGroup getAlbTargetGroup() {
        return (ApplicationTargetGroup)this.jsiiGet("albTargetGroup", ApplicationTargetGroup.class);
    }

    protected void setAlbTargetGroup(@Nullable ApplicationTargetGroup value) {
        this.jsiiSet("albTargetGroup", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AutoScalingGroup> {
        private final Construct scope;
        private final String id;
        private final AutoScalingGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new AutoScalingGroupProps.Builder();
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.props.associatePublicIpAddress(associatePublicIpAddress);
            return this;
        }

        public Builder autoScalingGroupName(String autoScalingGroupName) {
            this.props.autoScalingGroupName(autoScalingGroupName);
            return this;
        }

        public Builder blockDevices(List<BlockDevice> blockDevices) {
            this.props.blockDevices(blockDevices);
            return this;
        }

        public Builder cooldown(Duration cooldown) {
            this.props.cooldown(cooldown);
            return this;
        }

        public Builder desiredCapacity(Number desiredCapacity) {
            this.props.desiredCapacity(desiredCapacity);
            return this;
        }

        public Builder groupMetrics(List<GroupMetrics> groupMetrics) {
            this.props.groupMetrics(groupMetrics);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        public Builder ignoreUnmodifiedSizeProperties(Boolean ignoreUnmodifiedSizeProperties) {
            this.props.ignoreUnmodifiedSizeProperties(ignoreUnmodifiedSizeProperties);
            return this;
        }

        public Builder instanceMonitoring(Monitoring instanceMonitoring) {
            this.props.instanceMonitoring(instanceMonitoring);
            return this;
        }

        public Builder keyName(String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        public Builder maxCapacity(Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        public Builder maxInstanceLifetime(Duration maxInstanceLifetime) {
            this.props.maxInstanceLifetime(maxInstanceLifetime);
            return this;
        }

        public Builder minCapacity(Number minCapacity) {
            this.props.minCapacity(minCapacity);
            return this;
        }

        public Builder notifications(List<NotificationConfiguration> notifications) {
            this.props.notifications(notifications);
            return this;
        }

        @Deprecated
        public Builder notificationsTopic(ITopic notificationsTopic) {
            this.props.notificationsTopic(notificationsTopic);
            return this;
        }

        public Builder replacingUpdateMinSuccessfulInstancesPercent(Number replacingUpdateMinSuccessfulInstancesPercent) {
            this.props.replacingUpdateMinSuccessfulInstancesPercent(replacingUpdateMinSuccessfulInstancesPercent);
            return this;
        }

        public Builder resourceSignalCount(Number resourceSignalCount) {
            this.props.resourceSignalCount(resourceSignalCount);
            return this;
        }

        public Builder resourceSignalTimeout(Duration resourceSignalTimeout) {
            this.props.resourceSignalTimeout(resourceSignalTimeout);
            return this;
        }

        public Builder rollingUpdateConfiguration(RollingUpdateConfiguration rollingUpdateConfiguration) {
            this.props.rollingUpdateConfiguration(rollingUpdateConfiguration);
            return this;
        }

        public Builder spotPrice(String spotPrice) {
            this.props.spotPrice(spotPrice);
            return this;
        }

        public Builder updateType(UpdateType updateType) {
            this.props.updateType(updateType);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder machineImage(IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder userData(UserData userData) {
            this.props.userData(userData);
            return this;
        }

        public AutoScalingGroup build() {
            return new AutoScalingGroup(this.scope, this.id, this.props.build());
        }
    }
}

