/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.autoscaling;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup;
import software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_autoscaling.CfnAutoScalingGroup")
public class CfnAutoScalingGroup
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAutoScalingGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnAutoScalingGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAutoScalingGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAutoScalingGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnAutoScalingGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @NotNull
    public String getMaxSize() {
        return (String)this.jsiiGet("maxSize", String.class);
    }

    public void setMaxSize(@NotNull String value) {
        this.jsiiSet("maxSize", Objects.requireNonNull(value, "maxSize is required"));
    }

    @NotNull
    public String getMinSize() {
        return (String)this.jsiiGet("minSize", String.class);
    }

    public void setMinSize(@NotNull String value) {
        this.jsiiSet("minSize", Objects.requireNonNull(value, "minSize is required"));
    }

    @Nullable
    public String getAutoScalingGroupName() {
        return (String)this.jsiiGet("autoScalingGroupName", String.class);
    }

    public void setAutoScalingGroupName(@Nullable String value) {
        this.jsiiSet("autoScalingGroupName", value);
    }

    @Nullable
    public List<String> getAvailabilityZones() {
        return Optional.ofNullable((List)this.jsiiGet("availabilityZones", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAvailabilityZones(@Nullable List<String> value) {
        this.jsiiSet("availabilityZones", value);
    }

    @Nullable
    public String getCooldown() {
        return (String)this.jsiiGet("cooldown", String.class);
    }

    public void setCooldown(@Nullable String value) {
        this.jsiiSet("cooldown", value);
    }

    @Nullable
    public String getDesiredCapacity() {
        return (String)this.jsiiGet("desiredCapacity", String.class);
    }

    public void setDesiredCapacity(@Nullable String value) {
        this.jsiiSet("desiredCapacity", value);
    }

    @Nullable
    public Number getHealthCheckGracePeriod() {
        return (Number)this.jsiiGet("healthCheckGracePeriod", Number.class);
    }

    public void setHealthCheckGracePeriod(@Nullable Number value) {
        this.jsiiSet("healthCheckGracePeriod", value);
    }

    @Nullable
    public String getHealthCheckType() {
        return (String)this.jsiiGet("healthCheckType", String.class);
    }

    public void setHealthCheckType(@Nullable String value) {
        this.jsiiSet("healthCheckType", value);
    }

    @Nullable
    public String getInstanceId() {
        return (String)this.jsiiGet("instanceId", String.class);
    }

    public void setInstanceId(@Nullable String value) {
        this.jsiiSet("instanceId", value);
    }

    @Nullable
    public String getLaunchConfigurationName() {
        return (String)this.jsiiGet("launchConfigurationName", String.class);
    }

    public void setLaunchConfigurationName(@Nullable String value) {
        this.jsiiSet("launchConfigurationName", value);
    }

    @Nullable
    public Object getLaunchTemplate() {
        return this.jsiiGet("launchTemplate", Object.class);
    }

    public void setLaunchTemplate(@Nullable LaunchTemplateSpecificationProperty value) {
        this.jsiiSet("launchTemplate", value);
    }

    public void setLaunchTemplate(@Nullable IResolvable value) {
        this.jsiiSet("launchTemplate", value);
    }

    @Nullable
    public Object getLifecycleHookSpecificationList() {
        return this.jsiiGet("lifecycleHookSpecificationList", Object.class);
    }

    public void setLifecycleHookSpecificationList(@Nullable IResolvable value) {
        this.jsiiSet("lifecycleHookSpecificationList", value);
    }

    public void setLifecycleHookSpecificationList(@Nullable List<Object> value) {
        this.jsiiSet("lifecycleHookSpecificationList", value);
    }

    @Nullable
    public List<String> getLoadBalancerNames() {
        return Optional.ofNullable((List)this.jsiiGet("loadBalancerNames", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setLoadBalancerNames(@Nullable List<String> value) {
        this.jsiiSet("loadBalancerNames", value);
    }

    @Nullable
    public Number getMaxInstanceLifetime() {
        return (Number)this.jsiiGet("maxInstanceLifetime", Number.class);
    }

    public void setMaxInstanceLifetime(@Nullable Number value) {
        this.jsiiSet("maxInstanceLifetime", value);
    }

    @Nullable
    public Object getMetricsCollection() {
        return this.jsiiGet("metricsCollection", Object.class);
    }

    public void setMetricsCollection(@Nullable IResolvable value) {
        this.jsiiSet("metricsCollection", value);
    }

    public void setMetricsCollection(@Nullable List<Object> value) {
        this.jsiiSet("metricsCollection", value);
    }

    @Nullable
    public Object getMixedInstancesPolicy() {
        return this.jsiiGet("mixedInstancesPolicy", Object.class);
    }

    public void setMixedInstancesPolicy(@Nullable MixedInstancesPolicyProperty value) {
        this.jsiiSet("mixedInstancesPolicy", value);
    }

    public void setMixedInstancesPolicy(@Nullable IResolvable value) {
        this.jsiiSet("mixedInstancesPolicy", value);
    }

    @Nullable
    public Object getNewInstancesProtectedFromScaleIn() {
        return this.jsiiGet("newInstancesProtectedFromScaleIn", Object.class);
    }

    public void setNewInstancesProtectedFromScaleIn(@Nullable Boolean value) {
        this.jsiiSet("newInstancesProtectedFromScaleIn", value);
    }

    public void setNewInstancesProtectedFromScaleIn(@Nullable IResolvable value) {
        this.jsiiSet("newInstancesProtectedFromScaleIn", value);
    }

    @Nullable
    public Object getNotificationConfigurations() {
        return this.jsiiGet("notificationConfigurations", Object.class);
    }

    public void setNotificationConfigurations(@Nullable IResolvable value) {
        this.jsiiSet("notificationConfigurations", value);
    }

    public void setNotificationConfigurations(@Nullable List<Object> value) {
        this.jsiiSet("notificationConfigurations", value);
    }

    @Nullable
    public String getPlacementGroup() {
        return (String)this.jsiiGet("placementGroup", String.class);
    }

    public void setPlacementGroup(@Nullable String value) {
        this.jsiiSet("placementGroup", value);
    }

    @Nullable
    public String getServiceLinkedRoleArn() {
        return (String)this.jsiiGet("serviceLinkedRoleArn", String.class);
    }

    public void setServiceLinkedRoleArn(@Nullable String value) {
        this.jsiiSet("serviceLinkedRoleArn", value);
    }

    @Nullable
    public List<String> getTargetGroupArns() {
        return Optional.ofNullable((List)this.jsiiGet("targetGroupArns", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTargetGroupArns(@Nullable List<String> value) {
        this.jsiiSet("targetGroupArns", value);
    }

    @Nullable
    public List<String> getTerminationPolicies() {
        return Optional.ofNullable((List)this.jsiiGet("terminationPolicies", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTerminationPolicies(@Nullable List<String> value) {
        this.jsiiSet("terminationPolicies", value);
    }

    @Nullable
    public List<String> getVpcZoneIdentifier() {
        return Optional.ofNullable((List)this.jsiiGet("vpcZoneIdentifier", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setVpcZoneIdentifier(@Nullable List<String> value) {
        this.jsiiSet("vpcZoneIdentifier", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAutoScalingGroup> {
        private final Construct scope;
        private final String id;
        private final CfnAutoScalingGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAutoScalingGroupProps.Builder();
        }

        public Builder maxSize(String maxSize) {
            this.props.maxSize(maxSize);
            return this;
        }

        public Builder minSize(String minSize) {
            this.props.minSize(minSize);
            return this;
        }

        public Builder autoScalingGroupName(String autoScalingGroupName) {
            this.props.autoScalingGroupName(autoScalingGroupName);
            return this;
        }

        public Builder availabilityZones(List<String> availabilityZones) {
            this.props.availabilityZones(availabilityZones);
            return this;
        }

        public Builder cooldown(String cooldown) {
            this.props.cooldown(cooldown);
            return this;
        }

        public Builder desiredCapacity(String desiredCapacity) {
            this.props.desiredCapacity(desiredCapacity);
            return this;
        }

        public Builder healthCheckGracePeriod(Number healthCheckGracePeriod) {
            this.props.healthCheckGracePeriod(healthCheckGracePeriod);
            return this;
        }

        public Builder healthCheckType(String healthCheckType) {
            this.props.healthCheckType(healthCheckType);
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.props.instanceId(instanceId);
            return this;
        }

        public Builder launchConfigurationName(String launchConfigurationName) {
            this.props.launchConfigurationName(launchConfigurationName);
            return this;
        }

        public Builder launchTemplate(LaunchTemplateSpecificationProperty launchTemplate) {
            this.props.launchTemplate(launchTemplate);
            return this;
        }

        public Builder launchTemplate(IResolvable launchTemplate) {
            this.props.launchTemplate(launchTemplate);
            return this;
        }

        public Builder lifecycleHookSpecificationList(IResolvable lifecycleHookSpecificationList) {
            this.props.lifecycleHookSpecificationList(lifecycleHookSpecificationList);
            return this;
        }

        public Builder lifecycleHookSpecificationList(List<Object> lifecycleHookSpecificationList) {
            this.props.lifecycleHookSpecificationList(lifecycleHookSpecificationList);
            return this;
        }

        public Builder loadBalancerNames(List<String> loadBalancerNames) {
            this.props.loadBalancerNames(loadBalancerNames);
            return this;
        }

        public Builder maxInstanceLifetime(Number maxInstanceLifetime) {
            this.props.maxInstanceLifetime(maxInstanceLifetime);
            return this;
        }

        public Builder metricsCollection(IResolvable metricsCollection) {
            this.props.metricsCollection(metricsCollection);
            return this;
        }

        public Builder metricsCollection(List<Object> metricsCollection) {
            this.props.metricsCollection(metricsCollection);
            return this;
        }

        public Builder mixedInstancesPolicy(MixedInstancesPolicyProperty mixedInstancesPolicy) {
            this.props.mixedInstancesPolicy(mixedInstancesPolicy);
            return this;
        }

        public Builder mixedInstancesPolicy(IResolvable mixedInstancesPolicy) {
            this.props.mixedInstancesPolicy(mixedInstancesPolicy);
            return this;
        }

        public Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.props.newInstancesProtectedFromScaleIn(newInstancesProtectedFromScaleIn);
            return this;
        }

        public Builder newInstancesProtectedFromScaleIn(IResolvable newInstancesProtectedFromScaleIn) {
            this.props.newInstancesProtectedFromScaleIn(newInstancesProtectedFromScaleIn);
            return this;
        }

        public Builder notificationConfigurations(IResolvable notificationConfigurations) {
            this.props.notificationConfigurations(notificationConfigurations);
            return this;
        }

        public Builder notificationConfigurations(List<Object> notificationConfigurations) {
            this.props.notificationConfigurations(notificationConfigurations);
            return this;
        }

        public Builder placementGroup(String placementGroup) {
            this.props.placementGroup(placementGroup);
            return this;
        }

        public Builder serviceLinkedRoleArn(String serviceLinkedRoleArn) {
            this.props.serviceLinkedRoleArn(serviceLinkedRoleArn);
            return this;
        }

        public Builder tags(List<TagPropertyProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder targetGroupArns(List<String> targetGroupArns) {
            this.props.targetGroupArns(targetGroupArns);
            return this;
        }

        public Builder terminationPolicies(List<String> terminationPolicies) {
            this.props.terminationPolicies(terminationPolicies);
            return this;
        }

        public Builder vpcZoneIdentifier(List<String> vpcZoneIdentifier) {
            this.props.vpcZoneIdentifier(vpcZoneIdentifier);
            return this;
        }

        public CfnAutoScalingGroup build() {
            return new CfnAutoScalingGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_autoscaling.CfnAutoScalingGroup.TagPropertyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagPropertyProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public Object getPropagateAtLaunch();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagPropertyProperty> {
            private String key;
            private Object propagateAtLaunch;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder propagateAtLaunch(Boolean propagateAtLaunch) {
                this.propagateAtLaunch = propagateAtLaunch;
                return this;
            }

            public Builder propagateAtLaunch(IResolvable propagateAtLaunch) {
                this.propagateAtLaunch = propagateAtLaunch;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagPropertyProperty build() {
                return new Jsii.Proxy(this.key, this.propagateAtLaunch, this.value, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_autoscaling.CfnAutoScalingGroup.NotificationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NotificationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getTopicArn();

        @Nullable
        default public List<String> getNotificationTypes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NotificationConfigurationProperty> {
            private String topicArn;
            private List<String> notificationTypes;

            public Builder topicArn(String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            public Builder notificationTypes(List<String> notificationTypes) {
                this.notificationTypes = notificationTypes;
                return this;
            }

            public NotificationConfigurationProperty build() {
                return new Jsii.Proxy(this.topicArn, this.notificationTypes, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_autoscaling.CfnAutoScalingGroup.MixedInstancesPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MixedInstancesPolicyProperty
    extends JsiiSerializable {
        @NotNull
        public Object getLaunchTemplate();

        @Nullable
        default public Object getInstancesDistribution() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MixedInstancesPolicyProperty> {
            private Object launchTemplate;
            private Object instancesDistribution;

            public Builder launchTemplate(LaunchTemplateProperty launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            public Builder launchTemplate(IResolvable launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            public Builder instancesDistribution(InstancesDistributionProperty instancesDistribution) {
                this.instancesDistribution = instancesDistribution;
                return this;
            }

            public Builder instancesDistribution(IResolvable instancesDistribution) {
                this.instancesDistribution = instancesDistribution;
                return this;
            }

            public MixedInstancesPolicyProperty build() {
                return new Jsii.Proxy(this.launchTemplate, this.instancesDistribution, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_autoscaling.CfnAutoScalingGroup.MetricsCollectionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricsCollectionProperty
    extends JsiiSerializable {
        @NotNull
        public String getGranularity();

        @Nullable
        default public List<String> getMetrics() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricsCollectionProperty> {
            private String granularity;
            private List<String> metrics;

            public Builder granularity(String granularity) {
                this.granularity = granularity;
                return this;
            }

            public Builder metrics(List<String> metrics) {
                this.metrics = metrics;
                return this;
            }

            public MetricsCollectionProperty build() {
                return new Jsii.Proxy(this.granularity, this.metrics, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_autoscaling.CfnAutoScalingGroup.LifecycleHookSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LifecycleHookSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getLifecycleHookName();

        @NotNull
        public String getLifecycleTransition();

        @Nullable
        default public String getDefaultResult() {
            return null;
        }

        @Nullable
        default public Number getHeartbeatTimeout() {
            return null;
        }

        @Nullable
        default public String getNotificationMetadata() {
            return null;
        }

        @Nullable
        default public String getNotificationTargetArn() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LifecycleHookSpecificationProperty> {
            private String lifecycleHookName;
            private String lifecycleTransition;
            private String defaultResult;
            private Number heartbeatTimeout;
            private String notificationMetadata;
            private String notificationTargetArn;
            private String roleArn;

            public Builder lifecycleHookName(String lifecycleHookName) {
                this.lifecycleHookName = lifecycleHookName;
                return this;
            }

            public Builder lifecycleTransition(String lifecycleTransition) {
                this.lifecycleTransition = lifecycleTransition;
                return this;
            }

            public Builder defaultResult(String defaultResult) {
                this.defaultResult = defaultResult;
                return this;
            }

            public Builder heartbeatTimeout(Number heartbeatTimeout) {
                this.heartbeatTimeout = heartbeatTimeout;
                return this;
            }

            public Builder notificationMetadata(String notificationMetadata) {
                this.notificationMetadata = notificationMetadata;
                return this;
            }

            public Builder notificationTargetArn(String notificationTargetArn) {
                this.notificationTargetArn = notificationTargetArn;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public LifecycleHookSpecificationProperty build() {
                return new Jsii.Proxy(this.lifecycleHookName, this.lifecycleTransition, this.defaultResult, this.heartbeatTimeout, this.notificationMetadata, this.notificationTargetArn, this.roleArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_autoscaling.CfnAutoScalingGroup.LaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getVersion();

        @Nullable
        default public String getLaunchTemplateId() {
            return null;
        }

        @Nullable
        default public String getLaunchTemplateName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateSpecificationProperty> {
            private String version;
            private String launchTemplateId;
            private String launchTemplateName;

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public Builder launchTemplateId(String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            public Builder launchTemplateName(String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            public LaunchTemplateSpecificationProperty build() {
                return new Jsii.Proxy(this.version, this.launchTemplateId, this.launchTemplateName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_autoscaling.CfnAutoScalingGroup.LaunchTemplateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateProperty
    extends JsiiSerializable {
        @NotNull
        public Object getLaunchTemplateSpecification();

        @Nullable
        default public Object getOverrides() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateProperty> {
            private Object launchTemplateSpecification;
            private Object overrides;

            public Builder launchTemplateSpecification(LaunchTemplateSpecificationProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder launchTemplateSpecification(IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder overrides(IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            public Builder overrides(List<Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            public LaunchTemplateProperty build() {
                return new Jsii.Proxy(this.launchTemplateSpecification, this.overrides, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_autoscaling.CfnAutoScalingGroup.LaunchTemplateOverridesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateOverridesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public String getWeightedCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateOverridesProperty> {
            private String instanceType;
            private String weightedCapacity;

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder weightedCapacity(String weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public LaunchTemplateOverridesProperty build() {
                return new Jsii.Proxy(this.instanceType, this.weightedCapacity, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_autoscaling.CfnAutoScalingGroup.InstancesDistributionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstancesDistributionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getOnDemandAllocationStrategy() {
            return null;
        }

        @Nullable
        default public Number getOnDemandBaseCapacity() {
            return null;
        }

        @Nullable
        default public Number getOnDemandPercentageAboveBaseCapacity() {
            return null;
        }

        @Nullable
        default public String getSpotAllocationStrategy() {
            return null;
        }

        @Nullable
        default public Number getSpotInstancePools() {
            return null;
        }

        @Nullable
        default public String getSpotMaxPrice() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstancesDistributionProperty> {
            private String onDemandAllocationStrategy;
            private Number onDemandBaseCapacity;
            private Number onDemandPercentageAboveBaseCapacity;
            private String spotAllocationStrategy;
            private Number spotInstancePools;
            private String spotMaxPrice;

            public Builder onDemandAllocationStrategy(String onDemandAllocationStrategy) {
                this.onDemandAllocationStrategy = onDemandAllocationStrategy;
                return this;
            }

            public Builder onDemandBaseCapacity(Number onDemandBaseCapacity) {
                this.onDemandBaseCapacity = onDemandBaseCapacity;
                return this;
            }

            public Builder onDemandPercentageAboveBaseCapacity(Number onDemandPercentageAboveBaseCapacity) {
                this.onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity;
                return this;
            }

            public Builder spotAllocationStrategy(String spotAllocationStrategy) {
                this.spotAllocationStrategy = spotAllocationStrategy;
                return this;
            }

            public Builder spotInstancePools(Number spotInstancePools) {
                this.spotInstancePools = spotInstancePools;
                return this;
            }

            public Builder spotMaxPrice(String spotMaxPrice) {
                this.spotMaxPrice = spotMaxPrice;
                return this;
            }

            public InstancesDistributionProperty build() {
                return new Jsii.Proxy(this.onDemandAllocationStrategy, this.onDemandBaseCapacity, this.onDemandPercentageAboveBaseCapacity, this.spotAllocationStrategy, this.spotInstancePools, this.spotMaxPrice, null);
            }
        }
    }
}

