/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution;
import software.amazon.awscdk.services.cloudfront.CfnStreamingDistributionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudfront.CfnStreamingDistribution")
public class CfnStreamingDistribution
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnStreamingDistribution.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnStreamingDistribution(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStreamingDistribution(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnStreamingDistribution(@NotNull Construct scope, @NotNull String id, @NotNull CfnStreamingDistributionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDomainName() {
        return (String)this.jsiiGet("attrDomainName", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @NotNull
    public Object getStreamingDistributionConfig() {
        return this.jsiiGet("streamingDistributionConfig", Object.class);
    }

    public void setStreamingDistributionConfig(@NotNull StreamingDistributionConfigProperty value) {
        this.jsiiSet("streamingDistributionConfig", Objects.requireNonNull(value, "streamingDistributionConfig is required"));
    }

    public void setStreamingDistributionConfig(@NotNull IResolvable value) {
        this.jsiiSet("streamingDistributionConfig", Objects.requireNonNull(value, "streamingDistributionConfig is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnStreamingDistribution> {
        private final Construct scope;
        private final String id;
        private final CfnStreamingDistributionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnStreamingDistributionProps.Builder();
        }

        public Builder streamingDistributionConfig(StreamingDistributionConfigProperty streamingDistributionConfig) {
            this.props.streamingDistributionConfig(streamingDistributionConfig);
            return this;
        }

        public Builder streamingDistributionConfig(IResolvable streamingDistributionConfig) {
            this.props.streamingDistributionConfig(streamingDistributionConfig);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnStreamingDistribution build() {
            return new CfnStreamingDistribution(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudfront.CfnStreamingDistribution.TrustedSignersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TrustedSignersProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public List<String> getAwsAccountNumbers() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TrustedSignersProperty> {
            private Object enabled;
            private List<String> awsAccountNumbers;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder awsAccountNumbers(List<String> awsAccountNumbers) {
                this.awsAccountNumbers = awsAccountNumbers;
                return this;
            }

            public TrustedSignersProperty build() {
                return new Jsii.Proxy(this.enabled, this.awsAccountNumbers, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudfront.CfnStreamingDistribution.StreamingDistributionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StreamingDistributionConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getComment();

        @NotNull
        public Object getEnabled();

        @NotNull
        public Object getS3Origin();

        @NotNull
        public Object getTrustedSigners();

        @Nullable
        default public List<String> getAliases() {
            return null;
        }

        @Nullable
        default public Object getLogging() {
            return null;
        }

        @Nullable
        default public String getPriceClass() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StreamingDistributionConfigProperty> {
            private String comment;
            private Object enabled;
            private Object s3Origin;
            private Object trustedSigners;
            private List<String> aliases;
            private Object logging;
            private String priceClass;

            public Builder comment(String comment) {
                this.comment = comment;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder s3Origin(S3OriginProperty s3Origin) {
                this.s3Origin = s3Origin;
                return this;
            }

            public Builder s3Origin(IResolvable s3Origin) {
                this.s3Origin = s3Origin;
                return this;
            }

            public Builder trustedSigners(TrustedSignersProperty trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            public Builder trustedSigners(IResolvable trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            public Builder aliases(List<String> aliases) {
                this.aliases = aliases;
                return this;
            }

            public Builder logging(LoggingProperty logging) {
                this.logging = logging;
                return this;
            }

            public Builder logging(IResolvable logging) {
                this.logging = logging;
                return this;
            }

            public Builder priceClass(String priceClass) {
                this.priceClass = priceClass;
                return this;
            }

            public StreamingDistributionConfigProperty build() {
                return new Jsii.Proxy(this.comment, this.enabled, this.s3Origin, this.trustedSigners, this.aliases, this.logging, this.priceClass, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudfront.CfnStreamingDistribution.S3OriginProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3OriginProperty
    extends JsiiSerializable {
        @NotNull
        public String getDomainName();

        @NotNull
        public String getOriginAccessIdentity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3OriginProperty> {
            private String domainName;
            private String originAccessIdentity;

            public Builder domainName(String domainName) {
                this.domainName = domainName;
                return this;
            }

            public Builder originAccessIdentity(String originAccessIdentity) {
                this.originAccessIdentity = originAccessIdentity;
                return this;
            }

            public S3OriginProperty build() {
                return new Jsii.Proxy(this.domainName, this.originAccessIdentity, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudfront.CfnStreamingDistribution.LoggingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public Object getEnabled();

        @NotNull
        public String getPrefix();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoggingProperty> {
            private String bucket;
            private Object enabled;
            private String prefix;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public LoggingProperty build() {
                return new Jsii.Proxy(this.bucket, this.enabled, this.prefix, null);
            }
        }
    }
}

