/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudtrail;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloudtrail.AddEventSelectorOptions;
import software.amazon.awscdk.services.cloudtrail.DataResourceType;
import software.amazon.awscdk.services.cloudtrail.ReadWriteType;
import software.amazon.awscdk.services.cloudtrail.S3EventSelector;
import software.amazon.awscdk.services.cloudtrail.TrailProps;
import software.amazon.awscdk.services.events.OnEventOptions;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudtrail.Trail")
public class Trail
extends Resource {
    protected Trail(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Trail(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Trail(@NotNull Construct scope, @NotNull String id, @Nullable TrailProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Trail(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static Rule onEvent(@NotNull Construct scope, @NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)JsiiObject.jsiiStaticCall(Trail.class, (String)"onEvent", Rule.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), options});
    }

    @NotNull
    public static Rule onEvent(@NotNull Construct scope, @NotNull String id) {
        return (Rule)JsiiObject.jsiiStaticCall(Trail.class, (String)"onEvent", Rule.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void addEventSelector(@NotNull DataResourceType dataResourceType, @NotNull List<String> dataResourceValues, @Nullable AddEventSelectorOptions options) {
        this.jsiiCall("addEventSelector", NativeType.VOID, new Object[]{Objects.requireNonNull(dataResourceType, "dataResourceType is required"), Objects.requireNonNull(dataResourceValues, "dataResourceValues is required"), options});
    }

    public void addEventSelector(@NotNull DataResourceType dataResourceType, @NotNull List<String> dataResourceValues) {
        this.jsiiCall("addEventSelector", NativeType.VOID, new Object[]{Objects.requireNonNull(dataResourceType, "dataResourceType is required"), Objects.requireNonNull(dataResourceValues, "dataResourceValues is required")});
    }

    public void addLambdaEventSelector(@NotNull List<IFunction> handlers, @Nullable AddEventSelectorOptions options) {
        this.jsiiCall("addLambdaEventSelector", NativeType.VOID, new Object[]{Objects.requireNonNull(handlers, "handlers is required"), options});
    }

    public void addLambdaEventSelector(@NotNull List<IFunction> handlers) {
        this.jsiiCall("addLambdaEventSelector", NativeType.VOID, new Object[]{Objects.requireNonNull(handlers, "handlers is required")});
    }

    public void addS3EventSelector(@NotNull List<S3EventSelector> s3Selector, @Nullable AddEventSelectorOptions options) {
        this.jsiiCall("addS3EventSelector", NativeType.VOID, new Object[]{Objects.requireNonNull(s3Selector, "s3Selector is required"), options});
    }

    public void addS3EventSelector(@NotNull List<S3EventSelector> s3Selector) {
        this.jsiiCall("addS3EventSelector", NativeType.VOID, new Object[]{Objects.requireNonNull(s3Selector, "s3Selector is required")});
    }

    public void logAllLambdaDataEvents(@Nullable AddEventSelectorOptions options) {
        this.jsiiCall("logAllLambdaDataEvents", NativeType.VOID, new Object[]{options});
    }

    public void logAllLambdaDataEvents() {
        this.jsiiCall("logAllLambdaDataEvents", NativeType.VOID, new Object[0]);
    }

    public void logAllS3DataEvents(@Nullable AddEventSelectorOptions options) {
        this.jsiiCall("logAllS3DataEvents", NativeType.VOID, new Object[]{options});
    }

    public void logAllS3DataEvents() {
        this.jsiiCall("logAllS3DataEvents", NativeType.VOID, new Object[0]);
    }

    @Deprecated
    @NotNull
    public Rule onCloudTrailEvent(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onCloudTrailEvent", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Deprecated
    @NotNull
    public Rule onCloudTrailEvent(@NotNull String id) {
        return (Rule)this.jsiiCall("onCloudTrailEvent", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public String getTrailArn() {
        return (String)this.jsiiGet("trailArn", String.class);
    }

    @NotNull
    public String getTrailSnsTopicArn() {
        return (String)this.jsiiGet("trailSnsTopicArn", String.class);
    }

    @Nullable
    public ILogGroup getLogGroup() {
        return (ILogGroup)this.jsiiGet("logGroup", ILogGroup.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Trail> {
        private final Construct scope;
        private final String id;
        private TrailProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder bucket(IBucket bucket) {
            this.props().bucket(bucket);
            return this;
        }

        public Builder cloudWatchLogGroup(ILogGroup cloudWatchLogGroup) {
            this.props().cloudWatchLogGroup(cloudWatchLogGroup);
            return this;
        }

        public Builder cloudWatchLogsRetention(RetentionDays cloudWatchLogsRetention) {
            this.props().cloudWatchLogsRetention(cloudWatchLogsRetention);
            return this;
        }

        public Builder enableFileValidation(Boolean enableFileValidation) {
            this.props().enableFileValidation(enableFileValidation);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        public Builder includeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.props().includeGlobalServiceEvents(includeGlobalServiceEvents);
            return this;
        }

        public Builder isMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.props().isMultiRegionTrail(isMultiRegionTrail);
            return this;
        }

        @Deprecated
        public Builder kmsKey(IKey kmsKey) {
            this.props().kmsKey(kmsKey);
            return this;
        }

        public Builder managementEvents(ReadWriteType managementEvents) {
            this.props().managementEvents(managementEvents);
            return this;
        }

        public Builder s3KeyPrefix(String s3KeyPrefix) {
            this.props().s3KeyPrefix(s3KeyPrefix);
            return this;
        }

        public Builder sendToCloudWatchLogs(Boolean sendToCloudWatchLogs) {
            this.props().sendToCloudWatchLogs(sendToCloudWatchLogs);
            return this;
        }

        public Builder snsTopic(ITopic snsTopic) {
            this.props().snsTopic(snsTopic);
            return this;
        }

        public Builder trailName(String trailName) {
            this.props().trailName(trailName);
            return this;
        }

        public Trail build() {
            return new Trail(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private TrailProps.Builder props() {
            if (this.props == null) {
                this.props = new TrailProps.Builder();
            }
            return this.props;
        }
    }
}

