/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.cloudwatch.CfnAlarm;
import software.amazon.awscdk.services.cloudwatch.CfnAlarmProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudwatch.CfnAlarm")
public class CfnAlarm
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAlarm.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnAlarm(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAlarm(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAlarm(@NotNull Construct scope, @NotNull String id, @NotNull CfnAlarmProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getComparisonOperator() {
        return (String)this.jsiiGet("comparisonOperator", String.class);
    }

    public void setComparisonOperator(@NotNull String value) {
        this.jsiiSet("comparisonOperator", Objects.requireNonNull(value, "comparisonOperator is required"));
    }

    @NotNull
    public Number getEvaluationPeriods() {
        return (Number)this.jsiiGet("evaluationPeriods", Number.class);
    }

    public void setEvaluationPeriods(@NotNull Number value) {
        this.jsiiSet("evaluationPeriods", Objects.requireNonNull(value, "evaluationPeriods is required"));
    }

    @Nullable
    public Object getActionsEnabled() {
        return this.jsiiGet("actionsEnabled", Object.class);
    }

    public void setActionsEnabled(@Nullable Boolean value) {
        this.jsiiSet("actionsEnabled", value);
    }

    public void setActionsEnabled(@Nullable IResolvable value) {
        this.jsiiSet("actionsEnabled", value);
    }

    @Nullable
    public List<String> getAlarmActions() {
        return Optional.ofNullable((List)this.jsiiGet("alarmActions", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAlarmActions(@Nullable List<String> value) {
        this.jsiiSet("alarmActions", value);
    }

    @Nullable
    public String getAlarmDescription() {
        return (String)this.jsiiGet("alarmDescription", String.class);
    }

    public void setAlarmDescription(@Nullable String value) {
        this.jsiiSet("alarmDescription", value);
    }

    @Nullable
    public String getAlarmName() {
        return (String)this.jsiiGet("alarmName", String.class);
    }

    public void setAlarmName(@Nullable String value) {
        this.jsiiSet("alarmName", value);
    }

    @Nullable
    public Number getDatapointsToAlarm() {
        return (Number)this.jsiiGet("datapointsToAlarm", Number.class);
    }

    public void setDatapointsToAlarm(@Nullable Number value) {
        this.jsiiSet("datapointsToAlarm", value);
    }

    @Nullable
    public Object getDimensions() {
        return this.jsiiGet("dimensions", Object.class);
    }

    public void setDimensions(@Nullable IResolvable value) {
        this.jsiiSet("dimensions", value);
    }

    public void setDimensions(@Nullable List<Object> value) {
        this.jsiiSet("dimensions", value);
    }

    @Nullable
    public String getEvaluateLowSampleCountPercentile() {
        return (String)this.jsiiGet("evaluateLowSampleCountPercentile", String.class);
    }

    public void setEvaluateLowSampleCountPercentile(@Nullable String value) {
        this.jsiiSet("evaluateLowSampleCountPercentile", value);
    }

    @Nullable
    public String getExtendedStatistic() {
        return (String)this.jsiiGet("extendedStatistic", String.class);
    }

    public void setExtendedStatistic(@Nullable String value) {
        this.jsiiSet("extendedStatistic", value);
    }

    @Nullable
    public List<String> getInsufficientDataActions() {
        return Optional.ofNullable((List)this.jsiiGet("insufficientDataActions", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setInsufficientDataActions(@Nullable List<String> value) {
        this.jsiiSet("insufficientDataActions", value);
    }

    @Nullable
    public String getMetricName() {
        return (String)this.jsiiGet("metricName", String.class);
    }

    public void setMetricName(@Nullable String value) {
        this.jsiiSet("metricName", value);
    }

    @Nullable
    public Object getMetrics() {
        return this.jsiiGet("metrics", Object.class);
    }

    public void setMetrics(@Nullable IResolvable value) {
        this.jsiiSet("metrics", value);
    }

    public void setMetrics(@Nullable List<Object> value) {
        this.jsiiSet("metrics", value);
    }

    @Nullable
    public String getNamespace() {
        return (String)this.jsiiGet("namespace", String.class);
    }

    public void setNamespace(@Nullable String value) {
        this.jsiiSet("namespace", value);
    }

    @Nullable
    public List<String> getOkActions() {
        return Optional.ofNullable((List)this.jsiiGet("okActions", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setOkActions(@Nullable List<String> value) {
        this.jsiiSet("okActions", value);
    }

    @Nullable
    public Number getPeriod() {
        return (Number)this.jsiiGet("period", Number.class);
    }

    public void setPeriod(@Nullable Number value) {
        this.jsiiSet("period", value);
    }

    @Nullable
    public String getStatistic() {
        return (String)this.jsiiGet("statistic", String.class);
    }

    public void setStatistic(@Nullable String value) {
        this.jsiiSet("statistic", value);
    }

    @Nullable
    public Number getThreshold() {
        return (Number)this.jsiiGet("threshold", Number.class);
    }

    public void setThreshold(@Nullable Number value) {
        this.jsiiSet("threshold", value);
    }

    @Nullable
    public String getThresholdMetricId() {
        return (String)this.jsiiGet("thresholdMetricId", String.class);
    }

    public void setThresholdMetricId(@Nullable String value) {
        this.jsiiSet("thresholdMetricId", value);
    }

    @Nullable
    public String getTreatMissingData() {
        return (String)this.jsiiGet("treatMissingData", String.class);
    }

    public void setTreatMissingData(@Nullable String value) {
        this.jsiiSet("treatMissingData", value);
    }

    @Nullable
    public String getUnit() {
        return (String)this.jsiiGet("unit", String.class);
    }

    public void setUnit(@Nullable String value) {
        this.jsiiSet("unit", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAlarm> {
        private final Construct scope;
        private final String id;
        private final CfnAlarmProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAlarmProps.Builder();
        }

        public Builder comparisonOperator(String comparisonOperator) {
            this.props.comparisonOperator(comparisonOperator);
            return this;
        }

        public Builder evaluationPeriods(Number evaluationPeriods) {
            this.props.evaluationPeriods(evaluationPeriods);
            return this;
        }

        public Builder actionsEnabled(Boolean actionsEnabled) {
            this.props.actionsEnabled(actionsEnabled);
            return this;
        }

        public Builder actionsEnabled(IResolvable actionsEnabled) {
            this.props.actionsEnabled(actionsEnabled);
            return this;
        }

        public Builder alarmActions(List<String> alarmActions) {
            this.props.alarmActions(alarmActions);
            return this;
        }

        public Builder alarmDescription(String alarmDescription) {
            this.props.alarmDescription(alarmDescription);
            return this;
        }

        public Builder alarmName(String alarmName) {
            this.props.alarmName(alarmName);
            return this;
        }

        public Builder datapointsToAlarm(Number datapointsToAlarm) {
            this.props.datapointsToAlarm(datapointsToAlarm);
            return this;
        }

        public Builder dimensions(IResolvable dimensions) {
            this.props.dimensions(dimensions);
            return this;
        }

        public Builder dimensions(List<Object> dimensions) {
            this.props.dimensions(dimensions);
            return this;
        }

        public Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.props.evaluateLowSampleCountPercentile(evaluateLowSampleCountPercentile);
            return this;
        }

        public Builder extendedStatistic(String extendedStatistic) {
            this.props.extendedStatistic(extendedStatistic);
            return this;
        }

        public Builder insufficientDataActions(List<String> insufficientDataActions) {
            this.props.insufficientDataActions(insufficientDataActions);
            return this;
        }

        public Builder metricName(String metricName) {
            this.props.metricName(metricName);
            return this;
        }

        public Builder metrics(IResolvable metrics) {
            this.props.metrics(metrics);
            return this;
        }

        public Builder metrics(List<Object> metrics) {
            this.props.metrics(metrics);
            return this;
        }

        public Builder namespace(String namespace) {
            this.props.namespace(namespace);
            return this;
        }

        public Builder okActions(List<String> okActions) {
            this.props.okActions(okActions);
            return this;
        }

        public Builder period(Number period) {
            this.props.period(period);
            return this;
        }

        public Builder statistic(String statistic) {
            this.props.statistic(statistic);
            return this;
        }

        public Builder threshold(Number threshold) {
            this.props.threshold(threshold);
            return this;
        }

        public Builder thresholdMetricId(String thresholdMetricId) {
            this.props.thresholdMetricId(thresholdMetricId);
            return this;
        }

        public Builder treatMissingData(String treatMissingData) {
            this.props.treatMissingData(treatMissingData);
            return this;
        }

        public Builder unit(String unit) {
            this.props.unit(unit);
            return this;
        }

        public CfnAlarm build() {
            return new CfnAlarm(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudwatch.CfnAlarm.MetricStatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricStatProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMetric();

        @NotNull
        public Number getPeriod();

        @NotNull
        public String getStat();

        @Nullable
        default public String getUnit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricStatProperty> {
            private Object metric;
            private Number period;
            private String stat;
            private String unit;

            public Builder metric(MetricProperty metric) {
                this.metric = metric;
                return this;
            }

            public Builder metric(IResolvable metric) {
                this.metric = metric;
                return this;
            }

            public Builder period(Number period) {
                this.period = period;
                return this;
            }

            public Builder stat(String stat) {
                this.stat = stat;
                return this;
            }

            public Builder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public MetricStatProperty build() {
                return new Jsii.Proxy(this.metric, this.period, this.stat, this.unit, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudwatch.CfnAlarm.MetricProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDimensions() {
            return null;
        }

        @Nullable
        default public String getMetricName() {
            return null;
        }

        @Nullable
        default public String getNamespace() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricProperty> {
            private Object dimensions;
            private String metricName;
            private String namespace;

            public Builder dimensions(IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder dimensions(List<Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public MetricProperty build() {
                return new Jsii.Proxy(this.dimensions, this.metricName, this.namespace, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudwatch.CfnAlarm.MetricDataQueryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricDataQueryProperty
    extends JsiiSerializable {
        @NotNull
        public String getId();

        @Nullable
        default public String getExpression() {
            return null;
        }

        @Nullable
        default public String getLabel() {
            return null;
        }

        @Nullable
        default public Object getMetricStat() {
            return null;
        }

        @Nullable
        default public Number getPeriod() {
            return null;
        }

        @Nullable
        default public Object getReturnData() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricDataQueryProperty> {
            private String id;
            private String expression;
            private String label;
            private Object metricStat;
            private Number period;
            private Object returnData;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder label(String label) {
                this.label = label;
                return this;
            }

            public Builder metricStat(MetricStatProperty metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            public Builder metricStat(IResolvable metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            public Builder period(Number period) {
                this.period = period;
                return this;
            }

            public Builder returnData(Boolean returnData) {
                this.returnData = returnData;
                return this;
            }

            public Builder returnData(IResolvable returnData) {
                this.returnData = returnData;
                return this;
            }

            public MetricDataQueryProperty build() {
                return new Jsii.Proxy(this.id, this.expression, this.label, this.metricStat, this.period, this.returnData, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudwatch.CfnAlarm.DimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DimensionProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DimensionProperty> {
            private String name;
            private String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public DimensionProperty build() {
                return new Jsii.Proxy(this.name, this.value, null);
            }
        }
    }
}

