/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.cloudwatch.Alarm;
import software.amazon.awscdk.services.cloudwatch.CreateAlarmOptions;
import software.amazon.awscdk.services.cloudwatch.IMetric;
import software.amazon.awscdk.services.cloudwatch.MetricAlarmConfig;
import software.amazon.awscdk.services.cloudwatch.MetricConfig;
import software.amazon.awscdk.services.cloudwatch.MetricGraphConfig;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.cloudwatch.MetricProps;
import software.amazon.awscdk.services.cloudwatch.Unit;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_cloudwatch.Metric")
public class Metric
extends JsiiObject
implements IMetric {
    protected Metric(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Metric(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Metric(@NotNull MetricProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static Grant grantPutMetricData(@NotNull IGrantable grantee) {
        return (Grant)JsiiObject.jsiiStaticCall(Metric.class, (String)"grantPutMetricData", Grant.class, (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @NotNull
    public Metric attachTo(@NotNull Construct scope) {
        return (Metric)this.jsiiCall("attachTo", Metric.class, new Object[]{Objects.requireNonNull(scope, "scope is required")});
    }

    @NotNull
    public Alarm createAlarm(@NotNull Construct scope, @NotNull String id, @NotNull CreateAlarmOptions props) {
        return (Alarm)this.jsiiCall("createAlarm", Alarm.class, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public MetricAlarmConfig toAlarmConfig() {
        return (MetricAlarmConfig)this.jsiiCall("toAlarmConfig", MetricAlarmConfig.class, new Object[0]);
    }

    @Override
    @NotNull
    public MetricGraphConfig toGraphConfig() {
        return (MetricGraphConfig)this.jsiiCall("toGraphConfig", MetricGraphConfig.class, new Object[0]);
    }

    @Override
    @NotNull
    public MetricConfig toMetricConfig() {
        return (MetricConfig)this.jsiiCall("toMetricConfig", MetricConfig.class, new Object[0]);
    }

    @NotNull
    public String toString() {
        return (String)this.jsiiCall("toString", String.class, new Object[0]);
    }

    @NotNull
    public Metric with(@NotNull MetricOptions props) {
        return (Metric)this.jsiiCall("with", Metric.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public String getMetricName() {
        return (String)this.jsiiGet("metricName", String.class);
    }

    @NotNull
    public String getNamespace() {
        return (String)this.jsiiGet("namespace", String.class);
    }

    @NotNull
    public Duration getPeriod() {
        return (Duration)((Object)this.jsiiGet("period", Duration.class));
    }

    @NotNull
    public String getStatistic() {
        return (String)this.jsiiGet("statistic", String.class);
    }

    @Nullable
    public String getAccount() {
        return (String)this.jsiiGet("account", String.class);
    }

    @Nullable
    public String getColor() {
        return (String)this.jsiiGet("color", String.class);
    }

    @Nullable
    public Map<String, Object> getDimensions() {
        return Optional.ofNullable((Map)this.jsiiGet("dimensions", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Nullable
    public String getLabel() {
        return (String)this.jsiiGet("label", String.class);
    }

    @Nullable
    public String getRegion() {
        return (String)this.jsiiGet("region", String.class);
    }

    @Nullable
    public Unit getUnit() {
        return (Unit)((Object)this.jsiiGet("unit", Unit.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Metric> {
        private final MetricProps.Builder props = new MetricProps.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder account(String account) {
            this.props.account(account);
            return this;
        }

        public Builder color(String color) {
            this.props.color(color);
            return this;
        }

        public Builder dimensions(Map<String, Object> dimensions) {
            this.props.dimensions(dimensions);
            return this;
        }

        public Builder label(String label) {
            this.props.label(label);
            return this;
        }

        public Builder period(Duration period) {
            this.props.period(period);
            return this;
        }

        public Builder region(String region) {
            this.props.region(region);
            return this;
        }

        public Builder statistic(String statistic) {
            this.props.statistic(statistic);
            return this;
        }

        public Builder unit(Unit unit) {
            this.props.unit(unit);
            return this;
        }

        public Builder metricName(String metricName) {
            this.props.metricName(metricName);
            return this;
        }

        public Builder namespace(String namespace) {
            this.props.namespace(namespace);
            return this;
        }

        public Metric build() {
            return new Metric(this.props.build());
        }
    }
}

