/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.codepipeline.CfnPipeline;
import software.amazon.awscdk.services.codepipeline.CfnPipelineProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codepipeline.CfnPipeline")
public class CfnPipeline
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnPipeline.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnPipeline(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPipeline(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnPipeline(@NotNull Construct scope, @NotNull String id, @NotNull CfnPipelineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrVersion() {
        return (String)this.jsiiGet("attrVersion", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @NotNull
    public String getRoleArn() {
        return (String)this.jsiiGet("roleArn", String.class);
    }

    public void setRoleArn(@NotNull String value) {
        this.jsiiSet("roleArn", Objects.requireNonNull(value, "roleArn is required"));
    }

    @NotNull
    public Object getStages() {
        return this.jsiiGet("stages", Object.class);
    }

    public void setStages(@NotNull IResolvable value) {
        this.jsiiSet("stages", Objects.requireNonNull(value, "stages is required"));
    }

    public void setStages(@NotNull List<Object> value) {
        this.jsiiSet("stages", Objects.requireNonNull(value, "stages is required"));
    }

    @Nullable
    public Object getArtifactStore() {
        return this.jsiiGet("artifactStore", Object.class);
    }

    public void setArtifactStore(@Nullable ArtifactStoreProperty value) {
        this.jsiiSet("artifactStore", value);
    }

    public void setArtifactStore(@Nullable IResolvable value) {
        this.jsiiSet("artifactStore", value);
    }

    @Nullable
    public Object getArtifactStores() {
        return this.jsiiGet("artifactStores", Object.class);
    }

    public void setArtifactStores(@Nullable IResolvable value) {
        this.jsiiSet("artifactStores", value);
    }

    public void setArtifactStores(@Nullable List<Object> value) {
        this.jsiiSet("artifactStores", value);
    }

    @Nullable
    public Object getDisableInboundStageTransitions() {
        return this.jsiiGet("disableInboundStageTransitions", Object.class);
    }

    public void setDisableInboundStageTransitions(@Nullable IResolvable value) {
        this.jsiiSet("disableInboundStageTransitions", value);
    }

    public void setDisableInboundStageTransitions(@Nullable List<Object> value) {
        this.jsiiSet("disableInboundStageTransitions", value);
    }

    @Nullable
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@Nullable String value) {
        this.jsiiSet("name", value);
    }

    @Nullable
    public Object getRestartExecutionOnUpdate() {
        return this.jsiiGet("restartExecutionOnUpdate", Object.class);
    }

    public void setRestartExecutionOnUpdate(@Nullable Boolean value) {
        this.jsiiSet("restartExecutionOnUpdate", value);
    }

    public void setRestartExecutionOnUpdate(@Nullable IResolvable value) {
        this.jsiiSet("restartExecutionOnUpdate", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnPipeline> {
        private final Construct scope;
        private final String id;
        private final CfnPipelineProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnPipelineProps.Builder();
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder stages(IResolvable stages) {
            this.props.stages(stages);
            return this;
        }

        public Builder stages(List<Object> stages) {
            this.props.stages(stages);
            return this;
        }

        public Builder artifactStore(ArtifactStoreProperty artifactStore) {
            this.props.artifactStore(artifactStore);
            return this;
        }

        public Builder artifactStore(IResolvable artifactStore) {
            this.props.artifactStore(artifactStore);
            return this;
        }

        public Builder artifactStores(IResolvable artifactStores) {
            this.props.artifactStores(artifactStores);
            return this;
        }

        public Builder artifactStores(List<Object> artifactStores) {
            this.props.artifactStores(artifactStores);
            return this;
        }

        public Builder disableInboundStageTransitions(IResolvable disableInboundStageTransitions) {
            this.props.disableInboundStageTransitions(disableInboundStageTransitions);
            return this;
        }

        public Builder disableInboundStageTransitions(List<Object> disableInboundStageTransitions) {
            this.props.disableInboundStageTransitions(disableInboundStageTransitions);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder restartExecutionOnUpdate(Boolean restartExecutionOnUpdate) {
            this.props.restartExecutionOnUpdate(restartExecutionOnUpdate);
            return this;
        }

        public Builder restartExecutionOnUpdate(IResolvable restartExecutionOnUpdate) {
            this.props.restartExecutionOnUpdate(restartExecutionOnUpdate);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnPipeline build() {
            return new CfnPipeline(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codepipeline.CfnPipeline.StageTransitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StageTransitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getReason();

        @NotNull
        public String getStageName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StageTransitionProperty> {
            private String reason;
            private String stageName;

            public Builder reason(String reason) {
                this.reason = reason;
                return this;
            }

            public Builder stageName(String stageName) {
                this.stageName = stageName;
                return this;
            }

            public StageTransitionProperty build() {
                return new Jsii.Proxy(this.reason, this.stageName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codepipeline.CfnPipeline.StageDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StageDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getActions();

        @NotNull
        public String getName();

        @Nullable
        default public Object getBlockers() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StageDeclarationProperty> {
            private Object actions;
            private String name;
            private Object blockers;

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder blockers(IResolvable blockers) {
                this.blockers = blockers;
                return this;
            }

            public Builder blockers(List<Object> blockers) {
                this.blockers = blockers;
                return this;
            }

            public StageDeclarationProperty build() {
                return new Jsii.Proxy(this.actions, this.name, this.blockers, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codepipeline.CfnPipeline.OutputArtifactProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputArtifactProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputArtifactProperty> {
            private String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public OutputArtifactProperty build() {
                return new Jsii.Proxy(this.name, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codepipeline.CfnPipeline.InputArtifactProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputArtifactProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputArtifactProperty> {
            private String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public InputArtifactProperty build() {
                return new Jsii.Proxy(this.name, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codepipeline.CfnPipeline.EncryptionKeyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionKeyProperty
    extends JsiiSerializable {
        @NotNull
        public String getId();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionKeyProperty> {
            private String id;
            private String type;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public EncryptionKeyProperty build() {
                return new Jsii.Proxy(this.id, this.type, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codepipeline.CfnPipeline.BlockerDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BlockerDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BlockerDeclarationProperty> {
            private String name;
            private String type;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public BlockerDeclarationProperty build() {
                return new Jsii.Proxy(this.name, this.type, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codepipeline.CfnPipeline.ArtifactStoreProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArtifactStoreProperty
    extends JsiiSerializable {
        @NotNull
        public String getLocation();

        @NotNull
        public String getType();

        @Nullable
        default public Object getEncryptionKey() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArtifactStoreProperty> {
            private String location;
            private String type;
            private Object encryptionKey;

            public Builder location(String location) {
                this.location = location;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder encryptionKey(EncryptionKeyProperty encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            public Builder encryptionKey(IResolvable encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            public ArtifactStoreProperty build() {
                return new Jsii.Proxy(this.location, this.type, this.encryptionKey, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codepipeline.CfnPipeline.ArtifactStoreMapProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArtifactStoreMapProperty
    extends JsiiSerializable {
        @NotNull
        public Object getArtifactStore();

        @NotNull
        public String getRegion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArtifactStoreMapProperty> {
            private Object artifactStore;
            private String region;

            public Builder artifactStore(ArtifactStoreProperty artifactStore) {
                this.artifactStore = artifactStore;
                return this;
            }

            public Builder artifactStore(IResolvable artifactStore) {
                this.artifactStore = artifactStore;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public ArtifactStoreMapProperty build() {
                return new Jsii.Proxy(this.artifactStore, this.region, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codepipeline.CfnPipeline.ActionTypeIdProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ActionTypeIdProperty
    extends JsiiSerializable {
        @NotNull
        public String getCategory();

        @NotNull
        public String getOwner();

        @NotNull
        public String getProvider();

        @NotNull
        public String getVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ActionTypeIdProperty> {
            private String category;
            private String owner;
            private String provider;
            private String version;

            public Builder category(String category) {
                this.category = category;
                return this;
            }

            public Builder owner(String owner) {
                this.owner = owner;
                return this;
            }

            public Builder provider(String provider) {
                this.provider = provider;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public ActionTypeIdProperty build() {
                return new Jsii.Proxy(this.category, this.owner, this.provider, this.version, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_codepipeline.CfnPipeline.ActionDeclarationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ActionDeclarationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getActionTypeId();

        @NotNull
        public String getName();

        @Nullable
        default public Object getConfiguration() {
            return null;
        }

        @Nullable
        default public Object getInputArtifacts() {
            return null;
        }

        @Nullable
        default public String getNamespace() {
            return null;
        }

        @Nullable
        default public Object getOutputArtifacts() {
            return null;
        }

        @Nullable
        default public String getRegion() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        @Nullable
        default public Number getRunOrder() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ActionDeclarationProperty> {
            private Object actionTypeId;
            private String name;
            private Object configuration;
            private Object inputArtifacts;
            private String namespace;
            private Object outputArtifacts;
            private String region;
            private String roleArn;
            private Number runOrder;

            public Builder actionTypeId(ActionTypeIdProperty actionTypeId) {
                this.actionTypeId = actionTypeId;
                return this;
            }

            public Builder actionTypeId(IResolvable actionTypeId) {
                this.actionTypeId = actionTypeId;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder configuration(Object configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder inputArtifacts(IResolvable inputArtifacts) {
                this.inputArtifacts = inputArtifacts;
                return this;
            }

            public Builder inputArtifacts(List<Object> inputArtifacts) {
                this.inputArtifacts = inputArtifacts;
                return this;
            }

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public Builder outputArtifacts(IResolvable outputArtifacts) {
                this.outputArtifacts = outputArtifacts;
                return this;
            }

            public Builder outputArtifacts(List<Object> outputArtifacts) {
                this.outputArtifacts = outputArtifacts;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder runOrder(Number runOrder) {
                this.runOrder = runOrder;
                return this;
            }

            public ActionDeclarationProperty build() {
                return new Jsii.Proxy(this.actionTypeId, this.name, this.configuration, this.inputArtifacts, this.namespace, this.outputArtifacts, this.region, this.roleArn, this.runOrder, null);
            }
        }
    }
}

