/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.config.CfnConfigRule;
import software.amazon.awscdk.services.config.CfnConfigRuleProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_config.CfnConfigRule")
public class CfnConfigRule
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnConfigRule.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnConfigRule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigRule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnConfigRule(@NotNull Construct scope, @NotNull String id, @NotNull CfnConfigRuleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    public String getAttrComplianceType() {
        return (String)this.jsiiGet("attrComplianceType", String.class);
    }

    @NotNull
    public String getAttrConfigRuleId() {
        return (String)this.jsiiGet("attrConfigRuleId", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getInputParameters() {
        return this.jsiiGet("inputParameters", Object.class);
    }

    public void setInputParameters(@NotNull Object value) {
        this.jsiiSet("inputParameters", Objects.requireNonNull(value, "inputParameters is required"));
    }

    @NotNull
    public Object getSource() {
        return this.jsiiGet("source", Object.class);
    }

    public void setSource(@NotNull SourceProperty value) {
        this.jsiiSet("source", Objects.requireNonNull(value, "source is required"));
    }

    public void setSource(@NotNull IResolvable value) {
        this.jsiiSet("source", Objects.requireNonNull(value, "source is required"));
    }

    @Nullable
    public String getConfigRuleName() {
        return (String)this.jsiiGet("configRuleName", String.class);
    }

    public void setConfigRuleName(@Nullable String value) {
        this.jsiiSet("configRuleName", value);
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public String getMaximumExecutionFrequency() {
        return (String)this.jsiiGet("maximumExecutionFrequency", String.class);
    }

    public void setMaximumExecutionFrequency(@Nullable String value) {
        this.jsiiSet("maximumExecutionFrequency", value);
    }

    @Nullable
    public Object getScope() {
        return this.jsiiGet("scope", Object.class);
    }

    public void setScope(@Nullable ScopeProperty value) {
        this.jsiiSet("scope", value);
    }

    public void setScope(@Nullable IResolvable value) {
        this.jsiiSet("scope", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnConfigRule> {
        private final Construct scope;
        private final String id;
        private final CfnConfigRuleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnConfigRuleProps.Builder();
        }

        public Builder source(SourceProperty source) {
            this.props.source(source);
            return this;
        }

        public Builder source(IResolvable source) {
            this.props.source(source);
            return this;
        }

        public Builder configRuleName(String configRuleName) {
            this.props.configRuleName(configRuleName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder inputParameters(Object inputParameters) {
            this.props.inputParameters(inputParameters);
            return this;
        }

        public Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.props.maximumExecutionFrequency(maximumExecutionFrequency);
            return this;
        }

        public Builder scope(ScopeProperty scope) {
            this.props.scope(scope);
            return this;
        }

        public Builder scope(IResolvable scope) {
            this.props.scope(scope);
            return this;
        }

        public CfnConfigRule build() {
            return new CfnConfigRule(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_config.CfnConfigRule.SourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getOwner();

        @NotNull
        public String getSourceIdentifier();

        @Nullable
        default public Object getSourceDetails() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceProperty> {
            private String owner;
            private String sourceIdentifier;
            private Object sourceDetails;

            public Builder owner(String owner) {
                this.owner = owner;
                return this;
            }

            public Builder sourceIdentifier(String sourceIdentifier) {
                this.sourceIdentifier = sourceIdentifier;
                return this;
            }

            public Builder sourceDetails(IResolvable sourceDetails) {
                this.sourceDetails = sourceDetails;
                return this;
            }

            public Builder sourceDetails(List<Object> sourceDetails) {
                this.sourceDetails = sourceDetails;
                return this;
            }

            public SourceProperty build() {
                return new Jsii.Proxy(this.owner, this.sourceIdentifier, this.sourceDetails, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_config.CfnConfigRule.SourceDetailProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceDetailProperty
    extends JsiiSerializable {
        @NotNull
        public String getEventSource();

        @NotNull
        public String getMessageType();

        @Nullable
        default public String getMaximumExecutionFrequency() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceDetailProperty> {
            private String eventSource;
            private String messageType;
            private String maximumExecutionFrequency;

            public Builder eventSource(String eventSource) {
                this.eventSource = eventSource;
                return this;
            }

            public Builder messageType(String messageType) {
                this.messageType = messageType;
                return this;
            }

            public Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
                this.maximumExecutionFrequency = maximumExecutionFrequency;
                return this;
            }

            public SourceDetailProperty build() {
                return new Jsii.Proxy(this.eventSource, this.messageType, this.maximumExecutionFrequency, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_config.CfnConfigRule.ScopeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScopeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getComplianceResourceId() {
            return null;
        }

        @Nullable
        default public List<String> getComplianceResourceTypes() {
            return null;
        }

        @Nullable
        default public String getTagKey() {
            return null;
        }

        @Nullable
        default public String getTagValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScopeProperty> {
            private String complianceResourceId;
            private List<String> complianceResourceTypes;
            private String tagKey;
            private String tagValue;

            public Builder complianceResourceId(String complianceResourceId) {
                this.complianceResourceId = complianceResourceId;
                return this;
            }

            public Builder complianceResourceTypes(List<String> complianceResourceTypes) {
                this.complianceResourceTypes = complianceResourceTypes;
                return this;
            }

            public Builder tagKey(String tagKey) {
                this.tagKey = tagKey;
                return this;
            }

            public Builder tagValue(String tagValue) {
                this.tagValue = tagValue;
                return this;
            }

            public ScopeProperty build() {
                return new Jsii.Proxy(this.complianceResourceId, this.complianceResourceTypes, this.tagKey, this.tagValue, null);
            }
        }
    }
}

