/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.config;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.config.CfnConfigRule;
import software.amazon.awscdk.services.config.IRule;
import software.amazon.awscdk.services.config.ManagedRuleProps;
import software.amazon.awscdk.services.config.MaximumExecutionFrequency;
import software.amazon.awscdk.services.events.OnEventOptions;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_config.ManagedRule")
public class ManagedRule
extends Resource
implements IRule {
    protected ManagedRule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedRule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ManagedRule(@NotNull Construct scope, @NotNull String id, @NotNull ManagedRuleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IRule fromConfigRuleName(@NotNull Construct scope, @NotNull String id, @NotNull String configRuleName) {
        return (IRule)JsiiObject.jsiiStaticCall(ManagedRule.class, (String)"fromConfigRuleName", IRule.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(configRuleName, "configRuleName is required")});
    }

    @Override
    @NotNull
    public Rule onComplianceChange(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onComplianceChange", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onComplianceChange(@NotNull String id) {
        return (Rule)this.jsiiCall("onComplianceChange", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onEvent", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id) {
        return (Rule)this.jsiiCall("onEvent", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onReEvaluationStatus(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onReEvaluationStatus", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onReEvaluationStatus(@NotNull String id) {
        return (Rule)this.jsiiCall("onReEvaluationStatus", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    public void scopeToResource(@NotNull String type, @Nullable String identifier) {
        this.jsiiCall("scopeToResource", NativeType.VOID, new Object[]{Objects.requireNonNull(type, "type is required"), identifier});
    }

    public void scopeToResource(@NotNull String type) {
        this.jsiiCall("scopeToResource", NativeType.VOID, new Object[]{Objects.requireNonNull(type, "type is required")});
    }

    public void scopeToResources(String ... types) {
        this.jsiiCall("scopeToResources", NativeType.VOID, Arrays.stream(types).toArray(Object[]::new));
    }

    public void scopeToTag(@NotNull String key, @Nullable String value) {
        this.jsiiCall("scopeToTag", NativeType.VOID, new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    public void scopeToTag(@NotNull String key) {
        this.jsiiCall("scopeToTag", NativeType.VOID, new Object[]{Objects.requireNonNull(key, "key is required")});
    }

    @NotNull
    public String getConfigRuleArn() {
        return (String)this.jsiiGet("configRuleArn", String.class);
    }

    @NotNull
    public String getConfigRuleComplianceType() {
        return (String)this.jsiiGet("configRuleComplianceType", String.class);
    }

    @NotNull
    public String getConfigRuleId() {
        return (String)this.jsiiGet("configRuleId", String.class);
    }

    @Override
    @NotNull
    public String getConfigRuleName() {
        return (String)this.jsiiGet("configRuleName", String.class);
    }

    @Nullable
    protected Boolean getIsCustomWithChanges() {
        return (Boolean)this.jsiiGet("isCustomWithChanges", Boolean.class);
    }

    protected void setIsCustomWithChanges(@Nullable Boolean value) {
        this.jsiiSet("isCustomWithChanges", value);
    }

    @Nullable
    protected Boolean getIsManaged() {
        return (Boolean)this.jsiiGet("isManaged", Boolean.class);
    }

    protected void setIsManaged(@Nullable Boolean value) {
        this.jsiiSet("isManaged", value);
    }

    @Nullable
    protected CfnConfigRule.ScopeProperty getScope() {
        return (CfnConfigRule.ScopeProperty)this.jsiiGet("scope", CfnConfigRule.ScopeProperty.class);
    }

    protected void setScope(@Nullable CfnConfigRule.ScopeProperty value) {
        this.jsiiSet("scope", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ManagedRule> {
        private final Construct scope;
        private final String id;
        private final ManagedRuleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ManagedRuleProps.Builder();
        }

        public Builder configRuleName(String configRuleName) {
            this.props.configRuleName(configRuleName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder inputParameters(Map<String, Object> inputParameters) {
            this.props.inputParameters(inputParameters);
            return this;
        }

        public Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.props.maximumExecutionFrequency(maximumExecutionFrequency);
            return this;
        }

        public Builder identifier(String identifier) {
            this.props.identifier(identifier);
            return this;
        }

        public ManagedRule build() {
            return new ManagedRule(this.scope, this.id, this.props.build());
        }
    }
}

