/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dms;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.dms.CfnEndpoint;
import software.amazon.awscdk.services.dms.CfnEndpointProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_dms.CfnEndpoint")
public class CfnEndpoint
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnEndpoint.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnEndpoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEndpoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnEndpoint(@NotNull Construct scope, @NotNull String id, @NotNull CfnEndpointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrExternalId() {
        return (String)this.jsiiGet("attrExternalId", String.class);
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)this.jsiiGet("tags", TagManager.class));
    }

    @NotNull
    public String getEndpointType() {
        return (String)this.jsiiGet("endpointType", String.class);
    }

    public void setEndpointType(@NotNull String value) {
        this.jsiiSet("endpointType", Objects.requireNonNull(value, "endpointType is required"));
    }

    @NotNull
    public String getEngineName() {
        return (String)this.jsiiGet("engineName", String.class);
    }

    public void setEngineName(@NotNull String value) {
        this.jsiiSet("engineName", Objects.requireNonNull(value, "engineName is required"));
    }

    @Nullable
    public String getCertificateArn() {
        return (String)this.jsiiGet("certificateArn", String.class);
    }

    public void setCertificateArn(@Nullable String value) {
        this.jsiiSet("certificateArn", value);
    }

    @Nullable
    public String getDatabaseName() {
        return (String)this.jsiiGet("databaseName", String.class);
    }

    public void setDatabaseName(@Nullable String value) {
        this.jsiiSet("databaseName", value);
    }

    @Nullable
    public Object getDynamoDbSettings() {
        return this.jsiiGet("dynamoDbSettings", Object.class);
    }

    public void setDynamoDbSettings(@Nullable DynamoDbSettingsProperty value) {
        this.jsiiSet("dynamoDbSettings", value);
    }

    public void setDynamoDbSettings(@Nullable IResolvable value) {
        this.jsiiSet("dynamoDbSettings", value);
    }

    @Nullable
    public Object getElasticsearchSettings() {
        return this.jsiiGet("elasticsearchSettings", Object.class);
    }

    public void setElasticsearchSettings(@Nullable ElasticsearchSettingsProperty value) {
        this.jsiiSet("elasticsearchSettings", value);
    }

    public void setElasticsearchSettings(@Nullable IResolvable value) {
        this.jsiiSet("elasticsearchSettings", value);
    }

    @Nullable
    public String getEndpointIdentifier() {
        return (String)this.jsiiGet("endpointIdentifier", String.class);
    }

    public void setEndpointIdentifier(@Nullable String value) {
        this.jsiiSet("endpointIdentifier", value);
    }

    @Nullable
    public String getExtraConnectionAttributes() {
        return (String)this.jsiiGet("extraConnectionAttributes", String.class);
    }

    public void setExtraConnectionAttributes(@Nullable String value) {
        this.jsiiSet("extraConnectionAttributes", value);
    }

    @Nullable
    public Object getKafkaSettings() {
        return this.jsiiGet("kafkaSettings", Object.class);
    }

    public void setKafkaSettings(@Nullable KafkaSettingsProperty value) {
        this.jsiiSet("kafkaSettings", value);
    }

    public void setKafkaSettings(@Nullable IResolvable value) {
        this.jsiiSet("kafkaSettings", value);
    }

    @Nullable
    public Object getKinesisSettings() {
        return this.jsiiGet("kinesisSettings", Object.class);
    }

    public void setKinesisSettings(@Nullable KinesisSettingsProperty value) {
        this.jsiiSet("kinesisSettings", value);
    }

    public void setKinesisSettings(@Nullable IResolvable value) {
        this.jsiiSet("kinesisSettings", value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)this.jsiiGet("kmsKeyId", String.class);
    }

    public void setKmsKeyId(@Nullable String value) {
        this.jsiiSet("kmsKeyId", value);
    }

    @Nullable
    public Object getMongoDbSettings() {
        return this.jsiiGet("mongoDbSettings", Object.class);
    }

    public void setMongoDbSettings(@Nullable MongoDbSettingsProperty value) {
        this.jsiiSet("mongoDbSettings", value);
    }

    public void setMongoDbSettings(@Nullable IResolvable value) {
        this.jsiiSet("mongoDbSettings", value);
    }

    @Nullable
    public Object getNeptuneSettings() {
        return this.jsiiGet("neptuneSettings", Object.class);
    }

    public void setNeptuneSettings(@Nullable NeptuneSettingsProperty value) {
        this.jsiiSet("neptuneSettings", value);
    }

    public void setNeptuneSettings(@Nullable IResolvable value) {
        this.jsiiSet("neptuneSettings", value);
    }

    @Nullable
    public String getPassword() {
        return (String)this.jsiiGet("password", String.class);
    }

    public void setPassword(@Nullable String value) {
        this.jsiiSet("password", value);
    }

    @Nullable
    public Number getPort() {
        return (Number)this.jsiiGet("port", Number.class);
    }

    public void setPort(@Nullable Number value) {
        this.jsiiSet("port", value);
    }

    @Nullable
    public Object getS3Settings() {
        return this.jsiiGet("s3Settings", Object.class);
    }

    public void setS3Settings(@Nullable S3SettingsProperty value) {
        this.jsiiSet("s3Settings", value);
    }

    public void setS3Settings(@Nullable IResolvable value) {
        this.jsiiSet("s3Settings", value);
    }

    @Nullable
    public String getServerName() {
        return (String)this.jsiiGet("serverName", String.class);
    }

    public void setServerName(@Nullable String value) {
        this.jsiiSet("serverName", value);
    }

    @Nullable
    public String getSslMode() {
        return (String)this.jsiiGet("sslMode", String.class);
    }

    public void setSslMode(@Nullable String value) {
        this.jsiiSet("sslMode", value);
    }

    @Nullable
    public String getUsername() {
        return (String)this.jsiiGet("username", String.class);
    }

    public void setUsername(@Nullable String value) {
        this.jsiiSet("username", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnEndpoint> {
        private final Construct scope;
        private final String id;
        private final CfnEndpointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnEndpointProps.Builder();
        }

        public Builder endpointType(String endpointType) {
            this.props.endpointType(endpointType);
            return this;
        }

        public Builder engineName(String engineName) {
            this.props.engineName(engineName);
            return this;
        }

        public Builder certificateArn(String certificateArn) {
            this.props.certificateArn(certificateArn);
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        public Builder dynamoDbSettings(DynamoDbSettingsProperty dynamoDbSettings) {
            this.props.dynamoDbSettings(dynamoDbSettings);
            return this;
        }

        public Builder dynamoDbSettings(IResolvable dynamoDbSettings) {
            this.props.dynamoDbSettings(dynamoDbSettings);
            return this;
        }

        public Builder elasticsearchSettings(ElasticsearchSettingsProperty elasticsearchSettings) {
            this.props.elasticsearchSettings(elasticsearchSettings);
            return this;
        }

        public Builder elasticsearchSettings(IResolvable elasticsearchSettings) {
            this.props.elasticsearchSettings(elasticsearchSettings);
            return this;
        }

        public Builder endpointIdentifier(String endpointIdentifier) {
            this.props.endpointIdentifier(endpointIdentifier);
            return this;
        }

        public Builder extraConnectionAttributes(String extraConnectionAttributes) {
            this.props.extraConnectionAttributes(extraConnectionAttributes);
            return this;
        }

        public Builder kafkaSettings(KafkaSettingsProperty kafkaSettings) {
            this.props.kafkaSettings(kafkaSettings);
            return this;
        }

        public Builder kafkaSettings(IResolvable kafkaSettings) {
            this.props.kafkaSettings(kafkaSettings);
            return this;
        }

        public Builder kinesisSettings(KinesisSettingsProperty kinesisSettings) {
            this.props.kinesisSettings(kinesisSettings);
            return this;
        }

        public Builder kinesisSettings(IResolvable kinesisSettings) {
            this.props.kinesisSettings(kinesisSettings);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder mongoDbSettings(MongoDbSettingsProperty mongoDbSettings) {
            this.props.mongoDbSettings(mongoDbSettings);
            return this;
        }

        public Builder mongoDbSettings(IResolvable mongoDbSettings) {
            this.props.mongoDbSettings(mongoDbSettings);
            return this;
        }

        public Builder neptuneSettings(NeptuneSettingsProperty neptuneSettings) {
            this.props.neptuneSettings(neptuneSettings);
            return this;
        }

        public Builder neptuneSettings(IResolvable neptuneSettings) {
            this.props.neptuneSettings(neptuneSettings);
            return this;
        }

        public Builder password(String password) {
            this.props.password(password);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder s3Settings(S3SettingsProperty s3Settings) {
            this.props.s3Settings(s3Settings);
            return this;
        }

        public Builder s3Settings(IResolvable s3Settings) {
            this.props.s3Settings(s3Settings);
            return this;
        }

        public Builder serverName(String serverName) {
            this.props.serverName(serverName);
            return this;
        }

        public Builder sslMode(String sslMode) {
            this.props.sslMode(sslMode);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder username(String username) {
            this.props.username(username);
            return this;
        }

        public CfnEndpoint build() {
            return new CfnEndpoint(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_dms.CfnEndpoint.S3SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3SettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBucketFolder() {
            return null;
        }

        @Nullable
        default public String getBucketName() {
            return null;
        }

        @Nullable
        default public String getCompressionType() {
            return null;
        }

        @Nullable
        default public String getCsvDelimiter() {
            return null;
        }

        @Nullable
        default public String getCsvRowDelimiter() {
            return null;
        }

        @Nullable
        default public String getExternalTableDefinition() {
            return null;
        }

        @Nullable
        default public String getServiceAccessRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3SettingsProperty> {
            private String bucketFolder;
            private String bucketName;
            private String compressionType;
            private String csvDelimiter;
            private String csvRowDelimiter;
            private String externalTableDefinition;
            private String serviceAccessRoleArn;

            public Builder bucketFolder(String bucketFolder) {
                this.bucketFolder = bucketFolder;
                return this;
            }

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder compressionType(String compressionType) {
                this.compressionType = compressionType;
                return this;
            }

            public Builder csvDelimiter(String csvDelimiter) {
                this.csvDelimiter = csvDelimiter;
                return this;
            }

            public Builder csvRowDelimiter(String csvRowDelimiter) {
                this.csvRowDelimiter = csvRowDelimiter;
                return this;
            }

            public Builder externalTableDefinition(String externalTableDefinition) {
                this.externalTableDefinition = externalTableDefinition;
                return this;
            }

            public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            public S3SettingsProperty build() {
                return new Jsii.Proxy(this.bucketFolder, this.bucketName, this.compressionType, this.csvDelimiter, this.csvRowDelimiter, this.externalTableDefinition, this.serviceAccessRoleArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_dms.CfnEndpoint.NeptuneSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NeptuneSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getErrorRetryDuration() {
            return null;
        }

        @Nullable
        default public Object getIamAuthEnabled() {
            return null;
        }

        @Nullable
        default public Number getMaxFileSize() {
            return null;
        }

        @Nullable
        default public Number getMaxRetryCount() {
            return null;
        }

        @Nullable
        default public String getS3BucketFolder() {
            return null;
        }

        @Nullable
        default public String getS3BucketName() {
            return null;
        }

        @Nullable
        default public String getServiceAccessRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NeptuneSettingsProperty> {
            private Number errorRetryDuration;
            private Object iamAuthEnabled;
            private Number maxFileSize;
            private Number maxRetryCount;
            private String s3BucketFolder;
            private String s3BucketName;
            private String serviceAccessRoleArn;

            public Builder errorRetryDuration(Number errorRetryDuration) {
                this.errorRetryDuration = errorRetryDuration;
                return this;
            }

            public Builder iamAuthEnabled(Boolean iamAuthEnabled) {
                this.iamAuthEnabled = iamAuthEnabled;
                return this;
            }

            public Builder iamAuthEnabled(IResolvable iamAuthEnabled) {
                this.iamAuthEnabled = iamAuthEnabled;
                return this;
            }

            public Builder maxFileSize(Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            public Builder maxRetryCount(Number maxRetryCount) {
                this.maxRetryCount = maxRetryCount;
                return this;
            }

            public Builder s3BucketFolder(String s3BucketFolder) {
                this.s3BucketFolder = s3BucketFolder;
                return this;
            }

            public Builder s3BucketName(String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            public NeptuneSettingsProperty build() {
                return new Jsii.Proxy(this.errorRetryDuration, this.iamAuthEnabled, this.maxFileSize, this.maxRetryCount, this.s3BucketFolder, this.s3BucketName, this.serviceAccessRoleArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_dms.CfnEndpoint.MongoDbSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MongoDbSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAuthMechanism() {
            return null;
        }

        @Nullable
        default public String getAuthSource() {
            return null;
        }

        @Nullable
        default public String getAuthType() {
            return null;
        }

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public String getDocsToInvestigate() {
            return null;
        }

        @Nullable
        default public String getExtractDocId() {
            return null;
        }

        @Nullable
        default public String getNestingLevel() {
            return null;
        }

        @Nullable
        default public String getPassword() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        @Nullable
        default public String getServerName() {
            return null;
        }

        @Nullable
        default public String getUsername() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MongoDbSettingsProperty> {
            private String authMechanism;
            private String authSource;
            private String authType;
            private String databaseName;
            private String docsToInvestigate;
            private String extractDocId;
            private String nestingLevel;
            private String password;
            private Number port;
            private String serverName;
            private String username;

            public Builder authMechanism(String authMechanism) {
                this.authMechanism = authMechanism;
                return this;
            }

            public Builder authSource(String authSource) {
                this.authSource = authSource;
                return this;
            }

            public Builder authType(String authType) {
                this.authType = authType;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder docsToInvestigate(String docsToInvestigate) {
                this.docsToInvestigate = docsToInvestigate;
                return this;
            }

            public Builder extractDocId(String extractDocId) {
                this.extractDocId = extractDocId;
                return this;
            }

            public Builder nestingLevel(String nestingLevel) {
                this.nestingLevel = nestingLevel;
                return this;
            }

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder serverName(String serverName) {
                this.serverName = serverName;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public MongoDbSettingsProperty build() {
                return new Jsii.Proxy(this.authMechanism, this.authSource, this.authType, this.databaseName, this.docsToInvestigate, this.extractDocId, this.nestingLevel, this.password, this.port, this.serverName, this.username, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_dms.CfnEndpoint.KinesisSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMessageFormat() {
            return null;
        }

        @Nullable
        default public String getServiceAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getStreamArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisSettingsProperty> {
            private String messageFormat;
            private String serviceAccessRoleArn;
            private String streamArn;

            public Builder messageFormat(String messageFormat) {
                this.messageFormat = messageFormat;
                return this;
            }

            public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            public Builder streamArn(String streamArn) {
                this.streamArn = streamArn;
                return this;
            }

            public KinesisSettingsProperty build() {
                return new Jsii.Proxy(this.messageFormat, this.serviceAccessRoleArn, this.streamArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_dms.CfnEndpoint.KafkaSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KafkaSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBroker() {
            return null;
        }

        @Nullable
        default public String getTopic() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KafkaSettingsProperty> {
            private String broker;
            private String topic;

            public Builder broker(String broker) {
                this.broker = broker;
                return this;
            }

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public KafkaSettingsProperty build() {
                return new Jsii.Proxy(this.broker, this.topic, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_dms.CfnEndpoint.ElasticsearchSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticsearchSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEndpointUri() {
            return null;
        }

        @Nullable
        default public Number getErrorRetryDuration() {
            return null;
        }

        @Nullable
        default public Number getFullLoadErrorPercentage() {
            return null;
        }

        @Nullable
        default public String getServiceAccessRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticsearchSettingsProperty> {
            private String endpointUri;
            private Number errorRetryDuration;
            private Number fullLoadErrorPercentage;
            private String serviceAccessRoleArn;

            public Builder endpointUri(String endpointUri) {
                this.endpointUri = endpointUri;
                return this;
            }

            public Builder errorRetryDuration(Number errorRetryDuration) {
                this.errorRetryDuration = errorRetryDuration;
                return this;
            }

            public Builder fullLoadErrorPercentage(Number fullLoadErrorPercentage) {
                this.fullLoadErrorPercentage = fullLoadErrorPercentage;
                return this;
            }

            public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            public ElasticsearchSettingsProperty build() {
                return new Jsii.Proxy(this.endpointUri, this.errorRetryDuration, this.fullLoadErrorPercentage, this.serviceAccessRoleArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk-experiment.aws_dms.CfnEndpoint.DynamoDbSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDbSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getServiceAccessRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDbSettingsProperty> {
            private String serviceAccessRoleArn;

            public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            public DynamoDbSettingsProperty build() {
                return new Jsii.Proxy(this.serviceAccessRoleArn, null);
            }
        }
    }
}

