/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.docdb;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.docdb.BackupProps;
import software.amazon.awscdk.services.docdb.DatabaseClusterAttributes;
import software.amazon.awscdk.services.docdb.DatabaseClusterProps;
import software.amazon.awscdk.services.docdb.Endpoint;
import software.amazon.awscdk.services.docdb.IClusterParameterGroup;
import software.amazon.awscdk.services.docdb.IDatabaseCluster;
import software.amazon.awscdk.services.docdb.InstanceProps;
import software.amazon.awscdk.services.docdb.Login;
import software.amazon.awscdk.services.docdb.RotationMultiUserOptions;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps;
import software.amazon.awscdk.services.secretsmanager.SecretRotation;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_docdb.DatabaseCluster")
public class DatabaseCluster
extends Resource
implements IDatabaseCluster {
    public static final Number DEFAULT_NUM_INSTANCES = (Number)JsiiObject.jsiiStaticGet(DatabaseCluster.class, (String)"DEFAULT_NUM_INSTANCES", Number.class);
    public static final Number DEFAULT_PORT = (Number)JsiiObject.jsiiStaticGet(DatabaseCluster.class, (String)"DEFAULT_PORT", Number.class);

    protected DatabaseCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DatabaseCluster(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IDatabaseCluster fromDatabaseClusterAttributes(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseClusterAttributes attrs) {
        return (IDatabaseCluster)JsiiObject.jsiiStaticCall(DatabaseCluster.class, (String)"fromDatabaseClusterAttributes", IDatabaseCluster.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public SecretRotation addRotationMultiUser(@NotNull String id, @NotNull RotationMultiUserOptions options) {
        return (SecretRotation)this.jsiiCall("addRotationMultiUser", SecretRotation.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public SecretRotation addRotationSingleUser(@Nullable Duration automaticallyAfter) {
        return (SecretRotation)this.jsiiCall("addRotationSingleUser", SecretRotation.class, new Object[]{automaticallyAfter});
    }

    @NotNull
    public SecretRotation addRotationSingleUser() {
        return (SecretRotation)this.jsiiCall("addRotationSingleUser", SecretRotation.class, new Object[0]);
    }

    @Override
    @NotNull
    public SecretAttachmentTargetProps asSecretAttachmentTarget() {
        return (SecretAttachmentTargetProps)this.jsiiCall("asSecretAttachmentTarget", SecretAttachmentTargetProps.class, new Object[0]);
    }

    @Override
    @NotNull
    public Endpoint getClusterEndpoint() {
        return (Endpoint)((Object)this.jsiiGet("clusterEndpoint", Endpoint.class));
    }

    @Override
    @NotNull
    public String getClusterIdentifier() {
        return (String)this.jsiiGet("clusterIdentifier", String.class);
    }

    @Override
    @NotNull
    public Endpoint getClusterReadEndpoint() {
        return (Endpoint)((Object)this.jsiiGet("clusterReadEndpoint", Endpoint.class));
    }

    @NotNull
    public String getClusterResourceIdentifier() {
        return (String)this.jsiiGet("clusterResourceIdentifier", String.class);
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @Override
    @NotNull
    public List<Endpoint> getInstanceEndpoints() {
        return Collections.unmodifiableList((List)this.jsiiGet("instanceEndpoints", NativeType.listOf((NativeType)NativeType.forClass(Endpoint.class))));
    }

    @Override
    @NotNull
    public List<String> getInstanceIdentifiers() {
        return Collections.unmodifiableList((List)this.jsiiGet("instanceIdentifiers", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @Override
    @NotNull
    public String getSecurityGroupId() {
        return (String)this.jsiiGet("securityGroupId", String.class);
    }

    @Nullable
    public ISecret getSecret() {
        return (ISecret)this.jsiiGet("secret", ISecret.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseCluster> {
        private final Construct scope;
        private final String id;
        private final DatabaseClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DatabaseClusterProps.Builder();
        }

        public Builder instanceProps(InstanceProps instanceProps) {
            this.props.instanceProps(instanceProps);
            return this;
        }

        public Builder masterUser(Login masterUser) {
            this.props.masterUser(masterUser);
            return this;
        }

        public Builder backup(BackupProps backup) {
            this.props.backup(backup);
            return this;
        }

        public Builder dbClusterName(String dbClusterName) {
            this.props.dbClusterName(dbClusterName);
            return this;
        }

        public Builder engineVersion(String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        public Builder instanceIdentifierBase(String instanceIdentifierBase) {
            this.props.instanceIdentifierBase(instanceIdentifierBase);
            return this;
        }

        public Builder instances(Number instances) {
            this.props.instances(instances);
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        public Builder parameterGroup(IClusterParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        public DatabaseCluster build() {
            return new DatabaseCluster(this.scope, this.id, this.props.build());
        }
    }
}

