/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IPeer;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.Port;
import software.amazon.awscdk.services.ec2.SecurityGroupImportOptions;
import software.amazon.awscdk.services.ec2.SecurityGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ec2.SecurityGroup")
public class SecurityGroup
extends Resource
implements ISecurityGroup {
    protected SecurityGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecurityGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SecurityGroup(@NotNull Construct scope, @NotNull String id, @NotNull SecurityGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ISecurityGroup fromSecurityGroupId(@NotNull Construct scope, @NotNull String id, @NotNull String securityGroupId, @Nullable SecurityGroupImportOptions options) {
        return (ISecurityGroup)JsiiObject.jsiiStaticCall(SecurityGroup.class, (String)"fromSecurityGroupId", ISecurityGroup.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(securityGroupId, "securityGroupId is required"), options});
    }

    @NotNull
    public static ISecurityGroup fromSecurityGroupId(@NotNull Construct scope, @NotNull String id, @NotNull String securityGroupId) {
        return (ISecurityGroup)JsiiObject.jsiiStaticCall(SecurityGroup.class, (String)"fromSecurityGroupId", ISecurityGroup.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(securityGroupId, "securityGroupId is required")});
    }

    @NotNull
    public static Boolean isSecurityGroup(@NotNull Object x) {
        return (Boolean)JsiiObject.jsiiStaticCall(SecurityGroup.class, (String)"isSecurityGroup", Boolean.class, (Object[])new Object[]{x});
    }

    @Override
    public void addEgressRule(@NotNull IPeer peer, @NotNull Port connection, @Nullable String description, @Nullable Boolean remoteRule) {
        this.jsiiCall("addEgressRule", NativeType.VOID, new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required"), description, remoteRule});
    }

    @Override
    public void addEgressRule(@NotNull IPeer peer, @NotNull Port connection, @Nullable String description) {
        this.jsiiCall("addEgressRule", NativeType.VOID, new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required"), description});
    }

    @Override
    public void addEgressRule(@NotNull IPeer peer, @NotNull Port connection) {
        this.jsiiCall("addEgressRule", NativeType.VOID, new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required")});
    }

    @Override
    public void addIngressRule(@NotNull IPeer peer, @NotNull Port connection, @Nullable String description, @Nullable Boolean remoteRule) {
        this.jsiiCall("addIngressRule", NativeType.VOID, new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required"), description, remoteRule});
    }

    @Override
    public void addIngressRule(@NotNull IPeer peer, @NotNull Port connection, @Nullable String description) {
        this.jsiiCall("addIngressRule", NativeType.VOID, new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required"), description});
    }

    @Override
    public void addIngressRule(@NotNull IPeer peer, @NotNull Port connection) {
        this.jsiiCall("addIngressRule", NativeType.VOID, new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required")});
    }

    @Override
    @NotNull
    public Object toEgressRuleConfig() {
        return this.jsiiCall("toEgressRuleConfig", Object.class, new Object[0]);
    }

    @Override
    @NotNull
    public Object toIngressRuleConfig() {
        return this.jsiiCall("toIngressRuleConfig", Object.class, new Object[0]);
    }

    @Override
    @NotNull
    public Boolean getAllowAllOutbound() {
        return (Boolean)this.jsiiGet("allowAllOutbound", Boolean.class);
    }

    @Override
    @NotNull
    public Boolean getCanInlineRule() {
        return (Boolean)this.jsiiGet("canInlineRule", Boolean.class);
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @Override
    @NotNull
    public String getSecurityGroupId() {
        return (String)this.jsiiGet("securityGroupId", String.class);
    }

    @NotNull
    public String getSecurityGroupName() {
        return (String)this.jsiiGet("securityGroupName", String.class);
    }

    @NotNull
    public String getSecurityGroupVpcId() {
        return (String)this.jsiiGet("securityGroupVpcId", String.class);
    }

    @Override
    @NotNull
    public String getUniqueId() {
        return (String)this.jsiiGet("uniqueId", String.class);
    }

    @Nullable
    public Port getDefaultPort() {
        return (Port)((Object)this.jsiiGet("defaultPort", Port.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SecurityGroup> {
        private final Construct scope;
        private final String id;
        private final SecurityGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new SecurityGroupProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder securityGroupName(String securityGroupName) {
            this.props.securityGroupName(securityGroupName);
            return this;
        }

        public SecurityGroup build() {
            return new SecurityGroup(this.scope, this.id, this.props.build());
        }
    }
}

