/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.applicationautoscaling.EnableScalingProps;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.BaseServiceProps;
import software.amazon.awscdk.services.ecs.CfnService;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.EcsTarget;
import software.amazon.awscdk.services.ecs.IBaseService;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.IEcsLoadBalancerTarget;
import software.amazon.awscdk.services.ecs.LoadBalancerTargetOptions;
import software.amazon.awscdk.services.ecs.ScalableTaskCount;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps;
import software.amazon.awscdk.services.servicediscovery.IService;
import software.amazon.awscdk.services.servicediscovery.Service;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.BaseService")
public abstract class BaseService
extends Resource
implements IBaseService,
IApplicationLoadBalancerTarget,
INetworkLoadBalancerTarget,
ILoadBalancerTarget {
    protected BaseService(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BaseService(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected BaseService(@NotNull Construct scope, @NotNull String id, @NotNull BaseServiceProps props, @NotNull Object additionalProps, @NotNull TaskDefinition taskDefinition) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required"), additionalProps, Objects.requireNonNull(taskDefinition, "taskDefinition is required")});
    }

    @Override
    @NotNull
    public LoadBalancerTargetProps attachToApplicationTargetGroup(@NotNull IApplicationTargetGroup targetGroup) {
        return (LoadBalancerTargetProps)this.jsiiCall("attachToApplicationTargetGroup", LoadBalancerTargetProps.class, new Object[]{Objects.requireNonNull(targetGroup, "targetGroup is required")});
    }

    @Override
    public void attachToClassicLB(@NotNull LoadBalancer loadBalancer) {
        this.jsiiCall("attachToClassicLB", NativeType.VOID, new Object[]{Objects.requireNonNull(loadBalancer, "loadBalancer is required")});
    }

    @Override
    @NotNull
    public LoadBalancerTargetProps attachToNetworkTargetGroup(@NotNull INetworkTargetGroup targetGroup) {
        return (LoadBalancerTargetProps)this.jsiiCall("attachToNetworkTargetGroup", LoadBalancerTargetProps.class, new Object[]{Objects.requireNonNull(targetGroup, "targetGroup is required")});
    }

    @NotNull
    public ScalableTaskCount autoScaleTaskCount(@NotNull EnableScalingProps props) {
        return (ScalableTaskCount)this.jsiiCall("autoScaleTaskCount", ScalableTaskCount.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @Deprecated
    protected void configureAwsVpcNetworking(@NotNull IVpc vpc, @Nullable Boolean assignPublicIp, @Nullable SubnetSelection vpcSubnets, @Nullable ISecurityGroup securityGroup) {
        this.jsiiCall("configureAwsVpcNetworking", NativeType.VOID, new Object[]{Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets, securityGroup});
    }

    @Deprecated
    protected void configureAwsVpcNetworking(@NotNull IVpc vpc, @Nullable Boolean assignPublicIp, @Nullable SubnetSelection vpcSubnets) {
        this.jsiiCall("configureAwsVpcNetworking", NativeType.VOID, new Object[]{Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets});
    }

    @Deprecated
    protected void configureAwsVpcNetworking(@NotNull IVpc vpc, @Nullable Boolean assignPublicIp) {
        this.jsiiCall("configureAwsVpcNetworking", NativeType.VOID, new Object[]{Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp});
    }

    @Deprecated
    protected void configureAwsVpcNetworking(@NotNull IVpc vpc) {
        this.jsiiCall("configureAwsVpcNetworking", NativeType.VOID, new Object[]{Objects.requireNonNull(vpc, "vpc is required")});
    }

    protected void configureAwsVpcNetworkingWithSecurityGroups(@NotNull IVpc vpc, @Nullable Boolean assignPublicIp, @Nullable SubnetSelection vpcSubnets, @Nullable List<ISecurityGroup> securityGroups) {
        this.jsiiCall("configureAwsVpcNetworkingWithSecurityGroups", NativeType.VOID, new Object[]{Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets, securityGroups});
    }

    protected void configureAwsVpcNetworkingWithSecurityGroups(@NotNull IVpc vpc, @Nullable Boolean assignPublicIp, @Nullable SubnetSelection vpcSubnets) {
        this.jsiiCall("configureAwsVpcNetworkingWithSecurityGroups", NativeType.VOID, new Object[]{Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets});
    }

    protected void configureAwsVpcNetworkingWithSecurityGroups(@NotNull IVpc vpc, @Nullable Boolean assignPublicIp) {
        this.jsiiCall("configureAwsVpcNetworkingWithSecurityGroups", NativeType.VOID, new Object[]{Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp});
    }

    protected void configureAwsVpcNetworkingWithSecurityGroups(@NotNull IVpc vpc) {
        this.jsiiCall("configureAwsVpcNetworkingWithSecurityGroups", NativeType.VOID, new Object[]{Objects.requireNonNull(vpc, "vpc is required")});
    }

    @NotNull
    public Service enableCloudMap(@NotNull CloudMapOptions options) {
        return (Service)this.jsiiCall("enableCloudMap", Service.class, new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public IEcsLoadBalancerTarget loadBalancerTarget(@NotNull LoadBalancerTargetOptions options) {
        return (IEcsLoadBalancerTarget)this.jsiiCall("loadBalancerTarget", IEcsLoadBalancerTarget.class, new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @NotNull
    public Metric metricCpuUtilization(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricCpuUtilization", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricCpuUtilization() {
        return (Metric)this.jsiiCall("metricCpuUtilization", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricMemoryUtilization(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricMemoryUtilization", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricMemoryUtilization() {
        return (Metric)this.jsiiCall("metricMemoryUtilization", Metric.class, new Object[0]);
    }

    public void registerLoadBalancerTargets(EcsTarget ... targets) {
        this.jsiiCall("registerLoadBalancerTargets", NativeType.VOID, Arrays.stream(targets).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public ICluster getCluster() {
        return (ICluster)this.jsiiGet("cluster", ICluster.class);
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @Override
    @NotNull
    public String getServiceArn() {
        return (String)this.jsiiGet("serviceArn", String.class);
    }

    @Override
    @NotNull
    public String getServiceName() {
        return (String)this.jsiiGet("serviceName", String.class);
    }

    @NotNull
    public TaskDefinition getTaskDefinition() {
        return (TaskDefinition)this.jsiiGet("taskDefinition", TaskDefinition.class);
    }

    @Nullable
    public IService getCloudMapService() {
        return (IService)this.jsiiGet("cloudMapService", IService.class);
    }

    @NotNull
    protected List<CfnService.LoadBalancerProperty> getLoadBalancers() {
        return Collections.unmodifiableList((List)this.jsiiGet("loadBalancers", NativeType.listOf((NativeType)NativeType.forClass(CfnService.LoadBalancerProperty.class))));
    }

    protected void setLoadBalancers(@NotNull List<CfnService.LoadBalancerProperty> value) {
        this.jsiiSet("loadBalancers", Objects.requireNonNull(value, "loadBalancers is required"));
    }

    @NotNull
    protected List<CfnService.ServiceRegistryProperty> getServiceRegistries() {
        return Collections.unmodifiableList((List)this.jsiiGet("serviceRegistries", NativeType.listOf((NativeType)NativeType.forClass(CfnService.ServiceRegistryProperty.class))));
    }

    protected void setServiceRegistries(@NotNull List<CfnService.ServiceRegistryProperty> value) {
        this.jsiiSet("serviceRegistries", Objects.requireNonNull(value, "serviceRegistries is required"));
    }

    @Nullable
    protected Service getCloudmapService() {
        return (Service)this.jsiiGet("cloudmapService", Service.class);
    }

    protected void setCloudmapService(@Nullable Service value) {
        this.jsiiSet("cloudmapService", value);
    }

    @Nullable
    protected CfnService.NetworkConfigurationProperty getNetworkConfiguration() {
        return (CfnService.NetworkConfigurationProperty)this.jsiiGet("networkConfiguration", CfnService.NetworkConfigurationProperty.class);
    }

    protected void setNetworkConfiguration(@Nullable CfnService.NetworkConfigurationProperty value) {
        this.jsiiSet("networkConfiguration", value);
    }
}

