/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ecs.Compatibility;
import software.amazon.awscdk.services.ecs.ContainerDefinition;
import software.amazon.awscdk.services.ecs.ContainerDefinitionOptions;
import software.amazon.awscdk.services.ecs.FirelensLogRouter;
import software.amazon.awscdk.services.ecs.FirelensLogRouterDefinitionOptions;
import software.amazon.awscdk.services.ecs.ITaskDefinition;
import software.amazon.awscdk.services.ecs.ITaskDefinitionExtension;
import software.amazon.awscdk.services.ecs.IpcMode;
import software.amazon.awscdk.services.ecs.NetworkMode;
import software.amazon.awscdk.services.ecs.PidMode;
import software.amazon.awscdk.services.ecs.PlacementConstraint;
import software.amazon.awscdk.services.ecs.ProxyConfiguration;
import software.amazon.awscdk.services.ecs.TaskDefinitionProps;
import software.amazon.awscdk.services.ecs.Volume;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_ecs.TaskDefinition")
public class TaskDefinition
extends Resource
implements ITaskDefinition {
    protected TaskDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TaskDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public TaskDefinition(@NotNull Construct scope, @NotNull String id, @NotNull TaskDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ITaskDefinition fromTaskDefinitionArn(@NotNull Construct scope, @NotNull String id, @NotNull String taskDefinitionArn) {
        return (ITaskDefinition)JsiiObject.jsiiStaticCall(TaskDefinition.class, (String)"fromTaskDefinitionArn", ITaskDefinition.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(taskDefinitionArn, "taskDefinitionArn is required")});
    }

    @NotNull
    public ContainerDefinition addContainer(@NotNull String id, @NotNull ContainerDefinitionOptions props) {
        return (ContainerDefinition)this.jsiiCall("addContainer", ContainerDefinition.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addExtension(@NotNull ITaskDefinitionExtension extension) {
        this.jsiiCall("addExtension", NativeType.VOID, new Object[]{Objects.requireNonNull(extension, "extension is required")});
    }

    @NotNull
    public FirelensLogRouter addFirelensLogRouter(@NotNull String id, @NotNull FirelensLogRouterDefinitionOptions props) {
        return (FirelensLogRouter)this.jsiiCall("addFirelensLogRouter", FirelensLogRouter.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addPlacementConstraint(@NotNull PlacementConstraint constraint) {
        this.jsiiCall("addPlacementConstraint", NativeType.VOID, new Object[]{Objects.requireNonNull(constraint, "constraint is required")});
    }

    public void addToExecutionRolePolicy(@NotNull PolicyStatement statement) {
        this.jsiiCall("addToExecutionRolePolicy", NativeType.VOID, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    public void addToTaskRolePolicy(@NotNull PolicyStatement statement) {
        this.jsiiCall("addToTaskRolePolicy", NativeType.VOID, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    public void addVolume(@NotNull Volume volume) {
        this.jsiiCall("addVolume", NativeType.VOID, new Object[]{Objects.requireNonNull(volume, "volume is required")});
    }

    @NotNull
    public IRole obtainExecutionRole() {
        return (IRole)this.jsiiCall("obtainExecutionRole", IRole.class, new Object[0]);
    }

    @Override
    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)this.jsiiCall("validate", NativeType.listOf((NativeType)NativeType.forClass(String.class)), new Object[0]));
    }

    @Override
    @NotNull
    public Compatibility getCompatibility() {
        return (Compatibility)((Object)this.jsiiGet("compatibility", Compatibility.class));
    }

    @NotNull
    protected List<ContainerDefinition> getContainers() {
        return Collections.unmodifiableList((List)this.jsiiGet("containers", NativeType.listOf((NativeType)NativeType.forClass(ContainerDefinition.class))));
    }

    @NotNull
    public String getFamily() {
        return (String)this.jsiiGet("family", String.class);
    }

    @Override
    @NotNull
    public Boolean getIsEc2Compatible() {
        return (Boolean)this.jsiiGet("isEc2Compatible", Boolean.class);
    }

    @Override
    @NotNull
    public Boolean getIsFargateCompatible() {
        return (Boolean)this.jsiiGet("isFargateCompatible", Boolean.class);
    }

    @NotNull
    public NetworkMode getNetworkMode() {
        return (NetworkMode)((Object)this.jsiiGet("networkMode", NetworkMode.class));
    }

    @Override
    @NotNull
    public String getTaskDefinitionArn() {
        return (String)this.jsiiGet("taskDefinitionArn", String.class);
    }

    @NotNull
    public IRole getTaskRole() {
        return (IRole)this.jsiiGet("taskRole", IRole.class);
    }

    @Override
    @Nullable
    public IRole getExecutionRole() {
        return (IRole)this.jsiiGet("executionRole", IRole.class);
    }

    @Nullable
    public ContainerDefinition getDefaultContainer() {
        return (ContainerDefinition)this.jsiiGet("defaultContainer", ContainerDefinition.class);
    }

    public void setDefaultContainer(@Nullable ContainerDefinition value) {
        this.jsiiSet("defaultContainer", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TaskDefinition> {
        private final Construct scope;
        private final String id;
        private final TaskDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new TaskDefinitionProps.Builder();
        }

        public Builder executionRole(IRole executionRole) {
            this.props.executionRole(executionRole);
            return this;
        }

        public Builder family(String family) {
            this.props.family(family);
            return this;
        }

        public Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.props.proxyConfiguration(proxyConfiguration);
            return this;
        }

        public Builder taskRole(IRole taskRole) {
            this.props.taskRole(taskRole);
            return this;
        }

        public Builder volumes(List<Volume> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        public Builder compatibility(Compatibility compatibility) {
            this.props.compatibility(compatibility);
            return this;
        }

        public Builder cpu(String cpu) {
            this.props.cpu(cpu);
            return this;
        }

        public Builder ipcMode(IpcMode ipcMode) {
            this.props.ipcMode(ipcMode);
            return this;
        }

        public Builder memoryMiB(String memoryMiB) {
            this.props.memoryMiB(memoryMiB);
            return this;
        }

        public Builder networkMode(NetworkMode networkMode) {
            this.props.networkMode(networkMode);
            return this;
        }

        public Builder pidMode(PidMode pidMode) {
            this.props.pidMode(pidMode);
            return this;
        }

        public Builder placementConstraints(List<PlacementConstraint> placementConstraints) {
            this.props.placementConstraints(placementConstraints);
            return this;
        }

        public TaskDefinition build() {
            return new TaskDefinition(this.scope, this.id, this.props.build());
        }
    }
}

