/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.efs;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.efs.AccessPointProps;
import software.amazon.awscdk.services.efs.Acl;
import software.amazon.awscdk.services.efs.IAccessPoint;
import software.amazon.awscdk.services.efs.IFileSystem;
import software.amazon.awscdk.services.efs.PosixUser;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_efs.AccessPoint")
public class AccessPoint
extends Resource
implements IAccessPoint {
    protected AccessPoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessPoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AccessPoint(@NotNull Construct scope, @NotNull String id, @NotNull AccessPointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IAccessPoint fromAccessPointId(@NotNull Construct scope, @NotNull String id, @NotNull String accessPointId) {
        return (IAccessPoint)JsiiObject.jsiiStaticCall(AccessPoint.class, (String)"fromAccessPointId", IAccessPoint.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(accessPointId, "accessPointId is required")});
    }

    @Override
    @NotNull
    public String getAccessPointArn() {
        return (String)this.jsiiGet("accessPointArn", String.class);
    }

    @Override
    @NotNull
    public String getAccessPointId() {
        return (String)this.jsiiGet("accessPointId", String.class);
    }

    @NotNull
    public IFileSystem getFileSystem() {
        return (IFileSystem)this.jsiiGet("fileSystem", IFileSystem.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AccessPoint> {
        private final Construct scope;
        private final String id;
        private final AccessPointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new AccessPointProps.Builder();
        }

        public Builder createAcl(Acl createAcl) {
            this.props.createAcl(createAcl);
            return this;
        }

        public Builder path(String path) {
            this.props.path(path);
            return this;
        }

        public Builder posixUser(PosixUser posixUser) {
            this.props.posixUser(posixUser);
            return this;
        }

        public Builder fileSystem(IFileSystem fileSystem) {
            this.props.fileSystem(fileSystem);
            return this;
        }

        public AccessPoint build() {
            return new AccessPoint(this.scope, this.id, this.props.build());
        }
    }
}

