/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.efs;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IDependable;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.core.Size;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.efs.AccessPoint;
import software.amazon.awscdk.services.efs.AccessPointOptions;
import software.amazon.awscdk.services.efs.FileSystemAttributes;
import software.amazon.awscdk.services.efs.FileSystemProps;
import software.amazon.awscdk.services.efs.IFileSystem;
import software.amazon.awscdk.services.efs.LifecyclePolicy;
import software.amazon.awscdk.services.efs.PerformanceMode;
import software.amazon.awscdk.services.efs.ThroughputMode;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_efs.FileSystem")
public class FileSystem
extends Resource
implements IFileSystem {
    protected FileSystem(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FileSystem(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public FileSystem(@NotNull Construct scope, @NotNull String id, @NotNull FileSystemProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IFileSystem fromFileSystemAttributes(@NotNull Construct scope, @NotNull String id, @NotNull FileSystemAttributes attrs) {
        return (IFileSystem)JsiiObject.jsiiStaticCall(FileSystem.class, (String)"fromFileSystemAttributes", IFileSystem.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public AccessPoint addAccessPoint(@NotNull String id, @Nullable AccessPointOptions accessPointOptions) {
        return (AccessPoint)this.jsiiCall("addAccessPoint", AccessPoint.class, new Object[]{Objects.requireNonNull(id, "id is required"), accessPointOptions});
    }

    @NotNull
    public AccessPoint addAccessPoint(@NotNull String id) {
        return (AccessPoint)this.jsiiCall("addAccessPoint", AccessPoint.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @Override
    @NotNull
    public String getFileSystemId() {
        return (String)this.jsiiGet("fileSystemId", String.class);
    }

    @Override
    @NotNull
    public IDependable getMountTargetsAvailable() {
        return (IDependable)this.jsiiGet("mountTargetsAvailable", IDependable.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FileSystem> {
        private final Construct scope;
        private final String id;
        private final FileSystemProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new FileSystemProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder encrypted(Boolean encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }

        public Builder fileSystemName(String fileSystemName) {
            this.props.fileSystemName(fileSystemName);
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        public Builder lifecyclePolicy(LifecyclePolicy lifecyclePolicy) {
            this.props.lifecyclePolicy(lifecyclePolicy);
            return this;
        }

        public Builder performanceMode(PerformanceMode performanceMode) {
            this.props.performanceMode(performanceMode);
            return this;
        }

        public Builder provisionedThroughputPerSecond(Size provisionedThroughputPerSecond) {
            this.props.provisionedThroughputPerSecond(provisionedThroughputPerSecond);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder throughputMode(ThroughputMode throughputMode) {
            this.props.throughputMode(throughputMode);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public FileSystem build() {
            return new FileSystem(this.scope, this.id, this.props.build());
        }
    }
}

