/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.autoscaling.AutoScalingGroup;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.AutoScalingGroupOptions;
import software.amazon.awscdk.services.eks.AwsAuth;
import software.amazon.awscdk.services.eks.CapacityOptions;
import software.amazon.awscdk.services.eks.ClusterAttributes;
import software.amazon.awscdk.services.eks.ClusterProps;
import software.amazon.awscdk.services.eks.CoreDnsComputeType;
import software.amazon.awscdk.services.eks.DefaultCapacityType;
import software.amazon.awscdk.services.eks.EndpointAccess;
import software.amazon.awscdk.services.eks.FargateProfile;
import software.amazon.awscdk.services.eks.FargateProfileOptions;
import software.amazon.awscdk.services.eks.HelmChart;
import software.amazon.awscdk.services.eks.HelmChartOptions;
import software.amazon.awscdk.services.eks.ICluster;
import software.amazon.awscdk.services.eks.KubernetesManifest;
import software.amazon.awscdk.services.eks.KubernetesVersion;
import software.amazon.awscdk.services.eks.Nodegroup;
import software.amazon.awscdk.services.eks.NodegroupOptions;
import software.amazon.awscdk.services.eks.ServiceAccount;
import software.amazon.awscdk.services.eks.ServiceAccountOptions;
import software.amazon.awscdk.services.eks.ServiceLoadBalancerAddressOptions;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.OpenIdConnectProvider;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_eks.Cluster")
public class Cluster
extends Resource
implements ICluster {
    protected Cluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Cluster(@NotNull Construct scope, @NotNull String id, @NotNull ClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ICluster fromClusterAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ClusterAttributes attrs) {
        return (ICluster)JsiiObject.jsiiStaticCall(Cluster.class, (String)"fromClusterAttributes", ICluster.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addAutoScalingGroup(@NotNull AutoScalingGroup autoScalingGroup, @NotNull AutoScalingGroupOptions options) {
        this.jsiiCall("addAutoScalingGroup", NativeType.VOID, new Object[]{Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public AutoScalingGroup addCapacity(@NotNull String id, @NotNull CapacityOptions options) {
        return (AutoScalingGroup)this.jsiiCall("addCapacity", AutoScalingGroup.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public HelmChart addChart(@NotNull String id, @NotNull HelmChartOptions options) {
        return (HelmChart)this.jsiiCall("addChart", HelmChart.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public FargateProfile addFargateProfile(@NotNull String id, @NotNull FargateProfileOptions options) {
        return (FargateProfile)this.jsiiCall("addFargateProfile", FargateProfile.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public KubernetesManifest addManifest(@NotNull String id, Object ... manifest) {
        return (KubernetesManifest)this.jsiiCall("addManifest", KubernetesManifest.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(id, "id is required")}), Arrays.stream(manifest)).toArray(Object[]::new));
    }

    @NotNull
    public Nodegroup addNodegroup(@NotNull String id, @Nullable NodegroupOptions options) {
        return (Nodegroup)this.jsiiCall("addNodegroup", Nodegroup.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @NotNull
    public Nodegroup addNodegroup(@NotNull String id) {
        return (Nodegroup)this.jsiiCall("addNodegroup", Nodegroup.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public ServiceAccount addServiceAccount(@NotNull String id, @Nullable ServiceAccountOptions options) {
        return (ServiceAccount)this.jsiiCall("addServiceAccount", ServiceAccount.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @NotNull
    public ServiceAccount addServiceAccount(@NotNull String id) {
        return (ServiceAccount)this.jsiiCall("addServiceAccount", ServiceAccount.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public String getServiceLoadBalancerAddress(@NotNull String serviceName, @Nullable ServiceLoadBalancerAddressOptions options) {
        return (String)this.jsiiCall("getServiceLoadBalancerAddress", String.class, new Object[]{Objects.requireNonNull(serviceName, "serviceName is required"), options});
    }

    @NotNull
    public String getServiceLoadBalancerAddress(@NotNull String serviceName) {
        return (String)this.jsiiCall("getServiceLoadBalancerAddress", String.class, new Object[]{Objects.requireNonNull(serviceName, "serviceName is required")});
    }

    @NotNull
    public AwsAuth getAwsAuth() {
        return (AwsAuth)this.jsiiGet("awsAuth", AwsAuth.class);
    }

    @Override
    @NotNull
    public String getClusterArn() {
        return (String)this.jsiiGet("clusterArn", String.class);
    }

    @Override
    @NotNull
    public String getClusterCertificateAuthorityData() {
        return (String)this.jsiiGet("clusterCertificateAuthorityData", String.class);
    }

    @Override
    @NotNull
    public String getClusterEncryptionConfigKeyArn() {
        return (String)this.jsiiGet("clusterEncryptionConfigKeyArn", String.class);
    }

    @Override
    @NotNull
    public String getClusterEndpoint() {
        return (String)this.jsiiGet("clusterEndpoint", String.class);
    }

    @Override
    @NotNull
    public String getClusterName() {
        return (String)this.jsiiGet("clusterName", String.class);
    }

    @NotNull
    public String getClusterOpenIdConnectIssuer() {
        return (String)this.jsiiGet("clusterOpenIdConnectIssuer", String.class);
    }

    @NotNull
    public String getClusterOpenIdConnectIssuerUrl() {
        return (String)this.jsiiGet("clusterOpenIdConnectIssuerUrl", String.class);
    }

    @Override
    @NotNull
    public String getClusterSecurityGroupId() {
        return (String)this.jsiiGet("clusterSecurityGroupId", String.class);
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @NotNull
    public OpenIdConnectProvider getOpenIdConnectProvider() {
        return (OpenIdConnectProvider)this.jsiiGet("openIdConnectProvider", OpenIdConnectProvider.class);
    }

    @NotNull
    public IRole getRole() {
        return (IRole)this.jsiiGet("role", IRole.class);
    }

    @Override
    @NotNull
    public IVpc getVpc() {
        return (IVpc)this.jsiiGet("vpc", IVpc.class);
    }

    @Nullable
    public AutoScalingGroup getDefaultCapacity() {
        return (AutoScalingGroup)this.jsiiGet("defaultCapacity", AutoScalingGroup.class);
    }

    @Nullable
    public Nodegroup getDefaultNodegroup() {
        return (Nodegroup)this.jsiiGet("defaultNodegroup", Nodegroup.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Cluster> {
        private final Construct scope;
        private final String id;
        private final ClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ClusterProps.Builder();
        }

        public Builder version(KubernetesVersion version) {
            this.props.version(version);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        public Builder outputClusterName(Boolean outputClusterName) {
            this.props.outputClusterName(outputClusterName);
            return this;
        }

        public Builder outputConfigCommand(Boolean outputConfigCommand) {
            this.props.outputConfigCommand(outputConfigCommand);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder vpcSubnets(List<SubnetSelection> vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder coreDnsComputeType(CoreDnsComputeType coreDnsComputeType) {
            this.props.coreDnsComputeType(coreDnsComputeType);
            return this;
        }

        public Builder endpointAccess(EndpointAccess endpointAccess) {
            this.props.endpointAccess(endpointAccess);
            return this;
        }

        public Builder kubectlEnvironment(Map<String, String> kubectlEnvironment) {
            this.props.kubectlEnvironment(kubectlEnvironment);
            return this;
        }

        public Builder mastersRole(IRole mastersRole) {
            this.props.mastersRole(mastersRole);
            return this;
        }

        public Builder outputMastersRoleArn(Boolean outputMastersRoleArn) {
            this.props.outputMastersRoleArn(outputMastersRoleArn);
            return this;
        }

        public Builder defaultCapacity(Number defaultCapacity) {
            this.props.defaultCapacity(defaultCapacity);
            return this;
        }

        public Builder defaultCapacityInstance(InstanceType defaultCapacityInstance) {
            this.props.defaultCapacityInstance(defaultCapacityInstance);
            return this;
        }

        public Builder defaultCapacityType(DefaultCapacityType defaultCapacityType) {
            this.props.defaultCapacityType(defaultCapacityType);
            return this;
        }

        @Deprecated
        public Builder kubectlEnabled(Boolean kubectlEnabled) {
            this.props.kubectlEnabled(kubectlEnabled);
            return this;
        }

        public Cluster build() {
            return new Cluster(this.scope, this.id, this.props.build());
        }
    }
}

