/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.CommonClusterOptions;
import software.amazon.awscdk.services.eks.DefaultCapacityType;
import software.amazon.awscdk.services.eks.KubernetesVersion;
import software.amazon.awscdk.services.eks.LegacyClusterProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_eks.LegacyClusterProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface LegacyClusterProps
extends JsiiSerializable,
CommonClusterOptions {
    @Nullable
    default public Number getDefaultCapacity() {
        return null;
    }

    @Nullable
    default public InstanceType getDefaultCapacityInstance() {
        return null;
    }

    @Nullable
    default public DefaultCapacityType getDefaultCapacityType() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LegacyClusterProps> {
        private Number defaultCapacity;
        private InstanceType defaultCapacityInstance;
        private DefaultCapacityType defaultCapacityType;
        private KubernetesVersion version;
        private String clusterName;
        private Boolean outputClusterName;
        private Boolean outputConfigCommand;
        private IRole role;
        private ISecurityGroup securityGroup;
        private IVpc vpc;
        private List<SubnetSelection> vpcSubnets;

        public Builder defaultCapacity(Number defaultCapacity) {
            this.defaultCapacity = defaultCapacity;
            return this;
        }

        public Builder defaultCapacityInstance(InstanceType defaultCapacityInstance) {
            this.defaultCapacityInstance = defaultCapacityInstance;
            return this;
        }

        public Builder defaultCapacityType(DefaultCapacityType defaultCapacityType) {
            this.defaultCapacityType = defaultCapacityType;
            return this;
        }

        public Builder version(KubernetesVersion version) {
            this.version = version;
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder outputClusterName(Boolean outputClusterName) {
            this.outputClusterName = outputClusterName;
            return this;
        }

        public Builder outputConfigCommand(Boolean outputConfigCommand) {
            this.outputConfigCommand = outputConfigCommand;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder vpcSubnets(List<SubnetSelection> vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public LegacyClusterProps build() {
            return new Jsii.Proxy(this.defaultCapacity, this.defaultCapacityInstance, this.defaultCapacityType, this.version, this.clusterName, this.outputClusterName, this.outputConfigCommand, this.role, this.securityGroup, this.vpc, this.vpcSubnets, null);
        }
    }
}

