/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.ICluster;
import software.amazon.awscdk.services.eks.NodegroupAmiType;
import software.amazon.awscdk.services.eks.NodegroupOptions;
import software.amazon.awscdk.services.eks.NodegroupProps;
import software.amazon.awscdk.services.eks.NodegroupRemoteAccess;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_eks.NodegroupProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface NodegroupProps
extends JsiiSerializable,
NodegroupOptions {
    @NotNull
    public ICluster getCluster();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NodegroupProps> {
        private ICluster cluster;
        private NodegroupAmiType amiType;
        private Number desiredSize;
        private Number diskSize;
        private Boolean forceUpdate;
        private InstanceType instanceType;
        private Map<String, String> labels;
        private Number maxSize;
        private Number minSize;
        private String nodegroupName;
        private IRole nodeRole;
        private String releaseVersion;
        private NodegroupRemoteAccess remoteAccess;
        private SubnetSelection subnets;
        private Map<String, String> tags;

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder amiType(NodegroupAmiType amiType) {
            this.amiType = amiType;
            return this;
        }

        public Builder desiredSize(Number desiredSize) {
            this.desiredSize = desiredSize;
            return this;
        }

        public Builder diskSize(Number diskSize) {
            this.diskSize = diskSize;
            return this;
        }

        public Builder forceUpdate(Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder maxSize(Number maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder minSize(Number minSize) {
            this.minSize = minSize;
            return this;
        }

        public Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public Builder nodeRole(IRole nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public Builder remoteAccess(NodegroupRemoteAccess remoteAccess) {
            this.remoteAccess = remoteAccess;
            return this;
        }

        public Builder subnets(SubnetSelection subnets) {
            this.subnets = subnets;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public NodegroupProps build() {
            return new Jsii.Proxy(this.cluster, this.amiType, this.desiredSize, this.diskSize, this.forceUpdate, this.instanceType, this.labels, this.maxSize, this.minSize, this.nodegroupName, this.nodeRole, this.releaseVersion, this.remoteAccess, this.subnets, this.tags, null);
        }
    }
}

