/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerAttributes;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb;
import software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_elasticloadbalancingv2.ApplicationLoadBalancer")
public class ApplicationLoadBalancer
extends BaseLoadBalancer
implements IApplicationLoadBalancer {
    protected ApplicationLoadBalancer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationLoadBalancer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ApplicationLoadBalancer(@NotNull Construct scope, @NotNull String id, @NotNull ApplicationLoadBalancerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IApplicationLoadBalancer fromApplicationLoadBalancerAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ApplicationLoadBalancerAttributes attrs) {
        return (IApplicationLoadBalancer)JsiiObject.jsiiStaticCall(ApplicationLoadBalancer.class, (String)"fromApplicationLoadBalancerAttributes", IApplicationLoadBalancer.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public ApplicationListener addListener(@NotNull String id, @NotNull BaseApplicationListenerProps props) {
        return (ApplicationListener)this.jsiiCall("addListener", ApplicationListener.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @NotNull
    public Metric metricActiveConnectionCount(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricActiveConnectionCount", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricActiveConnectionCount() {
        return (Metric)this.jsiiCall("metricActiveConnectionCount", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricClientTlsNegotiationErrorCount(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricClientTlsNegotiationErrorCount", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricClientTlsNegotiationErrorCount() {
        return (Metric)this.jsiiCall("metricClientTlsNegotiationErrorCount", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricConsumedLCUs(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricConsumedLCUs", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricConsumedLCUs() {
        return (Metric)this.jsiiCall("metricConsumedLCUs", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricElbAuthError(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricElbAuthError", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricElbAuthError() {
        return (Metric)this.jsiiCall("metricElbAuthError", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricElbAuthFailure(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricElbAuthFailure", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricElbAuthFailure() {
        return (Metric)this.jsiiCall("metricElbAuthFailure", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricElbAuthLatency(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricElbAuthLatency", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricElbAuthLatency() {
        return (Metric)this.jsiiCall("metricElbAuthLatency", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricElbAuthSuccess(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricElbAuthSuccess", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricElbAuthSuccess() {
        return (Metric)this.jsiiCall("metricElbAuthSuccess", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricHttpCodeElb(@NotNull HttpCodeElb code, @Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricHttpCodeElb", Metric.class, new Object[]{Objects.requireNonNull(code, "code is required"), props});
    }

    @NotNull
    public Metric metricHttpCodeElb(@NotNull HttpCodeElb code) {
        return (Metric)this.jsiiCall("metricHttpCodeElb", Metric.class, new Object[]{Objects.requireNonNull(code, "code is required")});
    }

    @NotNull
    public Metric metricHttpCodeTarget(@NotNull HttpCodeTarget code, @Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricHttpCodeTarget", Metric.class, new Object[]{Objects.requireNonNull(code, "code is required"), props});
    }

    @NotNull
    public Metric metricHttpCodeTarget(@NotNull HttpCodeTarget code) {
        return (Metric)this.jsiiCall("metricHttpCodeTarget", Metric.class, new Object[]{Objects.requireNonNull(code, "code is required")});
    }

    @NotNull
    public Metric metricHttpFixedResponseCount(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricHttpFixedResponseCount", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricHttpFixedResponseCount() {
        return (Metric)this.jsiiCall("metricHttpFixedResponseCount", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricHttpRedirectCount(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricHttpRedirectCount", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricHttpRedirectCount() {
        return (Metric)this.jsiiCall("metricHttpRedirectCount", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricHttpRedirectUrlLimitExceededCount(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricHttpRedirectUrlLimitExceededCount", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricHttpRedirectUrlLimitExceededCount() {
        return (Metric)this.jsiiCall("metricHttpRedirectUrlLimitExceededCount", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricIpv6ProcessedBytes(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricIpv6ProcessedBytes", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricIpv6ProcessedBytes() {
        return (Metric)this.jsiiCall("metricIpv6ProcessedBytes", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricIpv6RequestCount(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricIpv6RequestCount", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricIpv6RequestCount() {
        return (Metric)this.jsiiCall("metricIpv6RequestCount", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricNewConnectionCount(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricNewConnectionCount", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricNewConnectionCount() {
        return (Metric)this.jsiiCall("metricNewConnectionCount", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricProcessedBytes(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricProcessedBytes", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricProcessedBytes() {
        return (Metric)this.jsiiCall("metricProcessedBytes", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricRejectedConnectionCount(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricRejectedConnectionCount", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricRejectedConnectionCount() {
        return (Metric)this.jsiiCall("metricRejectedConnectionCount", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricRequestCount(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricRequestCount", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricRequestCount() {
        return (Metric)this.jsiiCall("metricRequestCount", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricRuleEvaluations(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricRuleEvaluations", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricRuleEvaluations() {
        return (Metric)this.jsiiCall("metricRuleEvaluations", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricTargetConnectionErrorCount(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricTargetConnectionErrorCount", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricTargetConnectionErrorCount() {
        return (Metric)this.jsiiCall("metricTargetConnectionErrorCount", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricTargetResponseTime(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricTargetResponseTime", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricTargetResponseTime() {
        return (Metric)this.jsiiCall("metricTargetResponseTime", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricTargetTLSNegotiationErrorCount(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricTargetTLSNegotiationErrorCount", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricTargetTLSNegotiationErrorCount() {
        return (Metric)this.jsiiCall("metricTargetTLSNegotiationErrorCount", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @Override
    @Nullable
    public IpAddressType getIpAddressType() {
        return (IpAddressType)((Object)this.jsiiGet("ipAddressType", IpAddressType.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ApplicationLoadBalancer> {
        private final Construct scope;
        private final String id;
        private final ApplicationLoadBalancerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ApplicationLoadBalancerProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder internetFacing(Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        public Builder loadBalancerName(String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder http2Enabled(Boolean http2Enabled) {
            this.props.http2Enabled(http2Enabled);
            return this;
        }

        public Builder idleTimeout(Duration idleTimeout) {
            this.props.idleTimeout(idleTimeout);
            return this;
        }

        public Builder ipAddressType(IpAddressType ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public ApplicationLoadBalancer build() {
            return new ApplicationLoadBalancer(this.scope, this.id, this.props.build());
        }
    }
}

