/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events.targets;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.services.batch.IJobDefinition;
import software.amazon.awscdk.services.batch.IJobQueue;
import software.amazon.awscdk.services.events.IRule;
import software.amazon.awscdk.services.events.IRuleTarget;
import software.amazon.awscdk.services.events.RuleTargetConfig;
import software.amazon.awscdk.services.events.RuleTargetInput;
import software.amazon.awscdk.services.events.targets.BatchJobProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="monocdk-experiment.aws_events_targets.BatchJob")
public class BatchJob
extends JsiiObject
implements IRuleTarget {
    protected BatchJob(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BatchJob(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public BatchJob(@NotNull IJobQueue jobQueue, @NotNull IJobDefinition jobDefinition, @Nullable BatchJobProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(jobQueue, "jobQueue is required"), Objects.requireNonNull(jobDefinition, "jobDefinition is required"), props});
    }

    public BatchJob(@NotNull IJobQueue jobQueue, @NotNull IJobDefinition jobDefinition) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(jobQueue, "jobQueue is required"), Objects.requireNonNull(jobDefinition, "jobDefinition is required")});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule rule, @Nullable String _id) {
        return (RuleTargetConfig)this.jsiiCall("bind", RuleTargetConfig.class, new Object[]{Objects.requireNonNull(rule, "rule is required"), _id});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule rule) {
        return (RuleTargetConfig)this.jsiiCall("bind", RuleTargetConfig.class, new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<BatchJob> {
        private final IJobQueue jobQueue;
        private final IJobDefinition jobDefinition;
        private BatchJobProps.Builder props;

        public static Builder create(IJobQueue jobQueue, IJobDefinition jobDefinition) {
            return new Builder(jobQueue, jobDefinition);
        }

        private Builder(IJobQueue jobQueue, IJobDefinition jobDefinition) {
            this.jobQueue = jobQueue;
            this.jobDefinition = jobDefinition;
        }

        public Builder attempts(Number attempts) {
            this.props().attempts(attempts);
            return this;
        }

        public Builder event(RuleTargetInput event) {
            this.props().event(event);
            return this;
        }

        public Builder jobName(String jobName) {
            this.props().jobName(jobName);
            return this;
        }

        public Builder size(Number size) {
            this.props().size(size);
            return this;
        }

        public BatchJob build() {
            return new BatchJob(this.jobQueue, this.jobDefinition, this.props != null ? this.props.build() : null);
        }

        private BatchJobProps.Builder props() {
            if (this.props == null) {
                this.props = new BatchJobProps.Builder();
            }
            return this.props;
        }
    }
}

